/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.ITestQuestion;
import com.kingdee.eas.hr.perf.ITestQuestionTree;
import com.kingdee.eas.hr.perf.TestQuestionCollection;
import com.kingdee.eas.hr.perf.TestQuestionException;
import com.kingdee.eas.hr.perf.TestQuestionFactory;
import com.kingdee.eas.hr.perf.TestQuestionInfo;
import com.kingdee.eas.hr.perf.TestQuestionTreeFactory;
import com.kingdee.eas.hr.perf.TestQuestionTreeInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Hashtable;

public class TestQuestionDataTransmission
extends AbstractDataTransmission {
    private ITestQuestionTree iptt = null;
    private Object obj = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return TestQuestionFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (this.isSltImportUpdate()) {
                TestQuestionInfo info = (TestQuestionInfo)coreBaseInfo;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("treeid.hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
                viewInfo.setFilter(filter);
                SelectorItemCollection sic = viewInfo.getSelector();
                sic.add(new SelectorItemInfo("id"));
                ITestQuestion iTestQuestion = (ITestQuestion)this.getController(ctx);
                TestQuestionCollection coll = iTestQuestion.getTestQuestionCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    info.setId(coll.get(0).getId());
                }
            }
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        TestQuestionInfo ret = new TestQuestionInfo();
        try {
            if (this.iptt == null) {
                this.iptt = TestQuestionTreeFactory.getLocalInstance(ctx);
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            this.obj = hsData.get("typeNumber");
            if (this.obj == null) {
                throw new TestQuestionException(TestQuestionException.NULL_TYPE);
            }
            this.obj = this.obj.toString();
            if (this.obj.equals("")) {
                throw new TestQuestionException(TestQuestionException.NULL_TYPE);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("number", this.obj));
            filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
            viewInfo.setFilter(filterInfo);
            SelectorItemCollection selector = viewInfo.getSelector();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("isLeaf"));
            CoreBaseCollection coll = this.iptt.getCollection(viewInfo);
            TestQuestionTreeInfo typeInfo = null;
            if (coll != null && coll.size() == 1) {
                typeInfo = (TestQuestionTreeInfo)coll.get(0);
                if (!typeInfo.isIsLeaf()) {
                    throw new TestQuestionException(TestQuestionException.IMPORT_ITEM_NOTLEAF_ERROR);
                }
            } else {
                throw new TestQuestionException(TestQuestionException.ERROR_TYPE_NUMBER);
            }
            ret.setTreeid(typeInfo);
            this.obj = hsData.get("number");
            if (this.obj != null) {
                ret.setNumber(this.obj.toString());
            }
            this.obj = hsData.get("content");
            if (this.obj != null) {
                ret.setContent(this.obj.toString());
            }
            this.obj = hsData.get("standard");
            if (this.obj != null) {
                ret.setStandard(this.obj.toString());
            }
            ret.setDisabled(false);
            ret.setOrgUnit(ContextUtil.getCurrentAdminUnit((Context)ctx));
        }
        catch (EASBizException ex) {
            throw new TaskExternalException(ex.getMessage(ctx.getLocale()), ex.getCause());
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return ret;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("number", rs.getString("number"));
            if (rs.getString("content") != null) {
                result.put("content", rs.getString("content"));
            }
            if (rs.getString("standard") != null) {
                result.put("standard", rs.getString("standard"));
            }
            if (rs.getString("typeNumber") != null) {
                result.put("typeNumber", rs.getString("typeNumber"));
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("disabled", (Object)Boolean.FALSE));
        if (hrInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrInfo.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)"%invalidID%"));
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.perf.app.TestQuestionExpQuery";
    }
}

