/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.perf.PaperQuestionsFactory;
import com.kingdee.eas.hr.perf.TestQuestionTreeInfo;
import com.kingdee.eas.hr.perf.app.AbstractTestQuestionTreeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class TestQuestionTreeControllerBean
extends AbstractTestQuestionTreeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.TestQuestionTreeControllerBean");
    private static final String TABLE = "T_PF_TestQuestionType";

    @Override
    protected void _disableMe(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String sql = "UPDATE T_PF_TestQuestionType SET FIsEnabled = ? WHERE FLongNumber LIKE ?  AND FHROrgUnitID = ?";
        String tqSql = "UPDATE T_PF_TestQuestion SET FDisabled = ? WHERE FTreeID IN  (SELECT FID FROM T_PF_TestQuestionType WHERE FLongNumber LIKE ?  AND FHROrgUnitID = ?)";
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setBoolean(1, false);
            pstmt.setString(2, ((TestQuestionTreeInfo)model).getLongNumber() + "%");
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
            pstmt.execute();
            SQLUtils.cleanup((Statement)pstmt);
            pstmt = conn.prepareStatement(tqSql);
            pstmt.setBoolean(1, true);
            pstmt.setString(2, ((TestQuestionTreeInfo)model).getLongNumber() + "%");
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
            pstmt.execute();
            SQLUtils.cleanup((Statement)pstmt);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNumberBlank(ctx, model);
        this._checkNameDup(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNumberBlank(ctx, model);
        this._checkNameDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNumberBlank(ctx, model);
        this._checkNameDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)dataBaseInfo.getName()));
        if (this._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, dataBaseInfo, "name") + dataBaseInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)dataBaseInfo.getNumber()));
        if (this._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    @Override
    protected boolean _isQuestionRefered(Context ctx, String treeid) throws BOSException, EASBizException {
        boolean ret = false;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("testQuestion.treeid.id", (Object)treeid));
        ret = PaperQuestionsFactory.getLocalInstance(ctx).exists(filter);
        if (ret) {
            return ret;
        }
        return ret;
    }
}

