/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.ITestQuestionTree;
import com.kingdee.eas.hr.perf.TestQuestionException;
import com.kingdee.eas.hr.perf.TestQuestionTreeCollection;
import com.kingdee.eas.hr.perf.TestQuestionTreeFactory;
import com.kingdee.eas.hr.perf.TestQuestionTreeInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Hashtable;

public class TestQuestionTreeDataTransmission
extends AbstractDataTransmission {
    private ITestQuestionTree iptt = null;
    private Object obj = null;
    private String parentNumber = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return TestQuestionTreeFactory.getLocalInstance(ctx);
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        TestQuestionTreeInfo ret = new TestQuestionTreeInfo();
        this.obj = null;
        this.parentNumber = null;
        try {
            if (this.iptt == null) {
                this.iptt = TestQuestionTreeFactory.getLocalInstance(ctx);
            }
            this.obj = hsData.get("parentNumber");
            if (this.obj != null) {
                this.parentNumber = this.obj.toString();
            }
            if (!StringUtils.isEmpty((String)this.parentNumber)) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.parentNumber));
                filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
                viewInfo.setFilter(filterInfo);
                CoreBaseCollection coll = this.iptt.getCollection(viewInfo);
                if (coll == null || coll.size() != 1) throw new TestQuestionException(TestQuestionException.ERROR_PARENT_NUMBER);
                ret.setParent((TestQuestionTreeInfo)coll.get(0));
            } else {
                ret.setParent(null);
            }
            Object obj = hsData.get("name");
            if (obj != null) {
                ret.setName(obj.toString());
            }
            if ((obj = hsData.get("number")) != null) {
                ret.setNumber(obj.toString());
            }
            if ((obj = hsData.get("description")) != null) {
                ret.setDescription(obj.toString());
            }
            ret.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            ret.setEnabled(true);
            return ret;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (this.isSltImportUpdate()) {
                TestQuestionTreeInfo info = (TestQuestionTreeInfo)coreBaseInfo;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
                filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId()));
                viewInfo.setFilter(filter);
                SelectorItemCollection sic = viewInfo.getSelector();
                sic.add(new SelectorItemInfo("id"));
                ITestQuestionTree iTestQuestionTree = (ITestQuestionTree)this.getController(ctx);
                TestQuestionTreeCollection coll = iTestQuestionTree.getTestQuestionTreeCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    info.setId(coll.get(0).getId());
                }
            }
            if (coreBaseInfo.getId() == null) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (EASBizException ex) {
            throw new TaskExternalException(ex.getMessage(ctx.getLocale()), ex.getCause());
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("number", rs.getString("number"));
            result.put("name", rs.getString("name"));
            if (rs.getString("description") != null) {
                result.put("description", rs.getString("description"));
            }
            if (rs.getString("parentNumber") != null) {
                result.put("parentNumber", rs.getString("parentNumber"));
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("enabled", (Object)Boolean.TRUE));
        if (hrInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrInfo.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)"%invalidID%"));
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.perf.app.TestQuestionTypeExpQuery";
    }
}

