/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.MailUtil;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.perf.IPlanWriter;
import com.kingdee.eas.hr.perf.PlanFreqTypeInfo;
import com.kingdee.eas.hr.perf.PlanWriterCollection;
import com.kingdee.eas.hr.perf.PlanWriterFactory;
import com.kingdee.eas.hr.perf.WorkItemCollection;
import com.kingdee.eas.hr.perf.WorkItemInfo;
import com.kingdee.eas.hr.perf.WorkPlanCollection;
import com.kingdee.eas.hr.perf.WorkPlanInfo;
import com.kingdee.eas.hr.perf.app.AbstractWorkPlanControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;

public class WorkPlanControllerBean
extends AbstractWorkPlanControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.app.WorkPlanControllerBean");

    @Override
    protected List _getEmpList(com.kingdee.bos.Context ctx, String empId) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app.WorkPlanPersonListQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((com.kingdee.bos.Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)empId));
        fi.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)"00000000-0000-0000-0000-000000000001396FCAD0"));
        fi.setMaskString("#0 and #1");
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        PersonInfo pInfo = null;
        try {
            while (rows.next()) {
                pInfo = new PersonInfo();
                pInfo.setId(BOSUuid.read((String)rows.getString("id")));
                pInfo.setNumber(rows.getString("number"));
                pInfo.setName(rows.getString("name"));
                list.add(pInfo);
            }
            IPlanWriter iPW = PlanWriterFactory.getLocalInstance(ctx);
            String oql = "select person.id,person.name where writer='" + empId + "'";
            PlanWriterCollection pwColl = iPW.getPlanWriterCollection(oql);
            int size = pwColl.size();
            for (int i = 0; i < size; ++i) {
                list.add(pwColl.get(i).getPerson());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    @Override
    protected List _getEmpList2(com.kingdee.bos.Context ctx, String empId) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app.WorkPlanPersonList2Query");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((com.kingdee.bos.Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)empId));
        fi.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)"00000000-0000-0000-0000-000000000001396FCAD0"));
        fi.setMaskString("#0 and #1");
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        ArrayList<PersonInfo> list = new ArrayList<PersonInfo>();
        PersonInfo pInfo = null;
        try {
            while (rows.next()) {
                pInfo = new PersonInfo();
                pInfo.setId(BOSUuid.read((String)rows.getString("id")));
                pInfo.setNumber(rows.getString("number"));
                pInfo.setName(rows.getString("name"));
                pInfo.put("POSITION", (Object)rows.getString("Position.name"));
                list.add(pInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    @Override
    protected Map _getEmpPositionInfo(com.kingdee.bos.Context ctx, String empId) throws BOSException, EASBizException {
        HashMap<String, Object> map = null;
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app.WorkPlanSuperPositionQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((com.kingdee.bos.Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)empId));
        viewInfo.setFilter(fi);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        try {
            StringBuffer buf = null;
            PositionInfo positionInfo = null;
            PositionInfo superPositionInfo = null;
            HashMap<String, String> idMap = new HashMap<String, String>();
            while (rows.next()) {
                idMap.put(rows.getString("id"), rows.getString("id"));
                if (buf == null) {
                    buf = new StringBuffer();
                    buf.append(rows.getString("name"));
                    buf.append("!#!");
                    positionInfo = new PositionInfo();
                    positionInfo.setId(BOSUuid.read((String)rows.getString("Position.id")));
                    positionInfo.setName(rows.getString("Position.name"));
                    superPositionInfo = new PositionInfo();
                    superPositionInfo.setId(BOSUuid.read((String)rows.getString("Position2.id")));
                    superPositionInfo.setName(rows.getString("Position2.name"));
                    continue;
                }
                buf.append(",");
                buf.append(rows.getString("name"));
                buf.append("!#!");
            }
            if (buf != null) {
                map = new HashMap<String, Object>();
                map.put("SuperIDS", idMap);
                map.put("SuperNames", buf.toString());
                map.put("Position", positionInfo);
                map.put("SuperPosition", superPositionInfo);
            }
            if (map == null) {
                map = new HashMap();
                queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app.WorkPlanSuperPosition2Query");
                queryExcu = QueryExecutorFactory.getLocalInstance((com.kingdee.bos.Context)ctx, (IMetaDataPK)queryPK);
                viewInfo = new EntityViewInfo();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("Person.id", (Object)empId));
                viewInfo.setFilter(fi);
                queryExcu.setObjectView(viewInfo);
                rows = queryExcu.executeQuery();
                while (rows.next()) {
                    positionInfo = new PositionInfo();
                    positionInfo.setId(BOSUuid.read((String)rows.getString("id")));
                    positionInfo.setName(rows.getString("name"));
                    if (rows.getString("Position2.id") == null) continue;
                    superPositionInfo = new PositionInfo();
                    superPositionInfo.setId(BOSUuid.read((String)rows.getString("Position2.id")));
                    superPositionInfo.setName(rows.getString("Position2.name"));
                }
                map.put("Position", positionInfo);
                if (superPositionInfo != null) {
                    map.put("SuperPosition", superPositionInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    @Override
    protected void _sendMail(com.kingdee.bos.Context ctx, String empId, String emailAddress, Map map) throws BOSException, EASBizException {
        IPerson iP = PersonFactory.getLocalInstance((com.kingdee.bos.Context)ctx);
        PersonInfo pInfo = iP.getPersonInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)empId)));
        try {
            MailUtil mailUtil = MailUtil.getInstance((com.kingdee.bos.Context)ctx);
            mailUtil.sendHtmlMail(pInfo.getEmail(), emailAddress, map.get("Subject").toString(), this.getVelocityData(ctx, pInfo, map));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getVelocityData(com.kingdee.bos.Context ctx, PersonInfo pInfo, Map map) throws Exception {
        int i;
        Velocity.init();
        VelocityContext context = new VelocityContext();
        IPerson iP = PersonFactory.getLocalInstance((com.kingdee.bos.Context)ctx);
        PositionInfo posiInfo = iP.getPrimaryPosition(pInfo.getId());
        context.put("name", (Object)pInfo.getName());
        context.put("Position", (Object)posiInfo.getName());
        context.put("AdminOrgUnit", (Object)posiInfo.getAdminOrgUnit().getName());
        context.put("CurStartDate", map.get("CurStartDate"));
        context.put("CurEndDate", map.get("CurEndDate"));
        context.put("PreStartDate", map.get("PreStartDate"));
        context.put("PreEndDate", map.get("PreEndDate"));
        PlanFreqTypeInfo pfTypeInfo = (PlanFreqTypeInfo)map.get("PlanFreqType");
        context.put("PlanFreqType", (Object)pfTypeInfo.getType());
        WorkPlanInfo wpInfo = null;
        int size = 0;
        ArrayList<WorkItemInfo> list = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.executor.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.executor.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.monitor.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.monitor.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.founder.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.founder.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.planItemCategory.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.planItemCategory.name"));
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("planFreqType.id", (Object)pfTypeInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)((String)map.get("CurStartDate"))));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((com.kingdee.bos.Context)ctx).getId().toString()));
        WorkPlanCollection coll = this.getWorkPlanCollection(ctx, viewInfo);
        if (coll != null && coll.size() > 0) {
            wpInfo = coll.get(0);
            size = wpInfo.getWorkItem().size();
            list = new ArrayList<WorkItemInfo>(size);
            for (i = 0; i < size; ++i) {
                list.add(wpInfo.getWorkItem().get(i));
            }
            context.put("workItems", list);
            context.put("PlanDesc", (Object)wpInfo.getDescription());
            context.put("SelfComplete", (Object)wpInfo.getAccomplishResult());
            context.put("SuperAdvice", (Object)wpInfo.getAdvice());
            context.put("target", (Object)wpInfo.getTarget());
        }
        viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.*"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.executor.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.executor.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.monitor.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.monitor.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.founder.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.founder.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.planItemCategory.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("workItem.planItemCategory.name"));
        filter = new FilterInfo();
        viewInfo.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("planFreqType.id", (Object)pfTypeInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)((String)map.get("PreStartDate"))));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((com.kingdee.bos.Context)ctx).getId().toString()));
        coll = this.getWorkPlanCollection(ctx, viewInfo);
        if (coll != null && coll.size() > 0) {
            wpInfo = coll.get(0);
            size = wpInfo.getWorkItem().size();
            list = new ArrayList(size);
            for (i = 0; i < size; ++i) {
                list.add(wpInfo.getWorkItem().get(i));
            }
            context.put("workItems2", list);
            context.put("PlanDesc2", (Object)wpInfo.getDescription());
            context.put("SelfComplete2", (Object)wpInfo.getAccomplishResult());
            context.put("SuperAdvice2", (Object)wpInfo.getAdvice());
            context.put("target2", (Object)wpInfo.getTarget());
        }
        Template template = Velocity.getTemplate((String)this.getTemplateFile(), (String)"UTF-8");
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer);
        return writer.toString();
    }

    private String getTemplateFile() throws BOSException {
        File file;
        String strPath = System.getProperty("bos.config");
        if (File.separatorChar != '/') {
            strPath = strPath.replace('/', File.separatorChar);
        }
        if (!(file = new File(strPath)).isAbsolute()) {
            file = new File(this.getServerRoot(), strPath);
        }
        strPath = (strPath = file.getParent().toString()) == null ? "W:/eas/deploy/apusic/" : strPath + File.separatorChar;
        return strPath + "PlanTemplate.htm";
    }

    private File getServerRoot() {
        String root = System.getProperty("bos.root");
        if (root == null) {
            root = System.getProperty("user.dir");
        }
        return new File(root);
    }

    protected IObjectPK _addnew(com.kingdee.bos.Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WorkPlanInfo info = (WorkPlanInfo)model;
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((com.kingdee.bos.Context)ctx));
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected String _getLogInfo(com.kingdee.bos.Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return "";
        }
        SelectorItemCollection collection = new SelectorItemCollection();
        collection.add(new SelectorItemInfo("id"));
        collection.add(new SelectorItemInfo("person.name"));
        collection.add(new SelectorItemInfo("startDate"));
        WorkPlanInfo info = (WorkPlanInfo)super._getValue(ctx, pk, collection);
        StringBuffer sb = new StringBuffer();
        if (info.getPerson() != null) {
            sb.append(info.getPerson().getName());
        }
        sb.append(info.getStartDate());
        return sb.toString();
    }

    @Override
    protected Map _getQueryInitCondition(com.kingdee.bos.Context ctx) throws BOSException, EASBizException {
        HashMap<String, PersonPositionInfo> map = new HashMap<String, PersonPositionInfo>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)ContextUtil.getCurrentUserInfo((com.kingdee.bos.Context)ctx).getPerson().getId().toString()));
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("personDep.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("personDep.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("personDep.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("primaryPosition.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("primaryPosition.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("primaryPosition.number"));
        viewInfo.setFilter(filter);
        PersonPositionCollection coll = PersonPositionFactory.getLocalInstance((com.kingdee.bos.Context)ctx).getPersonPositionCollection(viewInfo);
        if (coll.size() > 0) {
            map.put("ppInfo", coll.get(0));
        }
        return map;
    }

    @Override
    protected void _audit(com.kingdee.bos.Context ctx, WorkItemCollection workItems) throws BOSException, EASBizException {
        this.saveWorkItem(ctx, workItems);
    }

    @Override
    protected void _unAudit(com.kingdee.bos.Context ctx, WorkItemCollection workItems) throws BOSException, EASBizException {
        this.saveWorkItem(ctx, workItems);
    }

    private void saveWorkItem(com.kingdee.bos.Context ctx, WorkItemCollection workItems) throws BOSException {
        if (workItems == null || workItems.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            String sql = "update t_pf_workItem set FAuditState = ?, FAuditorID = ? where fid = ?";
            pstmt = conn.prepareStatement(sql);
            WorkItemInfo workItemInfo = null;
            int size = workItems.size();
            for (int i = 0; i < size; ++i) {
                workItemInfo = workItems.get(i);
                if (workItemInfo.getAuditState() != null) {
                    pstmt.setInt(1, workItemInfo.getAuditState().getValue());
                } else {
                    pstmt.setInt(1, 10);
                }
                if (workItemInfo.getAuditor() != null) {
                    pstmt.setString(2, workItemInfo.getAuditor().getId().toString());
                } else {
                    pstmt.setString(2, null);
                }
                pstmt.setString(3, workItemInfo.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.info((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected void _dealPlanFreqType(com.kingdee.bos.Context ctx) throws BOSException, EASBizException {
        String sqlType = "select ftype from t_pf_PlanFreqType group by ftype having count(ftype) >1";
        IRowSet rowSet = DbUtil.executeQuery((com.kingdee.bos.Context)ctx, (String)sqlType.toString());
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            rowSet.beforeFirst();
            String sqlId = "select distinct fid from t_pf_PlanFreqType where ftype = ?";
            StringBuffer sqlUpdate = new StringBuffer();
            sqlUpdate.append("update T_PF_WorkPlan Set FPlanFreqTypeID = ? where FPlanFreqTypeID in ");
            sqlUpdate.append("(select distinct fid from t_pf_PlanFreqType where ftype = ?)");
            String sqlDelete = "delete from t_pf_PlanFreqType where ftype = ? and fid <> ?";
            conn = this.getConnection(ctx);
            while (rowSet.next()) {
                int type = rowSet.getInt("ftype");
                pstmt = conn.prepareStatement(sqlId);
                pstmt.setInt(1, type);
                ResultSet idSet = pstmt.executeQuery();
                String goalId = null;
                if (idSet.next()) {
                    goalId = idSet.getString("fid");
                }
                if (goalId == null) continue;
                pstmt = conn.prepareStatement(sqlUpdate.toString());
                pstmt.setString(1, goalId);
                pstmt.setInt(2, type);
                pstmt.execute();
                pstmt = conn.prepareStatement(sqlDelete);
                pstmt.setInt(1, type);
                pstmt.setString(2, goalId);
                pstmt.execute();
            }
            String defSql = "select fid, fisdefault from t_pf_planfreqtype where fisdefault = 1";
            IRowSet defSet = DbUtil.executeQuery((com.kingdee.bos.Context)ctx, (String)defSql);
            if (defSet.size() > 1) {
                ArrayList<String> idList = new ArrayList<String>();
                defSet.beforeFirst();
                String upSql = "update t_pf_planfreqtype set fisdefault = 0 where fid = ?";
                pstmt = conn.prepareStatement(upSql);
                while (defSet.next()) {
                    idList.add(defSet.getString("fid"));
                }
                int size = idList.size();
                for (int i = 0; i < size - 1; ++i) {
                    pstmt.setString(1, (String)idList.get(i));
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

