/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.hr.perf.FormulaAchieveEntryCollection;
import com.kingdee.eas.hr.perf.FormulaAchieveEntryFactory;
import com.kingdee.eas.hr.perf.FormulaAchieveEntryInfo;
import com.kingdee.eas.hr.perf.FormulaSystemEntryCollection;
import com.kingdee.eas.hr.perf.FormulaSystemEntryFactory;
import com.kingdee.eas.hr.perf.FormulaSystemEntryInfo;
import com.kingdee.eas.hr.perf.SumItemCollection;
import com.kingdee.eas.hr.perf.SumItemFactory;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormulaTranslatorUtil {
    public static String formatScript(String kScript) {
        Pattern p = Pattern.compile("[\\d][.](\\d)*E(\\d)*");
        Matcher m = p.matcher(kScript);
        String temp = "";
        StringBuffer rst = new StringBuffer();
        int start = 0;
        int end = 0;
        int tag = 0;
        BigDecimal big = null;
        while (m.find()) {
            start = m.start();
            end = m.end();
            temp = kScript.substring(start, end);
            big = new BigDecimal(temp);
            rst.append(kScript.substring(tag, start));
            rst.append(big.toString());
            tag = end;
        }
        rst.append(kScript.substring(end));
        kScript = rst.toString();
        kScript = kScript.replaceAll("\"", "'").replaceAll("\\|\\|", " OR ").replaceAll("\\&\\&", " AND ").replaceAll("==", "=");
        return kScript;
    }

    public static HashSet getSumItemNumbers(Context ctx) throws BOSException {
        Boolean b = (Boolean)ctx.get((Object)"is_platform");
        HashSet<String> result = new HashSet<String>();
        if (b == null || !b.booleanValue()) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)((String)ctx.get((Object)"hr_perf_formual_id"))));
            viewInfo.setFilter(filter);
            SumItemCollection coll = SumItemFactory.getLocalInstance(ctx).getSumItemCollection(viewInfo);
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                result.add(coll.get(i).getNumber().toUpperCase());
            }
        } else {
            int i;
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("formula.id", (Object)((String)ctx.get((Object)"hr_perf_formual_id"))));
            viewInfo.setFilter(filter);
            FormulaSystemEntryCollection sysColl = FormulaSystemEntryFactory.getLocalInstance(ctx).getFormulaSystemEntryCollection(viewInfo);
            FormulaAchieveEntryCollection achColl = FormulaAchieveEntryFactory.getLocalInstance(ctx).getFormulaAchieveEntryCollection(viewInfo);
            for (i = 0; i < sysColl.size(); ++i) {
                result.add(sysColl.get(i).getNumber().toUpperCase());
            }
            for (i = 0; i < achColl.size(); ++i) {
                result.add(achColl.get(i).getNumber().toUpperCase());
            }
        }
        return result;
    }

    public static String toTranslateKSQL(String str) {
        return str;
    }

    public static Map getFormulaElement(Context ctx, String formulaId) throws BOSException {
        int i;
        if (formulaId == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("formula.id", (Object)((String)ctx.get((Object)"hr_perf_formual_id"))));
        viewInfo.setFilter(filter);
        FormulaSystemEntryCollection sysColl = FormulaSystemEntryFactory.getLocalInstance(ctx).getFormulaSystemEntryCollection(viewInfo);
        FormulaAchieveEntryCollection achColl = FormulaAchieveEntryFactory.getLocalInstance(ctx).getFormulaAchieveEntryCollection(viewInfo);
        for (i = 0; i < sysColl.size(); ++i) {
            FormulaSystemEntryInfo seInfo = sysColl.get(i);
            if (seInfo.getNumber() == null) continue;
            map.put(seInfo.getNumber().toUpperCase(), seInfo.getName());
        }
        for (i = 0; i < achColl.size(); ++i) {
            FormulaAchieveEntryInfo aeInfo = achColl.get(i);
            if (aeInfo.getNumber() == null) continue;
            map.put(aeInfo.getNumber().toUpperCase(), aeInfo.getName());
        }
        return map;
    }
}

