/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ElseIfItem;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.IfStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.sql.dom.stmt.SqlUpdateStmt;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.FormulaException;
import com.kingdee.eas.hr.perf.PerfFormuleException;
import com.kingdee.eas.hr.perf.app.formula.FormulaTranslatorUtil;
import com.kingdee.eas.hr.perf.app.formula.PreTranslateScript;
import com.kingdee.eas.hr.perf.app.formula.ScriptTranslator;
import com.kingdee.eas.hr.perf.app.formula.StmtTransFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class KScriptToKSQL {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.perf.formula.KScriptToKSQL");
    private static final String RES = "com.kingdee.eas.hr.perf.PerfResource";
    private static final String result_l1 = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"sumResult", (Locale)LocaleUtils.getLocale((String)"l1"));
    private static final String result_l2 = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"sumResult", (Locale)LocaleUtils.getLocale((String)"l2"));
    private static final String result_l3 = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"sumResult", (Locale)LocaleUtils.getLocale((String)"l3"));
    private static final String fr_l1 = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"formula_result", (Locale)LocaleUtils.getLocale((String)"l1"));
    private static final String fr_l2 = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"formula_result", (Locale)LocaleUtils.getLocale((String)"l2"));
    private static final String fr_l3 = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"formula_result", (Locale)LocaleUtils.getLocale((String)"l3"));

    public String translateScript(Context ctx, String script) throws EASBizException, BOSException {
        if (script == null) {
            return "";
        }
        List stmtList = this.parseScript(script = this.beforeTrans(ctx, script));
        if (stmtList == null) {
            return null;
        }
        if (script.length() > 10000) {
            throw new PerfFormuleException(PerfFormuleException.TOO_LONG_SQL);
        }
        String ret = this.transKScriptToKsql(ctx, stmtList);
        return ret;
    }

    private String afterTrans(String sql) {
        sql = sql.toUpperCase().replaceAll("!\\s*=\\s*NULL", "IS NOT NULL").replaceAll("=\\s*NULL", " IS NULL ").replaceAll(result_l1.toUpperCase(), "FScore").replaceAll(result_l2.toUpperCase(), "FScore").replaceAll(result_l3.toLowerCase(), "FScore");
        return sql;
    }

    private String afterTrans(Context ctx, String sql) {
        Boolean isPlatForm = (Boolean)ctx.get((Object)"is_platform");
        if (isPlatForm == null || !isPlatForm.booleanValue()) {
            sql = sql.replaceAll("!\\s*=\\s*NULL", "IS NOT NULL").replaceAll("=\\s*NULL", " IS NULL ").replaceAll(result_l1.toUpperCase(), "FScore").replaceAll(result_l2.toUpperCase(), "FScore").replaceAll(result_l3.toLowerCase(), "FScore");
        } else if (ctx.getLocale().equals(LocaleUtils.getLocale((String)"l1"))) {
            sql = sql.toUpperCase().replaceAll("!\\s*=\\s*NULL", "IS NOT NULL").replaceAll("=\\s*NULL", " IS NULL ").replaceAll(fr_l1.toUpperCase(), "FRealValue");
        } else if (ctx.getLocale().equals(LocaleUtils.getLocale((String)"l2"))) {
            sql = sql.toUpperCase().replaceAll("!\\s*=\\s*NULL", "IS NOT NULL").replaceAll("=\\s*NULL", " IS NULL ").replaceAll(fr_l2.toUpperCase(), "FRealValue");
        } else if (ctx.getLocale().equals(LocaleUtils.getLocale((String)"l3"))) {
            sql = sql.toUpperCase().replaceAll("!\\s*=\\s*NULL", "IS NOT NULL").replaceAll("=\\s*NULL", " IS NULL ").replaceAll(fr_l3.toUpperCase(), "FRealValue");
        }
        return sql;
    }

    private ExprStmt preTranslateExprStmt(ExprStmt stmt) {
        PreTranslateScript preTranslator = new PreTranslateScript();
        stmt.expr = preTranslator.successor().preTranslate(stmt.expr);
        return stmt;
    }

    private IfStmt preTranslateIfStmt(IfStmt stmt) {
        int i;
        int i2;
        int i3;
        PreTranslateScript preTranslator = new PreTranslateScript();
        CodeExpr testExpr = stmt.testExpr;
        stmt.testExpr = testExpr = preTranslator.successor().preTranslate(testExpr);
        List trueList = stmt.trueStmtList;
        ArrayList<ExprStmt> trueListNew = new ArrayList<ExprStmt>();
        int size = trueList.size();
        for (i3 = 0; i3 < size; ++i3) {
            ExprStmt trueStmt = (ExprStmt)trueList.get(i3);
            trueStmt.expr = preTranslator.successor().preTranslate(trueStmt.expr);
            trueListNew.add(trueStmt);
        }
        stmt.trueStmtList.clear();
        size = trueListNew.size();
        for (i3 = 0; i3 < size; ++i3) {
            stmt.trueStmtList.add(trueListNew.get(i3));
        }
        List elseIfList = stmt.elseIfList;
        ArrayList<ElseIfItem> elseIfListNew = new ArrayList<ElseIfItem>();
        ArrayList<ExprStmt> elseIfStmtList = null;
        int size2 = elseIfList.size();
        for (i2 = 0; i2 < size2; ++i2) {
            ElseIfItem item = (ElseIfItem)elseIfList.get(i2);
            item.testExpr = preTranslator.successor().preTranslate(item.testExpr);
            elseIfStmtList = new ArrayList<ExprStmt>();
            int jsize = item.stmtList.size();
            for (int j = 0; j < jsize; ++j) {
                ExprStmt exprStmt = (ExprStmt)item.stmtList.get(j);
                exprStmt.expr = preTranslator.successor().preTranslate(exprStmt.expr);
                elseIfStmtList.add(exprStmt);
            }
            item.stmtList = elseIfStmtList;
            elseIfListNew.add(item);
        }
        stmt.elseIfList.clear();
        size2 = elseIfListNew.size();
        for (i2 = 0; i2 < size2; ++i2) {
            stmt.elseIfList.add(elseIfListNew.get(i2));
        }
        List elseList = stmt.elseStmtList;
        ArrayList<ExprStmt> elseListNew = new ArrayList<ExprStmt>();
        int size3 = elseList.size();
        for (i = 0; i < size3; ++i) {
            ExprStmt exprStmt = (ExprStmt)elseList.get(i);
            exprStmt.expr = preTranslator.successor().preTranslate(exprStmt.expr);
            elseListNew.add(exprStmt);
        }
        stmt.elseStmtList.clear();
        size3 = elseListNew.size();
        for (i = 0; i < size3; ++i) {
            stmt.elseStmtList.add(elseListNew.get(i));
        }
        return stmt;
    }

    private void beforeTrans(String script) throws EASBizException, BOSException {
    }

    private String beforeTrans(Context ctx, String script) throws EASBizException, BOSException {
        Boolean isPlatForm = (Boolean)ctx.get((Object)"is_platform");
        if (isPlatForm == null || !isPlatForm.booleanValue()) {
            script = script.replaceAll("\\[", "(").replaceAll("\\]", ")");
        } else {
            script = script.replaceAll("\\[", "(").replaceAll("\\]", ")");
            if (ctx.get((Object)"hr_perf_formual_id") != null) {
                Map map = FormulaTranslatorUtil.getFormulaElement(ctx, ctx.get((Object)"hr_perf_formual_id").toString());
                Set set = map.entrySet();
                for (Map.Entry entry : set) {
                    Object value = entry.getValue();
                    String key = entry.getKey().toString();
                    if (value == null || value.toString().trim().length() <= 0) continue;
                    script = script.replaceAll(value.toString().trim(), key);
                }
            }
        }
        return script;
    }

    private List parseScript(String script) throws EASBizException, BOSException {
        List ret = null;
        KScriptParser parser = new KScriptParser(script);
        try {
            parser.parse();
            ret = parser.stmtList;
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new PerfFormuleException(PerfFormuleException.PARSER_EXEC, ex);
        }
        return ret;
    }

    private String transKScriptToKsql(Context ctx, List stmtList) throws EASBizException, BOSException {
        StringBuffer buff = new StringBuffer();
        CodeStmt codeStmt2 = null;
        for (CodeStmt codeStmt2 : stmtList) {
            if (codeStmt2 instanceof IfStmt) {
                codeStmt2 = this.preTranslateIfStmt((IfStmt)codeStmt2);
            } else if (codeStmt2 instanceof ExprStmt) {
                codeStmt2 = this.preTranslateExprStmt((ExprStmt)codeStmt2);
            } else {
                throw new PerfFormuleException(PerfFormuleException.MODTH_NOT_SUPPORT);
            }
            ScriptTranslator stmtTranalator = StmtTransFactory.getTranslator(codeStmt2);
            List updStmtList = null;
            try {
                updStmtList = stmtTranalator.toKsql(ctx, codeStmt2);
            }
            catch (Exception ex) {
                throw new FormulaException(FormulaException.FORMULA_PARSE_ERROR);
            }
            if (updStmtList == null) continue;
            int size = updStmtList.size();
            for (int i = 0; i < size; ++i) {
                try {
                    DrSQLFormater formater = new DrSQLFormater(buff);
                    formater.formatUpdateStmt((SqlUpdateStmt)updStmtList.get(i));
                    buff.append(";");
                    continue;
                }
                catch (FormaterException e1) {
                    logger.error((Object)e1);
                    throw new PerfFormuleException(PerfFormuleException.FORMAT_SQL_EXEC, e1);
                }
            }
        }
        String ret = this.afterTrans(ctx, buff.toString());
        logger.debug((Object)ret);
        return ret;
    }
}

