/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.EvalPersonCollection;
import com.kingdee.eas.hr.perf.EvalPersonFactory;
import com.kingdee.eas.hr.perf.EvalPersonInfo;
import com.kingdee.eas.hr.perf.EvalRelationDetailFactory;
import com.kingdee.eas.hr.perf.EvalRelationDetailInfo;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluRelationFactory;
import com.kingdee.eas.hr.perf.EvaluRelationInfo;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.MDCommentDetailCollection;
import com.kingdee.eas.hr.perf.MDCommentDetailInfo;
import com.kingdee.eas.hr.perf.MDControlEnum;
import com.kingdee.eas.hr.perf.MDEvalDetailCollection;
import com.kingdee.eas.hr.perf.MDEvalDetailInfo;
import com.kingdee.eas.hr.perf.MDEvaluResultCollection;
import com.kingdee.eas.hr.perf.MDEvaluResultFactory;
import com.kingdee.eas.hr.perf.MDEvaluResultInfo;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MessageString;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFacadeFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorInfo;
import com.kingdee.eas.hr.perf.MultiDimTestPaperStateEnum;
import com.kingdee.eas.hr.perf.MultiDimentionCommentInfo;
import com.kingdee.eas.hr.perf.MultiDimentionEvalutionInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.PaperQueDetailCollection;
import com.kingdee.eas.hr.perf.PaperQueDetailInfo;
import com.kingdee.eas.hr.perf.PaperQuestionsInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.SynCommDetailCollection;
import com.kingdee.eas.hr.perf.SynCommDetailInfo;
import com.kingdee.eas.hr.perf.SynEvaluItemInfo;
import com.kingdee.eas.hr.perf.SynEvaluResultInfo;
import com.kingdee.eas.hr.perf.SynFlowNodeInfo;
import com.kingdee.eas.hr.perf.SynNodeProcesserFactory;
import com.kingdee.eas.hr.perf.SynNodeProcesserInfo;
import com.kingdee.eas.hr.perf.SynWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.TestPageFormFacadeFactory;
import com.kingdee.eas.hr.perf.TestPageFormFactory;
import com.kingdee.eas.hr.perf.TestPageFormInfo;
import com.kingdee.eas.hr.perf.TestPaperFactory;
import com.kingdee.eas.hr.perf.TestPaperInfo;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.web.Escape;
import com.kingdee.eas.hr.perf.web.EvalPersonUtil;
import com.kingdee.eas.hr.perf.web.PerfWebUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.STConverter;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class PerfEvaluatorWebService
extends BuffaloService {
    private static String RES = "com.kingdee.eas.hr.perf.PerfWebResource";
    Logger logger = Logger.getLogger((String)PerfEvaluatorWebService.class.getName());

    public String[] addEvalPersons(String mdEvaluatorID, String evalReDetailID, String evaluationID, String selectedPersons, String restrict, String fellowType, String relationName) {
        FilterInfo filterInfo;
        String[] error = new String[2];
        EvaluRelationInfo relationInfo = null;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (PerfUtils.objectIsNull(mdEvaluatorID) || PerfUtils.objectIsNull(evaluationID) || PerfUtils.objectIsNull(selectedPersons)) {
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        try {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)mdEvaluatorID));
            if (!MultiDimEvaluatorFactory.getLocalInstance(ctx).exists(filterInfo)) {
                error[1] = ResourceBase.getString((String)RES, (String)"evaluAnnalNotExist", (Locale)ctx.getLocale());
                error[0] = "refresh";
                return error;
            }
        }
        catch (Exception e) {
            this.logger.info((Object)e.getCause());
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        try {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)mdEvaluatorID));
            filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.SPStatuEnum", (Object)new Integer(101)));
            filterInfo.getFilterItems().add(new FilterItemInfo("auditState", (Object)new Integer(0)));
            filterInfo.getFilterItems().add(new FilterItemInfo("auditState", (Object)new Integer(60)));
            filterInfo.setMaskString("#0 and #1 and (#2 or #3)");
            if (!MultiDimEvaluatorFactory.getLocalInstance(ctx).exists(filterInfo)) {
                error[1] = ResourceBase.getString((String)RES, (String)"evaluatorStateError", (Locale)ctx.getLocale());
                error[0] = "refresh";
                return error;
            }
        }
        catch (Exception e) {
            this.logger.info((Object)e.getCause());
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("MDEvaluTypeEnum"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("personRestrict"));
            sic.add(new SelectorItemInfo("mdEvaluGroup.fellowType"));
            relationInfo = EvaluRelationFactory.getLocalInstance(ctx).getEvaluRelationInfo((IObjectPK)new ObjectUuidPK(evaluationID), sic);
        }
        catch (Exception e) {
            this.logger.info((Object)e.getCause());
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        String[] str = selectedPersons.split(",");
        HashSet<String> set = new HashSet<String>();
        int n = str.length;
        for (int i = 0; i < n; ++i) {
            if (str[i] == null || str[i].length() <= 0) continue;
            set.add(str[i]);
        }
        HashMap selectedMap = null;
        try {
            selectedMap = this.getPrimaryPositionMap(ctx, set);
        }
        catch (Exception e1) {
            this.logger.info((Object)e1.getCause());
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        if (selectedMap == null || selectedMap.size() == 0) {
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        EvalRelationDetailInfo detailInfo = null;
        if (PerfUtils.objectIsNull(evalReDetailID)) {
            try {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("evalRelation.id", (Object)evaluationID));
                fi.getFilterItems().add(new FilterItemInfo("mdEvaluator.id", (Object)mdEvaluatorID));
                if (EvalRelationDetailFactory.getLocalInstance(ctx).exists(fi)) {
                    error[1] = ResourceBase.getString((String)RES, (String)"dirtyData", (Locale)ctx.getLocale());
                    error[0] = "refresh";
                    return error;
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)ex.getMessage(), (Throwable)ex);
                error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
                error[0] = "normal";
                return error;
            }
            detailInfo = new EvalRelationDetailInfo();
            MultiDimEvaluatorInfo dimEvaluatorInfo = new MultiDimEvaluatorInfo();
            dimEvaluatorInfo.setId(BOSUuid.read((String)mdEvaluatorID));
            detailInfo.setMdEvaluator(dimEvaluatorInfo);
            detailInfo.setEvalRelation(relationInfo);
            StringBuffer sb = new StringBuffer();
            if (MDEvaluTypeEnum.APPOINT.equals((Object)relationInfo.getMDEvaluTypeEnum())) {
                sb.append(relationInfo.getName());
                sb.append("(");
                sb.append(relationInfo.getMDEvaluTypeEnum().toString());
                sb.append(")");
            } else {
                sb.append(relationInfo.getMDEvaluTypeEnum().toString());
            }
            String sname = STConverter.tc2sc((String)sb.toString());
            String tname = STConverter.sc2tc((String)sb.toString());
            detailInfo.setName(sname, new Locale("L2"));
            detailInfo.setName(tname, new Locale("L3"));
            detailInfo.setName(sb.toString(), new Locale("L1"));
            detailInfo.setId(BOSUuid.create((BOSObjectType)detailInfo.getBOSType()));
        } else {
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evalReDetailID));
            try {
                if (!EvalRelationDetailFactory.getLocalInstance(ctx).exists(filterInfo)) {
                    error[1] = ResourceBase.getString((String)RES, (String)"annalNotExist", (Locale)ctx.getLocale());
                    error[0] = "refresh";
                    return error;
                }
                detailInfo = EvalRelationDetailFactory.getLocalInstance(ctx).getEvalRelationDetailInfo((IObjectPK)new ObjectUuidPK(evalReDetailID));
            }
            catch (Exception e) {
                this.logger.info((Object)e.getCause());
                error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
                error[0] = "normal";
                return error;
            }
        }
        for (Map.Entry entry : selectedMap.entrySet()) {
            if (this.existPerson(detailInfo.getEvalPersons(), entry.getKey().toString())) continue;
            EvalPersonInfo evalPersonInfo = new EvalPersonInfo();
            detailInfo.getEvalPersons().add(evalPersonInfo);
            PersonInfo pInfo = new PersonInfo();
            pInfo.setId(BOSUuid.read((String)entry.getKey().toString()));
            evalPersonInfo.setPerson(pInfo);
            if (entry.getValue() != null) {
                PositionInfo posInfo = new PositionInfo();
                posInfo.setId(BOSUuid.read((String)entry.getValue().toString()));
                evalPersonInfo.setPosition(posInfo);
            }
            evalPersonInfo.setIsOrigin(true);
            evalPersonInfo.setPaperState(MultiDimTestPaperStateEnum.NOTSEND);
            evalPersonInfo.setWfStatus(WFStatuEnum.UNUSED);
        }
        detailInfo.setSelected(detailInfo.getEvalPersons().size());
        if (relationInfo.getPersonRestrict() < detailInfo.getEvalPersons().size()) {
            error[1] = ResourceBase.getString((String)RES, (String)"personOvertop", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        try {
            IObjectPK objectPK = EvalRelationDetailFactory.getLocalInstance(ctx).submit(detailInfo);
        }
        catch (Exception e) {
            this.logger.info((Object)e.getCause());
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        error[1] = "";
        error[0] = "refresh";
        return error;
    }

    private boolean existPerson(EvalPersonCollection evalPersons, String id) {
        if (evalPersons == null || id == null) {
            return false;
        }
        int n = evalPersons.size();
        for (int i = 0; i < n; ++i) {
            if (evalPersons.get(i).getPerson().getId() == null || !evalPersons.get(i).getPerson().getId().toString().equals(id)) continue;
            return true;
        }
        return false;
    }

    private boolean checkRelationModify(String restrict, String fellowType, String relationName, EvaluRelationInfo relationInfo, boolean fellowTypeModify) {
        if (Integer.parseInt(restrict) != relationInfo.getPersonRestrict()) {
            return true;
        }
        if (fellowType.equals("50") && fellowTypeModify) {
            return true;
        }
        if (fellowType.equals("80")) {
            return !relationName.equals(relationInfo.getName());
        }
        return false;
    }

    public HashMap getPrimaryPositionMap(Context ctx, HashSet personSet) throws Exception {
        HashMap<String, String> personPositionMap = new HashMap<String, String>();
        if (personSet == null) {
            return personPositionMap;
        }
        Iterator iterator = personSet.iterator();
        while (iterator.hasNext()) {
            personPositionMap.put(iterator.next().toString(), null);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("position.id"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        PositionMemberCollection coll = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(evi);
        if (coll.size() != 0) {
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                personPositionMap.put(coll.get(i).getPerson().getId().toString(), coll.get(i).getPosition().getId().toString());
            }
        }
        return personPositionMap;
    }

    private void removeEvalPersonByID(EvalRelationDetailInfo evalRelationDetailInfo, String id) {
        if (evalRelationDetailInfo == null || evalRelationDetailInfo.getEvalPersons() == null || id == null) {
            return;
        }
        int n = evalRelationDetailInfo.getEvalPersons().size();
        for (int i = 0; i < n; ++i) {
            if (!evalRelationDetailInfo.getEvalPersons().get(i).getId().toString().equals(id)) continue;
            evalRelationDetailInfo.getEvalPersons().removeObject(i);
            evalRelationDetailInfo.setSelected(evalRelationDetailInfo.getEvalPersons().size());
            break;
        }
    }

    public String[] delEvalPerson(String evalReDetailID, String evalPersonID) {
        String[] error = new String[2];
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (evalReDetailID == null || evalPersonID == null) {
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        EvalRelationDetailInfo detailInfo = null;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evalReDetailID));
        try {
            if (!EvalRelationDetailFactory.getLocalInstance(ctx).exists(filterInfo)) {
                error[1] = ResourceBase.getString((String)RES, (String)"annalNotExist", (Locale)ctx.getLocale());
                error[0] = "refresh";
                return error;
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evalReDetailID));
            filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluator.solutionPeriod.SPStatuEnum", (Object)new Integer(101)));
            filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluator.auditState", (Object)new Integer(0)));
            filterInfo.getFilterItems().add(new FilterItemInfo("mdEvaluator.auditState", (Object)new Integer(60)));
            filterInfo.setMaskString("#0 and #1 and (#2 or #3)");
            if (!EvalRelationDetailFactory.getLocalInstance(ctx).exists(filterInfo)) {
                error[1] = ResourceBase.getString((String)RES, (String)"evalRelationDetailStateError", (Locale)ctx.getLocale());
                error[0] = "refresh";
                return error;
            }
            detailInfo = EvalRelationDetailFactory.getLocalInstance(ctx).getEvalRelationDetailInfo((IObjectPK)new ObjectUuidPK(evalReDetailID));
        }
        catch (Exception e) {
            this.logger.info((Object)e.getCause());
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evalPersonID));
        try {
            if (!EvalPersonFactory.getLocalInstance(ctx).exists(filterInfo)) {
                error[1] = ResourceBase.getString((String)RES, (String)"annalNotExist", (Locale)ctx.getLocale());
                error[0] = "refresh";
                return error;
            }
        }
        catch (Exception e) {
            this.logger.info((Object)e.getCause());
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        this.removeEvalPersonByID(detailInfo, evalPersonID);
        try {
            IObjectPK objectPK = EvalRelationDetailFactory.getLocalInstance(ctx).submit(detailInfo);
        }
        catch (Exception e) {
            this.logger.info((Object)e.getCause());
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        error[1] = "";
        error[0] = "refresh";
        return error;
    }

    public String[] submitMDEvaluator(String mdEvaluatorID, String mdEvaluGroupID) {
        String[] error = new String[2];
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (mdEvaluatorID == null || mdEvaluGroupID == null) {
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        try {
            MultiDimEvaluatorFacadeFactory.getLocalInstance(ctx).submitEvaluator(mdEvaluatorID, mdEvaluGroupID);
        }
        catch (EASBizException e) {
            this.logger.info((Object)e.getCause());
            error[1] = e.getMessage();
            error[0] = "normal";
            return error;
        }
        catch (BOSException e) {
            this.logger.info((Object)e.getCause());
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
            error[0] = "normal";
            return error;
        }
        error[1] = ResourceBase.getString((String)RES, (String)"submitSuccess", (Locale)ctx.getLocale());
        error[0] = "refresh";
        return error;
    }

    public String[] getMDHastenEvaluRef(String mdEvaluatorID, String mdSolutionPeriodID) {
        String[] result = new String[3];
        if (mdEvaluatorID == null) {
            return result;
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("multiDimObject.id"));
            sic.add(new SelectorItemInfo("multiDimObject.person.id"));
            sic.add(new SelectorItemInfo("multiDimObject.person.number"));
            sic.add(new SelectorItemInfo("multiDimObject.person.name"));
            sic.add(new SelectorItemInfo("multiDimObject.position.id"));
            sic.add(new SelectorItemInfo("multiDimObject.position.name"));
            sic.add(new SelectorItemInfo("multiDimObject.position.adminOrgUnit.id"));
            sic.add(new SelectorItemInfo("multiDimObject.position.adminOrgUnit.displayName"));
            sic.add(new SelectorItemInfo("multiDimObject.position.adminOrgUnit.name"));
            MultiDimEvaluatorInfo dimEvaluatorInfo = MultiDimEvaluatorFactory.getLocalInstance(ctx).getMultiDimEvaluatorInfo((IObjectPK)new ObjectUuidPK(mdEvaluatorID), sic);
            result[0] = dimEvaluatorInfo.getMultiDimObject().getPerson().getId().toString();
            result[1] = dimEvaluatorInfo.getMultiDimObject().getPerson().getName();
            MultiDimentionSolutionPeriodInfo dimentionSolutionPeriodInfo = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(mdSolutionPeriodID));
            result[2] = dimentionSolutionPeriodInfo.getName();
        }
        catch (EASBizException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String canViewProcess(String mdSolutionID, String mdEvaluatorID) {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (mdSolutionID == null || mdSolutionID.length() == 0) {
            return ResourceBase.getString((String)RES, (String)"cannotView", (Locale)ctx.getLocale());
        }
        if (mdEvaluatorID == null || mdEvaluatorID.length() == 0) {
            return ResourceBase.getString((String)RES, (String)"cannotView", (Locale)ctx.getLocale());
        }
        SelectorItemCollection collection = new SelectorItemCollection();
        collection.add(new SelectorItemInfo("canViewSelfForm"));
        collection.add(new SelectorItemInfo("canViewEvalor"));
        MultiDimentionSolutionInfo dimentionSolutionInfo = null;
        try {
            dimentionSolutionInfo = MultiDimentionSolutionFactory.getLocalInstance(ctx).getMultiDimentionSolutionInfo((IObjectPK)new ObjectUuidPK(mdSolutionID), collection);
        }
        catch (EASBizException e1) {
            this.logger.error((Object)e1.getMessage(), (Throwable)e1);
            return e1.getCause().getMessage();
        }
        catch (BOSException e1) {
            this.logger.error((Object)e1.getMessage(), (Throwable)e1);
            return e1.getMessage();
        }
        collection = new SelectorItemCollection();
        collection.add(new SelectorItemInfo("auditState"));
        MultiDimEvaluatorInfo mdEvaluatorInfo = null;
        try {
            mdEvaluatorInfo = MultiDimEvaluatorFactory.getLocalInstance(ctx).getMultiDimEvaluatorInfo((IObjectPK)new ObjectUuidPK(mdEvaluatorID), collection);
        }
        catch (EASBizException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return e.getCause().getMessage();
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return e.getMessage();
        }
        if (!dimentionSolutionInfo.isCanViewEvalor() && !dimentionSolutionInfo.isCanViewSelfForm()) {
            return ResourceBase.getString((String)RES, (String)"CanViewSelfForm", (Locale)ctx.getLocale());
        }
        if (mdEvaluatorInfo.getAuditState().getValue() != 80) {
            return ResourceBase.getString((String)RES, (String)"NOTALREADYSEND", (Locale)ctx.getLocale());
        }
        return null;
    }

    public boolean sendMessage(String solutionPeriodName, String evaluObjectName, String hastenPersons) {
        HashMap<String, MessageString> messageMap = new HashMap<String, MessageString>();
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String[] str = hastenPersons.split(";");
        HashMap<String, String> personMap = new HashMap<String, String>();
        HashSet<String> personSet = new HashSet<String>();
        int n = str.length;
        for (int i = 0; i < n; ++i) {
            String[] temp = str[i].split(",");
            personSet.add(temp[0]);
        }
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", personSet, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(viewInfo);
            int n2 = personCollection.size();
            for (int i = 0; i < n2; ++i) {
                personMap.put(personCollection.get(i).getId().toString(), personCollection.get(i).getName());
            }
            Iterator iterator = personSet.iterator();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                String evalPersonName = personMap.get(key).toString();
                MessageString messageString = new MessageString();
                String message = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"hastenSubmitPaper", (Locale)ctx.getLocale());
                Object[] variables = new Object[]{evalPersonName, solutionPeriodName, evaluObjectName};
                messageString.setTitle(MessageFormat.format(message, variables));
                messageString.setSender(ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"sender", (Locale)ctx.getLocale()));
                messageMap.put(key, messageString);
            }
            EvalWorkFlowFacadeFactory.getLocalInstance(ctx).sendMessage(messageMap);
        }
        catch (Exception e) {
            this.logger.info((Object)e.getCause());
            return false;
        }
        return true;
    }

    public String getTestPaperID(String reDetailID) {
        if (!PerfUtils.objectIsNull(reDetailID)) {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("evalRelation.id"));
            sic.add(new SelectorItemInfo("evalRelation.paper.id"));
            try {
                EvalRelationDetailInfo erdi = EvalRelationDetailFactory.getLocalInstance(ctx).getEvalRelationDetailInfo((IObjectPK)new ObjectUuidPK(reDetailID), sic);
                if (erdi != null && erdi.getEvalRelation() != null && erdi.getEvalRelation().getPaper() != null) {
                    return erdi.getEvalRelation().getPaper().getId().toString();
                }
            }
            catch (Exception e) {
                this.logger.info((Object)e.getCause());
            }
            return "";
        }
        return "";
    }

    public String[] getTestPageFormRefInfo(String testPageFormID) {
        String[] result = new String[4];
        if (!PerfUtils.objectIsNull(testPageFormID)) {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("evalPerson.id"));
            sic.add(new SelectorItemInfo("testPaper.id"));
            sic.add(new SelectorItemInfo("mdEvaluResult.mdObject.id"));
            sic.add(new SelectorItemInfo("mdEvaluResult.solutionPeriod.id"));
            try {
                TestPageFormInfo testPageFormInfo = TestPageFormFactory.getLocalInstance(ctx).getTestPageFormInfo((IObjectPK)new ObjectUuidPK(testPageFormID), sic);
                result[0] = testPageFormInfo.getEvalPerson().getId().toString();
                result[1] = testPageFormInfo.getMdEvaluResult().getMdObject().getId().toString();
                result[2] = testPageFormInfo.getMdEvaluResult().getSolutionPeriod().getId().toString();
                result[3] = testPageFormInfo.getTestPaper().getId().toString();
            }
            catch (Exception e) {
                this.logger.info((Object)e.getCause());
            }
            return result;
        }
        return result;
    }

    public boolean reBackPaper(String cause, String assignmentId) {
        if (cause == null) {
            cause = "";
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String message = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfWebResource", (String)"reBackMsg", (Locale)ctx.getLocale());
        Object[] variables = new Object[]{Escape.unescape(cause)};
        try {
            SynWorkFlowFacadeFactory.getLocalInstance(ctx).reBack(assignmentId, ResourceBase.getString((String)"com.kingdee.eas.hr.perf.PerfWebResource", (String)"alreadyRebackMsg", (Locale)ctx.getLocale()), MessageFormat.format(message, variables));
        }
        catch (EASBizException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public String[] submitSynPaperForm(String submitType, String isgrade, String id, String result, String[][] strComment, String assignmentID, String evaluResultID, String evalor, String evaluNodeID) {
        String[] error = new String[2];
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            SynNodeProcesserInfo info = new SynNodeProcesserInfo();
            info.setId(BOSUuid.read((String)id));
            PersonInfo evaluer = new PersonInfo();
            evaluer.setId(BOSUuid.read((String)evalor));
            info.setEvaluer(evaluer);
            SynEvaluResultInfo evaluResultInfo = new SynEvaluResultInfo();
            evaluResultInfo.setId(BOSUuid.read((String)evaluResultID));
            info.setEvaluResult(evaluResultInfo);
            SynFlowNodeInfo flowNodeInfo = new SynFlowNodeInfo();
            flowNodeInfo.setId(BOSUuid.read((String)evaluNodeID));
            info.setEvaluNode(flowNodeInfo);
            if ("true".equals(isgrade)) {
                if (result == null || "".equals(result)) {
                    info.setScore(null);
                } else {
                    info.setScore(new BigDecimal(result));
                }
            } else if (!(PerfUtils.objectIsNull(result) || "undefined".equals(result) || "".equals(result))) {
                RankInfo rankInfo = new RankInfo();
                rankInfo.setId(BOSUuid.read((String)result));
                info.setRank(rankInfo);
            } else {
                info.setRank(null);
            }
            SynCommDetailCollection commColl = info.getComments();
            SynCommDetailInfo commDetailInfo = null;
            SynEvaluItemInfo evaluItemInfo = null;
            int n = strComment.length;
            for (int i = 0; i < n; ++i) {
                commDetailInfo = new SynCommDetailInfo();
                evaluItemInfo = new SynEvaluItemInfo();
                evaluItemInfo.setId(BOSUuid.read((String)strComment[i][0]));
                commDetailInfo.setEvaluItem(evaluItemInfo);
                commDetailInfo.setId(BOSUuid.read((String)strComment[i][1]));
                commDetailInfo.setNodeProcesser(info);
                commDetailInfo.setComment(Escape.unescape(strComment[i][2]));
                commColl.add(commDetailInfo);
            }
            info.setProcesserName(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getName());
            if ("submit".equals(submitType)) {
                info.setExtendedProperty("assignmentID", assignmentID);
                info.setExtendedProperty("isAddNew", "isAddNew");
                SynWorkFlowFacadeFactory.getLocalInstance(ctx).clearReBackReason(assignmentID);
                SynNodeProcesserFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                error[0] = "success";
                error[1] = ResourceBase.getString((String)RES, (String)"submitSuccess", (Locale)ctx.getLocale());
            } else {
                SynNodeProcesserFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
                error[0] = "success";
                error[1] = ResourceBase.getString((String)RES, (String)"saveSuccess", (Locale)ctx.getLocale());
            }
        }
        catch (EASBizException ex) {
            this.logger.info((Object)ex.getCause());
            error[0] = "faild";
            error[1] = ex.getMessage();
        }
        catch (Exception e) {
            this.logger.info((Object)e.getCause());
            error[0] = "faild";
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
        }
        return error;
    }

    public String[] submitMDEvaluResultForm(String submitType, String isgrade, String id, String[][] questionDetailArray, String[][] evaluDetailArray, String[][] commentArray, String evaluResultID, String evalPersonid, String testPaperID, String mdSolutionPeriodID, String mdObject, String score, String rank, String mdEvaluatorID, String evalReDetailID) {
        String[] error = new String[7];
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            TestPageFormInfo testPageInfo = new TestPageFormInfo();
            EvalPersonInfo evalPerson = new EvalPersonInfo();
            evalPerson.setId(BOSUuid.read((String)evalPersonid));
            testPageInfo.setEvalPerson(evalPerson);
            TestPaperInfo testPaper = new TestPaperInfo();
            testPaper.setId(BOSUuid.read((String)testPaperID));
            testPageInfo.setTestPaper(testPaper);
            if (!PerfUtils.objectIsNull(score)) {
                testPageInfo.setScore(new BigDecimal(score));
            } else {
                testPageInfo.setScore(null);
            }
            if (PerfUtils.objectIsNull(id)) {
                testPageInfo.setId(BOSUuid.create((BOSObjectType)testPageInfo.getBOSType()));
                error[2] = testPageInfo.getId().toString();
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("mdObject.id", (Object)mdObject));
                filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriodID));
                viewInfo.setFilter(filter);
                viewInfo.getSelector().add(new SelectorItemInfo("id"));
                MDEvaluResultCollection mderColl = MDEvaluResultFactory.getLocalInstance(ctx).getMDEvaluResultCollection(viewInfo);
                if (mderColl != null && mderColl.size() > 0) {
                    testPageInfo.setMdEvaluResult(mderColl.get(0));
                }
                error[3] = testPageInfo.getMdEvaluResult().getId().toString();
            } else {
                testPageInfo.setId(BOSUuid.read((String)id));
                MDEvaluResultInfo evaluResultInfo = new MDEvaluResultInfo();
                evaluResultInfo.setId(BOSUuid.read((String)evaluResultID));
                testPageInfo.setMdEvaluResult(evaluResultInfo);
            }
            StringBuffer sb = new StringBuffer();
            PaperQueDetailCollection pqdColl = testPageInfo.getPaperQueDetail();
            int n = questionDetailArray.length;
            for (int i = 0; i < n; ++i) {
                PaperQueDetailInfo paperQueDetailInfo = new PaperQueDetailInfo();
                if (PerfUtils.objectIsNull(questionDetailArray[i][0])) {
                    paperQueDetailInfo.setId(BOSUuid.create((BOSObjectType)paperQueDetailInfo.getBOSType()));
                    sb.append(questionDetailArray[i][1]);
                    sb.append(",");
                    sb.append(paperQueDetailInfo.getId().toString());
                    sb.append(";");
                } else {
                    paperQueDetailInfo.setId(BOSUuid.read((String)questionDetailArray[i][0]));
                }
                PaperQuestionsInfo paperQuestionsInfo = new PaperQuestionsInfo();
                paperQuestionsInfo.setId(BOSUuid.read((String)questionDetailArray[i][1]));
                paperQueDetailInfo.setPaperQue(paperQuestionsInfo);
                if ("true".equals(isgrade)) {
                    if (!(PerfUtils.objectIsNull(questionDetailArray[i][2]) || "undefined".equals(questionDetailArray[i][2]) || "".equals(questionDetailArray[i][2]))) {
                        RankInfo rankInfo = new RankInfo();
                        rankInfo.setId(BOSUuid.read((String)questionDetailArray[i][2]));
                        paperQueDetailInfo.setRank(rankInfo);
                    } else {
                        paperQueDetailInfo.setRank(null);
                    }
                } else if (!PerfUtils.objectIsNull(questionDetailArray[i][2])) {
                    paperQueDetailInfo.setScore(new BigDecimal(questionDetailArray[i][2]));
                } else {
                    paperQueDetailInfo.setScore(null);
                }
                paperQueDetailInfo.setTestPageForm(testPageInfo);
                pqdColl.add(paperQueDetailInfo);
            }
            error[4] = sb.toString();
            sb = new StringBuffer();
            MDEvalDetailCollection mdedColl = testPageInfo.getMdEvalDetail();
            MDEvalDetailInfo mdedInfo = null;
            MultiDimentionEvalutionInfo mdeInfo = null;
            int n2 = evaluDetailArray.length;
            for (int i = 0; i < n2; ++i) {
                mdedInfo = new MDEvalDetailInfo();
                if (PerfUtils.objectIsNull(evaluDetailArray[i][0])) {
                    mdedInfo.setId(BOSUuid.create((BOSObjectType)mdedInfo.getBOSType()));
                    sb.append(evaluDetailArray[i][1]);
                    sb.append(",");
                    sb.append(mdedInfo.getId().toString());
                    sb.append(";");
                } else {
                    mdedInfo.setId(BOSUuid.read((String)evaluDetailArray[i][0]));
                }
                mdeInfo = new MultiDimentionEvalutionInfo();
                mdeInfo.setId(BOSUuid.read((String)evaluDetailArray[i][1]));
                mdedInfo.setMdEval(mdeInfo);
                if (!PerfUtils.objectIsNull(evaluDetailArray[i][2])) {
                    mdedInfo.setScore(new BigDecimal(evaluDetailArray[i][2]));
                } else {
                    mdedInfo.setScore(null);
                }
                mdedInfo.setTestPaperForm(testPageInfo);
                mdedColl.add(mdedInfo);
            }
            error[5] = sb.toString();
            sb = new StringBuffer();
            MDCommentDetailCollection mdcdColl = testPageInfo.getMdCommentDetail();
            MDCommentDetailInfo mdcdInfo = null;
            int n3 = commentArray.length;
            for (int i = 0; i < n3; ++i) {
                mdcdInfo = new MDCommentDetailInfo();
                if (PerfUtils.objectIsNull(commentArray[i][0])) {
                    mdcdInfo.setId(BOSUuid.create((BOSObjectType)mdcdInfo.getBOSType()));
                    sb.append(commentArray[i][1]);
                    sb.append(",");
                    sb.append(mdcdInfo.getId().toString());
                    sb.append(";");
                } else {
                    mdcdInfo.setId(BOSUuid.read((String)commentArray[i][0]));
                }
                MultiDimentionCommentInfo commentInfo = new MultiDimentionCommentInfo();
                commentInfo.setId(BOSUuid.read((String)commentArray[i][1]));
                mdcdInfo.setMdComment(commentInfo);
                mdcdInfo.setEvaluation(Escape.unescape(commentArray[i][2]));
                mdcdInfo.setTestPaperForm(testPageInfo);
                mdcdColl.add(mdcdInfo);
            }
            error[6] = sb.toString();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evalPerson.id", (Object)evalPersonid));
            if (!PerfUtils.objectIsNull(id)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
            }
            TestPageFormFactory.getLocalInstance(ctx).delete(filterInfo);
            if ("submit".equals(submitType)) {
                BigDecimal score2 = testPageInfo.getScore();
                score2 = score2.setScale(6, 4);
                BigDecimal soluScore = null;
                BigDecimal zero = new BigDecimal("0.000000");
                BigDecimal minGrade = null;
                BigDecimal maxGrade = null;
                GradeModeInfo soluGradeMode = null;
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("MDSolution.GradeMode.minGrade"));
                sic.add(new SelectorItemInfo("MDSolution.GradeMode.maxGrade"));
                soluGradeMode = MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(mdSolutionPeriodID), sic).getMDSolution().getGradeMode();
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("gradeMode.minGrade"));
                sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
                GradeModeInfo paperGradeMode = TestPaperFactory.getLocalInstance(ctx).getTestPaperInfo((IObjectPK)new ObjectUuidPK(testPaperID), sic).getGradeMode();
                minGrade = paperGradeMode.getMinGrade();
                maxGrade = paperGradeMode.getMaxGrade();
                soluScore = zero.add(score2.subtract(minGrade)).divide(maxGrade.subtract(minGrade), 4);
                soluScore = soluScore.multiply(soluGradeMode.getMaxGrade().subtract(soluGradeMode.getMinGrade())).add(soluGradeMode.getMinGrade());
                EvalPersonInfo evalPerson2 = new EvalPersonInfo();
                evalPerson2.setId(testPageInfo.getEvalPerson().getId());
                evalPerson2.setScore(soluScore);
                evalPerson2.setPaperState(MultiDimTestPaperStateEnum.SUBMIT);
                evalPerson2.setWfStatus(WFStatuEnum.CLOSED);
                evalPerson2.setRank(testPageInfo.getRank());
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("score"));
                sic.add(new SelectorItemInfo("rank"));
                sic.add(new SelectorItemInfo("paperState"));
                sic.add(new SelectorItemInfo("wfStatus"));
                EvalPersonFactory.getLocalInstance(ctx).updatePartial(evalPerson2, sic);
                TestPageFormFactory.getLocalInstance(ctx).save(testPageInfo);
                TestPageFormFacadeFactory.getLocalInstance(ctx).updateStatusAndCountScoreNoWorkFlow(evalPersonid, mdSolutionPeriodID, mdObject, mdEvaluatorID, evalReDetailID);
                error[0] = "success";
                error[1] = ResourceBase.getString((String)RES, (String)"submitSuccess", (Locale)ctx.getLocale());
            } else {
                TestPageFormFactory.getLocalInstance(ctx).save(testPageInfo);
                error[0] = "success";
                error[1] = ResourceBase.getString((String)RES, (String)"saveSuccess", (Locale)ctx.getLocale());
            }
        }
        catch (EASBizException ex) {
            this.logger.info((Object)ex.getCause(), (Throwable)ex);
            error[0] = "faild";
            error[1] = ex.getMessage();
        }
        catch (Exception e) {
            this.logger.info((Object)e.getCause(), (Throwable)e);
            error[0] = "faild";
            error[1] = ResourceBase.getString((String)RES, (String)"operationError", (Locale)ctx.getLocale());
        }
        return error;
    }

    public String getHastenPersonsID(List relationIDList, String evalor) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet set = new HashSet();
        for (int i = 0; i < relationIDList.size(); ++i) {
            set.add(relationIDList.get(i));
        }
        filter.getFilterItems().add(new FilterItemInfo("evalPersons.paperState", (Object)new Integer(10)));
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        SorterItemInfo item = new SorterItemInfo("person.id");
        sorter.add(item);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvalRelationDetailEvalPersonPaperQuery");
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)WebContextUtil.getEasContext((HttpServletRequest)request), (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        StringBuffer hastenPersons = new StringBuffer();
        try {
            IRowSet rowSet = exec.executeQuery();
            while (rowSet.next()) {
                if (evalor.equals(rowSet.getString("person.id"))) continue;
                hastenPersons.append(rowSet.getString("person.id"));
                hastenPersons.append(",");
                hastenPersons.append(20);
                hastenPersons.append(";");
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        hastenPersons.append(evalor);
        hastenPersons.append(",");
        hastenPersons.append(10);
        if (hastenPersons != null) {
            return hastenPersons.toString();
        }
        return null;
    }

    public String getEvalProcHastenDataXml(String hastenPersons) {
        int COLUMN = 8;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (hastenPersons == null || hastenPersons.length() == 0) {
            return PerfWebUtils.makeErrorProcDataToXMLData(ctx, COLUMN);
        }
        String[] str = hastenPersons.split(";");
        HashMap<String, MDControlEnum> personMap = new HashMap<String, MDControlEnum>();
        String[] ids = new String[str.length];
        int n = str.length;
        for (int i = 0; i < n; ++i) {
            String[] temp = str[i].split(",");
            personMap.put(temp[0], MDControlEnum.getEnum(Integer.parseInt(temp[1])));
            ids[i] = temp[0];
        }
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            IRowSet rowSet = EvalPersonUtil.getPersonRowSetByPersonIds(ctx, ids);
            list.add("" + rowSet.size());
            int index = 0;
            while (rowSet.next()) {
                String[] printStr = new String[COLUMN];
                printStr[0] = "" + ++index;
                printStr[1] = rowSet.getString("id");
                printStr[2] = rowSet.getString("name");
                printStr[3] = rowSet.getString("number");
                printStr[4] = rowSet.getString("position.name");
                printStr[5] = rowSet.getString("adminOrgUnit.name") == null || "".equals(rowSet.getString("adminOrgUnit.name")) ? ResourceBase.getString((String)RES, (String)"noPositionPerson", (Locale)ctx.getLocale()) : rowSet.getString("adminOrgUnit.name");
                printStr[6] = ((MDControlEnum)((Object)personMap.get(rowSet.getString("id")))).toString();
                printStr[7] = rowSet.getString("id") + "," + ((MDControlEnum)((Object)personMap.get(rowSet.getString("id")))).getValue();
                list.add(printStr);
            }
        }
        catch (Exception e) {
            return PerfWebUtils.makeErrorProcDataToXMLData(ctx, COLUMN);
        }
        String xmlData = PerfWebUtils.makeProcDataToXMLData(list, COLUMN);
        return xmlData;
    }
}

