/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.RouterActivityDef;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeException;
import com.kingdee.eas.hr.perf.SynWorkFlowFacadeFactory;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class PerfWebService
extends BuffaloService {
    Logger logger = Logger.getLogger((String)PerfWebService.class.getName());

    public boolean reBackPaper(String cause, String assignmentId) {
        if (cause == null || "".equals(cause)) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String message = ResourceBase.getString((String)"com.kingdee.eas.hr.perf.client.NodeProcesserResource", (String)"reBackMsg", (Locale)ctx.getLocale());
        Object[] variables = new Object[]{cause};
        try {
            SynWorkFlowFacadeFactory.getLocalInstance(ctx).reBack(assignmentId, ResourceBase.getString((String)"com.kingdee.eas.hr.perf.client.NodeProcesserResource", (String)"alreadyRebackMsg", (Locale)ctx.getLocale()), MessageFormat.format(message, variables));
        }
        catch (EASBizException e) {
            this.logger.error((Object)e.getMessage());
            return false;
        }
        catch (BOSException e) {
            this.logger.error((Object)e.getMessage());
            return false;
        }
        return true;
    }

    protected void reBack(Context ctx, String assignmentID, String reBackTitle, String reBackReason) throws BOSException, EASBizException {
        EnactmentServiceProxy workflowClient = new EnactmentServiceProxy(ctx);
        AssignmentInfo assignmentInfo = workflowClient.getAssignmentById(assignmentID);
        ActivityInstInfo activityInstInfo = this.getActivityInstInfoById(ctx, assignmentInfo.getProcInstId(), assignmentInfo.getActInstId());
        ActivityInstInfo routerActivityInstInfo = null;
        if (!"open.running".equals(activityInstInfo.getState())) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.REBACK_FAILD);
        }
        String[] activityInstIDs = activityInstInfo.getPreActInstList();
        ActivityInstInfo actInfo = workflowClient.getActivityInstByActInstId(activityInstIDs[0]);
        ActivityDef activityDef = workflowClient.getActDefByActInstInfo(actInfo);
        if (activityDef instanceof StartActivityDef) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.FIRSTNODE_CANNOTREBACK);
        }
        if (!(activityDef instanceof RouterActivityDef)) {
            throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.REBACK_FAILD);
        }
        routerActivityInstInfo = this.getActivityInstInfoById(ctx, assignmentInfo.getProcInstId(), activityInstIDs[0]);
        activityInstIDs = routerActivityInstInfo.getPreActInstList();
        String[] postActivityInstIDs = routerActivityInstInfo.getToActInstList();
        if (postActivityInstIDs.length >= 1) {
            int n = postActivityInstIDs.length;
            for (int i = 0; i < n; ++i) {
                ActivityInstInfo postActivityInstInfo = this.getActivityInstInfoById(ctx, assignmentInfo.getProcInstId(), postActivityInstIDs[i]);
                if (!"closed.completed".equals(postActivityInstInfo.getState())) continue;
                workflowClient.rollbackActInst(postActivityInstIDs[i]);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("reBackTitle", reBackTitle);
        map.put("reBackReason", reBackReason);
        workflowClient.setProcessContext(assignmentInfo.getProcInstId(), map);
        int n = activityInstIDs.length;
        for (int i = 0; i < n; ++i) {
            try {
                workflowClient.rollbackActInst(activityInstIDs[i]);
                continue;
            }
            catch (Exception ex) {
                throw new EvalWorkFlowFacadeException(EvalWorkFlowFacadeException.REBACK_FAILD);
            }
        }
    }

    private ActivityInstInfo getActivityInstInfoById(Context ctx, String procInstId, String actInstID) throws BOSException, EASBizException {
        EnactmentServiceProxy workflowClient = new EnactmentServiceProxy(ctx);
        ActivityInstInfo[] activityInstInfos = workflowClient.getActInstMetaArrayByProcInstId(procInstId);
        int n = activityInstInfos.length;
        for (int i = 0; i < n; ++i) {
            if (!actInstID.equals(activityInstInfos[i].getActInstId())) continue;
            return activityInstInfos[i];
        }
        return null;
    }
}

