/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.perf.EvalWFObjectsCollection;
import com.kingdee.eas.hr.perf.EvalWFObjectsInfo;
import com.kingdee.eas.hr.perf.EvaluObjectFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.web.JsonObjectUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;

public class PersonalTargetEvaluStoreManageAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger(PersonalTargetEvaluStoreManageAction.class);

    public ActionForward getEvaluObject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String spId = request.getParameter("solutionPeriodId");
        EvalWFObjectsCollection evaluWfObjColl = this.getEvaluWFObjColl(request, spId, personId);
        JSONArray evaluobjJsonArray = new JSONArray();
        JSONObject evaluobjJsonResult = new JSONObject();
        evaluobjJsonArray = this.getJSONObject(evaluWfObjColl);
        evaluobjJsonResult.put("evaluObjcet", (Object)evaluobjJsonArray);
        String resultMsg = evaluobjJsonResult.toString();
        this.handleResult(response, resultMsg);
        return null;
    }

    private void handleResult(HttpServletResponse response, String resultMsg) {
        try {
            response.setContentType("text/json;charset=utf-8");
            response.getWriter().write(resultMsg);
            response.getWriter().flush();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void initEvaluObjectIdSet(HttpServletRequest request, String logInPersonId) {
        PersonCollection personColl = new PersonCollection();
        PersonInfo logInPersonInfo = new PersonInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        try {
            personColl = TargetEvaluStoreFactory.getRemoteInstance().getPersonalSubAndDeliverEvaluObject(BOSUuid.read((String)logInPersonId));
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            logInPersonInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(logInPersonId), sic);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), e.getCause());
        }
        if (personColl != null) {
            personColl.add(logInPersonInfo);
            HashSet<BOSUuid> objectIdSet = new HashSet<BOSUuid>();
            HashSet evaluObjectSet = new HashSet();
            PersonInfo person = null;
            int n = personColl.size();
            for (int i = 0; i < n; ++i) {
                HashMap<String, PersonInfo> personMap = null;
                person = personColl.get(i);
                if (person.get("evaluObject") != null) {
                    if (evaluObjectSet.size() == 0) {
                        evaluObjectSet.addAll((Set)person.get("evaluObject"));
                    }
                } else {
                    objectIdSet.add(person.getId());
                }
                if (personMap == null) {
                    personMap = new HashMap<String, PersonInfo>();
                }
                personMap.put(person.getId().toString(), person);
            }
            HttpSession session = request.getSession();
            session.setAttribute("objectId", objectIdSet);
            session.setAttribute("evaluObject", evaluObjectSet);
        }
    }

    private EvalWFObjectsCollection getEvaluWFObjColl(HttpServletRequest request, String solutionPeriodId, String personId) {
        if (StringUtils.isEmpty((String)solutionPeriodId)) {
            return null;
        }
        HttpSession session = request.getSession();
        Set objectIdSet = (Set)session.getAttribute("objectId");
        if (objectIdSet == null) {
            this.initEvaluObjectIdSet(request, personId);
            objectIdSet = (Set)session.getAttribute("objectId");
        }
        Set evaluObjectSet = (Set)session.getAttribute("evaluObject");
        EvalWFObjectsCollection evalWFObjectsColl = null;
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            evalWFObjectsColl = EvaluObjectFacadeFactory.getLocalInstance(ctx).getPersonByEvaluSolutionId(BOSUuid.read((String)solutionPeriodId), objectIdSet, evaluObjectSet);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage(), e.getCause());
        }
        return evalWFObjectsColl;
    }

    private JSONArray getJSONObject(EvalWFObjectsCollection evaluWfObjColl) {
        if (evaluWfObjColl == null || evaluWfObjColl.size() == 0) {
            return null;
        }
        JSONArray evaluobjJsonArray = new JSONArray();
        EvalWFObjectsInfo evaluWfObjectInfo = null;
        EvaluObjectInfo evaluObjectInfo = null;
        Iterator iterator = evaluWfObjColl.iterator();
        int i = 1;
        while (iterator.hasNext()) {
            evaluWfObjectInfo = (EvalWFObjectsInfo)iterator.next();
            evaluObjectInfo = evaluWfObjectInfo.getEvaluObject();
            JSONObject evaluObjectJsonObj = JsonObjectUtils.convertEvaluObjectForList(evaluObjectInfo);
            evaluobjJsonArray.put((Object)evaluObjectJsonObj);
            ++i;
        }
        return evaluobjJsonArray;
    }
}

