/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.hr.perf.EvalPersonFactory;
import com.kingdee.eas.hr.perf.EvalPersonInfo;
import com.kingdee.eas.hr.perf.MultiDimTestPaperStateEnum;
import com.kingdee.eas.hr.perf.MultiDimentionCommentCollection;
import com.kingdee.eas.hr.perf.MultiDimentionCommentFactory;
import com.kingdee.eas.hr.perf.MultiDimentionEvalutionCollection;
import com.kingdee.eas.hr.perf.MultiDimentionEvalutionInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.PaperQuestionsCollection;
import com.kingdee.eas.hr.perf.PaperQuestionsInfo;
import com.kingdee.eas.hr.perf.TestPageFormInfo;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.web.PerfWebUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class TestPaperScoreUtil {
    private static final Logger logger = Logger.getLogger(TestPaperScoreUtil.class);

    public static MultiDimentionEvalutionCollection getMultiDimentionEvalutionFromTestPageForm(TestPageFormInfo testPageFormInfo) {
        HashSet<String> hashSet = new HashSet<String>();
        MultiDimentionEvalutionCollection mdEvaluColl = new MultiDimentionEvalutionCollection();
        int n = testPageFormInfo.getMdEvalDetail().size();
        for (int i = 0; i < n; ++i) {
            if (testPageFormInfo.getMdEvalDetail().get(i).getMdEval() == null || hashSet.contains(testPageFormInfo.getMdEvalDetail().get(i).getMdEval().getId().toString())) continue;
            mdEvaluColl.add(testPageFormInfo.getMdEvalDetail().get(i).getMdEval());
            hashSet.add(testPageFormInfo.getMdEvalDetail().get(i).getMdEval().getId().toString());
        }
        int size = mdEvaluColl.size();
        int[] numbers = new int[size];
        HashMap<String, MultiDimentionEvalutionInfo> map = new HashMap<String, MultiDimentionEvalutionInfo>();
        for (int k = 0; k < size; ++k) {
            numbers[k] = mdEvaluColl.get(k).getSerial();
            map.put("" + numbers[k], mdEvaluColl.get(k));
        }
        Arrays.sort(numbers);
        mdEvaluColl = new MultiDimentionEvalutionCollection();
        for (int i = 0; i < size; ++i) {
            mdEvaluColl.add((MultiDimentionEvalutionInfo)map.get("" + numbers[i]));
        }
        return mdEvaluColl;
    }

    public static PaperQuestionsCollection getQuestionsFromTestPageForm(TestPageFormInfo testPageFormInfo) {
        HashSet<String> hashSet = new HashSet<String>();
        PaperQuestionsCollection mdEvaluColl = new PaperQuestionsCollection();
        int n = testPageFormInfo.getPaperQueDetail().size();
        for (int i = 0; i < n; ++i) {
            if (testPageFormInfo.getPaperQueDetail().get(i).getPaperQue() == null || hashSet.contains(testPageFormInfo.getPaperQueDetail().get(i).getPaperQue().getId().toString())) continue;
            mdEvaluColl.add(testPageFormInfo.getPaperQueDetail().get(i).getPaperQue());
            hashSet.add(testPageFormInfo.getPaperQueDetail().get(i).getPaperQue().getId().toString());
        }
        return TestPaperScoreUtil.sortPaperQuestions(mdEvaluColl);
    }

    private static PaperQuestionsCollection sortPaperQuestions(PaperQuestionsCollection mdEvaluColl) {
        int size = mdEvaluColl.size();
        int[] numbers = new int[size];
        HashMap<String, PaperQuestionsInfo> map = new HashMap<String, PaperQuestionsInfo>();
        for (int k = 0; k < size; ++k) {
            numbers[k] = mdEvaluColl.get(k).getSerial();
            map.put("" + numbers[k], mdEvaluColl.get(k));
        }
        Arrays.sort(numbers);
        mdEvaluColl.clear();
        for (int i = 0; i < size; ++i) {
            mdEvaluColl.add((PaperQuestionsInfo)map.get("" + numbers[i]));
        }
        return mdEvaluColl;
    }

    public static MultiDimentionCommentCollection getMultiDimentionCommentCollectionFromTestPageForm(HttpServletRequest request, TestPageFormInfo testPageFormInfo) {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String paperID = testPageFormInfo.getTestPaper().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("testPaper", (Object)paperID));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("serial"));
        try {
            MultiDimentionCommentCollection coll = MultiDimentionCommentFactory.getLocalInstance(ctx).getMultiDimentionCommentCollection(viewInfo);
            return coll;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), e.getCause());
            return null;
        }
    }

    public static HashMap getMultiDimentionEvalutionToQuest(PaperQuestionsCollection mdEvaluColl) {
        HashMap<String, PaperQuestionsCollection> map = new HashMap<String, PaperQuestionsCollection>();
        int n = mdEvaluColl.size();
        for (int i = 0; i < n; ++i) {
            PaperQuestionsCollection questionsCollection;
            if (mdEvaluColl.get(i).getEvaluation() == null) continue;
            if (map.containsKey(mdEvaluColl.get(i).getEvaluation().getId().toString())) {
                questionsCollection = (PaperQuestionsCollection)((Object)map.get(mdEvaluColl.get(i).getEvaluation().getId().toString()));
                questionsCollection.add(mdEvaluColl.get(i));
                continue;
            }
            questionsCollection = new PaperQuestionsCollection();
            questionsCollection.add(mdEvaluColl.get(i));
            map.put(mdEvaluColl.get(i).getEvaluation().getId().toString(), questionsCollection);
        }
        for (Map.Entry entry : map.entrySet()) {
            map.put((String)entry.getKey(), TestPaperScoreUtil.sortPaperQuestions((PaperQuestionsCollection)((Object)entry.getValue())));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMDEvalorResultDataXml(HttpServletRequest request) {
        String personID = request.getParameter("personID");
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        filter.getFilterItems().add(new FilterItemInfo("isApproved", (Object)Boolean.TRUE));
        viewInfo.setFilter(filter);
        int COLS = 11;
        String xmlData = null;
        int pageCount = Integer.parseInt(request.getParameter("pageCount"));
        int pageNumber = Integer.parseInt(request.getParameter("pageNumber"));
        int start = (pageNumber - 1) * pageCount;
        ArrayList<Object> list = new ArrayList<Object>();
        IQueryExecutor iqec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "MDEvalorResultReportQuery"));
        iqec.setObjectView(viewInfo);
        try {
            IRowSet rowSet = null;
            list.add("" + iqec.getRowCount());
            rowSet = iqec.executeQuery(start, pageCount);
            boolean isModify = false;
            rowSet.beforeFirst();
            BigDecimal mScore = null;
            while (rowSet.next()) {
                isModify = rowSet.getBoolean("isModify");
                if (!isModify || (mScore = rowSet.getBigDecimal("modifiedScore")) == null) continue;
                rowSet.updateBigDecimal("evaluScore", rowSet.getBigDecimal("modifiedScore"));
            }
            rowSet.beforeFirst();
            DecimalFormat format = new DecimalFormat("0.00");
            while (rowSet.next()) {
                String[] array = new String[COLS];
                array[0] = rowSet.getString("person.number");
                array[1] = rowSet.getString("person.name");
                array[2] = rowSet.getString("position.name");
                array[3] = rowSet.getString("adminOrgUnit.displayName");
                array[4] = rowSet.getString("MDSolution.name");
                array[5] = rowSet.getString("AssessPeriod.name");
                array[6] = rowSet.getString("AssessPeriod.startDate");
                array[7] = rowSet.getString("AssessPeriod.endDate");
                array[8] = rowSet.getBigDecimal("evaluScore") != null ? format.format(rowSet.getBigDecimal("evaluScore")).toString() : "0.00";
                array[9] = rowSet.getString("rank.name");
                array[10] = rowSet.getString("GradeMode.name");
                list.add(array);
            }
            xmlData = PerfWebUtils.makeProcDataToXMLData(list, COLS);
            return xmlData;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            xmlData = PerfWebUtils.makeErrorProcDataToXMLData(ctx, COLS);
            return xmlData;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            xmlData = PerfWebUtils.makeErrorProcDataToXMLData(ctx, COLS);
            return xmlData;
        }
        finally {
            return xmlData;
        }
    }

    public static String getOprtState(HttpServletRequest request, String evalPersonID) {
        String oprtState = "VIEW";
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("paperState");
            sic.add("wfStatus");
            EvalPersonInfo info = EvalPersonFactory.getLocalInstance(ctx).getEvalPersonInfo((IObjectPK)new ObjectUuidPK(evalPersonID), sic);
            if (info != null && !WFStatuEnum.CLOSED.equals((Object)info.getWfStatus()) && !MultiDimTestPaperStateEnum.SUBMIT.equals((Object)info.getPaperState())) {
                oprtState = "EDIT";
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.getCause());
        }
        return oprtState;
    }

    public static boolean checkSolutionPeriodStatus(HttpServletRequest request, String solutionPeriodID) {
        if (request == null || StringUtils.isEmpty((String)solutionPeriodID)) {
            return false;
        }
        boolean bool = true;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)solutionPeriodID));
        filter.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(101)));
        try {
            if (!MultiDimentionSolutionPeriodFactory.getLocalInstance(ctx).exists(filter)) {
                bool = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.getCause());
        }
        return bool;
    }

    public static boolean checkMDTestPaperState(HttpServletRequest request, String evalPersonID) {
        if (request == null || StringUtils.isEmpty((String)evalPersonID)) {
            return false;
        }
        boolean bool = true;
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)evalPersonID));
        filter.getFilterItems().add(new FilterItemInfo("paperState", (Object)new Integer(30)));
        try {
            if (EvalPersonFactory.getLocalInstance(ctx).exists(filter)) {
                bool = false;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), e.getCause());
        }
        return bool;
    }
}

