/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.app.BillExtendBeanProcess;
import com.kingdee.eas.hr.base.app.HRBillBeanBizFactory;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.base.app.PlugInBeanFactory;
import com.kingdee.eas.hr.base.app.PlugInBeanProxy;
import com.kingdee.eas.hr.base.app.config.HRBillBaseConfigReader;
import com.kingdee.eas.hr.base.util.IReflectMethod;
import com.kingdee.eas.hr.qualifications.CerApplicationBillInfo;
import com.kingdee.eas.hr.qualifications.app.AbstractCerApplicationBillControllerBean;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class CerApplicationBillControllerBean
extends AbstractCerApplicationBillControllerBean {
    private IHRBillBizBean bizBean = null;

    public void setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        if (billID == null) {
            return;
        }
        this.initBizBean(ctx);
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITED);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITED);
        }
    }

    public void setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITEND);
        this.initBizBean(ctx);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITEND);
        }
    }

    public void setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.AUDITING);
        this.initBizBean(ctx);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.AUDITING);
        }
    }

    public void setSubmited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this.updateBillState(ctx, billID, HRBillStateEnum.SUBMITED);
        this.initBizBean(ctx);
        if (this.bizBean != null) {
            this.bizBean._setBillState(ctx, billID, HRBillStateEnum.SUBMITED);
        }
    }

    protected void updateBillState(Context ctx, BOSUuid billID, HRBillStateEnum state) throws BOSException, EASBizException {
        if (billID == null || state == null) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("billState"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("approveDate"));
        selector.add(new SelectorItemInfo("auditor"));
        CerApplicationBillInfo model = this.getCerApplicationBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billID), selector);
        IMultiApprove iApprover = MultiApproveFactory.getLocalInstance((Context)ctx);
        String oql = "select lastUpdateUser where billId ='" + model.getId().toString() + "'";
        MultiApproveCollection approver = iApprover.getMultiApproveCollection(oql);
        model.setBillState(state);
        if (state.equals((Object)HRBillStateEnum.AUDITED) || state.equals((Object)HRBillStateEnum.AUDITEND)) {
            model.setBizDate(new Date());
            model.setApproveDate(new Date());
        } else {
            model.setBizDate(null);
            model.setApproveDate(null);
        }
        if (state.equals((Object)HRBillStateEnum.AUDITED) || state.equals((Object)HRBillStateEnum.AUDITEND)) {
            model.setAuditor(approver.get(0).getLastUpdateUser());
        } else {
            model.setAuditor(null);
        }
        this.updatePartial(ctx, (CoreBaseInfo)model, selector);
    }

    private void initBizBean(Context ctx) throws BOSException, EASBizException {
        if (this.bizBean == null) {
            this.bizBean = this.getBizBean();
            if (this.bizBean != null) {
                BillExtendBeanProcess billExtend = new BillExtendBeanProcess(this.bizBean.getExtendBillName(ctx));
                PlugInBeanProxy plugIn = null;
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                EntityObjectInfo entity = loader.getEntity(this.getBOSType());
                if (entity != null) {
                    String fullName = entity.getFullName();
                    try {
                        plugIn = PlugInBeanFactory.getPlugIn((Context)ctx, (String)fullName);
                    }
                    catch (Exception e) {
                        throw new BOSException("PlugInBean Get Error:" + e.getMessage(), e.getCause());
                    }
                }
                IReflectMethod[] decorators = null;
                decorators = plugIn != null ? new IReflectMethod[]{plugIn, billExtend} : new IReflectMethod[]{billExtend};
                if (decorators != null) {
                    this.bizBean = new HRBillBeanBizFactory(this.bizBean).getBizProxy(decorators);
                }
            }
        }
    }

    protected IHRBillBizBean getBizBean() throws BOSException, EASBizException {
        HRBillBaseConfigReader reader = this.getConfigReader();
        if (reader != null) {
            return (IHRBillBizBean)reader.getObject("biz");
        }
        return null;
    }

    protected HRBillBaseConfigReader getConfigReader() throws BOSException, EASBizException {
        return HRBillBaseConfigReader.getConfig(this.getClass(), (String)this.getConfigXML());
    }

    protected String getConfigXML() {
        return null;
    }

    public void setCerAssess(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super.setCerAssess(ctx, pk);
    }

    protected Result _save(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        int size = colls.size();
        for (int i = 0; i < size; ++i) {
            if (colls.getObject(i) == null) continue;
            this.setNumberFromCodingRule(ctx, colls.getObject(i));
        }
        return super._save(ctx, colls);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.setNumberFromCodingRule(ctx, model);
        super._save(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setNumberFromCodingRule(ctx, (IObjectValue)model);
        CerApplicationBillInfo info = (CerApplicationBillInfo)model;
        info.setApplyDate(DateTimeUtils.truncateDate((Date)info.getApplyDate()));
        model = info;
        return super._save(ctx, model);
    }

    protected void setNumberFromCodingRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number;
        CerApplicationBillInfo dataBaseInfo = null;
        dataBaseInfo = (CerApplicationBillInfo)model;
        if (dataBaseInfo.getNumber() == null && (number = CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).getNumberFromCodingRule(model, null, null)) != null) {
            dataBaseInfo.setNumber(number);
        }
    }
}

