/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.qualifications.CerSchemeBillEntryFactory;
import com.kingdee.eas.hr.qualifications.CerSchemeBillInfo;
import com.kingdee.eas.hr.qualifications.CerSchemeBillPublishCollection;
import com.kingdee.eas.hr.qualifications.CerSchemeBillPublishFactory;
import com.kingdee.eas.hr.qualifications.CerSchemeBillPublishInfo;
import com.kingdee.eas.hr.qualifications.CerSchemeMessageFactory;
import com.kingdee.eas.hr.qualifications.CerSchemeMessageInfo;
import com.kingdee.eas.hr.qualifications.CerSchemeStateEnum;
import com.kingdee.eas.hr.qualifications.app.AbstractCerSchemeBillControllerBean;
import com.kingdee.eas.hr.qualifications.app.CerSchemeBillBizBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CerSchemeBillControllerBean
extends AbstractCerSchemeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.qualifications.app.CerSchemeBillControllerBean");

    protected IHRBillBizBean getBizBean() throws BOSException, EASBizException {
        return new CerSchemeBillBizBean();
    }

    protected String getBillField() throws BOSException, EASBizException {
        return "bill";
    }

    protected String getEntryField() throws BOSException, EASBizException {
        return "entrys";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return CerSchemeBillEntryFactory.getLocalInstance(ctx);
    }

    protected String getEntryEffectDateField() throws BOSException, EASBizException {
        return null;
    }

    protected IObjectPK _publish(Context ctx, IObjectValue messageInfo, IObjectCollection scopeCollection) throws BOSException, EASBizException {
        CerSchemeMessageInfo cerSchemeMessage = (CerSchemeMessageInfo)messageInfo;
        CerSchemeBillPublishCollection scopes = (CerSchemeBillPublishCollection)scopeCollection;
        IObjectPK pk = null;
        if (scopes != null && scopes.size() > 0) {
            CerSchemeBillPublishInfo info = null;
            ArrayList<String> ids = new ArrayList<String>();
            int size = scopes.size();
            for (int i = 0; i < size; ++i) {
                info = scopes.get(i);
                if (info == null || info.getPerson() == null) continue;
                ids.add(info.getPerson().getId().toString());
            }
            HashMap<String, String> messageMap = new HashMap<String, String>();
            messageMap.put("title", cerSchemeMessage.getTitle());
            messageMap.put("sender", cerSchemeMessage.getSendPerson().getName());
            messageMap.put("body", cerSchemeMessage.getContent());
            this._sendMessage(ctx, ids, messageMap);
            int size2 = scopes.size();
            for (int i = 0; i < size2; ++i) {
                info = scopes.get(i);
                if (info == null) continue;
                info.setIsPublish(true);
                CerSchemeBillPublishFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
            }
            pk = CerSchemeMessageFactory.getLocalInstance(ctx).submit((CoreBaseInfo)cerSchemeMessage);
        }
        return pk;
    }

    protected void _sendMessage(Context ctx, List idList, Map messageMap) throws BOSException, EASBizException {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = CerSchemeBillControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        String personId = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 0);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", (String)messageMap.get("title"), locale2);
            message.setLocaleStringHeader("sender", (String)messageMap.get("sender"), locale2);
            message.setLocaleStringHeader("body", (String)messageMap.get("body"), locale2);
        }
        BOSUuid[] userIds = null;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            personId = (String)idList.get(i);
            userIds = this.getUsersByPerson(ctx, personId);
            if (userIds == null || userIds.length == 0) continue;
            int length = userIds.length;
            for (int j = 0; j < length; ++j) {
                if (userIds[j] == null) continue;
                message.setStringHeader("receiver", userIds[j].toString());
                senderAgent.sendMessage(message);
            }
        }
    }

    public static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    private BOSUuid[] getUsersByPerson(Context ctx, String personId) throws BOSException, EASBizException {
        BOSUuid[] userIDs = null;
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection users = iUser.getCollection("where person='" + personId + "'");
        if (users.size() > 0) {
            userIDs = new BOSUuid[users.size()];
            for (int i = 0; i < users.size(); ++i) {
                userIDs[i] = users.get(i).getId();
            }
        }
        return userIDs;
    }

    protected void _setFinish(Context ctx, IObjectPK pk, CerSchemeBillInfo model) throws BOSException, EASBizException {
        BOSUuid billID = BOSUuid.read((String)pk.toString());
        this.updateState(ctx, billID, model.getState());
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CerSchemeBillInfo info = (CerSchemeBillInfo)model;
        info.setState(CerSchemeStateEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        super._entryEffect(ctx, entry);
    }

    protected void _setAudited(Context arg0, BOSUuid arg1) throws BOSException, EASBizException {
        super._setAudited(arg0, arg1);
        this.updateState(arg0, arg1, CerSchemeStateEnum.PASS);
    }

    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditEnd(ctx, billID);
        this.updateState(ctx, billID, CerSchemeStateEnum.UNPASS);
    }

    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setAuditing(ctx, billID);
        this.updateState(ctx, billID, CerSchemeStateEnum.AUDITING);
    }

    protected void _setSubmited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        super._setSubmited(ctx, billID);
        this.updateState(ctx, billID, CerSchemeStateEnum.SUBMITED);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._passAudit(ctx, pk, model);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._unpassAudit(ctx, pk, model);
    }

    protected void _passUnaudit(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        this.updateBillState(ctx, ((HRBillBaseInfo)billInfo).getId(), HRBillStateEnum.SAVED);
        this.updateState(ctx, ((HRBillBaseInfo)billInfo).getId(), CerSchemeStateEnum.SAVED);
        MultiApproveFactory.getLocalInstance((Context)ctx).delete("WHERE billId = '" + ((HRBillBaseInfo)billInfo).getId().toString() + "'");
    }

    protected void _passUnaudit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (billId == null) {
            return;
        }
        String billID = billId.toString();
        CerSchemeBillInfo model = this.getCerSchemeBillInfo(ctx, (IObjectPK)new ObjectUuidPK(billID));
        this.updateBillState(ctx, model.getId(), HRBillStateEnum.SAVED);
        this.updateState(ctx, model.getId(), CerSchemeStateEnum.SAVED);
        MultiApproveFactory.getLocalInstance((Context)ctx).delete("WHERE billId = '" + model.getId().toString() + "'");
        super._passUnaudit(ctx, billId);
    }

    protected void updateState(Context ctx, BOSUuid billID, CerSchemeStateEnum state) throws BOSException, EASBizException {
        if (billID == null || state == null) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("state"));
        CerSchemeBillInfo model = (CerSchemeBillInfo)this.getHRBillBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(billID), selector);
        if (model != null) {
            model.setState(state);
            this.updatePartial(ctx, (CoreBaseInfo)model, selector);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String temp = "";
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        CerSchemeBillInfo info = (CerSchemeBillInfo)this._getValue(ctx, pk, sic);
        temp = info.getNumber() + "  ";
        temp = temp + info.getName();
        return temp;
    }
}

