/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.qualifications.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.hr.base.CodingRuleManageFacadeFactory;
import com.kingdee.eas.hr.qualifications.IdentifySchemeInfo;
import com.kingdee.eas.hr.qualifications.QualificationsException;
import com.kingdee.eas.hr.qualifications.app.AbstractIdentifySchemeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class IdentifySchemeControllerBean
extends AbstractIdentifySchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.qualifications.app.IdentifySchemeControllerBean");

    protected Result _submit(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        int size = colls.size();
        for (int i = 0; i < size; ++i) {
            if (colls.getObject(i) == null) continue;
            this.setNumberFromCodingRule(ctx, colls.getObject(i));
            this.check(ctx, colls.getObject(i));
        }
        return super._submit(ctx, colls);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.setNumberFromCodingRule(ctx, model);
        this.check(ctx, model);
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.setNumberFromCodingRule(ctx, model);
        this.check(ctx, model);
        return super._submit(ctx, model);
    }

    protected void setNumberFromCodingRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number;
        IdentifySchemeInfo dataBaseInfo = null;
        dataBaseInfo = (IdentifySchemeInfo)model;
        if (dataBaseInfo.getNumber() == null && (number = CodingRuleManageFacadeFactory.getLocalInstance((Context)ctx).getNumberFromCodingRule(model, null, null)) != null) {
            dataBaseInfo.setNumber(number);
        }
    }

    private void check(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IdentifySchemeInfo dataBaseInfo = null;
        dataBaseInfo = (IdentifySchemeInfo)model;
        if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
            try {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
            catch (EASBizException ev) {
                String strItemNumber = ev.getMessage();
                throw new QualificationsException(QualificationsException.NUMBERERROR, new Object[]{strItemNumber});
            }
        }
        if (dataBaseInfo.getName() != null && dataBaseInfo.getName().length() > 0) {
            try {
                this._checkNameDup(ctx, (IObjectValue)dataBaseInfo);
            }
            catch (EASBizException ev) {
                String strItemName = ev.getMessage();
                throw new QualificationsException(QualificationsException.NAMEERROR, new Object[]{strItemName});
            }
        }
    }

    protected void _setCancel(Context ctx, IObjectPK pk, IdentifySchemeInfo model) throws BOSException, EASBizException {
        super._update(ctx, pk, (IObjectValue)model);
    }

    protected void _setCancelCancel(Context ctx, IObjectPK pk, IdentifySchemeInfo model) throws BOSException, EASBizException {
        super._update(ctx, pk, (IObjectValue)model);
    }

    private int getMaxIndex(Context ctx) throws BOSException, EASBizException {
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)"SELECT MAX(FIndex) FROM T_HR_IdentifyScheme");
        if (rows != null && rows.size() != 0) {
            try {
                if (rows.next()) {
                    return rows.getInt(1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return 0;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IdentifySchemeInfo info = (IdentifySchemeInfo)model;
        info.setIndex(this.getMaxIndex(ctx) + 1);
        return super._addnew(ctx, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _sort(Context ctx, String[] ids, int[] orders) throws BOSException, EASBizException {
        String sql = "UPDATE T_HR_IdentifyScheme SET FIndex=? WHERE FID=?";
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            for (int i = 0; i < ids.length; ++i) {
                pstmt.setInt(1, orders[i]);
                pstmt.setString(2, ids[i]);
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)con);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)con);
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
        SQLUtils.cleanup((Statement)pstmt, (Connection)con);
        super._sort(ctx, ids, orders);
    }
}

