/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.CertificateFactory;
import com.kingdee.eas.hr.rec.CertificateInfo;
import com.kingdee.eas.hr.rec.ImportDataException;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class CertificateDataTransmission
extends AbstractDataTransmission {
    private boolean isFirstSubmit = true;
    private Set resumeBaseIds = new HashSet();
    private String resumeBaseID = null;
    private static final String solution = "com.kingdee.eas.hr.rec.app.ExportCertificateQuery";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.CertificateDataTransmission");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CertificateFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public ResumeBaseCollection getResumeBaseInfoBySign(Context ctx, String sign) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)sign));
        FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
        if (fi != null) {
            filter.mergeFilter(fi, "and");
        }
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        SorterItemInfo sInfo = new SorterItemInfo("createTime");
        sInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sInfo);
        ResumeBaseCollection col = ResumeBaseFactory.getLocalInstance(ctx).getResumeBaseCollection(viewInfo);
        return col;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            if (RecServerUtils.objectIsNull(hsData.get("resumeBaseID"))) {
                throw new ImportDataException(ImportDataException.ACCESSID_NOT_NULL);
            }
            this.resumeBaseID = hsData.get("resumeBaseID").toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)this.resumeBaseID));
            FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
            if (fi != null) {
                filter.mergeFilter(fi, "and");
            }
            if (!ResumeBaseFactory.getLocalInstance(ctx).exists(filter)) {
                new ImportDataException(ImportDataException.NEEDRESUMEBASE);
            }
            CertificateInfo info = new CertificateInfo();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            if (!RecServerUtils.objectIsNull(hsData.get("dateAbtain"))) {
                try {
                    info.setCertifyDate(format.parse(hsData.get("dateAbtain").toString()));
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"0_CertificateDataTransmission", (Locale)ctx.getLocale()));
                }
            }
            if (RecServerUtils.objectIsNull(hsData.get("name"))) {
                throw new ImportDataException(ImportDataException.CERTIFICATE_NAME_NULL);
            }
            info.setName(hsData.get("name").toString());
            return info;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        Object tmp = null;
        try {
            if (!StringUtils.isEmpty((String)rs.getString("idCardNO"))) {
                result.put("resumeBaseID", rs.getString("idCardNO"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("certificate.name"))) {
                result.put("name", rs.getString("certificate.name"));
            }
            if (!RecServerUtils.objectIsNull(rs.getDate("certificate.certifyDate"))) {
                result.put("dateAbtain", rs.getDate("certificate.certifyDate").toString());
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        try {
            return RecServerUtils.getHRFilterByParam(ctx, "REC002");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return solution;
    }

    private FilterInfo makeIDFilterByResumeBaseID(Context ctx, String table, String resumeBaseID) {
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer("SELECT FID FROM ");
        sql.append(table);
        sql.append(" WHERE FresumeBaseID = ");
        sql.append("'");
        sql.append(resumeBaseID);
        sql.append("'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return filter;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            ResumeBaseCollection col = this.getResumeBaseInfoBySign(ctx, this.resumeBaseID);
            if (col != null && col.size() > 0) {
                CertificateInfo info = (CertificateInfo)coreBaseInfo;
                if (this.isSltImportUpdate()) {
                    int size = col.size();
                    for (int i = 0; i < size; ++i) {
                        String resumeBaseId = col.get(i).getId().toString();
                        info.setResumeBase(col.get(i));
                        this.isFirstSubmit = !this.resumeBaseIds.contains(resumeBaseId);
                        if (this.isFirstSubmit) {
                            FilterInfo filter = this.makeIDFilterByResumeBaseID(ctx, "T_HR_Certificate", resumeBaseId);
                            CertificateFactory.getLocalInstance(ctx).delete(filter);
                            this.resumeBaseIds.add(resumeBaseId);
                        }
                        if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                            this.getController(ctx).addnew(coreBaseInfo);
                        } else {
                            this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
                        }
                        coreBaseInfo.setId(null);
                    }
                } else {
                    ResumeBaseInfo currResumeBaseInfo = col.get(0);
                    info.setResumeBase(currResumeBaseInfo);
                    if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                        if (RecServerUtils.isNotExists(ctx, this.getSQL(currResumeBaseInfo.getId().toString(), info.getName()))) {
                            this.getController(ctx).addnew(coreBaseInfo);
                        }
                    } else {
                        this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private String getSQL(String resumeID, String name) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT FName,FResumeBaseID FROM T_HR_Certificate where FName = '");
        strBuffer.append(name);
        strBuffer.append("'");
        strBuffer.append(" and FResumeBaseID = '");
        strBuffer.append(resumeID);
        strBuffer.append("'");
        return strBuffer.toString();
    }
}

