/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.rec.HRRecBaseInfo;
import com.kingdee.eas.hr.rec.HRRecEntryBaseInfo;
import com.kingdee.eas.hr.rec.HRRecException;
import com.kingdee.eas.hr.rec.HRRecState;
import com.kingdee.eas.hr.rec.IRequireApplyBillEntry;
import com.kingdee.eas.hr.rec.RequireAdjustBillEntryCollection;
import com.kingdee.eas.hr.rec.RequireAdjustBillEntryInfo;
import com.kingdee.eas.hr.rec.RequireAdjustBillInfo;
import com.kingdee.eas.hr.rec.RequireApplyBillEntryCollection;
import com.kingdee.eas.hr.rec.RequireApplyBillEntryFactory;
import com.kingdee.eas.hr.rec.RequireApplyBillEntryInfo;
import com.kingdee.eas.hr.rec.RequireApplyBillInfo;
import com.kingdee.eas.hr.rec.app.AbstractHRRecBaseControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class HRRecBaseControllerBean
extends AbstractHRRecBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.HRRecBaseControllerBean");

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this._setPassState(ctx, ((HRRecBaseInfo)model).getId());
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this._setNoPassState(ctx, ((HRRecBaseInfo)model).getId());
    }

    protected IObjectPK _submit2(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._submit(ctx, (IObjectValue)((CoreBaseInfo)model));
    }

    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRRecState.COMPLETE);
    }

    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRRecState.UNPASS);
    }

    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRRecState.APPROVE);
    }

    protected void _checkCanDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HRRecBaseInfo info = (HRRecBaseInfo)this._getValue(ctx, pk);
        if (info.getBizState().getValue() != 0 && info.getBizState().getValue() != -1) {
            throw new HRRecException(HRRecException.HRBILL_CAN_NOT_DELETE);
        }
    }

    protected void _setEditState(Context ctx, BOSUuid billId) throws EASBizException, BOSException {
        this._setState(ctx, billId, HRRecState.EDIT);
    }

    protected void _setState(Context ctx, BOSUuid billId, HRRecState state) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        HRRecBaseInfo info = (HRRecBaseInfo)this._getValue(ctx, "select id, bizState where id = '" + pk.toString() + "'");
        info.setBizState(state);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("bizState"));
        this.updatePartial(ctx, (CoreBaseInfo)info, selectors);
        if (state.getValue() == 3) {
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("entries.*"));
            if (info instanceof RequireApplyBillInfo) {
                sc.add(new SelectorItemInfo("entries.outPosition.name"));
                sc.add(new SelectorItemInfo("entries.outPosiType.name"));
                sc.add(new SelectorItemInfo("entries.adminOrg.name"));
                sc.add(new SelectorItemInfo("entries.planNumber"));
                sc.add(new SelectorItemInfo("entries.factNumber"));
                sc.add(new SelectorItemInfo("entries.needNumber"));
                sc.add(new SelectorItemInfo("entries.gender"));
                sc.add(new SelectorItemInfo("entries.age"));
                sc.add(new SelectorItemInfo("entries.xueli.name"));
                sc.add(new SelectorItemInfo("entries.specialty"));
                sc.add(new SelectorItemInfo("entries.exp"));
                sc.add(new SelectorItemInfo("entries.duty"));
                sc.add(new SelectorItemInfo("entries.salaryRange"));
                sc.add(new SelectorItemInfo("entries.address"));
                sc.add(new SelectorItemInfo("entries.id"));
                info = (HRRecBaseInfo)this._getValue(ctx, (IObjectPK)pk, sc);
            } else if (info instanceof RequireAdjustBillInfo) {
                sc.add(new SelectorItemInfo("entries.adjustNumber"));
                sc.add(new SelectorItemInfo("entries.gender"));
                sc.add(new SelectorItemInfo("entries.age"));
                sc.add(new SelectorItemInfo("entries.xueli"));
                sc.add(new SelectorItemInfo("entries.special"));
                sc.add(new SelectorItemInfo("entries.exp"));
                sc.add(new SelectorItemInfo("entries.salaryrange"));
                info = (HRRecBaseInfo)this._getValue(ctx, (IObjectPK)pk, sc);
                this.updateRequireApplyBillEntitisByAdjustBill(ctx, (RequireAdjustBillEntryCollection)((Object)info.get("entries")));
            } else {
                info = (HRRecBaseInfo)this._getValue(ctx, (IObjectPK)pk);
            }
            IObjectCollection entries = (IObjectCollection)info.get("entries");
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                ((HRRecEntryBaseInfo)entries.getObject(i)).put("HRO", info.getHrOrgUnit());
            }
        }
    }

    protected void updateRequireApplyBillEntitisByAdjustBill(Context ctx, RequireAdjustBillEntryCollection adjustBillEntryColl) throws BOSException, EASBizException {
        HashSet<String> SourceEntryID_adjustBillEntry = new HashSet<String>();
        RequireAdjustBillEntryInfo entryInfo = null;
        int size = adjustBillEntryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = adjustBillEntryColl.get(i);
            if (entryInfo == null || StringUtils.isEmpty((String)entryInfo.getSourceEntryID())) continue;
            SourceEntryID_adjustBillEntry.add(entryInfo.getSourceEntryID());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", SourceEntryID_adjustBillEntry, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        IRequireApplyBillEntry iRequireApplyBillEntry = RequireApplyBillEntryFactory.getLocalInstance(ctx);
        RequireApplyBillEntryCollection RequireApplyBillEntryCol_Old = iRequireApplyBillEntry.getRequireApplyBillEntryCollection(viewInfo);
        if (RequireApplyBillEntryCol_Old != null && RequireApplyBillEntryCol_Old.size() > 0) {
            CoreBaseCollection coreColl = new CoreBaseCollection();
            for (int i = 0; i < RequireApplyBillEntryCol_Old.size(); ++i) {
                RequireApplyBillEntryInfo requireApplyBillEntryInfo = RequireApplyBillEntryCol_Old.get(i);
                for (int j = 0; j < adjustBillEntryColl.size(); ++j) {
                    RequireAdjustBillEntryInfo rabeInfo = adjustBillEntryColl.get(j);
                    if (!requireApplyBillEntryInfo.getId().toString().equals(rabeInfo.getSourceEntryID())) continue;
                    requireApplyBillEntryInfo.setAdjustNumber(rabeInfo.getAdjustNumber());
                    requireApplyBillEntryInfo.setGender(rabeInfo.getGender());
                    requireApplyBillEntryInfo.setAge(rabeInfo.getAge());
                    requireApplyBillEntryInfo.setSpecial(rabeInfo.getSpecial());
                    requireApplyBillEntryInfo.setXueli(rabeInfo.getXueli());
                    requireApplyBillEntryInfo.setExp(rabeInfo.getExp());
                    requireApplyBillEntryInfo.setSalaryRange(rabeInfo.getSalaryRange());
                    coreColl.add((CoreBaseInfo)requireApplyBillEntryInfo);
                }
            }
            iRequireApplyBillEntry.update(coreColl);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._checkCanDelete(ctx, pk);
        this._dispachIntermitNumber(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void _dispachIntermitNumber(Context ctx, IObjectPK pk) throws CodingRuleException, EASBizException, BOSException {
        String comId;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        BOSObjectType type = BOSUuid.read((String)pk.toString()).getType();
        IObjectValue vo = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, pk);
        if (iCodingRuleManager.isExist(vo, comId = iCodingRuleManager.getCurrentAppOUID(vo)) && iCodingRuleManager.isUseIntermitNumber(vo, comId)) {
            iCodingRuleManager.recycleNumber(vo, comId, ((HRRecBaseInfo)vo).getNumber());
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super._getLogInfo(ctx, pk);
    }

    protected void _batchPassAudit(Context ctx, String[] billIds) throws BOSException, EASBizException {
        for (int i = 0; i < billIds.length; ++i) {
            this._setPassState(ctx, BOSUuid.read((String)billIds[i]));
            this.saveMultiApproveInfo(ctx, billIds[i]);
        }
    }

    private void saveMultiApproveInfo(Context ctx, String billId) throws BOSException, EASBizException {
        IMultiApprove im = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setIsPass(ApproveResult.PASS);
        info.setOpinion(this.getStr("Lbl_Direct_Audit_Opnion", ctx));
        BOSUuid id = BOSUuid.read((String)billId);
        info.setBillId(id);
        info.setBosTypeStr(id.getType().toString());
        im.addnew((CoreBaseInfo)info);
    }

    private String getStr(String resourcStr, Context ctx) {
        return ResourceBase.getString((String)("com.kingdee.eas.hr.affair.HRAffairResource." + resourcStr), (Locale)ctx.getLocale());
    }

    protected void _test(Context ctx, BOSUuid pk) throws BOSException, EASBizException {
    }

    protected void _setEffectDate(Context ctx, BOSUuid entryId) throws BOSException, EASBizException {
    }
}

