/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.rec.HRRecState;
import com.kingdee.eas.hr.rec.RequireAdjustBillFactory;
import com.kingdee.eas.hr.rec.RequireAdjustBillInfo;
import com.kingdee.eas.hr.rec.RequireApplyBillFactory;
import com.kingdee.eas.hr.rec.RequireApplyBillInfo;
import com.kingdee.eas.hr.rec.app.AbstractHRRecBaseFacadeControllerBean;
import com.kingdee.eas.hr.rec.app.HRRecAppUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class HRRecBaseFacadeControllerBean
extends AbstractHRRecBaseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.HRRecBaseFacadeControllerBean");

    protected boolean _canUpdate(Context ctx, String billId) throws BOSException, EASBizException {
        boolean value = true;
        BOSObjectType billBosType = BOSUuid.read((String)billId).getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        String billTableName = loader.getEntity(billBosType).getTable().getName();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user.getPerson() == null) {
            throw new BOSException("current person can not be null");
        }
        String personId = user.getPerson().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FProposer, FIsMultiEntry FROM ");
        sb.append(billTableName);
        sb.append(" WHERE FID = '");
        sb.append(billId);
        sb.append("' ");
        logger.debug((Object)sb.toString());
        IRowSet rows = null;
        rows = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString()).executeSQL();
        Object id = null;
        try {
            if (rows.next()) {
                String pId = rows.getString("FProposer");
                boolean isMulti = rows.getBoolean("FIsMultiEntry");
                if (pId.equals(personId) && !isMulti) {
                    value = false;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return value;
    }

    protected String _getSelfBillId(Context ctx, BOSObjectType billBosType, String personId, boolean isInProcess) throws BOSException, EASBizException {
        String state = "0";
        if (isInProcess) {
            state = "1";
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        String billTableName = loader.getEntity(billBosType).getTable().getName();
        PropertyCollection c = loader.getEntity(billBosType).getEntityProperties();
        int index = 0;
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            if (!c.get(i).getName().equals("entries")) continue;
            index = i;
            break;
        }
        String entryTableName = ((LinkPropertyInfo)c.get(index)).getRelationship().getSupplierObject().getTable().getName();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT A.FID AS FID FROM ");
        sb.append(billTableName);
        sb.append(" A INNER JOIN ");
        sb.append(entryTableName);
        sb.append(" B ON A.FID = B.FBillID ");
        sb.append("WHERE B.FPersonID = '");
        sb.append(personId);
        sb.append("' AND A.FState = ");
        sb.append(state);
        sb.append(" AND A.FIsMultiEntry = 0 ");
        sb.append(" ORDER BY A.FCreateTime DESC");
        logger.debug((Object)sb.toString());
        IRowSet rows = null;
        rows = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString()).executeSQL();
        String id = null;
        try {
            if (rows.next()) {
                id = rows.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return id;
    }

    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        int value = HRRecAppUtils.isAffairEffectImmediatly((Context)ctx) ? 1 : 0;
        this.saveInnerStateByValue(ctx, billId.toString(), value);
        this._setState(ctx, billId, HRRecState.COMPLETE);
    }

    private void saveInnerStateByValue(Context ctx, String billId, int value) throws BOSException, EASBizException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        String billTableName = loader.getEntity(BOSUuid.read((String)billId).getType()).getTable().getName();
        String sql = "Update " + billTableName + " SET FInnerState = ?  WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{value, billId});
    }

    protected void _setNoPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRRecState.STOP);
    }

    protected void _setApproveState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRRecState.APPROVE);
    }

    protected void _setEditState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, HRRecState.EDIT);
    }

    protected void _setState(Context ctx, BOSUuid billId, HRRecState state) throws BOSException, EASBizException {
        if (billId.getType().equals((Object)new RequireApplyBillInfo().getBOSType())) {
            RequireApplyBillFactory.getLocalInstance(ctx).setState(billId, state);
        } else if (billId.getType().equals((Object)new RequireAdjustBillInfo().getBOSType())) {
            RequireAdjustBillFactory.getLocalInstance(ctx).setState(billId, state);
        }
    }

    protected IObjectValue _getAdminForHRandUserOrgRange(Context ctx) throws BOSException, EASBizException {
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return null;
        }
        String hrOrgID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer("SELECT TOP 1 T_ORG_Admin.fid,T_ORG_Admin.fname_");
        sql.append(ctx.getLocale());
        sql.append(",T_ORG_Admin.fnumber,T_ORG_Admin.FLongNumber,T_ORG_Admin.FDisplayName_");
        sql.append(ctx.getLocale());
        sql.append(",T_ORG_Admin.FAddressID");
        sql.append(" FROM T_ORG_Admin ");
        sql.append(" INNER JOIN T_PM_OrgRange ON T_ORG_Admin.FID = T_PM_OrgRange.FOrgID ");
        if (!StringUtils.isEmpty((String)hrOrgID)) {
            sql.append(" INNER JOIN T_ORG_UnitRelation ON T_ORG_UnitRelation.FFromUnitID = T_ORG_Admin.FID");
        }
        sql.append(" WHERE T_PM_OrgRange.FType = 20 AND T_PM_OrgRange.FUserID='");
        sql.append(userID);
        if (!StringUtils.isEmpty((String)hrOrgID)) {
            sql.append("' AND T_ORG_UnitRelation.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' AND T_ORG_UnitRelation.FToUnitID = '");
            sql.append(hrOrgID);
            sql.append("' ORDER BY FLevel,FLongNumber ");
        } else {
            sql.append("' ORDER BY FLevel,FLongNumber ");
        }
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rows.next()) {
                AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
                adminInfo.setId(BOSUuid.read((String)rows.getString("fid")));
                adminInfo.setName(rows.getString("fname_" + ctx.getLocale()));
                adminInfo.setNumber(rows.getString("fnumber"));
                adminInfo.setLongNumber(rows.getString("flongnumber"));
                adminInfo.setDisplayName(rows.getString("fDisplayName_" + ctx.getLocale()));
                AddressInfo adInfo = new AddressInfo();
                if (!StringUtils.isEmpty((String)rows.getString("FAddressID"))) {
                    adInfo.setId(BOSUuid.read((String)rows.getString("FAddressID")));
                }
                adminInfo.setAddress(adInfo);
                return adminInfo;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }
}

