/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.message.MAGroupEntryCollection;
import com.kingdee.eas.base.message.MAGroupEntryFactory;
import com.kingdee.eas.base.message.MAGroupEntryInfo;
import com.kingdee.eas.base.message.MAGroupInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.MailUtil;
import com.kingdee.eas.hr.rec.ActivityRelationLevelCollection;
import com.kingdee.eas.hr.rec.ActivityRelationLevelFactory;
import com.kingdee.eas.hr.rec.ActivityRelationLevelInfo;
import com.kingdee.eas.hr.rec.ActivityRelationResumeFactory;
import com.kingdee.eas.hr.rec.DirectAuditInfoFactory;
import com.kingdee.eas.hr.rec.DirectAuditInfoInfo;
import com.kingdee.eas.hr.rec.IActivityRelationLevel;
import com.kingdee.eas.hr.rec.IActivityRelationResume;
import com.kingdee.eas.hr.rec.IDirectAuditInfo;
import com.kingdee.eas.hr.rec.IInterActivityPublishInfo;
import com.kingdee.eas.hr.rec.IInterview;
import com.kingdee.eas.hr.rec.IInterviewActivity;
import com.kingdee.eas.hr.rec.IPubInfoReceiveMaGroup;
import com.kingdee.eas.hr.rec.IPubInfoReceivePerson;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.IResumeExtend;
import com.kingdee.eas.hr.rec.ITalentExtend;
import com.kingdee.eas.hr.rec.InterActivityPublishInfoCollection;
import com.kingdee.eas.hr.rec.InterActivityPublishInfoFactory;
import com.kingdee.eas.hr.rec.InterActivityPublishInfoInfo;
import com.kingdee.eas.hr.rec.InterviewActivityEnum;
import com.kingdee.eas.hr.rec.InterviewActivityException;
import com.kingdee.eas.hr.rec.InterviewActivityFactory;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.InterviewFactory;
import com.kingdee.eas.hr.rec.InterviewLevelInfo;
import com.kingdee.eas.hr.rec.InterviewStepMagageFacadeFactory;
import com.kingdee.eas.hr.rec.PubInfoReceiveMaGroupCollection;
import com.kingdee.eas.hr.rec.PubInfoReceiveMaGroupFactory;
import com.kingdee.eas.hr.rec.PubInfoReceiveMaGroupInfo;
import com.kingdee.eas.hr.rec.PubInfoReceivePersonCollection;
import com.kingdee.eas.hr.rec.PubInfoReceivePersonFactory;
import com.kingdee.eas.hr.rec.PubInfoReceivePersonInfo;
import com.kingdee.eas.hr.rec.RecCommonException;
import com.kingdee.eas.hr.rec.RecruitSummaryFactory;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeExtendFactory;
import com.kingdee.eas.hr.rec.ResumeExtendInfo;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.TalentExtendFactory;
import com.kingdee.eas.hr.rec.app.AbstractInterviewActivityFacadeControllerBean;
import com.kingdee.eas.hr.rec.util.DateUtil;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InterviewActivityFacadeControllerBean
extends AbstractInterviewActivityFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.InterviewActivityFacadeControllerBean");

    protected void _setInterviewLevel(Context ctx, String activityId, Set levelIdSet) throws BOSException, EASBizException {
        if (activityId != null && levelIdSet != null) {
            IActivityRelationLevel dao = ActivityRelationLevelFactory.getLocalInstance(ctx);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("interviewActivity.id", (Object)activityId));
            dao.delete(fi);
            InterviewActivityInfo activityInfo = new InterviewActivityInfo();
            activityInfo.setId(BOSUuid.read((String)activityId));
            InterviewLevelInfo levelInfo = new InterviewLevelInfo();
            String levelId = null;
            Iterator it = levelIdSet.iterator();
            while (it.hasNext()) {
                levelId = it.next().toString();
                levelInfo.setId(BOSUuid.read((String)levelId));
                ActivityRelationLevelInfo info = new ActivityRelationLevelInfo();
                info.setInterviewActivity(activityInfo);
                info.setInterviewLevel(levelInfo);
                dao.addnew(info);
            }
        }
    }

    protected void _auditInterviewActivity(Context ctx, IObjectValue valueObject) throws BOSException, EASBizException {
        if (valueObject instanceof DirectAuditInfoInfo) {
            DirectAuditInfoInfo info = (DirectAuditInfoInfo)valueObject;
            PersonInfo pi = info.getPerson();
            if (pi == null || pi.getId() == null) {
                return;
            }
            if (info.getOriginBill() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("state"));
                IDirectAuditInfo dao = DirectAuditInfoFactory.getLocalInstance(ctx);
                IInterviewActivity activityDao = InterviewActivityFactory.getLocalInstance(ctx);
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("originBill", (Object)info.getOriginBill()));
                fi.getFilterItems().add(new FilterItemInfo("person", (Object)pi.getId()));
                dao.delete(fi);
                info.setHandlerDate(new Date(System.currentTimeMillis()));
                dao.addnew(info);
                InterviewActivityInfo activityInfo = activityDao.getInterviewActivityInfo((IObjectPK)new ObjectUuidPK(info.getOriginBill()));
                String loggerInfo = activityInfo.getNumber() + " " + activityInfo.getName();
                this.dealLogInfo(ctx, loggerInfo);
                if (info.isHandlerResult()) {
                    activityInfo.setState(InterviewActivityEnum.pass);
                } else {
                    activityInfo.setState(InterviewActivityEnum.noPass);
                }
                activityDao.updatePartial((CoreBaseInfo)activityInfo, sic);
            }
        }
    }

    protected void _changeState(Context ctx, String activityId, InterviewActivityEnum state) throws BOSException, EASBizException {
        if (activityId == null || state == null) {
            return;
        }
        int s = state.getValue();
        if (s == 7) {
            if (!"true".equals(this._checkInterviewCompleted(ctx, activityId))) {
                throw new InterviewActivityException(InterviewActivityException.CAN_NOT_END_NO_COMPLETE_INTERVIEW);
            }
        } else if (s == 8) {
            this.preAbandonStateHandle(ctx, activityId);
        } else if (s == 6 && !"true".equals(this._existLevel(ctx, activityId))) {
            throw new InterviewActivityException(InterviewActivityException.CAN_NOT_START_NO_LEVEL_ACTIVITY);
        }
        IInterviewActivity activityDao = InterviewActivityFactory.getLocalInstance(ctx);
        InterviewActivityInfo activityInfo = new InterviewActivityInfo();
        activityInfo.setId(BOSUuid.read((String)activityId));
        activityInfo.setState(state);
        activityDao.updatePartial((CoreBaseInfo)activityInfo, RecServerUtils.getSic(new String[]{"state"}));
    }

    public String _existLevel(Context ctx, String activityId) throws BOSException, EASBizException {
        IActivityRelationLevel dao = ActivityRelationLevelFactory.getLocalInstance(ctx);
        IInterviewActivity activityDao = InterviewActivityFactory.getLocalInstance(ctx);
        String result = "true";
        ActivityRelationLevelCollection arc = dao.getActivityRelationLevelCollection("where interviewActivity.id = '" + activityId + "'");
        if (arc == null || arc.size() <= 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("name"));
            InterviewActivityInfo activityInfo = activityDao.getInterviewActivityInfo((IObjectPK)new ObjectUuidPK(activityId), sic);
            result = activityInfo.getName();
        }
        return result;
    }

    protected String _getPublishInfoId(Context ctx, String interviewActivityId) throws BOSException, EASBizException {
        String sql = "select fid as id from t_hr_interActivityPublishInfo where FInterviewActivityId = '" + interviewActivityId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String id = null;
        try {
            if (rowSet.next()) {
                id = rowSet.getString("id");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return id;
    }

    protected void _savePublishInfo(Context ctx, String activityId, IObjectValue valueObject) throws BOSException, EASBizException {
        if (activityId == null || valueObject == null) {
            return;
        }
        InterActivityPublishInfoInfo info = (InterActivityPublishInfoInfo)valueObject;
        IInterActivityPublishInfo dao = InterActivityPublishInfoFactory.getLocalInstance(ctx);
        String id = this._getPublishInfoId(ctx, activityId);
        if (id == null || id.length() <= 0) {
            InterviewActivityInfo activityInfo = new InterviewActivityInfo();
            activityInfo.setId(BOSUuid.read((String)activityId));
            info.setInterviewActivity(activityInfo);
            IObjectPK pk = dao.submit(info);
        } else {
            info.setId(BOSUuid.read((String)id));
            dao.update((IObjectPK)new ObjectUuidPK(id), info);
        }
    }

    protected void _sendPublishInfo(Context ctx, String activityId, String publishInfoId, boolean isSendMail) throws BOSException, EASBizException {
        IPubInfoReceiveMaGroup group;
        PubInfoReceiveMaGroupCollection groupColl;
        PersonInfo personInfo;
        if (activityId == null && publishInfoId == null) {
            return;
        }
        IInterActivityPublishInfo publishDao = InterActivityPublishInfoFactory.getLocalInstance(ctx);
        InterActivityPublishInfoInfo publishInfo = (InterActivityPublishInfoInfo)this._loadPublishInfo(ctx, activityId, publishInfoId);
        activityId = publishInfo.getInterviewActivity().getId().toString();
        publishInfoId = publishInfo.getId().toString();
        String oql = " where publishInfo ='" + publishInfoId + "'";
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("name");
        sic.add("email");
        IPerson personDao = PersonFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> personMap = new HashMap<String, String>();
        IPubInfoReceivePerson person = PubInfoReceivePersonFactory.getLocalInstance(ctx);
        PubInfoReceivePersonCollection personColl = person.getPubInfoReceivePersonCollection(oql);
        if (personColl != null && personColl.size() >= 0) {
            int j = personColl.size();
            for (int i = 0; i < j; ++i) {
                PubInfoReceivePersonInfo rPersonInfo = personColl.get(i);
                personInfo = rPersonInfo.getPerson();
                personInfo = personDao.getPersonInfo((IObjectPK)new ObjectUuidPK(rPersonInfo.getPerson().getId().toString()), sic);
                personMap.put(personInfo.getId().toString(), personInfo.getEmail());
            }
        }
        if ((groupColl = (group = PubInfoReceiveMaGroupFactory.getLocalInstance(ctx)).getPubInfoReceiveMaGroupCollection(oql)) != null) {
            int j = groupColl.size();
            for (int i = 0; i < j; ++i) {
                PubInfoReceiveMaGroupInfo rGroupInfo = groupColl.get(i);
                String groupId = rGroupInfo.getMaGroup().getId().toString();
                MAGroupEntryCollection entryColl = MAGroupEntryFactory.getLocalInstance((Context)ctx).getMAGroupEntryCollection("where parent ='" + groupId + "'");
                if (entryColl == null) continue;
                int n = entryColl.size();
                for (int m = 0; m < n; ++m) {
                    MAGroupEntryInfo entryInfo = entryColl.get(m);
                    personInfo = entryInfo.getPersonnel();
                    personInfo = personDao.getPersonInfo((IObjectPK)new ObjectUuidPK(entryInfo.getPersonnel().getId().toString()), sic);
                    personMap.put(personInfo.getId().toString(), personInfo.getEmail());
                }
            }
        }
        StringBuffer sb = new StringBuffer();
        if (activityId != null) {
            ObjectUuidPK pk = new ObjectUuidPK(activityId);
            SelectorItemCollection siColl = RecServerUtils.getSic(new String[]{"hrOrgUnit.id", "hrOrgUnit.name"});
            InterviewActivityInfo activityInfo = InterviewActivityFactory.getLocalInstance(ctx).getInterviewActivityInfo((IObjectPK)pk, siColl);
            sb.append("                        ").append(activityInfo.getHrOrgUnit().getName());
        }
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RecServerResource", (String)"interview_info", (Locale)ctx.getLocale())).append("\n");
        sb.append("    ").append(publishInfo.getIntroduce()).append("\n");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RecServerResource", (String)"interview_purpose", (Locale)ctx.getLocale())).append("\n");
        sb.append(publishInfo.getPurpose()).append("\n");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RecServerResource", (String)"interview_require", (Locale)ctx.getLocale())).append("\n");
        sb.append(publishInfo.getRequirement()).append("\n");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RecServerResource", (String)"interview_program", (Locale)ctx.getLocale())).append("\n");
        sb.append(publishInfo.getProgram()).append("\n");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RecServerResource", (String)"interview_desc", (Locale)ctx.getLocale())).append("\n");
        sb.append(publishInfo.getDescription()).append("\n");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RecServerResource", (String)"interview_treatment", (Locale)ctx.getLocale())).append("\n");
        sb.append(publishInfo.getTreatment()).append("\n");
        sb.append(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RecServerResource", (String)"interview_address", (Locale)ctx.getLocale())).append("\n");
        sb.append(publishInfo.getContactInfo());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String sender = userInfo.getPerson().getName();
        String title = ResourceBase.getString((String)"com.kingdee.eas.hr.rec.ResumeResource", (String)"interviewActivity_publishInfo", (Locale)ctx.getLocale());
        HashMap<String, String> msgMap = new HashMap<String, String>();
        msgMap.put("sender", sender);
        msgMap.put("title", title);
        msgMap.put("body", sb.toString());
        try {
            InterviewStepMagageFacadeFactory.getLocalInstance(ctx).sendMsg(personMap.keySet(), msgMap);
        }
        catch (Exception e) {
            throw new RecCommonException(RecCommonException.SEND_MSG_ERROR);
        }
        if (isSendMail) {
            String email_body = sb.toString().replaceAll("\n", "<br/>");
            Set entrySet = personMap.entrySet();
            MailUtil mailUtil = MailUtil.getInstance((Context)ctx);
            String iaId = publishInfo.getInterviewActivity().getId().toString();
            InterviewActivityInfo iaInfo = InterviewActivityFactory.getLocalInstance(ctx).getInterviewActivityInfo((IObjectPK)new ObjectUuidPK(iaId), RecServerUtils.getSic(new String[]{"id", "name"}));
            String subject = iaInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RecServerResource", (String)"interview_activity_publish_info", (Locale)ctx.getLocale());
            try {
                for (Map.Entry e : entrySet) {
                    Object obj = e.getValue();
                    if (obj == null) continue;
                    mailUtil.sendHtmlMail("", obj.toString(), subject, email_body);
                }
            }
            catch (Exception e) {
                throw new RecCommonException(RecCommonException.SEND_EMAIL_ERROR);
            }
        }
        publishInfo.setPublished(true);
        publishDao.updatePartial(publishInfo, RecServerUtils.getSic(new String[]{"published"}));
    }

    protected String _checkPersonEmail(Context ctx, String publishInfoId) throws BOSException, EASBizException {
        IPubInfoReceiveMaGroup group;
        PubInfoReceiveMaGroupCollection groupColl;
        if (publishInfoId == null) {
            return "";
        }
        String oql = " where publishInfo ='" + publishInfoId + "'";
        IPerson personDao = PersonFactory.getLocalInstance((Context)ctx);
        HashSet<String> personSet = new HashSet<String>();
        IPubInfoReceivePerson person = PubInfoReceivePersonFactory.getLocalInstance(ctx);
        PubInfoReceivePersonCollection personColl = person.getPubInfoReceivePersonCollection(oql);
        if (personColl != null && personColl.size() >= 0) {
            int j = personColl.size();
            for (int i = 0; i < j; ++i) {
                PubInfoReceivePersonInfo rPersonInfo = personColl.get(i);
                if (rPersonInfo.getPerson() == null) continue;
                personSet.add(rPersonInfo.getPerson().getId().toString());
            }
        }
        if ((groupColl = (group = PubInfoReceiveMaGroupFactory.getLocalInstance(ctx)).getPubInfoReceiveMaGroupCollection(oql)) != null) {
            int j = groupColl.size();
            for (int i = 0; i < j; ++i) {
                PubInfoReceiveMaGroupInfo rGroupInfo = groupColl.get(i);
                String groupId = rGroupInfo.getMaGroup().getId().toString();
                MAGroupEntryCollection entryColl = MAGroupEntryFactory.getLocalInstance((Context)ctx).getMAGroupEntryCollection("where parent ='" + groupId + "'");
                if (entryColl == null) continue;
                int n = entryColl.size();
                for (int m = 0; m < n; ++m) {
                    MAGroupEntryInfo entryInfo = entryColl.get(m);
                    if (entryInfo.getPersonnel() == null) continue;
                    personSet.add(entryInfo.getPersonnel().getId().toString());
                }
            }
        }
        if (personSet.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection sic = evi.getSelector();
            sic.add("name");
            sic.add("email");
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", personSet, CompareType.INCLUDE));
            evi.setFilter(fi);
            PersonCollection pColl = personDao.getPersonCollection(evi);
            StringBuffer sb = new StringBuffer();
            int j = pColl.size();
            for (int i = 0; i < j; ++i) {
                PersonInfo pi = pColl.get(i);
                if (pi.getEmail() != null && pi.getEmail().trim().length() > 0) continue;
                sb.append(pi.getName()).append(",");
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            return "true";
        }
        return "true";
    }

    protected IObjectValue _loadPublishInfo(Context ctx, String activityId, String publishInfoId) throws BOSException, EASBizException {
        String id;
        InterActivityPublishInfoInfo info = null;
        IInterActivityPublishInfo publishDao = InterActivityPublishInfoFactory.getLocalInstance(ctx);
        if (publishInfoId != null && publishInfoId.trim().length() > 0) {
            info = publishDao.getInterActivityPublishInfoInfo((IObjectPK)new ObjectUuidPK(publishInfoId));
        } else if (activityId != null && (id = this._getPublishInfoId(ctx, activityId)) != null) {
            info = publishDao.getInterActivityPublishInfoInfo((IObjectPK)new ObjectUuidPK(id));
        }
        return info;
    }

    protected List _getMaGroupInfo(Context ctx, String publishInfoId) throws BOSException, EASBizException {
        ArrayList<MAGroupInfo> list = new ArrayList<MAGroupInfo>();
        if (publishInfoId != null) {
            IPubInfoReceiveMaGroup dao = PubInfoReceiveMaGroupFactory.getLocalInstance(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection sic = evi.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("maGroup.id"));
            sic.add(new SelectorItemInfo("maGroup.name"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("publishInfo.id", (Object)publishInfoId));
            evi.setFilter(fi);
            PubInfoReceiveMaGroupCollection coll = dao.getPubInfoReceiveMaGroupCollection(evi);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    list.add(coll.get(i).getMaGroup());
                }
            }
        }
        return list;
    }

    protected void _setResumeToInterview(Context ctx, String interviewActivityId, Map resumeMap, Map talentMap) throws BOSException, EASBizException {
        ResumeBaseInfo resumeBaseInfo;
        if (interviewActivityId == null || resumeMap == null && talentMap == null) {
            return;
        }
        IResumeBase resumeBaseDao = ResumeBaseFactory.getLocalInstance(ctx);
        InterviewActivityInfo activityInfo = new InterviewActivityInfo();
        activityInfo.setId(BOSUuid.read((String)interviewActivityId));
        PositionInfo positionInfo = new PositionInfo();
        if (talentMap != null && talentMap.size() > 0) {
            IResumeExtend resumeDao = ResumeExtendFactory.getLocalInstance(ctx);
            ITalentExtend talentDao = TalentExtendFactory.getLocalInstance(ctx);
            Set tSet = talentMap.entrySet();
            HashSet<String> idSet = new HashSet<String>();
            for (Map.Entry entry : tSet) {
                String resumeBaseId = entry.getKey().toString();
                idSet.add(resumeBaseId);
                ResumeExtendInfo resumeInfo = new ResumeExtendInfo();
                resumeBaseInfo = resumeBaseDao.getResumeBaseInfo((IObjectPK)new ObjectUuidPK(resumeBaseId));
                String positionId = entry.getValue().toString();
                positionInfo.setId(BOSUuid.read((String)positionId));
                resumeBaseInfo.setPosition(positionInfo);
                resumeBaseInfo.setInterviewActivity(activityInfo);
                resumeInfo.setResumeBase(resumeBaseInfo);
                resumeDao.addnew((CoreBaseInfo)resumeInfo);
            }
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("resumeBase", idSet, CompareType.INCLUDE));
            talentDao.delete(fi);
        }
        if (resumeMap != null && resumeMap.size() > 0) {
            Set set = resumeMap.entrySet();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("position"));
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("interviewActivity"));
            for (Map.Entry entry : set) {
                String resumeBaseId = entry.getKey().toString();
                resumeBaseInfo = resumeBaseDao.getResumeBaseInfo((IObjectPK)new ObjectUuidPK(resumeBaseId));
                String positionId = entry.getValue().toString();
                positionInfo.setId(BOSUuid.read((String)positionId));
                resumeBaseInfo.setPosition(positionInfo);
                resumeBaseInfo.setInterviewActivity(activityInfo);
                resumeBaseDao.updatePartial((CoreBaseInfo)resumeBaseInfo, sic);
            }
        }
    }

    public Map _getResumeAndPosition(Context ctx, String activityId) throws BOSException, EASBizException {
        if (activityId == null) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("interviewActivity", (Object)activityId));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("resumeState"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        IResumeBase resumeBaseDao = ResumeBaseFactory.getLocalInstance(ctx);
        HashMap<ResumeBaseInfo, PositionInfo> map = new HashMap<ResumeBaseInfo, PositionInfo>();
        ResumeBaseCollection rbc = resumeBaseDao.getResumeBaseCollection(evi);
        int j = rbc.size();
        for (int i = 0; i < j; ++i) {
            ResumeBaseInfo info = rbc.get(i);
            map.put(info, info.getPosition());
        }
        return map;
    }

    public String _checkInterviewCompleted(Context ctx, String activityId) throws BOSException, EASBizException {
        if (activityId == null) {
            return "true";
        }
        IResumeBase resumeBaseDao = ResumeBaseFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("interviewActivity", (Object)activityId));
        fi.getFilterItems().add(new FilterItemInfo("resumeState", (Object)new Integer(3), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("resumeState", (Object)new Integer(4), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("resumeState", (Object)new Integer(6), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("resumeState", (Object)new Integer(0), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("resumeState", (Object)new Integer(1), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("resumeState", (Object)new Integer(15), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("resumeState", (Object)new Integer(5), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("resumeState", (Object)new Integer(8), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("resumeState", (Object)new Integer(10), CompareType.NOTEQUALS));
        evi.setFilter(fi);
        ResumeBaseCollection rbc = resumeBaseDao.getResumeBaseCollection(evi);
        if (rbc.size() <= 0) {
            return "true";
        }
        StringBuffer sb = new StringBuffer();
        int j = rbc.size();
        for (int i = 0; i < j; ++i) {
            ResumeBaseInfo info = rbc.get(i);
            sb.append(info.getName()).append(",");
        }
        return sb.toString();
    }

    private void preAbandonStateHandle(Context ctx, String activityId) throws BOSException, EASBizException {
        if (activityId == null) {
            return;
        }
        IResumeBase resumeBaseDao = ResumeBaseFactory.getLocalInstance(ctx);
        FilterInfo fi = new FilterInfo();
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(6);
        set.add(3);
        fi.getFilterItems().add(new FilterItemInfo("interviewActivity", (Object)activityId));
        fi.getFilterItems().add(new FilterItemInfo("resumeState", set, CompareType.INCLUDE));
        if (resumeBaseDao.exists(fi)) {
            throw new InterviewActivityException(InterviewActivityException.CAN_NOT_ABANDON_PASS);
        }
        IInterview interviewDao = InterviewFactory.getLocalInstance(ctx);
        IActivityRelationResume rrDao = ActivityRelationResumeFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = RecServerUtils.getSic(new String[]{"interviewActivity", "position", "resumeState", "adminOrgUnit", "interviewTime"});
        StringBuffer oql = new StringBuffer();
        oql.append("where interviewActivity = '").append(activityId).append("'");
        ResumeBaseCollection rbc = resumeBaseDao.getResumeBaseCollection(oql.toString());
        if (rbc != null && rbc.size() > 0) {
            int j = rbc.size();
            for (int i = 0; i < j; ++i) {
                ResumeBaseInfo info = rbc.get(i);
                interviewDao.delete(" where resumeBase.id ='" + info.getId().toString() + "'");
                info.setInterviewActivity(null);
                info.setPosition(null);
                info.setAdminOrgUnit(null);
                info.setInterviewTime(null);
                info.setResumeState(ResumeStateEnum.no_dispose);
                resumeBaseDao.updatePartial((CoreBaseInfo)info, sic);
            }
        }
        rrDao.delete(oql.toString());
    }

    private void preEndStateHandle(Context ctx, String activityId) throws BOSException, EASBizException {
        if (activityId == null) {
            return;
        }
        IResumeBase resumeBaseDao = ResumeBaseFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("interviewActivity"));
        StringBuffer oql = new StringBuffer();
        oql.append("where interviewActivity = '").append(activityId).append("'");
        ResumeBaseCollection rbc = resumeBaseDao.getResumeBaseCollection(oql.toString());
        if (rbc != null && rbc.size() > 0) {
            int j = rbc.size();
            for (int i = 0; i < j; ++i) {
                ResumeBaseInfo info = rbc.get(i);
                info.setInterviewActivity(null);
                resumeBaseDao.updatePartial((CoreBaseInfo)info, sic);
            }
        }
    }

    protected List _getPositionByNumber(Context ctx, List numberList) throws BOSException, EASBizException {
        if (numberList == null || numberList.size() <= 0) {
            return null;
        }
        IPosition biz = PositionFactory.getLocalInstance((Context)ctx);
        ArrayList<PositionInfo> list = new ArrayList<PositionInfo>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        int j = numberList.size();
        for (int i = 0; i < j; ++i) {
            String position = numberList.get(i).toString();
            fi.getFilterItems().clear();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)position, CompareType.LIKE));
            PositionCollection pc = biz.getPositionCollection(evi);
            if (pc != null && pc.size() > 0) {
                list.add(pc.get(0));
                continue;
            }
            list.add(null);
        }
        return list;
    }

    protected IObjectValue _getLastestPublishInfo(Context ctx) throws BOSException, EASBizException {
        String oql;
        IInterActivityPublishInfo biz = InterActivityPublishInfoFactory.getLocalInstance(ctx);
        InterActivityPublishInfoCollection coll = biz.getInterActivityPublishInfoCollection(oql = "select * order by createTime desc ");
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    protected Map _getInterviewAvgScore(Context ctx, String activityId) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append(" select avg(b.FPOINT) avgPoint,a.FInterviewLevelId levelId ,a.FResumeBaseId resumeId ");
        sb.append(" from t_hr_Interview  a left outer join t_hr_InterviewRecord b on a.fid = b.FInterviewId ");
        sb.append(" where a.FInterviewActivityId = '").append(activityId).append("' ");
        sb.append(" group by a.FID,a.FInterviewLevelId,a.FResumeBaseId order by avgPoint desc ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashMap resumeKeyMap = new HashMap();
        String str = "";
        DecimalFormat df = new DecimalFormat("0.00");
        try {
            while (rowSet.next()) {
                String resumeId = rowSet.getString("resumeId");
                String levelId = rowSet.getString("levelId");
                BigDecimal avgPoint = rowSet.getBigDecimal("avgPoint");
                str = avgPoint != null ? df.format(avgPoint.doubleValue()) : "0.00";
                if (resumeKeyMap.containsKey(resumeId)) {
                    Map map = (Map)resumeKeyMap.get(resumeId);
                    map.put(levelId, str);
                    continue;
                }
                HashMap<String, String> levelKeyMap = new HashMap<String, String>();
                levelKeyMap.put(levelId, str);
                resumeKeyMap.put(resumeId, levelKeyMap);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return resumeKeyMap;
    }

    protected Map _getOrderInterviewAvgScore(Context ctx, String activityId, String interviewLevelId, boolean isAsc) throws BOSException, EASBizException {
        String resumeId;
        StringBuffer sb = new StringBuffer();
        sb.append(" select avg(b.FPOINT) avgPoint,a.FInterviewLevelId levelId ,a.FResumeBaseId resumeId ");
        sb.append(" from t_hr_Interview  a left outer join t_hr_InterviewRecord b on a.fid = b.FInterviewId ");
        sb.append(" where a.FInterviewActivityId = '").append(activityId).append("' ");
        sb.append(" where a.FInterviewLevelId = '").append(interviewLevelId).append("' ");
        sb.append(" group by a.FID,a.FInterviewLevelId,a.FResumeBaseId ");
        if (isAsc) {
            sb.append(" order by avgPoint asc ");
        } else {
            sb.append(" order by avgPoint desc ");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        LinkedHashMap resumeKeyMap = new LinkedHashMap();
        try {
            while (rowSet.next()) {
                resumeId = rowSet.getString("resumeId");
                HashMap levelMap = new HashMap();
                resumeKeyMap.put(resumeId, levelMap);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        StringBuffer sb2 = new StringBuffer();
        sb.append(" select avg(b.FPOINT) avgPoint,a.FInterviewLevelId levelId ,a.FResumeBaseId resumeId ");
        sb.append(" from t_hr_Interview  a left outer join t_hr_InterviewRecord b on a.fid = b.FInterviewId ");
        sb.append(" where a.FInterviewActivityId = '").append(activityId).append("' ");
        sb.append(" group by a.FID,a.FInterviewLevelId,a.FResumeBaseId order by avgPoint desc ");
        IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)sb2.toString());
        try {
            while (rowSet2.next()) {
                resumeId = rowSet2.getString("resumeId");
                String levelId = rowSet2.getString("levelId");
                BigDecimal avgPoint = rowSet2.getBigDecimal("avgPoint");
                if (resumeKeyMap.containsKey(resumeId)) {
                    Map map = (Map)resumeKeyMap.get(resumeId);
                    map.put(levelId, avgPoint);
                    continue;
                }
                HashMap<String, BigDecimal> levelKeyMap = new HashMap<String, BigDecimal>();
                levelKeyMap.put(levelId, avgPoint);
                resumeKeyMap.put(resumeId, levelKeyMap);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return resumeKeyMap;
    }

    protected IRowSet _getPublishInfoForPrint(Context ctx, String activityId, String publishInfoId) throws BOSException, EASBizException {
        InterviewActivityInfo activityInfo = null;
        InterActivityPublishInfoInfo publishInfo = null;
        if (activityId == null && publishInfoId == null) {
            return null;
        }
        if (activityId != null && publishInfoId == null) {
            activityInfo = InterviewActivityFactory.getLocalInstance(ctx).getInterviewActivityInfo((IObjectPK)new ObjectUuidPK(activityId));
            InterActivityPublishInfoCollection coll = InterActivityPublishInfoFactory.getLocalInstance(ctx).getInterActivityPublishInfoCollection("where interviewActivity ='" + activityId + "'");
            if (coll != null && coll.size() > 0) {
                publishInfo = coll.get(0);
            }
        } else if (activityId == null && publishInfoId != null) {
            publishInfo = InterActivityPublishInfoFactory.getLocalInstance(ctx).getInterActivityPublishInfoInfo((IObjectPK)new ObjectUuidPK(publishInfoId));
            activityInfo = publishInfo.getInterviewActivity();
        } else {
            activityInfo = InterviewActivityFactory.getLocalInstance(ctx).getInterviewActivityInfo((IObjectPK)new ObjectUuidPK(activityId));
            publishInfo = InterActivityPublishInfoFactory.getLocalInstance(ctx).getInterActivityPublishInfoInfo((IObjectPK)new ObjectUuidPK(publishInfoId));
        }
        DynamicRowSet rowSet = null;
        try {
            StringBuffer str = new StringBuffer();
            Date date = new Date(System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            str.append(cal.get(1)).append(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"3_InterviewActivityFacadeControllerBean", (Locale)ctx.getLocale()));
            str.append(cal.get(2) + 1).append(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"4_InterviewActivityFacadeControllerBean", (Locale)ctx.getLocale()));
            str.append(cal.get(5)).append(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"5_InterviewActivityFacadeControllerBean", (Locale)ctx.getLocale()));
            str.append(cal.get(11)).append(":");
            str.append(cal.get(12));
            rowSet = new DynamicRowSet(12);
            rowSet.setColInfo(1, new ColInfo("companyName", "companyName", 12, null));
            rowSet.setColInfo(2, new ColInfo("companyInfo", "companyInfo", 12, null));
            rowSet.setColInfo(3, new ColInfo("purpose", "purpose", 12, null));
            rowSet.setColInfo(4, new ColInfo("program", "program", 12, null));
            rowSet.setColInfo(5, new ColInfo("startDate", "startDate", 12, null));
            rowSet.setColInfo(6, new ColInfo("endDate", "endDate", 12, null));
            rowSet.setColInfo(7, new ColInfo("description", "description", 12, null));
            rowSet.setColInfo(8, new ColInfo("treatment", "treatment", 12, null));
            rowSet.setColInfo(9, new ColInfo("requirement", "requirement", 12, null));
            rowSet.setColInfo(10, new ColInfo("contactInfo", "contactInfo", 12, null));
            rowSet.setColInfo(11, new ColInfo("printDate", "printDate", 12, null));
            rowSet.setColInfo(12, new ColInfo("signDate", "signDate", 12, null));
            HROrgUnitInfo hrInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(activityInfo.getHrOrgUnit().getId().toString()));
            rowSet.moveToInsertRow();
            rowSet.updateString("companyName", hrInfo.getName());
            if (publishInfo != null) {
                rowSet.updateString("companyInfo", "      " + publishInfo.getIntroduce());
                rowSet.updateString("purpose", publishInfo.getPurpose());
                rowSet.updateString("program", publishInfo.getProgram());
                rowSet.updateString("startDate", DateUtil.format(publishInfo.getStartDate(), "yyyy-MM-dd"));
                rowSet.updateString("endDate", DateUtil.format(publishInfo.getEndDate(), "yyyy-MM-dd"));
                rowSet.updateString("description", publishInfo.getDescription());
                rowSet.updateString("treatment", publishInfo.getTreatment());
                rowSet.updateString("requirement", publishInfo.getRequirement());
                rowSet.updateString("contactInfo", publishInfo.getContactInfo());
                rowSet.updateString("signDate", ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"6_InterviewActivityFacadeControllerBean", (Locale)ctx.getLocale()) + DateUtil.format(publishInfo.getEndDate(), "yyyy-MM-dd"));
            }
            rowSet.updateString("printDate", str.toString());
            rowSet.insertRow();
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rowSet;
    }

    protected void _saveSum(Context ctx, IObjectCollection ioc) throws BOSException, EASBizException {
        ResumeBaseCollection rbc = (ResumeBaseCollection)ioc;
        if (rbc != null) {
            for (int i = 0; i < rbc.size(); ++i) {
                ResumeBaseInfo info = rbc.get(i);
                IResumeBase dao = ResumeBaseFactory.getLocalInstance(ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("sum"));
                dao.updatePartial((CoreBaseInfo)info, sic);
            }
        }
    }

    protected BigDecimal _getSumById(Context ctx, String resumeBaseId) throws BOSException, EASBizException {
        if (resumeBaseId == null) {
            return null;
        }
        IResumeBase dao = ResumeBaseFactory.getLocalInstance(ctx);
        ResumeBaseInfo rbInfo = null;
        String id = resumeBaseId;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("sum"));
        fi.getFilterItems().clear();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        rbInfo = dao.getResumeBaseInfo((IObjectPK)new ObjectUuidPK(id), sic);
        BigDecimal sum = rbInfo.getSum();
        return sum;
    }

    protected int _getSumPlanNumberForInterviewActivity(Context ctx, String interviewActivityId) throws BOSException, EASBizException {
        int sumPlanNumber = 0;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT SUM(\"ENTRY\".FAmount) AS FAmount FROM T_HR_InterviewActivityEntry AS \"ENTRY\" ");
        sb.append(" LEFT JOIN T_HR_InterviewActivity AS \"INTERVIEWACTIVITY\" ");
        sb.append(" ON \"ENTRY\".FInterviewActivityID = \"INTERVIEWACTIVITY\".FID ");
        sb.append(" WHERE \"ENTRY\".FInterviewActivityID = '");
        sb.append(interviewActivityId);
        sb.append("'");
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString()).executeSQL();
        try {
            if (rs.next()) {
                sumPlanNumber = rs.getInt("FAmount");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return sumPlanNumber;
    }

    protected int _getSumRealNumberForInterviewActivity(Context ctx, String interviewActivityId) throws BOSException, EASBizException {
        int sumRealNumber = 0;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT COUNT(\"RESUMEBASE\".FID) AS FCount FROM T_HR_ResumeBase AS \"RESUMEBASE\" ");
        sb.append(" LEFT JOIN T_HR_InterviewActivity AS \"INTERVIEWACTIVITY\" ");
        sb.append(" ON \"RESUMEBASE\".FInterviewActivityID = \"INTERVIEWACTIVITY\".FID ");
        sb.append(" WHERE \"INTERVIEWACTIVITY\".FID = '");
        sb.append(interviewActivityId);
        sb.append("' AND \"RESUMEBASE\".FPersonState IN(");
        sb.append(3);
        sb.append(",");
        sb.append(7);
        sb.append(") AND \"RESUMEBASE\".FResumeState IN (");
        sb.append(6);
        sb.append(",");
        sb.append(10);
        sb.append(" ) ");
        IRowSet rs = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sb.toString()).executeSQL();
        try {
            if (rs.next()) {
                sumRealNumber = rs.getInt("FCount");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return sumRealNumber;
    }

    private void dealLogInfo(Context ctx, String loggerInfo) throws BOSException, EASBizException {
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)RecruitSummaryFactory.getLocalInstance(ctx).getType(), null, (String)loggerInfo, (String)"rec_InterviewActivity_Audit");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }
}

