/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CityCollection;
import com.kingdee.eas.basedata.assistant.CityFactory;
import com.kingdee.eas.basedata.assistant.CityInfo;
import com.kingdee.eas.basedata.assistant.ProvinceCollection;
import com.kingdee.eas.basedata.assistant.ProvinceFactory;
import com.kingdee.eas.basedata.assistant.ProvinceInfo;
import com.kingdee.eas.basedata.hraux.RegpermresidenceCollection;
import com.kingdee.eas.basedata.hraux.RegpermresidenceFactory;
import com.kingdee.eas.basedata.hraux.RegpermresidenceInfo;
import com.kingdee.eas.basedata.hraux.WedCollection;
import com.kingdee.eas.basedata.hraux.WedFactory;
import com.kingdee.eas.basedata.hraux.WedInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.ActivityRelationResumeFactory;
import com.kingdee.eas.hr.rec.ActivityRelationResumeInfo;
import com.kingdee.eas.hr.rec.IActivityRelationResume;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.IResumeBaseExtend;
import com.kingdee.eas.hr.rec.IResumeExtend;
import com.kingdee.eas.hr.rec.ImportDataException;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.PersonStateEnum;
import com.kingdee.eas.hr.rec.RecChanneCollection;
import com.kingdee.eas.hr.rec.RecChanneFactory;
import com.kingdee.eas.hr.rec.RecChanneInfo;
import com.kingdee.eas.hr.rec.RecCommonException;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseExtendFactory;
import com.kingdee.eas.hr.rec.ResumeBaseExtendInfo;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeCategoryInfo;
import com.kingdee.eas.hr.rec.ResumeExtendCollection;
import com.kingdee.eas.hr.rec.ResumeExtendFactory;
import com.kingdee.eas.hr.rec.ResumeExtendInfo;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.app.ExcelField;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ResumeBaseDataTransmission
extends AbstractDataTransmission {
    private static final String solution = "com.kingdee.eas.hr.rec.app.ExportResumeBaseQuery";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.ResumeBaseDataTransmission");
    private static final String resumeRES = "com.kingdee.eas.hr.rec.ResumeResource";
    private static List props = new ArrayList();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ResumeBaseFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            Object weight;
            Object obj;
            ResumeBaseInfo info = new ResumeBaseInfo();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            if (hsData.get("ID") == null || hsData.get("ID").toString().trim().length() <= 0) {
                throw new ImportDataException(ImportDataException.ACCESSID_NOT_NULL);
            }
            if (hsData.get("name") == null || hsData.get("name").toString().trim().length() <= 0) {
                throw new ImportDataException(ImportDataException.RESUMEBASE_NAME_NULL);
            }
            info.setName(hsData.get("name").toString());
            if (hsData.get("gender") == null || hsData.get("gender").toString().trim().length() <= 0) {
                info.setGender(Genders.getEnum((String)"Male"));
            } else if (hsData.get("gender").toString().equals(Genders.getEnum((String)"Male").toString())) {
                info.setGender(Genders.getEnum((String)"Male"));
            } else if (hsData.get("gender").toString().equals(Genders.getEnum((String)"Female").toString())) {
                info.setGender(Genders.getEnum((String)"Female"));
            } else {
                throw new ImportDataException(ImportDataException.RESUMEBASE_SEX_INVALID);
            }
            if (hsData.get("birthday") != null && hsData.get("birthday").toString().trim().length() >= 1) {
                Pattern dateP = Pattern.compile("^(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)$");
                if (!dateP.matcher(hsData.get("birthday").toString()).matches()) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"9_ResumeBaseDataTransmission", (Locale)ctx.getLocale()));
                }
                Date birth = format.parse(hsData.get("birthday").toString());
                info.setBirthday(birth);
                info.setAge(RecServerUtils.subTwoDate(new Date(), birth));
            }
            if (hsData.get("currentResidency") != null && hsData.get("currentResidency").toString().trim().length() > 0) {
                obj = this.getProvinceCity(ctx, hsData.get("currentResidency").toString());
                info.setCity((CityInfo)obj[1]);
                info.setProvince((ProvinceInfo)obj[0]);
            }
            if (hsData.get("yearsofWorking") != null && hsData.get("yearsofWorking").toString().trim().length() > 0) {
                if (!RecServerUtils.isInt(hsData.get("yearsofWorking").toString(), true)) {
                    throw new ImportDataException(ImportDataException.RESUMEBASE_WORKYEARS_IS_INT);
                }
                info.setWorkYears(new Double(hsData.get("yearsofWorking").toString()).intValue());
            }
            if (hsData.get("huKou") != null && !StringUtils.isEmpty((String)hsData.get("huKou").toString())) {
                info.setNativePlace(hsData.get("huKou").toString());
            }
            if (hsData.get("address") != null && !StringUtils.isEmpty((String)hsData.get("address").toString())) {
                info.setAddressTX(hsData.get("address").toString());
            }
            if (hsData.get("eMail") != null && !StringUtils.isEmpty((String)hsData.get("eMail").toString())) {
                info.setEmail(hsData.get("eMail").toString());
            }
            if (hsData.get("homeTelephone") != null && !StringUtils.isEmpty((String)hsData.get("homeTelephone").toString())) {
                info.setHomePhone(hsData.get("homeTelephone").toString());
            }
            if (hsData.get("workPhone") != null && !StringUtils.isEmpty((String)hsData.get("workPhone").toString())) {
                info.setOfficePhone(hsData.get("workPhone").toString());
            }
            if (hsData.get("mobilePhone") != null && !StringUtils.isEmpty((String)hsData.get("mobilePhone").toString())) {
                info.setCell(hsData.get("mobilePhone").toString());
            }
            if (hsData.get("selfAssessment") != null && !StringUtils.isEmpty((String)hsData.get("selfAssessment").toString())) {
                info.setEvaluate(hsData.get("selfAssessment").toString());
            }
            if (hsData.get("ID") != null) {
                info.setIdCardNO(hsData.get("ID").toString());
                this.initBirthAndGenderFromIdCardNO(hsData.get("ID").toString(), info);
            }
            if (hsData.get("computerLevel") != null) {
                info.setComputerLevel(hsData.get("computerLevel").toString());
            }
            if ((obj = hsData.get("height")) != null && obj.toString().trim().length() > 0) {
                if (RecServerUtils.isInt(obj.toString())) {
                    info.setHeight(Integer.parseInt(obj.toString()));
                } else {
                    throw new ImportDataException(ImportDataException.RESUMEBASE_HEIGHT_ERROR);
                }
            }
            if ((weight = hsData.get("weight")) != null && weight.toString().trim().length() > 0) {
                if (RecServerUtils.isInt(weight.toString())) {
                    info.setWeight(Integer.parseInt(weight.toString()));
                } else {
                    throw new ImportDataException(ImportDataException.RESUMEBASE_WEIGHT_ERROR);
                }
            }
            if (hsData.get("passportNO") != null) {
                info.setPassportNO(hsData.get("passportNO").toString());
            }
            if (hsData.get("driveType") != null && !StringUtils.isEmpty((String)hsData.get("driveType").toString())) {
                info.setDriveType(hsData.get("driveType").toString());
            }
            if (hsData.get("driveLicenceNO") != null && !StringUtils.isEmpty((String)hsData.get("driveLicenceNO").toString())) {
                info.setDriveLicenceNO(hsData.get("driveLicenceNO").toString());
            }
            if (hsData.get("qqOrmsn") != null && !StringUtils.isEmpty((String)hsData.get("qqOrmsn").toString())) {
                info.setQqOrmsn(hsData.get("qqOrmsn").toString());
            }
            ResumeBaseExtendInfo eInfo = new ResumeBaseExtendInfo();
            int j = props.size();
            for (int i = 0; i < j; ++i) {
                Object value;
                String prop = props.get(i).toString();
                if ("id".equals(prop) || (value = hsData.get(prop)) == null) continue;
                eInfo.put(prop, value);
            }
            info.setResumeBaseExtend(eInfo);
            obj = hsData.get("englishLevel");
            if (obj != null && obj.toString().trim().length() > 0) {
                info.setEnglishLevel(obj.toString());
            }
            if (!RecServerUtils.objectIsNull(hsData.get("recChanne"))) {
                RecChanneInfo recInfo = this.getRecChanne(ctx, hsData.get("recChanne").toString());
                if (RecServerUtils.objectIsNull(recInfo)) {
                    throw new ImportDataException(ImportDataException.RESUMEBASE_RECCHANNE_ERROR);
                }
                info.setRecChanne(recInfo);
            }
            if (!RecServerUtils.objectIsNull(hsData.get("regPermSidence"))) {
                RegpermresidenceInfo regInfo = this.getRegPermSidence(ctx, hsData.get("regPermSidence").toString());
                if (RecServerUtils.objectIsNull(regInfo)) {
                    throw new ImportDataException(ImportDataException.RESUMEBASE_REGPERMSIDENCE_ERROR);
                }
                eInfo.setRegpermresidence(regInfo);
            }
            if (!RecServerUtils.objectIsNull(hsData.get("wed"))) {
                WedInfo dInfo = this.getWedInfo(ctx, hsData.get("wed").toString());
                if (RecServerUtils.objectIsNull(dInfo)) {
                    throw new ImportDataException(ImportDataException.RESUMEBASE_WED_ERROR);
                }
                info.setWed(dInfo);
            }
            info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            info.setYingPDate(DateTimeUtils.truncateDate((Date)new Date(System.currentTimeMillis())));
            return info;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private void initBirthAndGenderFromIdCardNO(String CarNo, ResumeBaseInfo resumeBaseInfo) throws ParseException {
        String year = null;
        String month = null;
        String day = null;
        String birthday = null;
        String gender = null;
        Date date = null;
        if (CarNo != null && !"".equals(CarNo)) {
            if (CarNo.length() != 15 && CarNo.length() != 18) {
                return;
            }
            if (CarNo.length() == 15) {
                year = CarNo.substring(6, 8);
                month = CarNo.substring(8, 10);
                day = CarNo.substring(10, 12);
                StringBuffer birth = new StringBuffer("19");
                birthday = birth.append(year).append("-").append(month).append("-").append(day).toString();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                date = format.parse(birthday);
                gender = CarNo.substring(14, 15);
            } else if (CarNo.length() == 18) {
                year = CarNo.substring(6, 10);
                month = CarNo.substring(10, 12);
                day = CarNo.substring(12, 14);
                StringBuffer sb = new StringBuffer("");
                birthday = sb.append(year).append("-").append(month).append("-").append(day).toString();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                date = format.parse(birthday);
                gender = CarNo.substring(16, 17);
            }
            if ("1".equals(gender) || "3".equals(gender) || "5".equals(gender) || "7".equals(gender) || "9".equals(gender)) {
                resumeBaseInfo.setGender(Genders.getEnum((String)"Male"));
            } else {
                resumeBaseInfo.setGender(Genders.getEnum((String)"Female"));
            }
            resumeBaseInfo.setBirthday(date);
            if (date == null) {
                date = new Date();
            }
            resumeBaseInfo.setAge(RecServerUtils.subTwoDate(new Date(), date));
        }
    }

    private RegpermresidenceInfo getRegPermSidence(Context ctx, String regPermSidence) throws BOSException, EASBizException {
        RegpermresidenceInfo info = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)regPermSidence));
        ev.setFilter(filter);
        ev.getSelector().add(new SelectorItemInfo("name"));
        RegpermresidenceCollection regCol = RegpermresidenceFactory.getLocalInstance((Context)ctx).getRegpermresidenceCollection(ev);
        int size = regCol.size();
        for (int i = 0; i < size; ++i) {
            if (!regCol.get(i).getName().equals(regPermSidence)) continue;
            info = regCol.get(i);
            break;
        }
        return info;
    }

    private RecChanneInfo getRecChanne(Context ctx, String recChanne) throws BOSException {
        RecChanneInfo info = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo wedFilter = new FilterInfo();
        wedFilter.getFilterItems().add(new FilterItemInfo("name", (Object)recChanne));
        ev.setFilter(wedFilter);
        ev.getSelector().add(new SelectorItemInfo("name"));
        RecChanneCollection recCol = RecChanneFactory.getLocalInstance(ctx).getRecChanneCollection(ev);
        int size = recCol.size();
        for (int i = 0; i < size; ++i) {
            if (!recCol.get(i).getName().equals(recChanne)) continue;
            info = recCol.get(i);
            break;
        }
        return info;
    }

    private WedInfo getWedInfo(Context ctx, String wedName) throws BOSException {
        WedInfo info = null;
        EntityViewInfo wedEntityViewInfo = new EntityViewInfo();
        FilterInfo wedFilter = new FilterInfo();
        wedFilter.getFilterItems().add(new FilterItemInfo("name", (Object)wedName));
        wedEntityViewInfo.setFilter(wedFilter);
        wedEntityViewInfo.getSelector().add(new SelectorItemInfo("name"));
        WedCollection dCol = WedFactory.getLocalInstance((Context)ctx).getWedCollection(wedEntityViewInfo);
        int size = dCol.size();
        for (int i = 0; i < size; ++i) {
            if (!dCol.get(i).getName().equals(wedName)) continue;
            info = dCol.get(i);
            break;
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        StringBuffer tmp = null;
        try {
            if (!StringUtils.isEmpty((String)rs.getString("idCardNO"))) {
                result.put("ID", rs.getString("idCardNO"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("name"))) {
                result.put("name", rs.getString("name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("gender"))) {
                result.put("gender", Genders.getEnum((int)Integer.valueOf(rs.getString("gender"))).toString());
            }
            if (rs.getDate("birthday") != null) {
                result.put("birthday", rs.getDate("birthday").toString());
            }
            result.put("yearsofWorking", "" + rs.getInt("workYears"));
            if (!StringUtils.isEmpty((String)rs.getString("nativePlace"))) {
                result.put("huKou", rs.getString("nativePlace"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("addressTX"))) {
                result.put("address", rs.getString("addressTX"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("email"))) {
                result.put("eMail", rs.getString("email"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("homePhone"))) {
                result.put("homeTelephone", rs.getString("homePhone"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("officePhone"))) {
                result.put("workPhone", rs.getString("officePhone"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("cell"))) {
                result.put("mobilePhone", rs.getString("cell"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("evaluate"))) {
                result.put("selfAssessment", rs.getString("evaluate"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("nativePlace"))) {
                result.put("huKou", rs.getString("nativePlace"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("computerLevel"))) {
                result.put("computerLevel", rs.getString("computerLevel"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("height"))) {
                result.put("height", rs.getString("height"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("weight"))) {
                result.put("weight", rs.getString("weight"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("passportNO"))) {
                result.put("passportNO", rs.getString("passportNO"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("driveType"))) {
                result.put("driveType", rs.getString("driveType"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("driveLicenceNO"))) {
                result.put("driveLicenceNO", rs.getString("driveLicenceNO"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("qqOrmsn"))) {
                result.put("qqOrmsn", rs.getString("qqOrmsn"));
            }
            int j = props.size();
            for (int i = 0; i < j; ++i) {
                String key = props.get(i).toString();
                String value = rs.getString("extend." + key);
                if (StringUtils.isEmpty((String)value)) continue;
                result.put(key, value);
            }
            if (!StringUtils.isEmpty((String)rs.getString("gender"))) {
                result.put("gender", Genders.getEnum((int)Integer.valueOf(rs.getString("gender"))).toString());
            }
            if (rs.getDate("birthday") != null) {
                result.put("birthday", rs.getDate("birthday").toString());
            }
            boolean isDirCity = rs.getBoolean("city.isDirCity");
            tmp = new StringBuffer();
            if (!StringUtils.isEmpty((String)rs.getString("province.name"))) {
                tmp.append(rs.getString("province.name"));
                if (!isDirCity) {
                    tmp.append(ExcelField.getProvince(ctx.getLocale()));
                }
            }
            if (!StringUtils.isEmpty((String)rs.getString("city.name"))) {
                if (isDirCity) {
                    tmp = new StringBuffer();
                }
                tmp.append(rs.getString("city.name"));
                tmp.append(ExcelField.getCity(ctx.getLocale()));
            }
            result.put("currentResidency", tmp.toString());
            result.put("yearsofWorking", "" + rs.getInt("workYears"));
            if (!StringUtils.isEmpty((String)rs.getString("nativePlace"))) {
                result.put("huKou", rs.getString("nativePlace"));
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return RecServerUtils.getHRFilterInfo(ctx, "hrOrgUnit.id");
    }

    public String getExportQueryInfo(Context ctx) {
        return solution;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        block14: {
            Boolean isReusltImport = (Boolean)this.getContextParameter("isResultImport");
            Object activity = this.getContextParameter("activityId");
            ResumeCategoryInfo categoryInfo = (ResumeCategoryInfo)this.getContextParameter("resumeCategory");
            try {
                IResumeBase resumeBaseDao = ResumeBaseFactory.getLocalInstance(ctx);
                IResumeExtend resumeExtendDao = ResumeExtendFactory.getLocalInstance(ctx);
                IResumeBaseExtend resumeBaseExtendDao = ResumeBaseExtendFactory.getLocalInstance(ctx);
                ResumeBaseInfo info = (ResumeBaseInfo)coreBaseInfo;
                ResumeBaseExtendInfo eInfo = info.getResumeBaseExtend();
                info.setIsInter(false);
                String cardNo = info.getIdCardNO();
                String passportNO = info.getPassportNO();
                StringBuffer sql = new StringBuffer("select a.fid, b.fname_l2 from T_HR_Blacklistextend a ,T_HR_Resumebase b where a.fresumebaseid = b.fid and (b.fidcardno='");
                sql.append(cardNo).append("'");
                if (passportNO != null && !passportNO.trim().equals("")) {
                    sql.append(" or b.fPassportNO='").append(passportNO).append("'");
                }
                sql.append(")");
                IRowSet rst = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString()).executeSQL();
                if (rst.next()) {
                    throw new RecCommonException(RecCommonException.PERSON_IN_BLACKLIST, new Object[]{cardNo});
                }
                if (this.isSltImportUpdate()) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)cardNo));
                    FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
                    if (fi != null) {
                        filter.mergeFilter(fi, "and");
                    }
                    if (resumeBaseDao.exists(filter)) {
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        viewInfo.setFilter(filter);
                        SelectorItemCollection sic = viewInfo.getSelector();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("number"));
                        ResumeBaseCollection baseCol = resumeBaseDao.getResumeBaseCollection(viewInfo);
                        HashSet<String> resumeBaseIds = new HashSet<String>();
                        int size = baseCol.size();
                        for (int i = 0; i < size; ++i) {
                            ResumeBaseInfo oldInfo = baseCol.get(i);
                            resumeBaseIds.add(oldInfo.getId().toString());
                            info.setId(oldInfo.getId());
                            info.setNumber(oldInfo.getNumber());
                            if (isReusltImport != null && isReusltImport.booleanValue() && activity != null) {
                                this.doPreResultImport(ctx, activity.toString(), info, true);
                            }
                            resumeBaseDao.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
                        }
                        EntityViewInfo extendViewInfo = new EntityViewInfo();
                        FilterInfo extendFilter = new FilterInfo();
                        extendFilter.getFilterItems().add(new FilterItemInfo("resumeBase.id", resumeBaseIds, CompareType.INCLUDE));
                        if (fi != null) {
                            extendFilter.mergeFilter(fi, "and");
                        }
                        extendViewInfo.setFilter(extendFilter);
                        ResumeExtendCollection extendCol = resumeExtendDao.getResumeExtendCollection(extendViewInfo);
                        int n = extendCol.size();
                        for (int j = 0; j < n; ++j) {
                            ResumeExtendInfo extendInfo = extendCol.get(j);
                            if (extendInfo.getCategory().equals(categoryInfo)) continue;
                            extendInfo.setCategory(categoryInfo);
                            resumeExtendDao.updatePartial((CoreBaseInfo)extendInfo, RecServerUtils.getSic(new String[]{"category"}));
                        }
                    } else {
                        this.addNewResumeBase(ctx, isReusltImport, activity, resumeBaseDao, resumeExtendDao, resumeBaseExtendDao, info, eInfo);
                    }
                    break block14;
                }
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)cardNo));
                FilterInfo filter = RecServerUtils.getHRFilterByParam(ctx, "REC002");
                if (fi != null) {
                    fi.mergeFilter(filter, "and");
                }
                if (!resumeBaseDao.exists(fi)) {
                    this.addNewResumeBase(ctx, isReusltImport, activity, resumeBaseDao, resumeExtendDao, resumeBaseExtendDao, info, eInfo);
                    break block14;
                }
                RecCommonException bizException = new RecCommonException(RecCommonException.DUP_IDCARDNO, new Object[]{cardNo});
                throw bizException;
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
    }

    private final void addNewResumeBase(Context ctx, Boolean isReusltImport, Object activity, IResumeBase resumeBaseDao, IResumeExtend resumeExtendDao, IResumeBaseExtend resumeBaseExtendDao, ResumeBaseInfo info, ResumeBaseExtendInfo eInfo) throws BOSException, EASBizException, TaskExternalException {
        if (info.getId() == null || !resumeBaseDao.exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
            info.setNumber(RecServerUtils.getNumberSilent(ctx, (CoreBaseInfo)info, RecServerUtils.getCurrentHROrgUnit(ctx).getId().toString()));
            info.setResumeState(ResumeStateEnum.no_dispose);
            info.setPersonState(PersonStateEnum.noEntry);
            info.setIsInter(false);
            IObjectPK pk = resumeBaseDao.addnew((CoreBaseInfo)info);
            if (isReusltImport != null && isReusltImport.booleanValue()) {
                if (activity != null) {
                    this.doPreResultImport(ctx, activity.toString(), info, false);
                }
                resumeBaseDao.updatePartial((CoreBaseInfo)info, RecServerUtils.getSic(new String[]{"resumeState", "interviewActivity"}));
            }
            info.setId(BOSUuid.read((String)pk.toString()));
            ResumeCategoryInfo categoryInfo = (ResumeCategoryInfo)this.getContextParameter("resumeCategory");
            ResumeExtendInfo extendInfo = new ResumeExtendInfo();
            extendInfo.setResumeBase(info);
            extendInfo.setCategory(categoryInfo);
            extendInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            resumeExtendDao.addnew((CoreBaseInfo)extendInfo);
        } else {
            if (eInfo != null) {
                if (eInfo.getId() != null) {
                    resumeBaseExtendDao.update((IObjectPK)new ObjectUuidPK(eInfo.getId()), eInfo);
                } else {
                    resumeBaseExtendDao.addnew(eInfo);
                }
            }
            resumeBaseDao.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
    }

    private void doPreResultImport(Context ctx, String activityId, ResumeBaseInfo info, boolean override) throws TaskExternalException {
        if (activityId == null || info == null || info.getId() == null) {
            return;
        }
        InterviewActivityInfo activityInfo = new InterviewActivityInfo();
        activityInfo.setId(BOSUuid.read((String)activityId));
        info.setInterviewActivity(activityInfo);
        info.setResumeState(ResumeStateEnum.pass);
        info.setPersonState(PersonStateEnum.noEntry);
        try {
            IActivityRelationResume rr = ActivityRelationResumeFactory.getLocalInstance(ctx);
            if (override) {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("interviewActivity.id", (Object)activityId));
                fi.getFilterItems().add(new FilterItemInfo("resumeBase.id", (Object)info.getId().toString()));
                if (rr.exists(fi)) {
                    return;
                }
            }
            ActivityRelationResumeInfo rrInfo = new ActivityRelationResumeInfo();
            rrInfo.setInterviewActivity(activityInfo);
            rrInfo.setResumeBase(info);
            rr.addnew(rrInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private Object[] getProvinceCity(Context ctx, String place) throws BOSException {
        String provinceKey = ExcelField.getProvince(ctx.getLocale());
        String cityKey = ExcelField.getCity(ctx.getLocale());
        String provinceName = null;
        String cityName = null;
        CityInfo cityInfo = null;
        ProvinceInfo provinceInfo = null;
        int provinceIndex = 0;
        int cityIndex = 0;
        Object[] obj = new Object[2];
        provinceIndex = place.indexOf(provinceKey);
        cityIndex = place.indexOf(cityKey);
        if (provinceIndex >= 0 && cityIndex == -1) {
            provinceName = place.substring(0, provinceIndex);
        } else if (provinceIndex >= 0 && cityIndex >= 0) {
            int cityLength = cityIndex + cityKey.length();
            int provinceLen = provinceIndex + provinceKey.length();
            if (provinceIndex > cityIndex) {
                provinceName = place.substring(cityLength, provinceIndex);
                cityName = place.substring(0, cityIndex);
            } else {
                cityName = place.substring(provinceLen, cityIndex);
                provinceName = place.substring(0, provinceIndex);
            }
        } else {
            cityName = provinceIndex == -1 && cityIndex >= 0 ? place.substring(0, cityIndex) : place;
        }
        if (cityName != null) {
            EntityViewInfo cityEntityViewInfo = new EntityViewInfo();
            cityEntityViewInfo.getSelector().add(new SelectorItemInfo("*"));
            cityEntityViewInfo.getSelector().add(new SelectorItemInfo("province.name"));
            FilterInfo cityFilter = new FilterInfo();
            cityFilter.getFilterItems().add(new FilterItemInfo("name", (Object)cityName));
            cityEntityViewInfo.setFilter(cityFilter);
            CityCollection ccol = CityFactory.getLocalInstance((Context)ctx).getCityCollection(cityEntityViewInfo);
            if (ccol != null && ccol.size() > 0) {
                cityInfo = ccol.get(0);
                provinceInfo = cityInfo.getProvince();
            }
        }
        if (provinceInfo == null && provinceName != null) {
            EntityViewInfo provineEntityViewInfo = new EntityViewInfo();
            FilterInfo provinceFilter = new FilterInfo();
            provinceFilter.getFilterItems().add(new FilterItemInfo("name", (Object)provinceName));
            provineEntityViewInfo.setFilter(provinceFilter);
            ProvinceCollection pcol = ProvinceFactory.getLocalInstance((Context)ctx).getProvinceCollection(provineEntityViewInfo);
            if (pcol != null && pcol.size() > 0) {
                provinceInfo = pcol.get(0);
            }
        }
        obj[0] = provinceInfo;
        obj[1] = cityInfo;
        return obj;
    }

    static {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeBaseExtend");
        EntityObjectInfo entity = loader.getEntity((IMetaDataPK)pk);
        PropertyCollection coll = entity.getDuplicatedEntityProperties();
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            if ("id".equals(coll.get(i).getName())) continue;
            props.add(coll.get(i).getName());
        }
    }
}

