/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.RegpermresidenceInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.AffairBizCheckFacadeFactory;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryFactory;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillFactory;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillInfo;
import com.kingdee.eas.hr.affair.EnrollBillEntryFactory;
import com.kingdee.eas.hr.affair.EnrollBillEntryInfo;
import com.kingdee.eas.hr.affair.HRAffairState;
import com.kingdee.eas.hr.affair.IEnrollBillEntry;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.IEmployeeType;
import com.kingdee.eas.hr.emp.IPersonCertification;
import com.kingdee.eas.hr.emp.IPersonContactMethod;
import com.kingdee.eas.hr.emp.IPersonDegree;
import com.kingdee.eas.hr.emp.IPersonFamily;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.IPersonWorkExp;
import com.kingdee.eas.hr.emp.PersonCertificationFactory;
import com.kingdee.eas.hr.emp.PersonCertificationInfo;
import com.kingdee.eas.hr.emp.PersonContactMethodFactory;
import com.kingdee.eas.hr.emp.PersonContactMethodInfo;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonDegreeInfo;
import com.kingdee.eas.hr.emp.PersonFamilyFactory;
import com.kingdee.eas.hr.emp.PersonFamilyInfo;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.emp.PersonPhotoInfo;
import com.kingdee.eas.hr.emp.PersonWorkExpFactory;
import com.kingdee.eas.hr.emp.PersonWorkExpInfo;
import com.kingdee.eas.hr.rec.CertificateCollection;
import com.kingdee.eas.hr.rec.CertificateInfo;
import com.kingdee.eas.hr.rec.EducationExpCollection;
import com.kingdee.eas.hr.rec.EducationExpFactory;
import com.kingdee.eas.hr.rec.EducationExpInfo;
import com.kingdee.eas.hr.rec.FamilyRelationCollection;
import com.kingdee.eas.hr.rec.FamilyRelationInfo;
import com.kingdee.eas.hr.rec.HRRecState;
import com.kingdee.eas.hr.rec.HireApplyBillEntryCollection;
import com.kingdee.eas.hr.rec.HireApplyBillEntryFactory;
import com.kingdee.eas.hr.rec.IEducationExp;
import com.kingdee.eas.hr.rec.IHireApplyBillEntry;
import com.kingdee.eas.hr.rec.IInterview;
import com.kingdee.eas.hr.rec.IRequireApplyBill;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.InterviewActivityEntryCollection;
import com.kingdee.eas.hr.rec.InterviewActivityEntryFactory;
import com.kingdee.eas.hr.rec.InterviewActivityEntryInfo;
import com.kingdee.eas.hr.rec.InterviewCollection;
import com.kingdee.eas.hr.rec.InterviewFactory;
import com.kingdee.eas.hr.rec.InterviewInfo;
import com.kingdee.eas.hr.rec.PersonStateEnum;
import com.kingdee.eas.hr.rec.RequireApplyBillCollection;
import com.kingdee.eas.hr.rec.RequireApplyBillEntryCollection;
import com.kingdee.eas.hr.rec.RequireApplyBillEntryFactory;
import com.kingdee.eas.hr.rec.RequireApplyBillEntryInfo;
import com.kingdee.eas.hr.rec.RequireApplyBillFactory;
import com.kingdee.eas.hr.rec.RequireApplyBillInfo;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseExtendInfo;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeEntryException;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.WorkExpCollection;
import com.kingdee.eas.hr.rec.WorkExpInfo;
import com.kingdee.eas.hr.rec.app.AbstractResumeEntryFacadeControllerBean;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class ResumeEntryFacadeControllerBean
extends AbstractResumeEntryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.ResumeEntryFacadeControllerBean");

    protected Map _getInterviewInfo(Context ctx, Map resumeMap) throws BOSException, EASBizException {
        LinkedHashMap map = new LinkedHashMap();
        IInterview interview = InterviewFactory.getLocalInstance(ctx);
        if (resumeMap != null && resumeMap.size() > 0) {
            SorterItemInfo sii = new SorterItemInfo("stepDate");
            sii.setSortType(SortType.ASCEND);
            SelectorItemInfo selectorInfo = new SelectorItemInfo("interviewLevel.name");
            Set set = resumeMap.entrySet();
            for (Map.Entry entry : set) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection fic = filterInfo.getFilterItems();
                if (entry.getKey() != null) {
                    fic.add(new FilterItemInfo("resumeBase.id", entry.getKey()));
                }
                if (entry.getValue() != null) {
                    fic.add(new FilterItemInfo("interviewTime", entry.getValue()));
                }
                evi.setFilter(filterInfo);
                evi.getSorter().add(sii);
                evi.getSelector().add(selectorInfo);
                InterviewCollection ic = interview.getInterviewCollection(evi);
                if (ic != null && ic.size() > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < ic.size(); ++i) {
                        InterviewInfo interviewInfo = ic.get(i);
                        if (interviewInfo.getInterviewLevel() != null) {
                            sb.append(interviewInfo.getInterviewLevel().getName());
                        }
                        if (i >= ic.size() - 1) continue;
                        sb.append("--");
                    }
                    map.put(entry.getKey(), sb.toString());
                    continue;
                }
                map.put(entry.getKey(), "");
            }
        }
        return map;
    }

    public void _setBillToResume(Context ctx, IObjectPK enrollBillId, List resumeIds) throws BOSException, EASBizException {
        if (enrollBillId != null && resumeIds != null && resumeIds.size() > 0) {
            IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = RecServerUtils.getSic(new String[]{"enrollBillId", "personState", "resumeState"});
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            HashSet set = new HashSet(resumeIds);
            fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            evi.setFilter(fi);
            ResumeBaseCollection resumes = resumeBase.getResumeBaseCollection(evi);
            int j = resumes.size();
            for (int i = 0; i < j; ++i) {
                ResumeBaseInfo info = resumes.get(i);
                info.setEnrollBillId(enrollBillId.toString());
                info.setPersonState(PersonStateEnum.confirm);
                info.setResumeState(ResumeStateEnum.entrying);
                resumeBase.updatePartial((CoreBaseInfo)info, sic);
            }
        }
    }

    public void _setResumePersonState(Context ctx, IObjectPK enrollBillId, HRAffairState state) throws BOSException, EASBizException {
        if (enrollBillId != null && state != null) {
            IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo fInfo = new FilterInfo();
            fInfo.getFilterItems().add(new FilterItemInfo("enrollBillId", (Object)enrollBillId));
            evInfo.setFilter(fInfo);
            ResumeBaseCollection rbc = resumeBase.getResumeBaseCollection(evInfo);
            EmpEnrollBizBillInfo empEnrollInfo = EmpEnrollBizBillFactory.getLocalInstance((Context)ctx).getEmpEnrollBizBillInfo(enrollBillId);
            EmpEnrollBizBillEntryCollection col = null;
            if (empEnrollInfo != null) {
                col = empEnrollInfo.getEntrys();
            }
            EmpEnrollBizBillEntryInfo empEnrolInfo = null;
            if (rbc != null && rbc.size() > 0) {
                for (int i = 0; i < rbc.size(); ++i) {
                    if (col != null && !col.isEmpty()) {
                        empEnrolInfo = col.get(i);
                    }
                    ResumeBaseInfo info = rbc.get(i);
                    PersonStateEnum oldPersonState = info.getPersonState();
                    if (state.equals((Object)HRAffairState.APPROVE)) {
                        if (PersonStateEnum.entryed.equals((Object)oldPersonState)) {
                            throw new ResumeEntryException(ResumeEntryException.RESUME_IS_ENTRYED_OR_ENTRING);
                        }
                        this.changeReusmePersonState(ctx, info, PersonStateEnum.confirm);
                        continue;
                    }
                    if (state.equals((Object)HRAffairState.COMPLETE)) {
                        Date createPersonDate;
                        Date now = new Date();
                        if (empEnrolInfo == null || (createPersonDate = empEnrolInfo.getEnrollDate()) == null || !now.before(createPersonDate)) continue;
                        this.changeReusmePersonState(ctx, info, PersonStateEnum.confirm);
                        continue;
                    }
                    if (state.equals((Object)HRAffairState.STOP)) {
                        this.changeReusmePersonState(ctx, info, PersonStateEnum.noEntry);
                        continue;
                    }
                    if (!state.equals((Object)HRAffairState.EDIT)) continue;
                    this.changeReusmePersonState(ctx, info, PersonStateEnum.confirm);
                }
            }
        }
    }

    public void _personStateComplete(Context ctx, IObjectPK enrollBillEntryId) throws BOSException, EASBizException {
        String resumeId = null;
        PersonInfo personInfo = null;
        if (AffairBizCheckFacadeFactory.getLocalInstance((Context)ctx).isUpgradeToBiz()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("resumeID"));
            sic.add(new SelectorItemInfo("person.id"));
            EmpEnrollBizBillEntryInfo entry = EmpEnrollBizBillEntryFactory.getLocalInstance((Context)ctx).getEmpEnrollBizBillEntryInfo(enrollBillEntryId, sic);
            if (entry.getResumeID() != null) {
                resumeId = entry.getResumeID().toString();
            }
            personInfo = entry.getPerson();
        } else {
            IEnrollBillEntry enrollBillEntry = EnrollBillEntryFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("resumeId"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.employeeType.id"));
            sic.add(new SelectorItemInfo("xinDian.id"));
            sic.add(new SelectorItemInfo("xinDian.scheme.id"));
            EnrollBillEntryInfo billEntryInfo = (EnrollBillEntryInfo)enrollBillEntry.getHRBillBaseEntryInfo(enrollBillEntryId, sic);
            resumeId = billEntryInfo.getResumeId();
            personInfo = billEntryInfo.getPerson();
        }
        if (resumeId != null) {
            IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
            ResumeBaseInfo info = resumeBase.getResumeBaseInfo((IObjectPK)new ObjectUuidPK(resumeId), this.getResumeBaseSelector());
            this.fillPersonDetailData(ctx, personInfo, info);
            info.setPersonState(PersonStateEnum.entryed);
            info.setResumeState(ResumeStateEnum.entryed);
            info.setIsInter(true);
            SelectorItemCollection sicc = RecServerUtils.getSic(new String[]{"resumeState", "personState", "isInter"});
            resumeBase.updatePartial((CoreBaseInfo)info, sicc);
            this.setRequireAppBillState(ctx, info);
        }
    }

    public static boolean getParamValue(Context ctx, String number) throws Exception {
        String HRO_ID;
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String val = iParam.getParamValue((IObjectPK)new ObjectUuidPK(HRO_ID = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()), number);
        return "true".equals(val);
    }

    private void setRequireAppBillState(Context ctx, ResumeBaseInfo info) {
        try {
            boolean paramVal = ResumeEntryFacadeControllerBean.getParamValue(ctx, "REC006");
            if (paramVal) {
                this.setRequireApplyBillState(ctx, info);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void setRequireApplyBillState(Context ctx, ResumeBaseInfo resumeInfo) {
        String activityId = resumeInfo.getInterviewActivity().getId().toString();
        String positionId = resumeInfo.getPosition().getId().toString();
        int inviteCompassNumber = this.getInviteCompassNumber(ctx, activityId, positionId);
        Map needMap = this.getRequireNumberByPosition(ctx, activityId, positionId);
        int needNumber = 0;
        if (needMap != null && needMap.get("needNumber") != null && !"".equals(needMap.get("needNumber").toString())) {
            needNumber = Integer.parseInt(needMap.get("needNumber").toString());
        }
        String requrieAppBillNum = "";
        if (needMap != null && needMap.get("requrieAppBillNum") != null) {
            requrieAppBillNum = needMap.get("requrieAppBillNum").toString();
        }
        boolean otherPositionIsEnd = this.getRequrieAppBillOtherPositionEnd(ctx, requrieAppBillNum, positionId);
        if (inviteCompassNumber >= needNumber && !"".equals(requrieAppBillNum) && otherPositionIsEnd) {
            this.setRequireAppBillEnd(ctx, requrieAppBillNum);
        }
    }

    private boolean getRequrieAppBillOtherPositionEnd(Context ctx, String requrieAppBillNum, String positionId) {
        if (!"".equals(requrieAppBillNum)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("sourceNumber", (Object)requrieAppBillNum));
            view.setFilter(filter);
            try {
                RequireApplyBillEntryCollection entryCol = this.getRequrieAppBillEntryByPositionAndNumber(ctx, positionId, requrieAppBillNum);
                if (entryCol == null || entryCol.size() == 0) {
                    return true;
                }
                InterviewActivityEntryCollection ActivityEntryCol = InterviewActivityEntryFactory.getLocalInstance(ctx).getInterviewActivityEntryCollection(view);
                if (ActivityEntryCol == null || ActivityEntryCol.size() == 0) {
                    return false;
                }
                for (int i = 0; i < ActivityEntryCol.size(); ++i) {
                    InterviewActivityEntryInfo entryInfo = ActivityEntryCol.get(i);
                    String activityId = entryInfo.getInterviewActivity().getId().toString();
                    String positiontempId = entryInfo.getPosition().getId().toString();
                    int inviteCompassNumber = this.getInviteCompassNumber(ctx, activityId, positiontempId);
                    Map needMap = this.getRequireNumberByPosition(ctx, activityId, positiontempId);
                    int needNumber = 0;
                    if (needMap != null && needMap.get("needNumber") != null && !"".equals(needMap.get("needNumber").toString())) {
                        needNumber = Integer.parseInt(needMap.get("needNumber").toString());
                    }
                    if (needNumber <= inviteCompassNumber) continue;
                    return false;
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        } else {
            return false;
        }
        return true;
    }

    private RequireApplyBillEntryCollection getRequrieAppBillEntryByPositionAndNumber(Context ctx, String positionId, String requrieAppBillNum) {
        RequireApplyBillEntryCollection entryCol = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)requrieAppBillNum));
            view.setFilter(filter);
            entryCol = RequireApplyBillEntryFactory.getLocalInstance(ctx).getRequireApplyBillEntryCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return entryCol;
    }

    private Map getRequireNumberByPosition(Context ctx, String activityId, String positionId) {
        HashMap<String, String> needMap = new HashMap<String, String>();
        int needNumber = 0;
        String requrieAppBillNum = "";
        try {
            String sql = null;
            sql = "select FAmount,FSourceNumber from T_HR_InterviewActivityEntry where FInterviewActivityId='" + activityId + "' and FPositionId='" + positionId + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next()) {
                requrieAppBillNum = rowSet.getString("FSourceNumber");
                String requriedAppBillId = "";
                if (requrieAppBillNum != null && !"".equals(requrieAppBillNum)) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)requrieAppBillNum));
                    view.setFilter(filter);
                    RequireApplyBillCollection appCol = RequireApplyBillFactory.getLocalInstance(ctx).getRequireApplyBillCollection(view);
                    if (appCol != null && appCol.size() > 0) {
                        RequireApplyBillInfo appInfo = appCol.get(0);
                        requriedAppBillId = appInfo.getId().toString();
                    }
                }
                if (!"".equals(requriedAppBillId)) {
                    needNumber = this.getNeedNumberByAppBillId(ctx, requriedAppBillId, positionId);
                }
            }
            needMap.put("needNumber", needNumber + "");
            needMap.put("requrieAppBillNum", requrieAppBillNum);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (NumberFormatException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return needMap;
    }

    private int getNeedNumberByAppBillId(Context ctx, String requriedAppBillId, String positionId) {
        int needNumber = 0;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)requriedAppBillId));
        filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionId));
        view.setFilter(filter);
        try {
            RequireApplyBillEntryCollection entryCol = RequireApplyBillEntryFactory.getLocalInstance(ctx).getRequireApplyBillEntryCollection(view);
            if (entryCol != null && entryCol.size() > 0) {
                for (int i = 0; i < entryCol.size(); ++i) {
                    RequireApplyBillEntryInfo entryInfo = entryCol.get(i);
                    if (!"".equals(entryInfo.getAdjustNumber() == null ? "" : entryInfo.getAdjustNumber())) {
                        needNumber += Integer.parseInt(entryInfo.getAdjustNumber());
                        continue;
                    }
                    if (entryInfo.getNeedNumber() == 0 || "".equals(entryInfo.getNeedNumber() + "")) continue;
                    needNumber += entryInfo.getNeedNumber();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return needNumber;
    }

    private void setRequireAppBillEnd(Context ctx, String requrieAppBillNum) {
        try {
            IRequireApplyBill appBillFac = RequireApplyBillFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)requrieAppBillNum));
            view.setFilter(filter);
            RequireApplyBillCollection appBillCol = appBillFac.getRequireApplyBillCollection(view);
            if (appBillCol != null && appBillCol.size() > 0) {
                RequireApplyBillInfo appBill = appBillCol.get(0);
                appBill.setBizState(HRRecState.OVER);
                appBillFac.update((IObjectPK)new ObjectUuidPK(appBill.getId().toString()), appBill);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
    }

    private int getInviteCompassNumber(Context ctx, String activityId, String positionId) {
        int inviteCompassNumber = 0;
        try {
            String sql = null;
            sql = "select count(*) as sum from T_HR_ResumeBase where FinterviewActivityId='" + activityId + "' and FPositionId='" + positionId + "' and ( FpersonState=3 or FpersonState=7 )";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next() && rowSet.getString("sum") != null && !"".equals(rowSet.getString("sum").toString())) {
                inviteCompassNumber = Integer.parseInt(rowSet.getString("sum").toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (NumberFormatException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return inviteCompassNumber;
    }

    protected void _updateResumeOnEnrollBillDeleted(Context ctx, IObjectPK enrollBillId) throws BOSException, EASBizException {
        if (enrollBillId != null) {
            IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
            EntityViewInfo evInfo = new EntityViewInfo();
            FilterInfo fInfo = new FilterInfo();
            fInfo.getFilterItems().add(new FilterItemInfo("enrollBillId", (Object)enrollBillId));
            evInfo.setFilter(fInfo);
            ResumeBaseCollection rbc = resumeBase.getResumeBaseCollection(evInfo);
            if (rbc != null && rbc.size() > 0) {
                for (int i = 0; i < rbc.size(); ++i) {
                    ResumeBaseInfo info = rbc.get(i);
                    info.setEnrollBillId(null);
                    info.setPersonState(PersonStateEnum.noEntry);
                    info.setResumeState(ResumeStateEnum.pass);
                    resumeBase.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
                }
            }
        }
    }

    protected void _setEntry(Context ctx, List resumeIds) throws BOSException, EASBizException {
        IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        IPerson person = PersonFactory.getLocalInstance((Context)ctx);
        IPositionMember positionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        IPersonPhoto personPhoto = PersonPhotoFactory.getLocalInstance((Context)ctx);
        IPersonWorkExp personWorkExp = PersonWorkExpFactory.getLocalInstance((Context)ctx);
        IPersonDegree personDegree = PersonDegreeFactory.getLocalInstance((Context)ctx);
        IPersonCertification personCertification = PersonCertificationFactory.getLocalInstance((Context)ctx);
        IPersonContactMethod personContactMethod = PersonContactMethodFactory.getLocalInstance((Context)ctx);
        if (resumeIds != null && resumeIds.size() > 0) {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            HROrgUnitInfo orgUnit = ContextUtil.getCurrentHRUnit((Context)ctx);
            String orgUnitId = orgUnit.getId().toString();
            FilterInfo fi = new FilterInfo();
            int size = resumeIds.size();
            for (int i = 0; i < size; ++i) {
                RegpermresidenceInfo reg;
                ResumeBaseExtendInfo rex;
                boolean flag;
                String str;
                PersonContactMethodInfo pcmInfo;
                FamilyRelationCollection frColl;
                CertificateCollection cfc;
                int j;
                EducationExpCollection eec;
                WorkExpCollection wec;
                String resumeBaseId = resumeIds.get(i).toString();
                ResumeBaseInfo resumeBaseInfo = resumeBase.getResumeBaseInfo((IObjectPK)new ObjectUuidPK(resumeBaseId.toString()), this.getResumeBaseSelector());
                PersonInfo personInfo = new PersonInfo();
                if (codingRuleManager.isExist((IObjectValue)personInfo, orgUnitId)) {
                    personInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                    String number = codingRuleManager.getNumber((IObjectValue)personInfo, orgUnitId);
                    personInfo.setNumber(number);
                } else {
                    personInfo.setNumber(this.getNumber());
                }
                EmployeeTypeInfo etInfo = this.findEmployeeTypeByID(ctx, "00000000-0000-0000-0000-000000000001A29E85B3");
                if (etInfo != null) {
                    personInfo.setEmployeeType(etInfo);
                }
                personInfo.setIdCardNO(resumeBaseInfo.getIdCardNO());
                personInfo.setName(resumeBaseInfo.getName());
                personInfo.setGender(resumeBaseInfo.getGender());
                personInfo.setBirthday(resumeBaseInfo.getBirthday());
                personInfo.setEmail(resumeBaseInfo.getEmail());
                personInfo.setHeight(resumeBaseInfo.getHeight());
                personInfo.setNativePlace(resumeBaseInfo.getNativePlace());
                personInfo.setHomePhone(resumeBaseInfo.getHomePhone());
                personInfo.setWed(resumeBaseInfo.getWed());
                personInfo.setPoliticalFace(resumeBaseInfo.getPoliticalFace());
                personInfo.setAddressTX(resumeBaseInfo.getContactAddress());
                personInfo.setHrOrgUnit(resumeBaseInfo.getHrOrgUnit());
                personInfo.setOldName(resumeBaseInfo.getOldName());
                personInfo.setFolk(resumeBaseInfo.getFolk());
                personInfo.setHighestDegree(resumeBaseInfo.getHighestDiploma());
                personInfo.setHealth(resumeBaseInfo.getHealth());
                personInfo.setCell(resumeBaseInfo.getCell());
                personInfo.setPassportNO(resumeBaseInfo.getPassportNO());
                personInfo.setBloodType(resumeBaseInfo.getBloodType());
                personInfo.setStanding(resumeBaseInfo.getStanding());
                personInfo.setBirth(resumeBaseInfo.getBirth());
                person.addnew((CoreBaseInfo)personInfo);
                if (resumeBaseInfo.getPhoto() != null) {
                    PersonPhotoInfo personPhotoInfo = new PersonPhotoInfo();
                    personPhotoInfo.setPerson(personInfo);
                    personPhotoInfo.setImageData(resumeBaseInfo.getPhoto().getImageData());
                    personPhoto.addnew((CoreBaseInfo)personPhotoInfo);
                }
                if ((wec = resumeBaseInfo.getWorkExp()) != null && wec.size() > 0) {
                    for (int j2 = 0; j2 < wec.size(); ++j2) {
                        WorkExpInfo workExpInfo = wec.get(j2);
                        PersonWorkExpInfo personWorkExpInfo = new PersonWorkExpInfo();
                        personWorkExpInfo.setBeginDate(workExpInfo.getStartDate());
                        personWorkExpInfo.setEndDate(workExpInfo.getEndDate());
                        personWorkExpInfo.setUnitName(workExpInfo.getOrgan());
                        personWorkExpInfo.setPersonQuantity(workExpInfo.getOrganPerson());
                        personWorkExpInfo.setUnitAddress(workExpInfo.getOrganAddress());
                        personWorkExpInfo.setWorkDept(workExpInfo.getOrganDepartment());
                        personWorkExpInfo.setPosition(workExpInfo.getPosition());
                        personWorkExpInfo.setSubordinateQuantity(workExpInfo.getUnderNum());
                        personWorkExpInfo.setSalary(workExpInfo.getSalary());
                        personWorkExpInfo.setDimission(workExpInfo.getDimissionReson());
                        personWorkExpInfo.setLinkman(workExpInfo.getLinkman());
                        personWorkExpInfo.setLinkmanPhone(workExpInfo.getLinkmanPhone());
                        personWorkExpInfo.setRemark(workExpInfo.getRemark());
                        personWorkExpInfo.setIndustryType(workExpInfo.getIndustryType());
                        personWorkExpInfo.setPerson(personInfo);
                        personWorkExp.addnew((CoreBaseInfo)personWorkExpInfo);
                    }
                }
                if ((eec = resumeBaseInfo.getEducationExp()) != null && eec.size() > 0) {
                    PersonDegreeInfo personDegreeInfo;
                    EducationExpInfo educationExpInfo;
                    boolean haveHighDegree = false;
                    for (j = 0; j < eec.size(); ++j) {
                        educationExpInfo = eec.get(j);
                        if (!educationExpInfo.isHighDegree()) continue;
                        haveHighDegree = true;
                        personDegreeInfo = new PersonDegreeInfo();
                        personDegreeInfo.setDiploma(educationExpInfo.getDiploma());
                        personDegreeInfo.setDegree(educationExpInfo.getDegree());
                        personDegreeInfo.setEnrollDate(educationExpInfo.getStartDate());
                        personDegreeInfo.setGraduateDate(educationExpInfo.getEndDate());
                        personDegreeInfo.setGraduateSchool(educationExpInfo.getSchool());
                        personDegreeInfo.setSpecialty(educationExpInfo.getSpecialty());
                        personDegreeInfo.setSpecialtyType(educationExpInfo.getSpecialtyType());
                        personDegreeInfo.setStudyPattern(educationExpInfo.getPattern());
                        personDegreeInfo.setStudyLength(educationExpInfo.getLength());
                        personDegreeInfo.setDegreeUnit(educationExpInfo.getDegreeUnit());
                        personDegreeInfo.setDegreeDate(educationExpInfo.getDegreeDate());
                        personDegreeInfo.setDegreeNumber(educationExpInfo.getDegreeNumber());
                        personDegreeInfo.setIsHighest(educationExpInfo.isHighDegree());
                        personDegreeInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                        personDegreeInfo.setPerson(personInfo);
                        personDegree.addnew((CoreBaseInfo)personDegreeInfo);
                        eec.remove(educationExpInfo);
                        break;
                    }
                    for (j = 0; j < eec.size(); ++j) {
                        educationExpInfo = eec.get(j);
                        personDegreeInfo = new PersonDegreeInfo();
                        personDegreeInfo.setDiploma(educationExpInfo.getDiploma());
                        personDegreeInfo.setDegree(educationExpInfo.getDegree());
                        personDegreeInfo.setEnrollDate(educationExpInfo.getStartDate());
                        personDegreeInfo.setGraduateDate(educationExpInfo.getEndDate());
                        personDegreeInfo.setGraduateSchool(educationExpInfo.getSchool());
                        personDegreeInfo.setSpecialty(educationExpInfo.getSpecialty());
                        personDegreeInfo.setSpecialtyType(educationExpInfo.getSpecialtyType());
                        personDegreeInfo.setStudyPattern(educationExpInfo.getPattern());
                        personDegreeInfo.setStudyLength(educationExpInfo.getLength());
                        personDegreeInfo.setDegreeUnit(educationExpInfo.getDegreeUnit());
                        personDegreeInfo.setDegreeDate(educationExpInfo.getDegreeDate());
                        personDegreeInfo.setDegreeNumber(educationExpInfo.getDegreeNumber());
                        personDegreeInfo.setIsHighest(educationExpInfo.isHighDegree());
                        personDegreeInfo.setPerson(personInfo);
                        personDegreeInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                        if (!haveHighDegree && j == 0) {
                            personDegreeInfo.setIsHighest(true);
                        }
                        personDegree.addnew((CoreBaseInfo)personDegreeInfo);
                    }
                }
                if ((cfc = resumeBaseInfo.getCertificate()) != null && cfc.size() > 0) {
                    for (j = 0; j < cfc.size(); ++j) {
                        CertificateInfo cfInfo = cfc.get(j);
                        PersonCertificationInfo pcfInfo = new PersonCertificationInfo();
                        if (cfInfo.getCerNumber() != null) {
                            pcfInfo.setCertificateNumber(cfInfo.getCerNumber());
                        } else {
                            pcfInfo.setCertificateNumber("   ");
                        }
                        if (cfInfo.getName() != null) {
                            pcfInfo.setCertificateName(cfInfo.getName());
                        } else {
                            pcfInfo.setCertificateName("  ");
                        }
                        pcfInfo.setCertifyDate(cfInfo.getCertifyDate());
                        pcfInfo.setOrgan(cfInfo.getOrgan());
                        pcfInfo.setPerson(personInfo);
                        pcfInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                        pcfInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                        personCertification.addnew((CoreBaseInfo)pcfInfo);
                    }
                }
                if ((frColl = resumeBaseInfo.getFamilyRelation()) != null && frColl.size() > 0) {
                    IPersonFamily personFamily = PersonFamilyFactory.getLocalInstance((Context)ctx);
                    int n = frColl.size();
                    for (int m = 0; m < n; ++m) {
                        FamilyRelationInfo frInfo = frColl.get(m);
                        PersonFamilyInfo pfInfo = new PersonFamilyInfo();
                        pfInfo.setName(frInfo.getName());
                        pfInfo.setBirthday(frInfo.getBirthDate());
                        pfInfo.setWorkUnit(frInfo.getOrgan());
                        pfInfo.setPoliticalFace(frInfo.getPoliticalFace());
                        pfInfo.setHomeAddress(frInfo.getAddress());
                        pfInfo.setHomePhone(frInfo.getPhone());
                        pfInfo.setPerson(personInfo);
                        personFamily.addnew((CoreBaseInfo)pfInfo);
                    }
                }
                if (!personContactMethod.exists(" WHERE person.id ='" + personInfo.getId() + "'")) {
                    pcmInfo = new PersonContactMethodInfo();
                    str = resumeBaseInfo.getEmail();
                    flag = false;
                    if (str != null) {
                        pcmInfo.setEmail(str);
                        flag = true;
                    }
                    if ((str = resumeBaseInfo.getHomePhone()) != null) {
                        pcmInfo.setHomePhone(str);
                        flag = true;
                    }
                    if ((str = resumeBaseInfo.getPostalCode()) != null) {
                        pcmInfo.setPostalcode(str);
                        flag = true;
                    }
                    if ((str = resumeBaseInfo.getCell()) != null) {
                        pcmInfo.setMobile(str);
                        flag = true;
                    }
                    if ((str = resumeBaseInfo.getContactAddress()) != null) {
                        pcmInfo.setAddressTX(str);
                        pcmInfo.setHomeAddress(str);
                        flag = true;
                    }
                    if ((str = resumeBaseInfo.getAddressTX()) != null) {
                        pcmInfo.setIdCardAddress(str);
                        flag = true;
                    }
                    rex = resumeBaseInfo.getResumeBaseExtend();
                    reg = null;
                    if (rex != null) {
                        reg = rex.getRegpermresidence();
                    }
                    if (reg != null) {
                        pcmInfo.setRegresidence(reg);
                    }
                    if (flag) {
                        pcmInfo.setPerson(personInfo);
                        personContactMethod.addnew((CoreBaseInfo)pcmInfo);
                    }
                } else {
                    pcmInfo = personContactMethod.getPersonContactMethodInfo(" WHERE person.id ='" + personInfo.getId() + "'");
                    str = resumeBaseInfo.getEmail();
                    flag = false;
                    if (str != null) {
                        pcmInfo.setEmail(str);
                        flag = true;
                    }
                    if ((str = resumeBaseInfo.getHomePhone()) != null) {
                        pcmInfo.setHomePhone(str);
                        flag = true;
                    }
                    if ((str = resumeBaseInfo.getPostalCode()) != null) {
                        pcmInfo.setPostalcode(str);
                        flag = true;
                    }
                    if ((str = resumeBaseInfo.getCell()) != null) {
                        pcmInfo.setMobile(str);
                        flag = true;
                    }
                    if ((str = resumeBaseInfo.getContactAddress()) != null) {
                        pcmInfo.setAddressTX(str);
                        pcmInfo.setHomeAddress(str);
                        flag = true;
                    }
                    if ((str = resumeBaseInfo.getAddressTX()) != null) {
                        pcmInfo.setIdCardAddress(str);
                        flag = true;
                    }
                    if ((str = resumeBaseInfo.getQqOrmsn()) != null) {
                        pcmInfo.setQQ(str);
                        flag = true;
                    }
                    rex = resumeBaseInfo.getResumeBaseExtend();
                    reg = null;
                    if (rex != null) {
                        reg = rex.getRegpermresidence();
                    }
                    if (reg != null) {
                        pcmInfo.setRegresidence(reg);
                    }
                    if (flag) {
                        pcmInfo.setPerson(personInfo);
                        personContactMethod.updatePartial((CoreBaseInfo)pcmInfo, RecServerUtils.getSic(new String[]{"email", "homePhone", "postalcode", "mobile", "addressTX", "homeAddress", "idCardAddress", "QQ", "regresidence"}));
                    }
                }
                PositionMemberInfo positionMemberInfo = new PositionMemberInfo();
                positionMemberInfo.setPerson(personInfo);
                positionMemberInfo.setIsPrimary(true);
                positionMemberInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                if (resumeBaseInfo.getPosition() == null) {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("resumeBase", (Object)resumeBaseInfo.getId().toString(), CompareType.EQUALS));
                    viewInfo.setFilter(filter);
                    viewInfo.getSelector().add(new SelectorItemInfo("hirePosition.*"));
                    IHireApplyBillEntry hireapplyEntry = HireApplyBillEntryFactory.getLocalInstance(ctx);
                    HireApplyBillEntryCollection hireApplyEntryColl = hireapplyEntry.getHireApplyBillEntryCollection(viewInfo);
                    if (hireApplyEntryColl.size() > 0) {
                        positionMemberInfo.setPosition(hireApplyEntryColl.get(0).getHirePosition());
                        positionMemberInfo.setHrOrgUnit(hireApplyEntryColl.get(0).getHirePosition().getHrOrgUnit());
                    }
                } else {
                    positionMemberInfo.setPosition(resumeBaseInfo.getPosition());
                    positionMemberInfo.setHrOrgUnit(resumeBaseInfo.getPosition().getHrOrgUnit());
                }
                positionMemberInfo.setBeginDate(null);
                positionMemberInfo.setEndDate(null);
                positionMember.addnew((CoreBaseInfo)positionMemberInfo);
                this.changeReusmePersonState(ctx, resumeBaseInfo, PersonStateEnum.entryed);
                this.setRequireAppBillState(ctx, resumeBaseInfo);
                resumeBaseInfo.setPersonID(personInfo.getId().toString());
                ResumeBaseFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)resumeBaseInfo, RecServerUtils.getSic(new String[]{"personID"}));
            }
        }
    }

    protected IObjectValue _getProposer(Context ctx) throws BOSException, EASBizException {
        IPerson person = PersonFactory.getLocalInstance((Context)ctx);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PersonInfo proposerInfo = userInfo.getPerson();
        if (proposerInfo != null) {
            proposerInfo = person.getPersonInfo((IObjectPK)new ObjectUuidPK(proposerInfo.getId().toString()));
        }
        return proposerInfo;
    }

    protected List _getEnrollBillEntrys(Context ctx, List resumeIds) throws BOSException, EASBizException {
        ArrayList<EnrollBillEntryInfo> list = new ArrayList<EnrollBillEntryInfo>();
        if (resumeIds != null && resumeIds.size() > 0) {
            IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String orgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
            PersonInfo personInfo = new PersonInfo();
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection selector = evi.getSelector();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("certificate.id"));
            selector.add(new SelectorItemInfo("position.id"));
            selector.add(new SelectorItemInfo("position.name"));
            selector.add(new SelectorItemInfo("position.adminOrgUnit.name"));
            selector.add(new SelectorItemInfo("adminOrgUnit.id"));
            selector.add(new SelectorItemInfo("folk.id"));
            selector.add(new SelectorItemInfo("politicalFace.id"));
            selector.add(new SelectorItemInfo("highestDiploma.id"));
            selector.add(new SelectorItemInfo("outPosition.id"));
            selector.add(new SelectorItemInfo("outPosition.name"));
            selector.add(new SelectorItemInfo("xinDian.id"));
            selector.add(new SelectorItemInfo("xinDian.name"));
            selector.add(new SelectorItemInfo("xinDian.parent.id"));
            selector.add(new SelectorItemInfo("xinDian.parent.name"));
            selector.add(new SelectorItemInfo("position.PositionType.id"));
            selector.add(new SelectorItemInfo("position.PositionType.name"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", new HashSet(resumeIds), CompareType.INCLUDE));
            evi.setFilter(fi);
            ResumeBaseCollection rbc = resumeBase.getResumeBaseCollection(evi);
            IEducationExp educationExp = EducationExpFactory.getLocalInstance(ctx);
            int j = rbc.size();
            for (int i = 0; i < j; ++i) {
                ResumeBaseInfo resumeBaseInfo = rbc.get(i);
                EnrollBillEntryInfo enrollBillEntryInfo = new EnrollBillEntryInfo();
                enrollBillEntryInfo.setName(resumeBaseInfo.getName());
                enrollBillEntryInfo.setPersonName(resumeBaseInfo.getName());
                enrollBillEntryInfo.setNumber(resumeBaseInfo.getNumber());
                enrollBillEntryInfo.setGender(resumeBaseInfo.getGender());
                enrollBillEntryInfo.setIdCardNumber(resumeBaseInfo.getIdCardNO());
                enrollBillEntryInfo.setPassportNumber(resumeBaseInfo.getPassportNO());
                enrollBillEntryInfo.setDiploma(resumeBaseInfo.getHighestDiploma());
                enrollBillEntryInfo.setSeq(i);
                enrollBillEntryInfo.setEnrollDate(new Date(System.currentTimeMillis()));
                enrollBillEntryInfo.setPosition(resumeBaseInfo.getPosition());
                if (resumeBaseInfo.getAdminOrgUnit() != null) {
                    enrollBillEntryInfo.setDept(resumeBaseInfo.getAdminOrgUnit().getName());
                } else if (resumeBaseInfo.getPosition() != null) {
                    enrollBillEntryInfo.setDept(resumeBaseInfo.getPosition().getAdminOrgUnit().getName());
                }
                enrollBillEntryInfo.setResumeId(resumeIds.get(i).toString());
                enrollBillEntryInfo.setBirthday(resumeBaseInfo.getBirthday());
                enrollBillEntryInfo.setFolk(resumeBaseInfo.getFolk());
                enrollBillEntryInfo.setPoliticalFace(resumeBaseInfo.getPoliticalFace());
                enrollBillEntryInfo.setHomePhone(resumeBaseInfo.getHomePhone());
                enrollBillEntryInfo.setCell(resumeBaseInfo.getCell());
                enrollBillEntryInfo.setHomeAddress(resumeBaseInfo.getAddressTX());
                enrollBillEntryInfo.setWorkAspect(resumeBaseInfo.getWorkAspect());
                enrollBillEntryInfo.setOutPosition(resumeBaseInfo.getOutPosition());
                enrollBillEntryInfo.setRemark(resumeBaseInfo.getRemark());
                if (resumeBaseInfo.getPosition() != null && resumeBaseInfo.getPosition().getPositionType() != null) {
                    enrollBillEntryInfo.setPositionType(resumeBaseInfo.getPosition().getPositionType());
                }
                if (resumeBaseInfo.getXinDian() != null) {
                    enrollBillEntryInfo.setXinDian(resumeBaseInfo.getXinDian());
                }
                if (codingRuleManager.isExist((IObjectValue)personInfo, orgUnitId)) {
                    String number = codingRuleManager.getNumber((IObjectValue)personInfo, orgUnitId);
                    enrollBillEntryInfo.setNumber(number);
                } else {
                    fi = new FilterInfo();
                    fi.getFilterItems().add(new FilterItemInfo("number", (Object)resumeBaseInfo.getNumber()));
                    if (PersonFactory.getLocalInstance((Context)ctx).exists(fi)) {
                        enrollBillEntryInfo.setNumber(this.getNumber());
                    } else {
                        enrollBillEntryInfo.setNumber(resumeBaseInfo.getNumber());
                    }
                }
                evi = new EntityViewInfo();
                fi = new FilterInfo();
                FilterItemCollection fic = fi.getFilterItems();
                fic.add(new FilterItemInfo("resumeBase", (Object)resumeBaseInfo.getId().toString()));
                fic.add(new FilterItemInfo("highDegree", (Object)Boolean.TRUE));
                SelectorItemCollection sic = evi.getSelector();
                sic.add(new SelectorItemInfo("specialty"));
                sic.add(new SelectorItemInfo("school"));
                sic.add(new SelectorItemInfo("diploma.id"));
                sic.add(new SelectorItemInfo("diploma.name"));
                sic.add(new SelectorItemInfo("degree.id"));
                sic.add(new SelectorItemInfo("degree.name"));
                evi.setFilter(fi);
                EducationExpCollection ec = educationExp.getEducationExpCollection(evi);
                if (ec.size() > 0) {
                    EducationExpInfo ecInfo = ec.get(0);
                    enrollBillEntryInfo.setDiploma(ecInfo.getDiploma());
                    enrollBillEntryInfo.setDegree(ecInfo.getDegree());
                    enrollBillEntryInfo.setSpecialty(ecInfo.getSpecialty());
                    enrollBillEntryInfo.setGraduateSchool(ecInfo.getSchool());
                }
                list.add(enrollBillEntryInfo);
            }
        }
        return list;
    }

    private void fillPersonDetailData(Context ctx, PersonInfo personInfo, ResumeBaseInfo resumeBaseInfo) throws BOSException, EASBizException {
        RegpermresidenceInfo reg;
        ResumeBaseExtendInfo rex;
        boolean flag;
        String str;
        PersonContactMethodInfo pcmInfo;
        FamilyRelationCollection frColl;
        CertificateCollection cfc;
        EducationExpCollection eec;
        WorkExpCollection wec;
        if (personInfo == null || resumeBaseInfo == null) {
            return;
        }
        IPerson person = PersonFactory.getLocalInstance((Context)ctx);
        IPersonPhoto personPhoto = PersonPhotoFactory.getLocalInstance((Context)ctx);
        IPersonWorkExp personWorkExp = PersonWorkExpFactory.getLocalInstance((Context)ctx);
        IPersonDegree personDegree = PersonDegreeFactory.getLocalInstance((Context)ctx);
        IPersonCertification personCertification = PersonCertificationFactory.getLocalInstance((Context)ctx);
        IPersonContactMethod personContactMethod = PersonContactMethodFactory.getLocalInstance((Context)ctx);
        EmployeeTypeInfo empTypeInfo = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT empEntry.FEmpTypeID FROM T_HR_EmpEnrollBizBillEntry empEntry ");
        sb.append(" INNER JOIN T_HR_ResumeBase rec  ON  empEntry.FresumeID = rec.FID ");
        sb.append(" WHERE rec.FID = '");
        sb.append(resumeBaseInfo.getId());
        sb.append("' ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    empTypeInfo = new EmployeeTypeInfo();
                    empTypeInfo.setId(BOSUuid.read((String)rowSet.getString(1)));
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (AffairBizCheckFacadeFactory.getLocalInstance((Context)ctx).isUpgradeToBiz()) {
            EmployeeTypeInfo etInfo;
            if (empTypeInfo != null) {
                personInfo.setEmployeeType(empTypeInfo);
            } else {
                etInfo = this.findEmployeeTypeByID(ctx, "00000000-0000-0000-0000-000000000001A29E85B3");
                personInfo.setEmployeeType(etInfo);
            }
            if (empTypeInfo != null) {
                personInfo.setEmployeeType(empTypeInfo);
            } else {
                etInfo = this.findEmployeeTypeByID(ctx, "00000000-0000-0000-0000-000000000001A29E85B3");
                personInfo.setEmployeeType(etInfo);
            }
            if (empTypeInfo != null) {
                personInfo.setEmployeeType(empTypeInfo);
            } else {
                etInfo = this.findEmployeeTypeByID(ctx, "00000000-0000-0000-0000-000000000001A29E85B3");
                personInfo.setEmployeeType(etInfo);
            }
            personInfo.setEmail(resumeBaseInfo.getEmail());
            personInfo.setHeight(resumeBaseInfo.getHeight());
            personInfo.setNativePlace(resumeBaseInfo.getNativePlace());
            personInfo.setHomePhone(resumeBaseInfo.getHomePhone());
            personInfo.setWed(resumeBaseInfo.getWed());
            personInfo.setPoliticalFace(resumeBaseInfo.getPoliticalFace());
            personInfo.setAddressTX(resumeBaseInfo.getContactAddress());
            personInfo.setHrOrgUnit(resumeBaseInfo.getHrOrgUnit());
            personInfo.setOldName(resumeBaseInfo.getOldName());
            personInfo.setFolk(resumeBaseInfo.getFolk());
            personInfo.setHighestDegree(resumeBaseInfo.getHighestDiploma());
            personInfo.setHealth(resumeBaseInfo.getHealth());
            personInfo.setCell(resumeBaseInfo.getCell());
            personInfo.setBloodType(resumeBaseInfo.getBloodType());
            personInfo.setStanding(resumeBaseInfo.getStanding());
            if (person.exists((IObjectPK)new ObjectUuidPK(personInfo.getId()))) {
                person.updatePartial((CoreBaseInfo)personInfo, RecServerUtils.getSic(new String[]{"email", "height", "nativePlace", "homePhone", "wed", "politicalFace", "addressTX", "hrOrgUnit", "oldName", "folk", "highestDegree", "health", "cell", "bloodType", "standing", "employeeType"}));
            } else {
                person.addnew((CoreBaseInfo)personInfo);
            }
        }
        if (resumeBaseInfo.getPhoto() != null) {
            PersonPhotoInfo personPhotoInfo = new PersonPhotoInfo();
            personPhotoInfo.setPerson(personInfo);
            personPhotoInfo.setImageData(resumeBaseInfo.getPhoto().getImageData());
            personPhoto.addnew((CoreBaseInfo)personPhotoInfo);
        }
        if ((wec = resumeBaseInfo.getWorkExp()) != null && wec.size() > 0) {
            for (int j = 0; j < wec.size(); ++j) {
                WorkExpInfo workExpInfo = wec.get(j);
                PersonWorkExpInfo personWorkExpInfo = new PersonWorkExpInfo();
                personWorkExpInfo.setBeginDate(workExpInfo.getStartDate());
                personWorkExpInfo.setEndDate(workExpInfo.getEndDate());
                personWorkExpInfo.setUnitName(workExpInfo.getOrgan());
                personWorkExpInfo.setPersonQuantity(workExpInfo.getOrganPerson());
                personWorkExpInfo.setUnitAddress(workExpInfo.getOrganAddress());
                personWorkExpInfo.setWorkDept(workExpInfo.getOrganDepartment());
                personWorkExpInfo.setPosition(workExpInfo.getPosition());
                personWorkExpInfo.setSubordinateQuantity(workExpInfo.getUnderNum());
                personWorkExpInfo.setSalary(workExpInfo.getSalary());
                personWorkExpInfo.setDimission(workExpInfo.getDimissionReson());
                personWorkExpInfo.setLinkman(workExpInfo.getLinkman());
                personWorkExpInfo.setLinkmanPhone(workExpInfo.getLinkmanPhone());
                personWorkExpInfo.setRemark(workExpInfo.getRemark());
                personWorkExpInfo.setIndustryType(workExpInfo.getIndustryType());
                personWorkExpInfo.setPerson(personInfo);
                personWorkExp.addnew((CoreBaseInfo)personWorkExpInfo);
            }
        }
        if ((eec = resumeBaseInfo.getEducationExp()) != null && eec.size() > 0) {
            PersonDegreeInfo personDegreeInfo;
            EducationExpInfo educationExpInfo;
            boolean haveHighDegree = false;
            for (int i = 0; i < eec.size(); ++i) {
                educationExpInfo = eec.get(i);
                if (!educationExpInfo.isHighDegree()) continue;
                haveHighDegree = true;
                personDegreeInfo = new PersonDegreeInfo();
                personDegreeInfo.setDiploma(educationExpInfo.getDiploma());
                personDegreeInfo.setDegree(educationExpInfo.getDegree());
                personDegreeInfo.setEnrollDate(educationExpInfo.getStartDate());
                personDegreeInfo.setGraduateDate(educationExpInfo.getEndDate());
                personDegreeInfo.setGraduateSchool(educationExpInfo.getSchool());
                personDegreeInfo.setSpecialty(educationExpInfo.getSpecialty());
                personDegreeInfo.setSpecialtyType(educationExpInfo.getSpecialtyType());
                personDegreeInfo.setStudyPattern(educationExpInfo.getPattern());
                personDegreeInfo.setStudyLength(educationExpInfo.getLength());
                personDegreeInfo.setDegreeUnit(educationExpInfo.getDegreeUnit());
                personDegreeInfo.setDegreeDate(educationExpInfo.getDegreeDate());
                personDegreeInfo.setDegreeNumber(educationExpInfo.getDegreeNumber());
                personDegreeInfo.setIsHighest(educationExpInfo.isHighDegree());
                personDegreeInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                personDegreeInfo.setPerson(personInfo);
                if (!this.isDegreeDup(ctx, personDegreeInfo)) {
                    personDegree.addnew((CoreBaseInfo)personDegreeInfo);
                }
                eec.remove(educationExpInfo);
                break;
            }
            for (int j = 0; j < eec.size(); ++j) {
                educationExpInfo = eec.get(j);
                personDegreeInfo = new PersonDegreeInfo();
                personDegreeInfo.setDiploma(educationExpInfo.getDiploma());
                personDegreeInfo.setDegree(educationExpInfo.getDegree());
                personDegreeInfo.setEnrollDate(educationExpInfo.getStartDate());
                personDegreeInfo.setGraduateDate(educationExpInfo.getEndDate());
                personDegreeInfo.setGraduateSchool(educationExpInfo.getSchool());
                personDegreeInfo.setSpecialty(educationExpInfo.getSpecialty());
                personDegreeInfo.setSpecialtyType(educationExpInfo.getSpecialtyType());
                personDegreeInfo.setStudyPattern(educationExpInfo.getPattern());
                personDegreeInfo.setStudyLength(educationExpInfo.getLength());
                personDegreeInfo.setDegreeUnit(educationExpInfo.getDegreeUnit());
                personDegreeInfo.setDegreeDate(educationExpInfo.getDegreeDate());
                personDegreeInfo.setDegreeNumber(educationExpInfo.getDegreeNumber());
                personDegreeInfo.setIsHighest(educationExpInfo.isHighDegree());
                personDegreeInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                personDegreeInfo.setPerson(personInfo);
                if (!haveHighDegree && j == 0) {
                    personDegreeInfo.setIsHighest(true);
                }
                if (this.isDegreeDup(ctx, personDegreeInfo)) continue;
                personDegree.addnew((CoreBaseInfo)personDegreeInfo);
            }
        }
        if ((cfc = resumeBaseInfo.getCertificate()) != null && cfc.size() > 0) {
            for (int j = 0; j < cfc.size(); ++j) {
                CertificateInfo cfInfo = cfc.get(j);
                PersonCertificationInfo pcfInfo = new PersonCertificationInfo();
                if (cfInfo.getCerNumber() != null) {
                    pcfInfo.setCertificateNumber(cfInfo.getCerNumber());
                } else {
                    pcfInfo.setCertificateNumber("   ");
                }
                if (cfInfo.getName() != null) {
                    pcfInfo.setCertificateName(cfInfo.getName());
                } else {
                    pcfInfo.setCertificateName("  ");
                }
                pcfInfo.setCertifyDate(cfInfo.getCertifyDate());
                pcfInfo.setOrgan(cfInfo.getOrgan());
                pcfInfo.setPerson(personInfo);
                pcfInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                pcfInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                personCertification.addnew((CoreBaseInfo)pcfInfo);
            }
        }
        if ((frColl = resumeBaseInfo.getFamilyRelation()) != null && frColl.size() > 0) {
            IPersonFamily personFamily = PersonFamilyFactory.getLocalInstance((Context)ctx);
            int n = frColl.size();
            for (int m = 0; m < n; ++m) {
                FamilyRelationInfo frInfo = frColl.get(m);
                PersonFamilyInfo pfInfo = new PersonFamilyInfo();
                pfInfo.setName(frInfo.getName());
                pfInfo.setBirthday(frInfo.getBirthDate());
                pfInfo.setWorkUnit(frInfo.getOrgan());
                pfInfo.setPoliticalFace(frInfo.getPoliticalFace());
                pfInfo.setHomeAddress(frInfo.getAddress());
                pfInfo.setHomePhone(frInfo.getPhone());
                pfInfo.setPerson(personInfo);
                personFamily.addnew((CoreBaseInfo)pfInfo);
            }
        }
        if (!personContactMethod.exists(" WHERE person.id ='" + personInfo.getId() + "'")) {
            pcmInfo = new PersonContactMethodInfo();
            str = resumeBaseInfo.getEmail();
            flag = false;
            if (str != null) {
                pcmInfo.setEmail(str);
                flag = true;
            }
            if ((str = resumeBaseInfo.getHomePhone()) != null) {
                pcmInfo.setHomePhone(str);
                flag = true;
            }
            if ((str = resumeBaseInfo.getPostalCode()) != null) {
                pcmInfo.setPostalcode(str);
                flag = true;
            }
            if ((str = resumeBaseInfo.getCell()) != null) {
                pcmInfo.setMobile(str);
                flag = true;
            }
            if ((str = resumeBaseInfo.getContactAddress()) != null) {
                pcmInfo.setAddressTX(str);
                pcmInfo.setHomeAddress(str);
                flag = true;
            }
            if ((str = resumeBaseInfo.getAddressTX()) != null) {
                pcmInfo.setIdCardAddress(str);
                flag = true;
            }
            rex = resumeBaseInfo.getResumeBaseExtend();
            reg = null;
            if (rex != null) {
                reg = rex.getRegpermresidence();
            }
            if (reg != null) {
                pcmInfo.setRegresidence(reg);
            }
            if (flag) {
                pcmInfo.setPerson(personInfo);
                personContactMethod.addnew((CoreBaseInfo)pcmInfo);
            }
        } else {
            pcmInfo = personContactMethod.getPersonContactMethodInfo(" WHERE person.id ='" + personInfo.getId() + "'");
            str = resumeBaseInfo.getEmail();
            flag = false;
            if (str != null) {
                pcmInfo.setEmail(str);
                flag = true;
            }
            if ((str = resumeBaseInfo.getHomePhone()) != null) {
                pcmInfo.setHomePhone(str);
                flag = true;
            }
            if ((str = resumeBaseInfo.getPostalCode()) != null) {
                pcmInfo.setPostalcode(str);
                flag = true;
            }
            if ((str = resumeBaseInfo.getCell()) != null) {
                pcmInfo.setMobile(str);
                flag = true;
            }
            if ((str = resumeBaseInfo.getContactAddress()) != null) {
                pcmInfo.setAddressTX(str);
                pcmInfo.setHomeAddress(str);
                flag = true;
            }
            if ((str = resumeBaseInfo.getAddressTX()) != null) {
                pcmInfo.setIdCardAddress(str);
                flag = true;
            }
            if ((str = resumeBaseInfo.getQqOrmsn()) != null) {
                pcmInfo.setQQ(str);
                flag = true;
            }
            rex = resumeBaseInfo.getResumeBaseExtend();
            reg = null;
            if (rex != null) {
                reg = rex.getRegpermresidence();
            }
            if (reg != null) {
                pcmInfo.setRegresidence(reg);
            }
            if (flag) {
                pcmInfo.setPerson(personInfo);
                personContactMethod.updatePartial((CoreBaseInfo)pcmInfo, RecServerUtils.getSic(new String[]{"email", "homePhone", "postalcode", "mobile", "addressTX", "homeAddress", "idCardAddress", "QQ", "regresidence"}));
            }
        }
        resumeBaseInfo.setPersonID(personInfo.getId().toString());
        ResumeBaseFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)resumeBaseInfo, RecServerUtils.getSic(new String[]{"personID"}));
    }

    private boolean isDegreeDup(Context ctx, PersonDegreeInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("degree.id", (Object)(info.getDegree() != null ? info.getDegree().getId() : null), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("diploma.id", (Object)(info.getDiploma() != null ? info.getDiploma().getId() : null), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("degreeCountry.id", (Object)(info.getDegreeCountry() != null ? info.getDegreeCountry().getId() : null), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)info.getPerson().getId(), CompareType.EQUALS));
        int maskNum = 4;
        StringBuffer maskStr = new StringBuffer();
        String degreeUnit = info.getDegreeUnit();
        String specialty = info.getSpecialty();
        if (StringUtils.isEmpty((String)degreeUnit)) {
            filter.getFilterItems().add(new FilterItemInfo("degreeUnit", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("degreeUnit", (Object)"", CompareType.EQUALS));
            maskStr.append(" and (#" + maskNum + " or #" + (maskNum + 1) + ")");
            maskNum += 2;
        } else {
            filter.getFilterItems().add(new FilterItemInfo("degreeUnit", (Object)degreeUnit, CompareType.EQUALS));
            maskStr.append(" and #" + maskNum);
            ++maskNum;
        }
        if (StringUtils.isEmpty((String)specialty)) {
            filter.getFilterItems().add(new FilterItemInfo("specialty", null, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("specialty", (Object)"", CompareType.EQUALS));
            maskStr.append(" and (#" + maskNum + " or #" + (maskNum + 1) + ")");
            maskNum += 2;
        } else {
            filter.getFilterItems().add(new FilterItemInfo("specialty", (Object)specialty, CompareType.EQUALS));
            maskStr.append(" and #" + maskNum);
            ++maskNum;
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
            maskStr.append(" and #" + maskNum);
            ++maskNum;
        }
        filter.setMaskString("#0 and #1 and #2 and #3 " + maskStr.toString());
        return PersonDegreeFactory.getLocalInstance((Context)ctx).exists(filter);
    }

    private EmployeeTypeInfo findEmployeeTypeByName(Context ctx, String name) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + name + "%"), CompareType.LIKE));
        evi.setFilter(fi);
        IEmployeeType et = EmployeeTypeFactory.getLocalInstance((Context)ctx);
        EmployeeTypeCollection etc = et.getEmployeeTypeCollection(evi);
        if (etc != null && etc.size() > 0) {
            return etc.get(0);
        }
        return null;
    }

    private EmployeeTypeInfo findEmployeeTypeByID(Context ctx, String id) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        evi.setFilter(filter);
        IEmployeeType et = EmployeeTypeFactory.getLocalInstance((Context)ctx);
        EmployeeTypeCollection etc = et.getEmployeeTypeCollection(evi);
        if (etc != null && etc.size() > 0) {
            return etc.get(0);
        }
        return null;
    }

    public String _checkIdCardNO(Context ctx, List resumeIds) throws BOSException, EASBizException {
        String locale = RecServerUtils.getLocalString(ctx);
        StringBuffer sqlBuff = new StringBuffer("select fname_");
        sqlBuff.append(locale);
        sqlBuff.append(" as name,FIdCardNO as cardNO from T_HR_RESUMEBASE where FID in ( ");
        StringBuffer errorData = new StringBuffer();
        int size = resumeIds.size();
        int j = size - 1;
        for (int i = 0; i < size; ++i) {
            sqlBuff.append("'");
            sqlBuff.append(resumeIds.get(i));
            sqlBuff.append("'");
            if (i >= j) continue;
            sqlBuff.append(",");
        }
        sqlBuff.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString());
        String res = "com.kingdee.eas.hr.rec.ResumeResource";
        ArrayList<String> nameCardNullList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String name = rowSet.getString("name");
                String cardNo = rowSet.getString("cardNO");
                if (cardNo == null || cardNo.trim().length() == 0) {
                    nameCardNullList.add(name);
                    continue;
                }
                String sql = " select FID from T_BD_Person where FIDCardNO = '" + cardNo + "'";
                IRowSet rowSet2 = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (!rowSet2.next()) continue;
                errorData.append(" ").append(name).append(ResourceBase.getString((String)res, (String)"cardNo_has_exist", (Locale)ctx.getLocale()));
            }
            if (nameCardNullList.size() > 0) {
                if (nameCardNullList.size() == 1) {
                    errorData.append(" ");
                    errorData.append(nameCardNullList.get(0)).append(ResourceBase.getString((String)res, (String)"not_exist_IdCardNo", (Locale)ctx.getLocale()));
                } else {
                    for (int i = 0; i < nameCardNullList.size(); ++i) {
                        errorData.append(" ");
                        errorData.append(nameCardNullList.get(i));
                    }
                    errorData.append(ResourceBase.getString((String)res, (String)"not_exist_IdCardNo", (Locale)ctx.getLocale()));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (errorData.length() > 0) {
            return errorData.toString();
        }
        return "true";
    }

    protected void _cancelEntry(Context ctx, List resumeIds) throws BOSException, EASBizException {
        if (resumeIds == null || resumeIds.size() <= 0) {
            return;
        }
        IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = RecServerUtils.getSic(new String[]{"resumeState", "interviewActivity"});
        int j = resumeIds.size();
        for (int i = 0; i < j; ++i) {
            ResumeBaseInfo info = resumeBase.getResumeBaseInfo((IObjectPK)new ObjectUuidPK(resumeIds.get(i).toString()));
            if (!info.getResumeState().equals((Object)ResumeStateEnum.pass)) continue;
            info.setResumeState(ResumeStateEnum.no_dispose);
            info.setInterviewActivity(null);
            resumeBase.updatePartial((CoreBaseInfo)info, sic);
        }
    }

    private void changeReusmePersonState(Context ctx, ResumeBaseInfo resumeBaseInfo, PersonStateEnum state) throws BOSException, EASBizException {
        IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        resumeBaseInfo.setPersonState(state);
        if (state.equals((Object)PersonStateEnum.entryed)) {
            resumeBaseInfo.setResumeState(ResumeStateEnum.entryed);
        } else if (state.equals((Object)PersonStateEnum.confirm)) {
            resumeBaseInfo.setResumeState(ResumeStateEnum.entrying);
        } else if (state.equals((Object)PersonStateEnum.confirm_false)) {
            resumeBaseInfo.setResumeState(ResumeStateEnum.entry_noPass);
        } else if (state.equals((Object)PersonStateEnum.noEntry)) {
            resumeBaseInfo.setResumeState(ResumeStateEnum.pass);
        }
        SelectorItemCollection sic = RecServerUtils.getSic(new String[]{"personState", "resumeState"});
        resumeBase.updatePartial((CoreBaseInfo)resumeBaseInfo, sic);
    }

    private SelectorItemCollection getResumeBaseSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("photo.*"));
        sic.add(new SelectorItemInfo("educationExp.*"));
        sic.add(new SelectorItemInfo("workExp.*"));
        sic.add(new SelectorItemInfo("certificate.*"));
        sic.add(new SelectorItemInfo("position.*"));
        sic.add(new SelectorItemInfo("adminOrgUnit.*"));
        sic.add(new SelectorItemInfo("folk.*"));
        sic.add(new SelectorItemInfo("politicalFace.*"));
        sic.add(new SelectorItemInfo("familyRelation.*"));
        sic.add(new SelectorItemInfo("wed.id"));
        sic.add(new SelectorItemInfo("health.id"));
        sic.add(new SelectorItemInfo("resumeBaseExtend.regpermresidence.id"));
        sic.add(new SelectorItemInfo("outPosition.id"));
        sic.add(new SelectorItemInfo("outPosition.name"));
        sic.add(new SelectorItemInfo("xinDian.id"));
        sic.add(new SelectorItemInfo("xinDian.name"));
        sic.add(new SelectorItemInfo("xinDian.parent.id"));
        sic.add(new SelectorItemInfo("xinDian.parent.name"));
        sic.add(new SelectorItemInfo("position.PositionType.id"));
        sic.add(new SelectorItemInfo("position.PositionType.name"));
        return sic;
    }

    private String getNumber() {
        StringBuffer sb = new StringBuffer();
        Date date = new Date();
        sb.append(String.valueOf(DateTimeUtils.getYear((Date)date))).append("-").append(String.valueOf(DateTimeUtils.getMonth((Date)date))).append("-").append(String.valueOf(DateTimeUtils.getDay((Date)date)));
        Random r = new Random();
        sb.append(date.getTime() + (long)r.nextInt() + (long)r.nextInt());
        return sb.toString();
    }
}

