/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.util.MailUtil;
import com.kingdee.eas.hr.rec.ActivityRelationResumeCollection;
import com.kingdee.eas.hr.rec.ActivityRelationResumeFactory;
import com.kingdee.eas.hr.rec.ActivityRelationResumeInfo;
import com.kingdee.eas.hr.rec.BlacklistExtendFactory;
import com.kingdee.eas.hr.rec.BlacklistExtendInfo;
import com.kingdee.eas.hr.rec.IActivityRelationResume;
import com.kingdee.eas.hr.rec.IBlacklistExtend;
import com.kingdee.eas.hr.rec.IInterview;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.IResumeExtend;
import com.kingdee.eas.hr.rec.ITalentExtend;
import com.kingdee.eas.hr.rec.InterviewActivityInfo;
import com.kingdee.eas.hr.rec.InterviewCollection;
import com.kingdee.eas.hr.rec.InterviewFactory;
import com.kingdee.eas.hr.rec.InterviewInfo;
import com.kingdee.eas.hr.rec.OutPositionInfo;
import com.kingdee.eas.hr.rec.PersonStateEnum;
import com.kingdee.eas.hr.rec.RecCommonException;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeExtendException;
import com.kingdee.eas.hr.rec.ResumeExtendFactory;
import com.kingdee.eas.hr.rec.ResumeExtendInfo;
import com.kingdee.eas.hr.rec.ResumeStateEnum;
import com.kingdee.eas.hr.rec.TalentCategoryInfo;
import com.kingdee.eas.hr.rec.TalentExtendFactory;
import com.kingdee.eas.hr.rec.TalentExtendInfo;
import com.kingdee.eas.hr.rec.app.AbstractResumeExtendControllerBean;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ResumeExtendControllerBean
extends AbstractResumeExtendControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.ResumeExtendControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ResumeExtendInfo resumeExtendInfo = (ResumeExtendInfo)model;
        resumeExtendInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        IObjectPK pk = super._addnew(ctx, (IObjectValue)resumeExtendInfo);
        return pk;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ResumeExtendInfo resumeExtendInfo = (ResumeExtendInfo)model;
        resumeExtendInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        super._addnew(ctx, pk, (IObjectValue)resumeExtendInfo);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.preSubmit(ctx, model);
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.preSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ResumeExtendInfo info = this.getResumeExtendInfo(ctx, pk, RecServerUtils.getSic(new String[]{"*", "resumeBase.id"}));
        String resumeBasePK = info.getResumeBase().getId().toString();
        super._delete(ctx, pk);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("resumeBase.id", (Object)resumeBasePK));
        ActivityRelationResumeFactory.getLocalInstance(ctx).delete(fi);
        ResumeBaseFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(resumeBasePK));
    }

    private void preSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ResumeExtendInfo resumeExtendInfo = (ResumeExtendInfo)model;
        ResumeBaseInfo resumeBaseInfo = resumeExtendInfo.getResumeBase();
        if (resumeBaseInfo == null) {
            throw new BOSException("resumeBaseInfo save error");
        }
        if (resumeBaseInfo.getId() == null) {
            IObjectPK resumeBaseId = ResumeBaseFactory.getLocalInstance(ctx).submit((CoreBaseInfo)resumeBaseInfo);
            resumeBaseInfo.setId(BOSUuid.read((String)resumeBaseId.toString()));
        }
    }

    protected void _putToTalent(Context ctx, List resumeBaseIds, BOSUuid talentCategoryId) throws BOSException, EASBizException {
        if (resumeBaseIds == null || resumeBaseIds.size() <= 0 || talentCategoryId == null) {
            return;
        }
        IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        ITalentExtend talentExtend = TalentExtendFactory.getLocalInstance(ctx);
        TalentCategoryInfo talentCategoryInfo = new TalentCategoryInfo();
        talentCategoryInfo.setId(BOSUuid.read((String)talentCategoryId.toString()));
        StringBuffer ids = new StringBuffer();
        int lenght = resumeBaseIds.size();
        for (int i = 0; i < lenght; ++i) {
            String resumeBaseId = resumeBaseIds.get(i).toString();
            ResumeBaseInfo resumeBaseInfo = resumeBase.getResumeBaseInfo((IObjectPK)new ObjectUuidPK(resumeBaseId));
            if (ResumeStateEnum.entryed.equals((Object)resumeBaseInfo.getResumeState()) || ResumeStateEnum.entrying.equals((Object)resumeBaseInfo.getResumeState())) {
                throw new RecCommonException(RecCommonException.TALENT_CONFIRM_RESUME);
            }
            if (resumeBaseInfo.getPersonState() != null && !PersonStateEnum.noEntry.equals((Object)resumeBaseInfo.getPersonState()) && !PersonStateEnum.confirm_false.equals((Object)resumeBaseInfo.getPersonState())) {
                throw new RecCommonException(RecCommonException.TALENT_CONFIRM_RESUME);
            }
            resumeBaseInfo.setResumeState(ResumeStateEnum.pass_in_talent);
            resumeBaseInfo.setInterviewActivity(null);
            resumeBaseInfo.setPersonState(PersonStateEnum.noEntry);
            resumeBase.updatePartial((CoreBaseInfo)resumeBaseInfo, RecServerUtils.getSic(new String[]{"resumeState", "personState", "interviewActivity"}));
            TalentExtendInfo talentExtendInfo = new TalentExtendInfo();
            talentExtendInfo.setCategory(talentCategoryInfo);
            talentExtendInfo.setResumeBase(resumeBaseInfo);
            talentExtendInfo.setEntryDate(new Date(System.currentTimeMillis()));
            talentExtendInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            talentExtendInfo.setHistory(false);
            talentExtend.addnew((CoreBaseInfo)talentExtendInfo);
            this.updateInterviewInfo(ctx, resumeBaseInfo.getId().toString(), false, true);
            if (i != 0) {
                ids.append(",");
            }
            ids.append("'").append(resumeBaseId).append("'");
        }
        String sql = "delete from t_hr_resumeExtend where FResumebaseId in (" + ids.toString() + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void _changeState(Context ctx, List resumeIds, ResumeStateEnum state) throws BOSException, EASBizException {
        IResumeExtend resumeExtend = ResumeExtendFactory.getLocalInstance(ctx);
        IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        ResumeBaseInfo tempResumeBase = null;
        ResumeExtendInfo tempResumeExtend = null;
        Iterator iterator = resumeIds.iterator();
        while (iterator.hasNext()) {
            tempResumeExtend = (ResumeExtendInfo)resumeExtend.getValue((IObjectPK)new ObjectUuidPK(iterator.next().toString()));
            tempResumeBase = tempResumeExtend.getResumeBase();
            tempResumeBase.setResumeState(state);
            resumeBase.update((IObjectPK)new ObjectUuidPK(tempResumeBase.getId()), (CoreBaseInfo)tempResumeBase);
            resumeExtend.update((IObjectPK)new ObjectUuidPK(tempResumeExtend.getId()), (CoreBaseInfo)tempResumeExtend);
        }
    }

    protected void _sendMail(Context ctx, List mailList, String subject, String content) throws BOSException, EASBizException, ResumeExtendException {
        MailUtil mailUtil = MailUtil.getInstance((Context)ctx);
        int length = mailList.size();
        for (int i = 0; i < length; ++i) {
            try {
                mailUtil.sendHtmlMail("from", mailList.get(i).toString(), subject, content);
                continue;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected String _getMailList(Context ctx, List resumeExtendIds) throws BOSException, EASBizException {
        IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        ResumeBaseInfo tempResumeBaseInfo = null;
        StringBuffer mailStr = new StringBuffer();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("email"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", new HashSet(resumeExtendIds), CompareType.INCLUDE));
        evi.setFilter(fi);
        ResumeBaseCollection rbc = resumeBase.getResumeBaseCollection(evi);
        int j = rbc.size() - 1;
        for (int i = 0; i <= j; ++i) {
            tempResumeBaseInfo = rbc.get(i);
            String name = tempResumeBaseInfo.getName();
            String mail = tempResumeBaseInfo.getEmail();
            if (name != null && name.trim().length() > 0) {
                mailStr.append(name).append("(");
            } else {
                mailStr.append(" ").append("(");
            }
            if (mail != null && mail.trim().length() > 0) {
                mailStr.append(mail);
                mailStr.append(")");
            } else {
                mailStr.append(" ").append(")");
            }
            if (i >= j) continue;
            mailStr.append(";");
        }
        return mailStr.toString();
    }

    protected void _setInterview(Context ctx, List selectResumeIds, BOSUuid activityId, BOSUuid positionId, BOSUuid outPositionId) throws BOSException, EASBizException {
        if (selectResumeIds == null || selectResumeIds.size() <= 0) {
            return;
        }
        IResumeExtend resumeExtend = ResumeExtendFactory.getLocalInstance(ctx);
        IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        IPosition position = PositionFactory.getLocalInstance((Context)ctx);
        IInterview interview = InterviewFactory.getLocalInstance(ctx);
        PositionInfo positionInfo = null;
        if (positionId != null && positionId.toString().trim().length() > 0) {
            positionInfo = (PositionInfo)position.getValue((IObjectPK)new ObjectUuidPK(positionId));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("resumeBase.id"));
        sic.add(new SelectorItemInfo("resumeBase.resumeState"));
        sic.add(new SelectorItemInfo("resumeBase.name"));
        InterviewActivityInfo activityInfo = new InterviewActivityInfo();
        activityInfo.setId(activityId);
        long l = System.currentTimeMillis();
        Time interviewTime = new Time(l);
        Timestamp ts = new Timestamp(l);
        EntityViewInfo evi = new EntityViewInfo();
        int length = selectResumeIds.size();
        for (int i = 0; i < length; ++i) {
            ActivityRelationResumeInfo info;
            String tempResumeExtendId = selectResumeIds.get(i).toString();
            ResumeExtendInfo resumeExtendInfo = (ResumeExtendInfo)resumeExtend.getValue((IObjectPK)new ObjectUuidPK(tempResumeExtendId), sic);
            int state = resumeExtendInfo.getResumeBase().getResumeState().getValue();
            if (state != 0 && state != 4) continue;
            ResumeBaseInfo resumeBaseInfo = resumeExtendInfo.getResumeBase();
            resumeBaseInfo = resumeBase.getResumeBaseInfo((IObjectPK)new ObjectUuidPK(resumeBaseInfo.getId().toString()));
            if (positionInfo != null) {
                resumeBaseInfo.setPosition(positionInfo);
                resumeBaseInfo.setAdminOrgUnit(positionInfo.getAdminOrgUnit());
                resumeBaseInfo.setOutPosition(null);
            }
            if (outPositionId != null) {
                OutPositionInfo opsInfo = new OutPositionInfo();
                opsInfo.setId(BOSUuid.read((String)outPositionId.toString()));
                resumeBaseInfo.setOutPosition(opsInfo);
                resumeBaseInfo.setPosition(null);
            }
            resumeBaseInfo.setResumeState(ResumeStateEnum.no_interview);
            resumeBaseInfo.setInterviewTime(ts);
            resumeBaseInfo.setInterviewActivity(activityInfo);
            resumeBase.update((IObjectPK)new ObjectUuidPK(resumeBaseInfo.getId()), (CoreBaseInfo)resumeBaseInfo);
            this.updateInterviewInfo(ctx, resumeBaseInfo.getId().toString(), true, false);
            InterviewInfo interviewInfo = new InterviewInfo();
            interviewInfo.setInterviewActivity(activityInfo);
            interviewInfo.setResumeBase(resumeBaseInfo);
            interviewInfo.setPosition(positionInfo);
            interviewInfo.setInterviewTime(interviewTime);
            interviewInfo.setIsCurrentInterView(true);
            interviewInfo.setShowInReportForm(true);
            interviewInfo.setIsInTalentExtend(false);
            interviewInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            interviewInfo.setResumeHistory(null);
            interview.addnew((CoreBaseInfo)interviewInfo);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("resumeBase.id", (Object)resumeBaseInfo.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("interviewActivity.id", (Object)activityId));
            evi.setFilter(fi);
            IActivityRelationResume relationService = ActivityRelationResumeFactory.getLocalInstance(ctx);
            ActivityRelationResumeCollection coll = relationService.getActivityRelationResumeCollection(evi);
            if (!relationService.exists(fi)) {
                info = new ActivityRelationResumeInfo();
                info.setResumeBase(resumeBaseInfo);
                info.setInterviewActivity(activityInfo);
                info.setPosition(positionInfo);
                relationService.addnew(info);
                continue;
            }
            if (coll == null || coll.size() != 1) continue;
            info = coll.get(0);
            info.setPosition(positionInfo);
            relationService.updatePartial(info, RecServerUtils.getSic(new String[]{"position"}));
        }
    }

    protected void _setToInterview2(Context ctx, String resumeBaseId, String activityId, String positionId) throws BOSException, EASBizException {
        if (resumeBaseId == null || activityId == null) {
            return;
        }
        IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        IPosition position = PositionFactory.getLocalInstance((Context)ctx);
        IInterview interview = InterviewFactory.getLocalInstance(ctx);
        PositionInfo positionInfo = null;
        if (positionId != null) {
            positionInfo = (PositionInfo)position.getValue((IObjectPK)new ObjectUuidPK(positionId));
        }
        ResumeBaseInfo resumeBaseInfo = resumeBase.getResumeBaseInfo((IObjectPK)new ObjectUuidPK(resumeBaseId));
        SelectorItemCollection sic = RecServerUtils.getSic(new String[]{"resumeState", "position", "adminOrgUnit", "interviewTime", "interviewActivity"});
        InterviewActivityInfo activityInfo = new InterviewActivityInfo();
        activityInfo.setId(BOSUuid.read((String)activityId));
        int state = resumeBaseInfo.getResumeState().getValue();
        if (positionInfo != null) {
            resumeBaseInfo.setPosition(positionInfo);
            resumeBaseInfo.setAdminOrgUnit(positionInfo.getAdminOrgUnit());
        } else {
            resumeBaseInfo.setPosition(null);
            resumeBaseInfo.setAdminOrgUnit(null);
        }
        if (state == 0 || state == 5) {
            long l = System.currentTimeMillis();
            Time interviewTime = new Time(l);
            Timestamp ts = new Timestamp(l);
            resumeBaseInfo.setResumeState(ResumeStateEnum.no_interview);
            resumeBaseInfo.setInterviewTime(ts);
            resumeBaseInfo.setInterviewActivity(activityInfo);
            resumeBase.updatePartial((CoreBaseInfo)resumeBaseInfo, sic);
            if (state == 0) {
                this.updateInterviewInfo(ctx, resumeBaseInfo.getId().toString(), true, false);
            } else {
                this.updateInterviewInfo(ctx, resumeBaseInfo.getId().toString(), true, true);
            }
            InterviewInfo interviewInfo = new InterviewInfo();
            interviewInfo.setResumeBase(resumeBaseInfo);
            interviewInfo.setPosition(resumeBaseInfo.getPosition());
            interviewInfo.setInterviewActivity(activityInfo);
            interviewInfo.setInterviewTime(interviewTime);
            interviewInfo.setIsCurrentInterView(true);
            interviewInfo.setShowInReportForm(true);
            interviewInfo.setIsInTalentExtend(false);
            interviewInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            interview.addnew((CoreBaseInfo)interviewInfo);
        } else if (state == 1) {
            long l = System.currentTimeMillis();
            Time interviewTime = new Time(l);
            Timestamp ts = new Timestamp(l);
            resumeBaseInfo.setResumeState(ResumeStateEnum.no_interview);
            resumeBaseInfo.setInterviewTime(ts);
            resumeBaseInfo.setInterviewActivity(activityInfo);
            resumeBase.updatePartial((CoreBaseInfo)resumeBaseInfo, sic);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection fic = filterInfo.getFilterItems();
            fic.add(new FilterItemInfo("resumeBase", (Object)resumeBaseInfo.getId().toString()));
            fic.add(new FilterItemInfo("isCurrentInterView", (Object)Boolean.TRUE));
            evi.setFilter(filterInfo);
            InterviewCollection ic = interview.getInterviewCollection(evi);
            if (ic.size() > 0) {
                InterviewInfo interviewInfo = ic.get(0);
                interviewInfo.setInterviewActivity(activityInfo);
                interviewInfo.setPosition(resumeBaseInfo.getPosition());
                interviewInfo.setInterviewTime(interviewTime);
                interviewInfo.setIsCurrentInterView(true);
                interviewInfo.setShowInReportForm(true);
                interviewInfo.setIsInTalentExtend(false);
                interview.update((IObjectPK)new ObjectUuidPK(interviewInfo.getId().toString()), (CoreBaseInfo)interviewInfo);
            }
        } else if (state == 2) {
            resumeBase.updatePartial((CoreBaseInfo)resumeBaseInfo, sic);
        } else if (state == 4) {
            if (resumeBaseInfo.getInterviewActivity() != null) {
                resumeBaseInfo.setResumeState(ResumeStateEnum.interviewing);
                resumeBaseInfo.setInterviewActivity(activityInfo);
                resumeBase.updatePartial((CoreBaseInfo)resumeBaseInfo, sic);
            } else {
                long l = System.currentTimeMillis();
                Time interviewTime = new Time(l);
                Timestamp ts = new Timestamp(l);
                resumeBaseInfo.setResumeState(ResumeStateEnum.no_interview);
                resumeBaseInfo.setInterviewTime(ts);
                resumeBaseInfo.setInterviewActivity(activityInfo);
                resumeBase.updatePartial((CoreBaseInfo)resumeBaseInfo, sic);
                this.updateInterviewInfo(ctx, resumeBaseInfo.getId().toString(), true, false);
                InterviewInfo interviewInfo = new InterviewInfo();
                interviewInfo.setResumeBase(resumeBaseInfo);
                interviewInfo.setPosition(resumeBaseInfo.getPosition());
                interviewInfo.setInterviewActivity(activityInfo);
                interviewInfo.setInterviewTime(interviewTime);
                interviewInfo.setIsCurrentInterView(true);
                interviewInfo.setShowInReportForm(true);
                interviewInfo.setIsInTalentExtend(false);
                interviewInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                interview.addnew((CoreBaseInfo)interviewInfo);
            }
        } else if (state == 6 || state == 3) {
            resumeBase.updatePartial((CoreBaseInfo)resumeBaseInfo, RecServerUtils.getSic(new String[]{"position", "adminOrgUnit"}));
        }
    }

    private void updateInterviewInfo(Context ctx, String resumeBaseId, boolean isUpdateCurrentInterview, boolean isSetToTalent) throws BOSException, EASBizException {
        IInterview interview = InterviewFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection fic = filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("resumeBase", (Object)resumeBaseId));
        evi.setFilter(filterInfo);
        InterviewCollection ic = interview.getInterviewCollection(evi);
        if (ic != null && ic.size() > 0) {
            for (int i = 0; i < ic.size(); ++i) {
                InterviewInfo interviewInfo = ic.get(i);
                interviewInfo.setIsInTalentExtend(isSetToTalent);
                if (isUpdateCurrentInterview) {
                    interviewInfo.setIsCurrentInterView(false);
                    interviewInfo.setShowInReportForm(false);
                }
                interview.update((IObjectPK)new ObjectUuidPK(interviewInfo.getId().toString()), (CoreBaseInfo)interviewInfo);
            }
        }
    }

    protected void _putToBlacklist(Context ctx, List resumeBaseIds, String entryCourse) throws BOSException, EASBizException {
        if (resumeBaseIds == null || resumeBaseIds.size() <= 0) {
            return;
        }
        IResumeBase resumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        IBlacklistExtend blacklistExtend = BlacklistExtendFactory.getLocalInstance(ctx);
        StringBuffer ids = new StringBuffer();
        int lenght = resumeBaseIds.size();
        for (int i = 0; i < lenght; ++i) {
            String resumeBaseId = resumeBaseIds.get(i).toString();
            ResumeBaseInfo resumeBaseInfo = resumeBase.getResumeBaseInfo((IObjectPK)new ObjectUuidPK(resumeBaseId));
            if (ResumeStateEnum.entryed.equals((Object)resumeBaseInfo.getResumeState()) || ResumeStateEnum.entrying.equals((Object)resumeBaseInfo.getResumeState())) {
                throw new RecCommonException(RecCommonException.BLACKLIST_CONFIRM_RESUME);
            }
            if (resumeBaseInfo.getPersonState() != null && !PersonStateEnum.noEntry.equals((Object)resumeBaseInfo.getPersonState()) && !PersonStateEnum.confirm_false.equals((Object)resumeBaseInfo.getPersonState())) {
                throw new RecCommonException(RecCommonException.BLACKLIST_CONFIRM_RESUME);
            }
            resumeBaseInfo.setResumeState(ResumeStateEnum.blacklist);
            resumeBaseInfo.setInterviewActivity(null);
            resumeBaseInfo.setPersonState(PersonStateEnum.noEntry);
            resumeBase.updatePartial((CoreBaseInfo)resumeBaseInfo, RecServerUtils.getSic(new String[]{"resumeState", "personState", "interviewActivity"}));
            BlacklistExtendInfo blacklistExtendInfo = new BlacklistExtendInfo();
            blacklistExtendInfo.setResumeBase(resumeBaseInfo);
            blacklistExtendInfo.setEntryDate(new Date(System.currentTimeMillis()));
            blacklistExtendInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
            blacklistExtendInfo.setHistory(false);
            blacklistExtendInfo.setEntryCourse(entryCourse);
            blacklistExtendInfo.setIsInsider(false);
            blacklistExtend.addnew((CoreBaseInfo)blacklistExtendInfo);
            this.updateInterviewInfo(ctx, resumeBaseInfo.getId().toString(), false, true);
            if (i != 0) {
                ids.append(",");
            }
            ids.append("'").append(resumeBaseId).append("'");
        }
        String sql = "delete from t_hr_resumeExtend where FResumebaseId in (" + ids.toString() + ")";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("resumeBase.name"));
        ResumeExtendInfo info = (ResumeExtendInfo)this.getValue(ctx, pk, sic);
        return info.getResumeBase().getName();
    }
}

