/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.IResumeExtend;
import com.kingdee.eas.hr.rec.IResumePhoto;
import com.kingdee.eas.hr.rec.ITalentExtend;
import com.kingdee.eas.hr.rec.RecCommonException;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.ResumeCategoryInfo;
import com.kingdee.eas.hr.rec.ResumeExtendFactory;
import com.kingdee.eas.hr.rec.ResumeExtendInfo;
import com.kingdee.eas.hr.rec.ResumeHistoryFactory;
import com.kingdee.eas.hr.rec.ResumeHistoryInfo;
import com.kingdee.eas.hr.rec.ResumePhotoFactory;
import com.kingdee.eas.hr.rec.ResumePhotoInfo;
import com.kingdee.eas.hr.rec.TalentCategoryInfo;
import com.kingdee.eas.hr.rec.TalentExtendFactory;
import com.kingdee.eas.hr.rec.TalentExtendInfo;
import com.kingdee.eas.hr.rec.app.AbstractResumeExtendFacadeControllerBean;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ResumeExtendFacadeControllerBean
extends AbstractResumeExtendFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.ResumeExtendFacadeControllerBean");

    protected IRowSet _getResumeDetailInfo(Context ctx, String queryPath, String filterFieldName, String filterFieldValue) throws BOSException, EASBizException {
        if (filterFieldValue == null || "".equals(filterFieldValue)) {
            return null;
        }
        MetaDataPK queryPK = new MetaDataPK(queryPath);
        IQueryExecutor query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(filterFieldName, (Object)filterFieldValue));
        viewInfo.setFilter(filterInfo);
        query.setObjectView(viewInfo);
        return query.executeQuery();
    }

    protected IRowSet _getResumeBaseRowSet(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeBaseQuery");
        IQueryExecutor query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        if (filterInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            query.setObjectView(viewInfo);
            return query.executeQuery();
        }
        return query.executeQuery();
    }

    protected IRowSet _getHistoryResumeBaseRowSet(Context ctx, FilterInfo filterInfo) throws BOSException, EASBizException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.rec.app.HistoryResumeBaseQuery");
        IQueryExecutor query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        if (filterInfo != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            query.setObjectView(viewInfo);
            return query.executeQuery();
        }
        return query.executeQuery();
    }

    protected IRowSet _getPhoto(Context ctx, String resumeBaseId) throws BOSException, EASBizException {
        return this.getResumePhoto(ctx, resumeBaseId, false);
    }

    protected Map _getResumeInfo(Context ctx, Set resumeBaseIds, boolean isHistory) throws BOSException, EASBizException {
        if (resumeBaseIds == null || resumeBaseIds.size() <= 0) {
            return null;
        }
        MetaDataPK queryPK = null;
        MetaDataPK queryPK_workExp = null;
        MetaDataPK queryPK_educationExp = null;
        MetaDataPK queryPK_trainExp = null;
        MetaDataPK queryPK_certificate = null;
        MetaDataPK queryPK_skill = null;
        MetaDataPK queryPK_familyRelation = null;
        MetaDataPK queryPK_reward = null;
        HashMap<String, IRowSet> map = new HashMap<String, IRowSet>();
        if (isHistory) {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.rec.app.HistoryResumeBaseQuery");
            queryPK_workExp = new MetaDataPK("com.kingdee.eas.hr.rec.app.HistoryWorkExpQuery");
            queryPK_educationExp = new MetaDataPK("com.kingdee.eas.hr.rec.app.HistoryEducationExpQuery");
            queryPK_trainExp = new MetaDataPK("com.kingdee.eas.hr.rec.app.HistoryTrainExpQuery");
            queryPK_certificate = new MetaDataPK("com.kingdee.eas.hr.rec.app.HistoryCertificateQuery");
            queryPK_skill = new MetaDataPK("com.kingdee.eas.hr.rec.app.HistorySkillQuery");
            queryPK_familyRelation = new MetaDataPK("com.kingdee.eas.hr.rec.app.HistoryFamilyRelationQuery");
            queryPK_reward = new MetaDataPK("com.kingdee.eas.hr.rec.app.HistoryRewardQuery");
        } else {
            queryPK = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeBaseQuery");
            queryPK_workExp = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeWorkExpQuery");
            queryPK_educationExp = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeEducationExpQuery");
            queryPK_trainExp = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeTrainExpQuery");
            queryPK_certificate = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeCertificateQuery");
            queryPK_skill = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeSkillQuery");
            queryPK_familyRelation = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeFamilyRelationQuery");
            queryPK_reward = new MetaDataPK("com.kingdee.eas.hr.rec.app.ResumeRewardQuery");
        }
        IQueryExecutor query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)resumeBaseIds, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        query.setObjectView(viewInfo);
        IRowSet resumeBaseRows = query.executeQuery();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            while (resumeBaseRows.next()) {
                String resumeBaseId = resumeBaseRows.getString("id");
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("resumeBase.id", (Object)resumeBaseId));
                evi.setFilter(fi);
                query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK_workExp);
                query.setObjectView(evi);
                map.put(resumeBaseId + "_workExp", query.executeQuery());
                query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK_educationExp);
                query.setObjectView(evi);
                map.put(resumeBaseId + "_educationExp", query.executeQuery());
                query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK_trainExp);
                query.setObjectView(evi);
                map.put(resumeBaseId + "_trainExp", query.executeQuery());
                query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK_certificate);
                query.setObjectView(evi);
                map.put(resumeBaseId + "_certificate", query.executeQuery());
                query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK_skill);
                query.setObjectView(evi);
                map.put(resumeBaseId + "_skill", query.executeQuery());
                query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK_familyRelation);
                query.setObjectView(evi);
                map.put(resumeBaseId + "_familyRelation", query.executeQuery());
                query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK_reward);
                query.setObjectView(evi);
                map.put(resumeBaseId + "_reward", query.executeQuery());
                map.put(resumeBaseId + "_photo", this.getResumePhoto(ctx, resumeBaseId, isHistory));
            }
            resumeBaseRows.beforeFirst();
            map.put("resumeBase", resumeBaseRows);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private IRowSet getResumePhoto(Context ctx, String resumeBaseId, boolean isHistory) throws BOSException, EASBizException {
        if (resumeBaseId == null) {
            return null;
        }
        DynamicRowSet photoResultSet = null;
        ResumePhotoInfo resumePhotoInfo = null;
        String photoId = "";
        IResumePhoto resumePhoto = ResumePhotoFactory.getLocalInstance(ctx);
        if (isHistory) {
            ResumeHistoryInfo historyInfo = ResumeHistoryFactory.getLocalInstance(ctx).getResumeHistoryInfo((IObjectPK)new ObjectUuidPK(resumeBaseId));
            resumePhotoInfo = historyInfo.getPhoto();
            photoId = historyInfo.getId().toString();
        } else {
            ResumeBaseInfo resumeBaseInfo = (ResumeBaseInfo)ResumeBaseFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(resumeBaseId));
            resumePhotoInfo = resumeBaseInfo.getPhoto();
            photoId = resumeBaseInfo.getId().toString();
        }
        if (resumePhotoInfo != null) {
            resumePhotoInfo = (ResumePhotoInfo)resumePhoto.getValue((IObjectPK)new ObjectUuidPK(resumePhotoInfo.getId().toString()));
            try {
                byte[] imageData = resumePhotoInfo.getImageData();
                if (imageData != null) {
                    photoResultSet = new DynamicRowSet(2);
                    photoResultSet.setColInfo(1, new ColInfo("photo", "photo", -2, null));
                    photoResultSet.setColInfo(2, new ColInfo("photoId", "photoId", 12, null));
                    ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
                    photoResultSet.moveToInsertRow();
                    photoResultSet.updateBinaryStream("photo", (InputStream)bais, imageData.length);
                    photoResultSet.updateString("photoId", photoId);
                    photoResultSet.insertRow();
                    photoResultSet.beforeFirst();
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return photoResultSet;
    }

    protected String _addNewResumeBaseInfo(Context ctx, IObjectValue resumeBaseInfo, IObjectValue resumeCategoryInfo) throws BOSException, EASBizException {
        ResumeBaseInfo rInfo = (ResumeBaseInfo)resumeBaseInfo;
        ResumeCategoryInfo cInfo = (ResumeCategoryInfo)resumeCategoryInfo;
        if (rInfo == null || cInfo == null) {
            return null;
        }
        if (rInfo.getId() != null) {
            return rInfo.getId().toString();
        }
        this.preSaveResume(ctx, rInfo);
        rInfo.setAge(this.getAgeByBirthday(rInfo.getBirthday()));
        IResumeBase rBaseDao = ResumeBaseFactory.getLocalInstance(ctx);
        IObjectPK pk = rBaseDao.addnew((CoreBaseInfo)rInfo);
        IResumeExtend rExtendDao = ResumeExtendFactory.getLocalInstance(ctx);
        ResumeExtendInfo resumeExtendInfo = new ResumeExtendInfo();
        resumeExtendInfo.setCategory(cInfo);
        resumeExtendInfo.setResumeBase(rInfo);
        rExtendDao.addnew((CoreBaseInfo)resumeExtendInfo);
        return pk.toString();
    }

    protected String _addNewTalentBaseInfo(Context ctx, IObjectValue resumeBaseInfo, IObjectValue talentCategory) throws BOSException, EASBizException {
        ResumeBaseInfo rInfo = (ResumeBaseInfo)resumeBaseInfo;
        TalentCategoryInfo tInfo = (TalentCategoryInfo)talentCategory;
        if (rInfo == null || tInfo == null) {
            return null;
        }
        if (rInfo.getId() != null) {
            return rInfo.getId().toString();
        }
        this.preSaveResume(ctx, rInfo);
        rInfo.setAge(this.getAgeByBirthday(rInfo.getBirthday()));
        IResumeBase rBaseDao = ResumeBaseFactory.getLocalInstance(ctx);
        IObjectPK pk = rBaseDao.addnew((CoreBaseInfo)rInfo);
        ITalentExtend tExtendDao = TalentExtendFactory.getLocalInstance(ctx);
        TalentExtendInfo talentExtendInfo = new TalentExtendInfo();
        talentExtendInfo.setCategory(tInfo);
        talentExtendInfo.setHistory(false);
        talentExtendInfo.setResumeBase(rInfo);
        talentExtendInfo.setHrOrgUnit(RecServerUtils.getCurrentHROrgUnit(ctx));
        tExtendDao.addnew((CoreBaseInfo)talentExtendInfo);
        return pk.toString();
    }

    protected void _updateResumeBaseInfo(Context ctx, IObjectValue resumeBaseInfo, String categoryInfoId, boolean isTalent) throws BOSException, EASBizException {
        AbstractObjectCollection coll;
        ResumeBaseInfo rInfo = (ResumeBaseInfo)resumeBaseInfo;
        if (rInfo == null || categoryInfoId == null) {
            return;
        }
        if (rInfo.getId() == null) {
            return;
        }
        this.preSaveResume(ctx, rInfo);
        String id = rInfo.getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("category.*"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("resumeBase.id", (Object)id));
        evi.setFilter(fi);
        if (isTalent) {
            TalentExtendInfo tExtendinfo;
            ITalentExtend talentExtendDao = TalentExtendFactory.getLocalInstance(ctx);
            coll = talentExtendDao.getTalentExtendCollection(evi);
            if (!(coll == null || coll.size() <= 0 || (tExtendinfo = coll.get(0)).getCategory() != null && categoryInfoId.equals(tExtendinfo.getCategory().getId().toString()))) {
                TalentCategoryInfo tCategoryInfo = new TalentCategoryInfo();
                tCategoryInfo.setId(BOSUuid.read((String)categoryInfoId));
                tExtendinfo.setCategory(tCategoryInfo);
                talentExtendDao.updatePartial((CoreBaseInfo)tCategoryInfo, RecServerUtils.getSic(new String[]{"category"}));
            }
        } else {
            ResumeExtendInfo info;
            IResumeExtend resumeExtendDao = ResumeExtendFactory.getLocalInstance(ctx);
            coll = resumeExtendDao.getResumeExtendCollection(evi);
            if (!(coll == null || coll.size() <= 0 || (info = coll.get(0)).getCategory() != null && categoryInfoId.equals(info.getCategory().getId().toString()))) {
                ResumeCategoryInfo rCategoryInfo = new ResumeCategoryInfo();
                rCategoryInfo.setId(BOSUuid.read((String)categoryInfoId));
                info.setCategory(rCategoryInfo);
                resumeExtendDao.updatePartial((CoreBaseInfo)info, RecServerUtils.getSic(new String[]{"category"}));
            }
        }
        IResumeBase rBaseDao = ResumeBaseFactory.getLocalInstance(ctx);
        rInfo.setAge(this.getAgeByBirthday(rInfo.getBirthday()));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        rBaseDao.updatePartial((CoreBaseInfo)rInfo, selector);
    }

    private int getAgeByBirthday(Date birthday) {
        if (birthday != null) {
            return RecServerUtils.subTwoDate(new Date(), birthday);
        }
        return 0;
    }

    private void preSaveResume(Context ctx, ResumeBaseInfo resumeBaseInfo) throws BOSException, EASBizException {
        if (resumeBaseInfo == null) {
            return;
        }
        IResumeBase rBaseDao = ResumeBaseFactory.getLocalInstance(ctx);
        String idCardNO = resumeBaseInfo.getIdCardNO();
        if (idCardNO != null && idCardNO.trim().length() > 0) {
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)idCardNO));
            FilterInfo filter = RecServerUtils.getHRFilterByParam(ctx, "REC002");
            if (filter != null) {
                fi.mergeFilter(filter, "and");
            }
            if (resumeBaseInfo.getId() == null) {
                if (rBaseDao.exists(fi)) {
                    RecCommonException bizException = new RecCommonException(RecCommonException.DUP_IDCARDNO, new Object[]{idCardNO});
                    throw bizException;
                }
            } else {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(fi);
                evi.getSelector().add(new SelectorItemInfo("idCardNO"));
                ResumeBaseCollection rbColl = rBaseDao.getResumeBaseCollection(evi);
                if (rbColl.size() > 1 || rbColl.size() == 1 && !resumeBaseInfo.getId().equals((Object)rbColl.get(0).getId())) {
                    RecCommonException bizException = new RecCommonException(RecCommonException.DUP_IDCARDNO, new Object[]{idCardNO});
                    throw bizException;
                }
            }
        }
    }
}

