/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.ImportDataException;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.WorkExpFactory;
import com.kingdee.eas.hr.rec.WorkExpInfo;
import com.kingdee.eas.hr.rec.app.ExcelField;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class WorkExpDataTransmission
extends AbstractDataTransmission {
    private boolean isFirstSubmit = true;
    private Set resumeBaseIds = new HashSet();
    private String resumeBaseID = null;
    private final String solution = "com.kingdee.eas.hr.rec.app.ExportWorkExpQuery";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.WorkExpDataTransmission");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return WorkExpFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public boolean isEnqualsNow(Context ctx, String date) {
        return date.equals(ExcelField.getToNow(ctx.getLocale())) || date.equals(ExcelField.getNow(ctx.getLocale()));
    }

    public ResumeBaseCollection getResumeBaseInfoBySign(Context ctx, String sign) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)sign));
        FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
        if (fi != null) {
            filter.mergeFilter(fi, "and");
        }
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        SorterItemInfo sInfo = new SorterItemInfo("createTime");
        sInfo.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sInfo);
        ResumeBaseCollection col = ResumeBaseFactory.getLocalInstance(ctx).getResumeBaseCollection(viewInfo);
        return col;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            WorkExpInfo info = new WorkExpInfo();
            if (RecServerUtils.objectIsNull(hsData.get("resumeBaseID"))) {
                throw new ImportDataException(ImportDataException.ACCESSID_NOT_NULL);
            }
            this.resumeBaseID = hsData.get("resumeBaseID").toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)this.resumeBaseID));
            FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
            if (fi != null) {
                filter.mergeFilter(fi, "and");
            }
            if (!ResumeBaseFactory.getLocalInstance(ctx).exists(filter)) {
                new ImportDataException(ImportDataException.NEEDRESUMEBASE);
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            if (!RecServerUtils.objectIsNull(hsData.get("dateStart"))) {
                try {
                    info.setStartDate(format.parse(hsData.get("dateStart").toString()));
                }
                catch (Exception e) {
                    throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"12_TrainExpDataTransmission", (Locale)ctx.getLocale()));
                }
            }
            if (!RecServerUtils.objectIsNull(hsData.get("dateEnd"))) {
                if (this.isEnqualsNow(ctx, hsData.get("dateEnd").toString())) {
                    info.setEndDate(DateTimeUtils.truncateDate((Date)new Date(System.currentTimeMillis())));
                } else {
                    try {
                        info.setEndDate(format.parse(hsData.get("dateEnd").toString()));
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.hr.rec.RECAutoGenerateResource", (String)"13_TrainExpDataTransmission", (Locale)ctx.getLocale()));
                    }
                }
            }
            if (RecServerUtils.objectIsNull(hsData.get("companyName"))) {
                throw new ImportDataException(ImportDataException.WORKEXP_COMPANY_NULL);
            }
            info.setOrgan(hsData.get("companyName").toString());
            if (!RecServerUtils.objectIsNull(hsData.get("positionName"))) {
                info.setPosition(hsData.get("positionName").toString());
            }
            if (!RecServerUtils.objectIsNull(hsData.get("positionDiscription"))) {
                info.setDuty(hsData.get("positionDiscription").toString());
            }
            if (!RecServerUtils.objectIsNull(hsData.get("underlings")) && !StringUtils.isEmpty((String)hsData.get("underlings").toString())) {
                info.setUnderNum(new Double(hsData.get("underlings").toString()).intValue());
            }
            if (!RecServerUtils.objectIsNull(hsData.get("attestor"))) {
                info.setLinkman(hsData.get("attestor").toString());
            }
            if (!RecServerUtils.objectIsNull(hsData.get("reasonForLeaving"))) {
                info.setDimissionReson(hsData.get("reasonForLeaving").toString());
            }
            if (!RecServerUtils.objectIsNull(hsData.get("outstandingArchievement"))) {
                info.setRemark(hsData.get("outstandingArchievement").toString());
            }
            if (hsData.get("organAddress") != null) {
                info.setRemark(hsData.get("organAddress").toString());
            }
            return info;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            if (!StringUtils.isEmpty((String)rs.getString("idCardNO"))) {
                result.put("resumeBaseID", rs.getString("idCardNO"));
            }
            if (!RecServerUtils.objectIsNull(rs.getDate("workExp.startDate"))) {
                result.put("dateStart", rs.getDate("workExp.startDate").toString());
            }
            if (!RecServerUtils.objectIsNull(rs.getDate("workExp.endDate"))) {
                result.put("dateEnd", rs.getDate("workExp.endDate").toString());
            }
            if (!StringUtils.isEmpty((String)rs.getString("workExp.organ"))) {
                result.put("companyName", rs.getString("workExp.organ"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("workExp.position"))) {
                result.put("positionName", rs.getString("workExp.position"));
            }
            result.put("underlings", "" + rs.getInt("workExp.underNum"));
            if (!StringUtils.isEmpty((String)rs.getString("workExp.linkman"))) {
                result.put("attestor", rs.getString("workExp.linkman"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("workExp.dimissionReson"))) {
                result.put("reasonForLeaving", rs.getString("workExp.dimissionReson"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("workExp.remark"))) {
                result.put("outstandingArchievement", rs.getString("workExp.remark"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("workExp.duty"))) {
                result.put("positionDiscription", rs.getString("workExp.duty"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("workExp.organAddress"))) {
                result.put("organAddress", rs.getString("workExp.organAddress"));
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        try {
            return RecServerUtils.getHRFilterByParam(ctx, "REC002");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.hr.rec.app.ExportWorkExpQuery";
    }

    private FilterInfo makeIDFilterByResumeBaseID(Context ctx, String table, String resumeBaseID) {
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer("SELECT FID FROM ");
        sql.append(table);
        sql.append(" WHERE FresumeBaseID = ");
        sql.append("'");
        sql.append(resumeBaseID);
        sql.append("'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return filter;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            ResumeBaseCollection col = this.getResumeBaseInfoBySign(ctx, this.resumeBaseID);
            if (col != null && col.size() > 0) {
                WorkExpInfo info = (WorkExpInfo)coreBaseInfo;
                if (this.isSltImportUpdate()) {
                    int size = col.size();
                    for (int i = 0; i < size; ++i) {
                        String resumeBaseId = col.get(i).getId().toString();
                        info.setResumeBase(col.get(i));
                        this.isFirstSubmit = !this.resumeBaseIds.contains(resumeBaseId);
                        if (this.isFirstSubmit && this.isSltImportUpdate()) {
                            FilterInfo filter = this.makeIDFilterByResumeBaseID(ctx, "T_HR_WorkExp", resumeBaseId);
                            WorkExpFactory.getLocalInstance(ctx).delete(filter);
                            this.resumeBaseIds.add(resumeBaseId);
                        }
                        if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                            this.getController(ctx).addnew(coreBaseInfo);
                        } else {
                            this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
                        }
                        coreBaseInfo.setId(null);
                    }
                } else {
                    ResumeBaseInfo currResumeBaseInfo = col.get(0);
                    info.setResumeBase(currResumeBaseInfo);
                    if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                        if (RecServerUtils.isNotExists(ctx, this.getSQL(currResumeBaseInfo.getId().toString(), info.getOrgan()))) {
                            this.getController(ctx).addnew(coreBaseInfo);
                        }
                    } else {
                        this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private String getSQL(String resumeID, String name) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("SELECT FOrgan,FResumeBaseID FROM T_HR_WorkExp where FOrgan = '");
        strBuffer.append(name);
        strBuffer.append("'");
        strBuffer.append(" and FResumeBaseID = '");
        strBuffer.append(resumeID);
        strBuffer.append("'");
        return strBuffer.toString();
    }
}

