/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.rec.ImportDataException;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.hr.rec.app.ExcelField;
import com.kingdee.eas.hr.rec.util.RecServerUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class WorkExpectedDataTransmission
extends AbstractDataTransmission {
    private String resumeBaseID = null;
    private static final String solution = "com.kingdee.eas.hr.rec.app.ExportWorkExpectedQuery";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.rec.app.FamilyRelationDataTransmission");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ResumeBaseFactory.getLocalInstance(ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public ResumeBaseCollection getResumeBaseInfoBySign(Context ctx, String sign) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)sign));
        FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
        if (fi != null) {
            filter.mergeFilter(fi, "and");
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("job_1"));
        sic.add(new SelectorItemInfo("job_2"));
        sic.add(new SelectorItemInfo("job_3"));
        sic.add(new SelectorItemInfo("salaryReq"));
        sic.add(new SelectorItemInfo("workAspect"));
        ResumeBaseCollection col = ResumeBaseFactory.getLocalInstance(ctx).getResumeBaseCollection(viewInfo);
        return col;
    }

    private List splitJobs(String jobs) {
        ArrayList<String> result = new ArrayList<String>();
        if (jobs == null || jobs.trim().length() <= 0) {
            return result;
        }
        String[] infos = StringUtils.split((String)jobs, (String)"**");
        for (int i = 0; i < infos.length && infos[i].trim().length() > 0; ++i) {
            result.add(infos[i]);
        }
        return result;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        try {
            if (RecServerUtils.objectIsNull(hsData.get("resumeBaseID"))) {
                throw new ImportDataException(ImportDataException.ACCESSID_NOT_NULL);
            }
            this.resumeBaseID = hsData.get("resumeBaseID").toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("idCardNO", (Object)this.resumeBaseID));
            FilterInfo fi = RecServerUtils.getHRFilterByParam(ctx, "REC002");
            if (fi != null) {
                filter.mergeFilter(fi, "and");
            }
            if (!ResumeBaseFactory.getLocalInstance(ctx).exists(filter)) {
                new ImportDataException(ImportDataException.NEEDRESUMEBASE);
            }
            ResumeBaseInfo info = new ResumeBaseInfo();
            if (!RecServerUtils.objectIsNull(hsData.get("functionExpected"))) {
                List jobs = this.splitJobs(hsData.get("functionExpected").toString());
                int max = jobs.size() > 3 ? 3 : jobs.size();
                for (int i = 0; i < max; ++i) {
                    if (i == 0) {
                        info.setJob_1((String)jobs.get(i));
                    }
                    if (i == 1) {
                        info.setJob_2((String)jobs.get(i));
                    }
                    if (i != 2) continue;
                    info.setJob_3((String)jobs.get(i));
                }
            }
            if (!RecServerUtils.objectIsNull(hsData.get("salaryExpected"))) {
                info.setSalaryReq(hsData.get("salaryExpected").toString());
            }
            StringBuffer workExpected = new StringBuffer();
            workExpected.append(ExcelField.getTypeofEmployment(ctx.getLocale()));
            workExpected.append(":");
            if (!RecServerUtils.objectIsNull(hsData.get("typeofEmployed"))) {
                workExpected.append(hsData.get("typeofEmployed").toString());
            }
            workExpected.append("\n");
            workExpected.append(ExcelField.getTypeofCompany(ctx.getLocale()));
            workExpected.append(":");
            if (!RecServerUtils.objectIsNull(hsData.get("typeofCompany"))) {
                workExpected.append(hsData.get("typeofCompany").toString());
            }
            workExpected.append("\n");
            workExpected.append(ExcelField.getIndustryExpected(ctx.getLocale()));
            workExpected.append(":");
            if (!RecServerUtils.objectIsNull(hsData.get("industryExpected"))) {
                workExpected.append(hsData.get("industryExpected").toString());
            }
            workExpected.append("\n");
            workExpected.append(ExcelField.getWorkingPlaceExpected(ctx.getLocale()));
            workExpected.append(":");
            if (!RecServerUtils.objectIsNull(hsData.get("placeExpected"))) {
                workExpected.append(hsData.get("placeExpected").toString());
            }
            workExpected.append("\n");
            info.setWorkAspect(workExpected.toString());
            return info;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private List splitWorkAspect(Context ctx, String aspect) {
        ArrayList<String> list = null;
        String typeofEmployed = ExcelField.getTypeofEmployment(ctx.getLocale()) + ":";
        String typeofCompany = ExcelField.getTypeofCompany(ctx.getLocale()) + ":";
        String industryExpected = ExcelField.getIndustryExpected(ctx.getLocale()) + ":";
        String placeExpected = ExcelField.getWorkingPlaceExpected(ctx.getLocale()) + ":";
        int keyLen = 0;
        if (aspect.indexOf(typeofEmployed) >= 0 && aspect.indexOf(typeofCompany) > 0 && aspect.indexOf(industryExpected) > 0 && aspect.indexOf(placeExpected) > 0) {
            list = new ArrayList<String>();
            keyLen = aspect.indexOf(typeofEmployed) + typeofEmployed.length();
            list.add(aspect.substring(keyLen, aspect.indexOf(typeofCompany) - 1));
            keyLen = aspect.indexOf(typeofCompany) + typeofCompany.length();
            list.add(aspect.substring(keyLen, aspect.indexOf(industryExpected) - 1));
            keyLen = aspect.indexOf(industryExpected) + industryExpected.length();
            list.add(aspect.substring(keyLen, aspect.indexOf(placeExpected) - 1));
            keyLen = aspect.indexOf(placeExpected) + placeExpected.length();
            list.add(aspect.substring(keyLen));
        }
        return list;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        StringBuffer tmp = null;
        try {
            List aspect;
            if (!StringUtils.isEmpty((String)rs.getString("idCardNO"))) {
                result.put("resumeBaseID", rs.getString("idCardNO"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("salaryReq"))) {
                result.put("salaryExpected", rs.getString("salaryReq"));
            }
            tmp = new StringBuffer();
            if (!StringUtils.isEmpty((String)rs.getString("job_1"))) {
                tmp.append(rs.getString("job_1"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("job_2"))) {
                if (tmp.length() > 0) {
                    tmp.append("**");
                }
                tmp.append(rs.getString("job_2"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("job_3"))) {
                if (tmp.length() > 0) {
                    tmp.append("**");
                }
                tmp.append(rs.getString("job_3"));
            }
            if (tmp.length() > 0) {
                result.put("functionExpected", tmp.toString());
            }
            if (!StringUtils.isEmpty((String)rs.getString("workAspect")) && (aspect = this.splitWorkAspect(ctx, rs.getString("workAspect"))) != null) {
                for (int i = 0; i < aspect.size(); ++i) {
                    if (i == 0) {
                        result.put("typeofEmployed", aspect.get(i).toString());
                    }
                    if (i == 1) {
                        result.put("typeofCompany", aspect.get(i).toString());
                    }
                    if (i == 2) {
                        result.put("industryExpected", aspect.get(i).toString());
                    }
                    if (i != 3) continue;
                    result.put("placeExpected", aspect.get(i).toString());
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        try {
            return RecServerUtils.getHRFilterByParam(ctx, "REC002");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return solution;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            ResumeBaseCollection col = this.getResumeBaseInfoBySign(ctx, this.resumeBaseID);
            ResumeBaseInfo baseInfo = (ResumeBaseInfo)coreBaseInfo;
            if (col != null) {
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    ResumeBaseInfo info = col.get(i);
                    info.setJob_1(baseInfo.getJob_1());
                    info.setJob_2(baseInfo.getJob_2());
                    info.setJob_3(baseInfo.getJob_3());
                    info.setSalaryReq(baseInfo.getSalaryReq());
                    info.setWorkAspect(baseInfo.getWorkAspect());
                    if (info.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                        throw new ImportDataException(ImportDataException.WORKEXPECTED_IMPORT_ERROR);
                    }
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("job_1"));
                    sic.add(new SelectorItemInfo("job_2"));
                    sic.add(new SelectorItemInfo("job_3"));
                    sic.add(new SelectorItemInfo("salaryReq"));
                    sic.add(new SelectorItemInfo("workAspect"));
                    this.getController(ctx).updatePartial((CoreBaseInfo)info, sic);
                }
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }
}

