/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.util;

import com.kingdee.eas.hr.rec.AccessImportTaskStateEnum;
import com.kingdee.eas.util.ExceptionUtil;
import com.kingdee.util.BaseException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public final class AccessImportTaskLog {
    private String uuid;
    private ArrayList errorSubject = new ArrayList();
    private ArrayList errorDetail = new ArrayList();
    private int recordCount;
    private int successRecordCount;
    private int failRecordCount;
    private AccessImportTaskStateEnum taskState = null;
    private ArrayList exceptionList = new ArrayList();
    public static final String IMPORTLOG = "importlog";
    public static final String EXPORTLOG = "exportlog";
    private String logType = "importlog";

    public String getLogUuID() {
        return this.uuid;
    }

    public void setLogUuID(String uuid) {
        this.uuid = uuid;
    }

    public void setSuccessRecordCount(int successRecordCount) {
        this.successRecordCount = successRecordCount;
    }

    public int getSuccessRecordCount() {
        return this.successRecordCount;
    }

    public void setFailRecordCount(int failRecordCount) {
        this.failRecordCount = failRecordCount;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public int getFailRecordCount() {
        return this.failRecordCount;
    }

    public void setTaskState(AccessImportTaskStateEnum state) {
        this.taskState = state;
    }

    public AccessImportTaskStateEnum getTaskState() {
        return this.taskState;
    }

    public void addException(String subject, Throwable e) {
        this.exceptionList.add(e);
        this.errorSubject.add(subject);
        String errDetail = subject;
        if (e.getMessage() != null) {
            errDetail = errDetail + "\r\n" + e.getMessage().replaceAll(this.getReplacedStr(), "");
        }
        this.errorDetail.add(errDetail);
    }

    public String getException(int i) {
        return ((Throwable)this.exceptionList.get(i)).toString();
    }

    public String getExceptionStack(int i) {
        Throwable t = (Throwable)this.exceptionList.get(i);
        if (t instanceof BaseException) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                MyPrintStream ps = new MyPrintStream(os);
                t.printStackTrace(ps);
                return ps.toString();
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
        return ExceptionUtil.getExcLinkStackTrace((Throwable)t);
    }

    public String getErrorSubject(int i) {
        return (String)this.errorSubject.get(i);
    }

    public String getErrorDetail(int i) {
        return (String)this.errorDetail.get(i);
    }

    public int getErrorDetailCount() {
        return this.errorDetail.size();
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getLogType() {
        return this.logType;
    }

    private String getReplacedStr() {
        return "Caused exception message is:";
    }

    private static class MyPrintStream
    extends PrintStream {
        private ByteArrayOutputStream os = null;

        public MyPrintStream(ByteArrayOutputStream os) throws UnsupportedEncodingException {
            super((OutputStream)os, false, "UTF8");
            os.reset();
            this.os = os;
        }

        private MyPrintStream() {
            super((OutputStream)null);
        }

        public String toString() {
            try {
                return this.os.toString("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }
    }
}

