/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.util;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.eas.hr.org.HRPositionFacadeFactory;
import com.kingdee.eas.hr.org.IHRPositionFacade;
import com.kingdee.eas.hr.org.client.PositionSpecHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class PositionDescPrintProvider
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger(PositionDescPrintProvider.class);
    private static final String POSITIONSPEC_FILENAME = "/HR/OrgUnit/PositionSpecNew";
    private String positionId;

    private PositionDescPrintProvider() {
    }

    private PositionDescPrintProvider(String positionId) {
        this.positionId = positionId;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        try {
            IHRPositionFacade iPosition = HRPositionFacadeFactory.getRemoteInstance();
            if ("ds".equals(ds.getID())) {
                return iPosition.getRowSetForPosiSpec(this.positionId, 0);
            }
            if ("ds2".equals(ds.getID())) {
                return iPosition.getRowSetForPosiSpec(this.positionId, 1);
            }
            if ("ds3".equals(ds.getID())) {
                return iPosition.getRowSetForPosiSpec(this.positionId, 2);
            }
            if ("ds4".equals(ds.getID())) {
                return iPosition.getRowSetForPosiSpec(this.positionId, 3);
            }
            if ("ds5".equals(ds.getID())) {
                DynamicRowSet drs = new DynamicRowSet(1);
                drs.setColInfo(1, new ColInfo("positionMap", "positionMap", -4, null));
                PositionSpecHelper helper = new PositionSpecHelper();
                drs.moveToInsertRow();
                byte[] bts = helper.creatPositionMap(this.positionId);
                ByteArrayInputStream bais = new ByteArrayInputStream(bts);
                drs.updateBinaryStream("positionMap", (InputStream)bais, bts.length);
                drs.insertRow();
                drs.beforeFirst();
                return drs;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return null;
    }

    public static void executeActionPrint(String positionId, Component comp) {
        if (positionId != null) {
            KDNoteHelper appHlp = new KDNoteHelper();
            PositionDescPrintProvider data = new PositionDescPrintProvider(positionId);
            appHlp.printPreview(POSITIONSPEC_FILENAME, (Object)data, comp);
        }
    }
}

