/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.rec.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.hr.rec.IResumeBase;
import com.kingdee.eas.hr.rec.PersonStateEnum;
import com.kingdee.eas.hr.rec.ResumeBaseCollection;
import com.kingdee.eas.hr.rec.ResumeBaseFactory;
import com.kingdee.eas.hr.rec.ResumeBaseInfo;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RecServerUtils {
    private static final Logger logger = Logger.getLogger(RecServerUtils.class.getName());

    public static boolean objectIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)((String)obj));
        }
        if (obj instanceof DataToken) {
            return StringUtils.isEmpty((String)obj.toString());
        }
        return false;
    }

    public static boolean isNotExists(Context ctx, String sql) throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return !rs.next();
    }

    public static String getAdminOrgRengAndHROrgUnitSQL(Context ctx) {
        String hrOrgUnitId = ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitId);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        return sql.toString();
    }

    public static HROrgUnitInfo getCurrentHROrgUnit(Context ctx) {
        HROrgUnitInfo info = ContextUtil.getCurrentHRUnit((Context)ctx);
        return info;
    }

    public static FilterInfo getHRFilterInfo(Context ctx, String hrOrgUnitId) {
        FilterInfo filter = new FilterInfo();
        if (ContextUtil.getCurrentHRUnit((Context)ctx) != null) {
            filter.getFilterItems().add(new FilterItemInfo(hrOrgUnitId, (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        }
        return filter;
    }

    public static FilterInfo getHRFilterByParam(Context ctx, String paramNumber) throws BOSException, EASBizException {
        String val = "";
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        val = iParam.getParamValue(null, paramNumber);
        if ("true".equals(val)) {
            return null;
        }
        return RecServerUtils.getHRFilterInfo(ctx, "hrOrgUnit.id");
    }

    public static String getNumberSilent(Context ctx, CoreBaseInfo info, String orgUnitId) throws BOSException, EASBizException {
        if (info == null || orgUnitId == null || orgUnitId.equals("")) {
            return null;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        return codingRuleManager.getNumber((IObjectValue)info, orgUnitId);
    }

    public static void recycleNumber(Context ctx, CoreBaseInfo info, String orgUnitId) throws BOSException, EASBizException {
        if (info == null || orgUnitId == null || orgUnitId.equals("")) {
            return;
        }
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (codingRuleManager.isExist((IObjectValue)info, orgUnitId) && codingRuleManager.isUseIntermitNumber((IObjectValue)info, orgUnitId)) {
            codingRuleManager.recycleNumber((IObjectValue)info, orgUnitId, info.getString("number"));
        }
    }

    public static String getWholeNameByAdminOrgUnitId(String id) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
        if (adminOrgUnitInfo == null) {
            return null;
        }
        if (adminOrgUnitInfo.getParent() == null) {
            return adminOrgUnitInfo.getName();
        }
        return RecServerUtils.getWholeNameByAdminOrgUnitId(adminOrgUnitInfo.getParent().getId().toString()) + "-" + adminOrgUnitInfo.getName();
    }

    public static boolean getParamtForHRO(Context ctx) {
        boolean result = false;
        try {
            result = HRParamUtil.getParamOfHR(null, (String)"REC003", (String)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Date dateAdd(Date inputDate, int next) {
        Calendar c = Calendar.getInstance();
        c.setTime(inputDate);
        c.add(5, next);
        return c.getTime();
    }

    public static DataBaseInfo getDataBaseInfo(IDataBase dataBase, String pk) throws Exception {
        DataBaseInfo info = null;
        if (dataBase != null && pk != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            info = dataBase.getDataBaseInfo((IObjectPK)new ObjectUuidPK(pk));
        }
        return info;
    }

    public static SelectorItemCollection getSic(String[] columns) {
        SelectorItemCollection sic = new SelectorItemCollection();
        for (int i = 0; i < columns.length; ++i) {
            sic.add(new SelectorItemInfo(columns[i]));
        }
        return sic;
    }

    public static int subTwoDate(Date edate, Date sdate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdate);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long slong = cal.getTimeInMillis();
        cal.setTime(edate);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        long elong = cal.getTimeInMillis();
        int days = (int)((elong - slong) / 86400000L);
        return days / 365;
    }

    public static boolean isInt(String str) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        String regex = "^[1-9][0-9]*$";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static boolean isInt(String str, boolean isIncludeZero) {
        if (str == null || str.trim().length() <= 0) {
            return false;
        }
        String regex = "^[1-9]\\d*$";
        if (isIncludeZero) {
            regex = "^[1-9]\\d*|0$";
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static FilterInfo getHROrgUnitFilter(Context ctx, String columnName) {
        if (ContextUtil.getCurrentHRUnit((Context)ctx) == null) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(columnName, (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString()));
        return filterInfo;
    }

    public static void setAutoNumberByOrg(Context ctx, IObjectValue object, String orgType) {
        if (object instanceof ObjectBaseInfo) {
            ObjectBaseInfo model = (ObjectBaseInfo)object;
            String sysNumber = null;
            try {
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)orgType)) != null) {
                    sysNumber = FrameWorkUtils.getCodeRuleServer((Context)ctx, (CoreBaseInfo)model, (String)ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)orgType)).getString("id"));
                } else if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
                    sysNumber = FrameWorkUtils.getCodeRuleServer((Context)ctx, (CoreBaseInfo)model, (String)ContextUtil.getCurrentOrgUnit((Context)ctx).getString("id"));
                }
                if (!StringUtils.isEmpty(sysNumber)) {
                    model.setString("number", sysNumber);
                }
            }
            catch (Exception e) {
                logger.info("set number error by codeRule");
            }
        }
    }

    public static boolean isNotEq(Object o1, Object o2) {
        if (o1 != null && o2 != null && !o1.equals(o2)) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return true;
        }
        return o2 == null && o1 != null;
    }

    public static boolean isEq(CoreBaseInfo c1, CoreBaseInfo c2) {
        if (c1 != null && c1.getId() == null) {
            c1 = null;
        }
        if (c2 != null && c2.getId() == null) {
            c2 = null;
        }
        if (c1 != null && c2 != null && !c1.getId().toString().equals(c2.getId().toString())) {
            return false;
        }
        if (c1 == null && c2 != null) {
            return false;
        }
        return c2 != null || c1 == null;
    }

    public static String getLocalString(Context ctx) {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    public static void setResumeBaseState(Context ctx, Set rsSet, PersonStateEnum state) throws EASBizException, BOSException {
        if (rsSet == null || rsSet.size() <= 0) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)rsSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("resumeState"));
        IResumeBase iResumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        ResumeBaseCollection coll = iResumeBase.getResumeBaseCollection(viewInfo);
        if (coll.size() > 0) {
            ResumeBaseInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                info.setPersonState(state);
                iResumeBase.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            }
        }
    }

    public static void setResumeBaseState(Context ctx, String personId, PersonStateEnum state) throws EASBizException, BOSException {
        if (personId == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("personID", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isInter", (Object)Boolean.TRUE));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("resumeState"));
        IResumeBase iResumeBase = ResumeBaseFactory.getLocalInstance(ctx);
        ResumeBaseCollection coll = iResumeBase.getResumeBaseCollection(viewInfo);
        if (coll.size() > 0) {
            ResumeBaseInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                info.setPersonState(PersonStateEnum.changed);
                iResumeBase.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            }
        }
    }
}

