/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.JobCategoryCollection;
import com.kingdee.eas.basedata.org.JobCategoryFactory;
import com.kingdee.eas.basedata.org.JobFamilyCollection;
import com.kingdee.eas.basedata.org.JobFamilyFactory;
import com.kingdee.eas.basedata.org.JobSubCategoryCollection;
import com.kingdee.eas.basedata.org.JobSubCategoryFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.service.FactTypeEnum;
import com.kingdee.eas.hr.service.app.AbstractSelectFactoryControllerBean;
import com.kingdee.eas.hr.service.app.output.GetSelectSql;
import com.kingdee.eas.hr.service.app.output.OutPutSelectHelper;
import com.kingdee.eas.hr.service.app.output.PersonRefInfoSelectHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SelectFactoryControllerBean
extends AbstractSelectFactoryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.service.app.SelectFactoryControllerBean");

    @Override
    protected List _getPositionCount(Context ctx, String orgId, String filterStr) throws BOSException, EASBizException {
        StringBuffer selector = new StringBuffer();
        selector.append("posnm,");
        selector.append("jfanm,");
        selector.append("jcnm,");
        selector.append("josnm,");
        selector.append("jobnm,");
        selector.append("plinm,");
        selector.append("jgrnm,");
        selector.append("orgpn,");
        selector.append("plinm,");
        selector.append("jgrnm,");
        selector.append("jlevnm,");
        selector.append("domnm,");
        selector.append("pospc,");
        selector.append("domnm,");
        selector.append("posco");
        List<HashMap> result = this.getSelectData(ctx, orgId, FactTypeEnum.POSITION, filterStr, selector.toString());
        return result;
    }

    private List<HashMap> getSelectData(Context ctx, String orgId, FactTypeEnum type, String filterStr, String selector) throws EASBizException, BOSException {
        OutPutSelectHelper helper = new OutPutSelectHelper();
        int orgLevel = helper.getOrgLevel(ctx, orgId);
        int maxLevel = helper.getMaxLevel(ctx, orgId, orgLevel);
        GetSelectSql count = new GetSelectSql();
        String sql = count.getSql(ctx, type, orgId, orgLevel, selector.toString(), filterStr);
        List<HashMap> result = helper.processResult(ctx, orgLevel, maxLevel, sql);
        return result;
    }

    @Override
    protected Map _getJobFSystem(Context ctx) throws BOSException, EASBizException {
        List childrenList;
        HashMap<String, Object> tempNode;
        int i;
        String NAME = "name";
        String ID = "id";
        String CHILDREN = "children";
        JobFamilyCollection jfColl = JobFamilyFactory.getLocalInstance((Context)ctx).getJobFamilyCollection();
        JobCategoryCollection jcColl = JobCategoryFactory.getLocalInstance((Context)ctx).getJobCategoryCollection();
        JobSubCategoryCollection jscColl = JobSubCategoryFactory.getLocalInstance((Context)ctx).getJobSubCategoryCollection();
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put(NAME, "jobsystem");
        root.put(ID, "");
        ArrayList jobFamilyList = new ArrayList();
        root.put(CHILDREN, jobFamilyList);
        HashMap keyMap = new HashMap();
        for (i = 0; i < jfColl.size(); ++i) {
            tempNode = new HashMap<String, Object>();
            tempNode.put(NAME, jfColl.get(i).getName());
            tempNode.put(ID, jfColl.get(i).getId().toString());
            tempNode.put(CHILDREN, new ArrayList());
            jobFamilyList.add(tempNode);
            keyMap.put(jfColl.get(i).getId().toString(), tempNode);
        }
        for (i = 0; i < jcColl.size(); ++i) {
            tempNode = new HashMap();
            tempNode.put(NAME, jcColl.get(i).getName());
            tempNode.put(ID, jcColl.get(i).getId().toString());
            tempNode.put(CHILDREN, new ArrayList());
            if (jcColl.get(i).getJobFamily() == null || !keyMap.containsKey(jcColl.get(i).getJobFamily().getId().toString())) continue;
            childrenList = (List)((HashMap)keyMap.get(jcColl.get(i).getJobFamily().getId().toString())).get(CHILDREN);
            childrenList.add(tempNode);
            keyMap.put(jcColl.get(i).getId().toString(), tempNode);
        }
        for (i = 0; i < jscColl.size(); ++i) {
            tempNode = new HashMap();
            tempNode.put(NAME, jscColl.get(i).getName());
            tempNode.put(ID, jscColl.get(i).getId().toString());
            if (jscColl.get(i).getJobCategory() == null || !keyMap.containsKey(jscColl.get(i).getJobCategory().getId().toString())) continue;
            childrenList = (List)((HashMap)keyMap.get(jscColl.get(i).getJobCategory().getId().toString())).get(CHILDREN);
            childrenList.add(tempNode);
            keyMap.put(jscColl.get(i).getId().toString(), tempNode);
        }
        return root;
    }

    @Override
    protected Map _getPersonRefInfo(Context ctx, String personID) throws BOSException, EASBizException {
        PersonRefInfoSelectHelper helper = new PersonRefInfoSelectHelper();
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("assignData", helper.getAssignMap(ctx, personID));
        result.put("jobGradeData", helper.getPersonJobGradeData(ctx, personID));
        result.put("jobGrade", helper.getJobGrade(ctx));
        result.put("performData", helper.getPerfData(ctx, personID));
        result.put("salarayData", helper.getSalaryData(ctx, personID));
        return result;
    }

    @Override
    protected List _getAdminInfos(Context ctx, String orgId, String selectorStr, String filterStr) throws BOSException, EASBizException {
        List<HashMap> result = this.getSelectData(ctx, orgId, FactTypeEnum.ADMIN, filterStr, selectorStr);
        return result;
    }

    @Override
    protected List _getPositionInfos(Context ctx, String orgId, String filterStr, String selectorStr) throws BOSException, EASBizException {
        List<HashMap> result = this.getSelectData(ctx, orgId, FactTypeEnum.POSITION, filterStr, selectorStr);
        return result;
    }

    @Override
    protected List _getPersonInfos(Context ctx, String adminOrgID, String selecterStr, String filterStr) throws BOSException, EASBizException {
        List<HashMap> result = this.getSelectData(ctx, adminOrgID, FactTypeEnum.PERSON, filterStr, selecterStr);
        return result;
    }
}

