/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.listener;

import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.MSFServiceUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.hr.service.ModifyLogInfo;
import com.kingdee.eas.hr.service.app.ModifyStateManager;
import com.kingdee.eas.hr.service.app.listener.DigestThreadUtil;
import com.kingdee.eas.hr.service.app.solid.SolidPartFromDB;
import com.kingdee.eas.util.app.ContextUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class DigestThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(DigestThread.class);
    private long interval = 15000L;
    private volatile boolean stopped = false;
    ModifyStateManager stateManager = null;
    Map<String, Context> datacenterMap = new HashMap<String, Context>();

    public DigestThread(ModifyStateManager stateManager, long interval) {
        this.stateManager = stateManager;
        this.interval = interval;
        this.parseDC();
    }

    protected final void scan() {
        Map<String, ConcurrentHashMap<String, ModifyLogInfo>> udpateQueue = this.stateManager.getUpdateQueue();
        if (null == udpateQueue || udpateQueue.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"DigestThread scan stateManager.getUpdateQueue() is null or is empty");
            }
            return;
        }
        for (Map.Entry<String, ConcurrentHashMap<String, ModifyLogInfo>> entry : udpateQueue.entrySet()) {
            Context ctx = this.datacenterMap.get(entry.getKey());
            SolidPartFromDB solidPart = new SolidPartFromDB();
            if (null == entry.getValue() || entry.getValue().isEmpty()) continue;
            ConcurrentHashMap<String, ModifyLogInfo> value = new ConcurrentHashMap<String, ModifyLogInfo>();
            value.putAll((Map)entry.getValue());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("DigestThread scan db:{0},value size:{2}", entry.getKey(), value.size()));
            }
            if (DigestThreadUtil.isSyncPause(ctx)) continue;
            this.stateManager.initUpdateQueue();
            solidPart.solidPart(ctx, value);
        }
    }

    private void parseDC() {
        ArrayList newList = null;
        try {
            newList = DCManager.getInstance().getDCList();
        }
        catch (Exception e1) {
            logger.error((Object)("FaRebuildViewService.newList = " + e1.getMessage()));
        }
        if (null == newList || newList.isEmpty()) {
            return;
        }
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F"));
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
        for (int i = 0; i < newList.size(); ++i) {
            try {
                DCInfo info = (DCInfo)newList.get(i);
                Context ctx = new Context(null, info.getSolutionName(), info.getNumber(), null);
                ctx.setUserName(info.getUserName());
                ctx.put((Object)"dbType", (Object)MSFServiceUtil.getDBType((int)info.getDBType()));
                ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)user);
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)cu);
                ctx.setCaller((IObjectPK)new ObjectUuidPK(user.getId().toString()));
                this.datacenterMap.put(ctx.getAIS(), ctx);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("init service config  lose = " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public synchronized void start() {
        Thread t = new Thread((Runnable)this, "HRModifyLog digest Thread");
        t.setDaemon(true);
        t.start();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"HRModifyLog digest Thread start");
        }
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DigestThread digestThread = this;
        synchronized (digestThread) {
            while (!this.stopped) {
                long now;
                long until = System.currentTimeMillis() + this.interval;
                while (!this.stopped && until > (now = System.currentTimeMillis())) {
                    try {
                        this.wait(until - now);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.stopped) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"HRModifyLog digest Thread scan");
                }
                this.scan();
            }
        }
    }
}

