/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.output;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.emp.EmpPostRankCollection;
import com.kingdee.eas.hr.emp.EmpPostRankFactory;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.perf.EvaluResultCollection;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.service.app.util.ServiceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PersonRefInfoSelectHelper {
    public List<String> getJobGrade(Context ctx) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemCollection sortCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("index");
        sortInfo.setSortType(SortType.DESCEND);
        sortCollection.add(sortInfo);
        viewInfo.setSorter(sortCollection);
        JobGradeCollection jgColl = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeCollection(viewInfo);
        for (int i = 0; i < jgColl.size(); ++i) {
            result.add(jgColl.get(i).getName());
        }
        return result;
    }

    public List<HashMap<String, String>> getPersonJobGradeData(Context ctx, String personID) throws BOSException, EASBizException {
        ArrayList<HashMap<String, String>> jobGradeList = new ArrayList<HashMap<String, String>>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(HistoryConstant.EFFDT));
        sic.add(new SelectorItemInfo(HistoryConstant.LEFFDT));
        sic.add(new SelectorItemInfo("jobGrade.name"));
        sic.add(new SelectorItemInfo("jobGrade.id"));
        viewInfo.setSelector(sic);
        SorterItemCollection sortCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo(HistoryConstant.EFFDT);
        sortInfo.setSortType(SortType.ASCEND);
        sortCollection.add(sortInfo);
        viewInfo.setSorter(sortCollection);
        EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance((Context)ctx).getEmpPostRankCollection(viewInfo);
        EmpPostRankInfo eprInfo = null;
        for (int i = 0; i < eprColl.size(); ++i) {
            HashMap preJob;
            eprInfo = eprColl.get(i);
            HashMap<String, String> record = new HashMap<String, String>();
            record.put("BDate", ServiceUtil.formatDate(eprInfo.getEFFDT()));
            record.put("EDate", ServiceUtil.formatDate(eprInfo.getLEFFDT()));
            String jg = "";
            if (eprInfo.getJobGrade() != null) {
                jg = eprInfo.getJobGrade().getName();
            }
            if (StringUtils.isEmpty((String)jg) && jobGradeList.size() == 0) continue;
            record.put("JobGrade", jg);
            if (jobGradeList.size() > 0 && jg.equals((preJob = (HashMap)jobGradeList.get(jobGradeList.size() - 1)).get("JobGrade"))) {
                preJob.put("EDate", ServiceUtil.formatDate(eprInfo.getLEFFDT()));
                continue;
            }
            jobGradeList.add(record);
        }
        return jobGradeList;
    }

    public List getJobGradeMap(Context ctx, String personID) throws BOSException, EASBizException {
        ArrayList jobGrade = new ArrayList();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        viewInfo.setFilter(filter);
        PersonPositionCollection ppc = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(viewInfo);
        if (ppc == null || ppc.size() == 0) {
            return jobGrade;
        }
        String ppID = ppc.get(0).getId().toString();
        viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(HistoryConstant.EFFDT));
        sic.add(new SelectorItemInfo(HistoryConstant.LEFFDT));
        sic.add(new SelectorItemInfo("jobGrade.name"));
        sic.add(new SelectorItemInfo("jobGrade.id"));
        viewInfo.setSelector(sic);
        SorterItemCollection sortCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo(HistoryConstant.EFFDT);
        sortInfo.setSortType(SortType.ASCEND);
        sortCollection.add(sortInfo);
        viewInfo.setSorter(sortCollection);
        List ppHisList = PersonPositionFactory.getLocalInstance((Context)ctx).getAllHisVersionReturnCurrentPaging((IObjectPK)new ObjectUuidPK(ppID), viewInfo, 0, 1000);
        for (int i = 0; i < ppHisList.size(); ++i) {
            HashMap preJob;
            PersonPositionInfo ppInfo = (PersonPositionInfo)ppHisList.get(i);
            HashMap<String, String> record = new HashMap<String, String>();
            record.put("BDate", ServiceUtil.formatDate(ppInfo.getEFFDT()));
            record.put("EDate", ServiceUtil.formatDate(ppInfo.getLEFFDT()));
            String jg = "";
            if (ppInfo.getJobGrade() != null) {
                jg = ppInfo.getJobGrade().getName();
            }
            if (StringUtils.isEmpty((String)jg) && jobGrade.size() == 0) continue;
            record.put("JobGrade", jg);
            if (jobGrade.size() > 0 && jg.equals((preJob = (HashMap)jobGrade.get(jobGrade.size() - 1)).get("JobGrade"))) {
                preJob.put("EDate", ServiceUtil.formatDate(ppInfo.getLEFFDT()));
                continue;
            }
            jobGrade.add(record);
        }
        return jobGrade;
    }

    public List getAssignMap(Context ctx, String personID) throws BOSException {
        ArrayList assignList = new ArrayList();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)new Integer(1)));
        view.setFilter(filter);
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        view.setSelector(helper.getSelector());
        SorterItemCollection sortCollection = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo(HistoryConstant.EFFDT);
        sortInfo.setSortType(SortType.ASCEND);
        sortCollection.add(sortInfo);
        view.setSorter(sortCollection);
        EmpPosOrgRelationCollection empposorgRelationColl = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
        for (int i = 0; i < empposorgRelationColl.size(); ++i) {
            HashMap<String, String> record = new HashMap<String, String>();
            record.put("BDate", ServiceUtil.formatDate(empposorgRelationColl.get(i).getEFFDT()));
            record.put("EDate", ServiceUtil.formatDate(empposorgRelationColl.get(i).getLEFFDT()));
            record.put("Position", empposorgRelationColl.get(i).getPosition().getName());
            record.put("Type", this.getAssignType(empposorgRelationColl.get(i).getAssignType()));
            assignList.add(record);
        }
        return assignList;
    }

    public List getSalaryData(Context ctx, String personID) throws BOSException {
        ArrayList result = new ArrayList();
        String selectSql = " select distinct FHisTableName from t_hr_cmpschemeperson cmpperson inner join t_hr_cmpscheme cmpscheme on cmpscheme.fid=cmpperson.fcmpschemeid  where fpersonid= ?  and cmpscheme.fenable=1 ";
        Object[] params = new Object[]{personID};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])params);
        HashMap recordMaps = new HashMap();
        try {
            while (rowSet.next()) {
                String FHisTableName = rowSet.getString("FHisTableName");
                if (StringUtils.isEmpty((String)FHisTableName)) continue;
                StringBuffer sql = new StringBuffer();
                sql.append("select sum(FSAL004) fsal004,period.fbegindate begindate,period.fenddate enddate from ").append(FHisTableName).append(" cmp ").append(" inner join t_hr_cmpperiod period on period.fid = cmp.fperiod ").append(" where cmp.fpersonid='").append(personID).append("'").append(" group by period.fbegindate,period.fenddate ");
                IRowSet periodResult = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (periodResult.next()) {
                    String begin = ServiceUtil.formatDate(periodResult.getDate("begindate"));
                    String end = ServiceUtil.formatDate(periodResult.getDate("enddate"));
                    HashMap<String, String> record = (HashMap<String, String>)recordMaps.get(begin + end);
                    if (record == null) {
                        record = new HashMap<String, String>();
                        result.add(record);
                        recordMaps.put(begin + end, record);
                        record.put("BDate", begin);
                        record.put("EDate", end);
                        record.put("Salaray", ServiceUtil.formatBigDecimal(periodResult.getBigDecimal("fsal004"), 2));
                        continue;
                    }
                    BigDecimal value = periodResult.getBigDecimal("fsal004");
                    value = value.add(new BigDecimal((String)record.get("Salaray")));
                    record.put("Salaray", ServiceUtil.formatBigDecimal(value, 2));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public List getPerfData(Context ctx, String personID) throws BOSException {
        ArrayList result = new ArrayList();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.objectID", (Object)personID));
        filter.getFilterItems().add(new FilterItemInfo("isApproved", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.evaluSolution.solutionType", (Object)new Integer(100)));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("targetEvaluScore"));
        sic.add(new SelectorItemInfo("modifiedScore"));
        sic.add(new SelectorItemInfo("solutionPeriod.assessPeriod.startDate"));
        sic.add(new SelectorItemInfo("solutionPeriod.assessPeriod.endDate"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.name"));
        sic.add(new SelectorItemInfo("isModified"));
        sic.add(new SelectorItemInfo("perfRank.name"));
        view.setSelector(sic);
        EvaluResultCollection evaluResultColl = EvaluResultFactory.getLocalInstance((Context)ctx).getEvaluResultCollection(view);
        EvaluResultInfo info = null;
        for (int i = 0; i < evaluResultColl.size(); ++i) {
            HashMap<String, String> record = new HashMap<String, String>();
            info = evaluResultColl.get(i);
            record.put("BDate", ServiceUtil.formatDate(info.getSolutionPeriod().getAssessPeriod().getStartDate()));
            record.put("EDate", ServiceUtil.formatDate(info.getSolutionPeriod().getAssessPeriod().getEndDate()));
            if (info.isIsModified()) {
                record.put("perfScore", ServiceUtil.formatBigDecimal(info.getModifiedScore(), 2));
            } else {
                record.put("perfScore", ServiceUtil.formatBigDecimal(info.getTargetEvaluScore(), 2));
            }
            String perform = "";
            if (info.getPerfRank() != null) {
                perform = info.getPerfRank().getName();
            }
            record.put("Perform", perform);
            record.put("solutionName", info.getSolutionPeriod().getEvaluSolution().getName());
            result.add(record);
        }
        return result;
    }

    public String getAssignType(AssignTypeEnum type) {
        if (AssignTypeEnum.MAIN.equals((Object)type)) {
            return "M";
        }
        return "A";
    }
}

