/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.output;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.UniqueID;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.service.FactOutPutConfigCollection;
import com.kingdee.eas.hr.service.FactOutPutConfigFactory;
import com.kingdee.eas.hr.service.FactOutPutConfigInfo;
import com.kingdee.eas.hr.service.app.output.SelectParam;
import com.kingdee.eas.hr.service.app.output.SelectParseParam;
import com.kingdee.eas.hr.service.app.output.WhereGeneratorHelper;
import com.kingdee.eas.hr.service.app.solid.ObjectLinkProperty;
import com.kingdee.eas.hr.service.app.solid.SolidUtil;
import com.kingdee.util.StringUtils;
import java.util.HashSet;

public class SelectSqlGenerator {
    Context ctx = null;
    SelectParam selectParam = null;
    SelectParseParam parseParam = new SelectParseParam();
    EntityObjectInfo mainInfo = null;
    private final UniqueID aliasIndex;
    HashSet<String> selectSet = new HashSet();
    HashSet<String> filterSet = new HashSet();
    HashSet<String> sortSet = new HashSet();

    public SelectSqlGenerator(Context ctx, SelectParam param) {
        this.selectParam = param;
        this.aliasIndex = new UniqueID(0L);
        this.ctx = ctx;
        this.mainInfo = SolidUtil.getTargetObject(ctx, this.selectParam.getMainFact());
    }

    public SelectParseParam parseSelect() {
        FilterInfo filter = null;
        try {
            int i;
            filter = new FilterInfo(this.selectParam.getWhereStr());
            String[] selectStrs = this.selectParam.getSelectStr().split(",");
            this.parseParam.setSelectorStr(selectStrs);
            SorterItemCollection sorter = new SorterItemCollection();
            if (!StringUtils.isEmpty((String)this.selectParam.getSorterStr())) {
                sorter = new SorterItemCollection(this.selectParam.getSorterStr());
            }
            HashSet<String> outputfilterSet = new HashSet<String>();
            for (String each : selectStrs) {
                outputfilterSet.add(each.trim().toLowerCase());
                this.selectSet.add(each.trim().toLowerCase());
            }
            for (i = 0; i < filter.getFilterItems().size(); ++i) {
                outputfilterSet.add(filter.getFilterItems().get(i).getPropertyName().toLowerCase());
                this.filterSet.add(filter.getFilterItems().get(i).getPropertyName().toLowerCase());
            }
            for (i = 0; i < sorter.getSorter().size(); ++i) {
                outputfilterSet.add(sorter.getSorter().get(i).getPropertyName().toLowerCase());
                this.sortSet.add(filter.getFilterItems().get(i).getPropertyName().toLowerCase());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("outputName", outputfilterSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            FactOutPutConfigCollection coll = FactOutPutConfigFactory.getLocalInstance(this.ctx).getFactOutPutConfigCollection(view);
            this.selectParam.setOutPutColl(coll);
        }
        catch (ParserException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        try {
            this.parse();
            WhereGeneratorHelper whereHelper = new WhereGeneratorHelper();
            this.parseParam.setWhereParseStr(whereHelper.getWhereClause(this.ctx, this.parseParam, filter));
        }
        catch (InvalidDAOMetaDataException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return this.parseParam;
    }

    private void parse() throws InvalidDAOMetaDataException {
        FactOutPutConfigInfo configInfo = null;
        this.getTableAlias(this.mainInfo, "id");
        for (int i = 0; i < this.selectParam.getOutPutColl().size(); ++i) {
            configInfo = this.selectParam.getOutPutColl().get(i);
            PropertyInfo sourceProperty = null;
            if (StringUtils.isEmpty((String)configInfo.getSourceField())) continue;
            EntityObjectInfo tempSource = SolidUtil.getTargetObject(this.ctx, configInfo.getType());
            sourceProperty = SolidUtil.getPropertyByName(tempSource, configInfo.getSourceField());
            String sourceFieldName = sourceProperty.getMappingField().getName();
            if (sourceProperty.getMappingField().isMultilingual()) {
                sourceFieldName = sourceFieldName + "_" + this.ctx.getLocale().getDisplayName();
            }
            this.appendSelect(sourceFieldName, this.getTableAlias(tempSource, configInfo.getSourceField()), configInfo.getOutputName());
            this.parseParam.getFilePropertyMappings().put(configInfo.getOutputName().trim().toLowerCase(), sourceProperty);
        }
    }

    String getTableAlias(EntityObjectInfo base, String columnName) throws InvalidDAOMetaDataException {
        String alias;
        if (StringUtils.isEmpty((String)columnName)) {
            return "";
        }
        boolean specialProcess = false;
        if (!base.getName().equals(this.mainInfo.getName())) {
            specialProcess = true;
            if (this.parseParam.getTableMappings().get(base.getName()) == null) {
                alias = "t" + this.aliasIndex.next();
                this.parseParam.getTableMappings().put(base.getName(), alias);
                String boTableAlias = this.parseParam.getTableMappings().get(this.mainInfo.getName());
                PropertyInfo linkProperty = SolidUtil.getJoinColumn(this.mainInfo, base);
                this.parseParam.getFromParseStr().append(" left join ").append(base.getTable().getName()).append(" as ").append(alias).append("  on  ").append("\"").append(boTableAlias).append("\"").append(".").append(linkProperty.getMappingField().getName()).append(" = ").append("\"").append(alias).append("\"").append(".").append(SolidUtil.getJoinColumn(base).getMappingField().getName());
            }
        }
        if (columnName.indexOf(".") >= 0) {
            String[] splits = columnName.split("\\.");
            StringBuffer path = new StringBuffer();
            StringBuffer pre = new StringBuffer();
            for (int i = 0; i < splits.length - 1; ++i) {
                if (path.length() > 0) {
                    path.append(".");
                }
                path.append(splits[i]);
                if (this.parseParam.getTableMappings().get(path.toString()) == null) {
                    String alias2 = "t" + this.aliasIndex.next();
                    this.parseParam.getTableMappings().put(path.toString(), alias2);
                    ObjectLinkProperty link = SolidUtil.getLinkObjectRelationInfoByName(base, path.toString());
                    String boTableAlias = null;
                    boTableAlias = StringUtils.isEmpty((String)pre.toString()) ? this.parseParam.getTableMappings().get(base.getName()) : this.parseParam.getTableMappings().get(pre.toString());
                    this.parseParam.getFromParseStr().append(" left join ").append(link.getChildObj().getTable().getName()).append(" as ").append(alias2).append("  on  ").append("\"").append(boTableAlias).append("\"").append(".").append(link.getLinkProperty().getMappingField().getName()).append(" = ").append("\"").append(alias2).append("\"").append(".").append(SolidUtil.getJoinColumn(link.getParentObj()).getMappingField().getName());
                }
                pre = new StringBuffer(path);
            }
            return this.parseParam.getTableMappings().get(path.toString());
        }
        if (this.parseParam.getTableMappings().get(base.getName()) == null) {
            alias = "t" + this.aliasIndex.next();
            this.parseParam.getTableMappings().put(base.getName(), alias);
            this.parseParam.getFromParseStr().append(base.getTable().getName()).append(" as ").append(alias).append(" ");
        }
        return this.parseParam.getTableMappings().get(base.getName());
    }

    private void appendSelect(String sourceField, String sourceTableAlias, String alias) {
        String tempFieldName = "\"" + sourceTableAlias + "\"." + sourceField;
        this.parseParam.getFileMappings().put(alias, tempFieldName);
        if (!this.selectSet.contains(alias)) {
            return;
        }
        if (this.parseParam.getSelectParseStr().length() > 0) {
            this.parseParam.getSelectParseStr().append(" ,");
        }
        this.parseParam.getSelectParseStr().append(tempFieldName).append(" as ").append(alias);
    }
}

