/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.app.EmpPosOrgRelationQueryHelper;
import com.kingdee.eas.hr.service.app.service.ServiceUtils;
import com.kingdee.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PersonPositionReportService
implements IHRMsfService {
    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String personID = (String)param.get("personID");
        Date appointDate = DateTimeUtils.truncateDate((Date)new Date());
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        EmpPosOrgRelationQueryHelper helper = new EmpPosOrgRelationQueryHelper();
        EmpPosOrgRelationCollection empPos = helper.getAppointDateActivePrimaryPosition(ctx, personID, appointDate);
        PositionInfo pInfo = null;
        if (empPos == null || empPos.size() <= 0) {
            return result;
        }
        pInfo = empPos.get(0).getPosition();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("adminorgunit.name"));
        sic.add(new SelectorItemInfo("adminorgunit.id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.adminorgunit.name"));
        sic.add(new SelectorItemInfo("parent.adminorgunit.id"));
        sic.add(new SelectorItemInfo("parent.name"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pInfo.getId().toString()));
        filter.setMaskString("#0 or #1");
        view.setFilter(filter);
        PositionCollection pColl = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(view);
        PositionInfo parent = null;
        HashSet<String> pSet = new HashSet<String>();
        for (int i = 0; i < pColl.size(); ++i) {
            if (pInfo.getId().equals((Object)pColl.get(i).getId()) && (parent = (pInfo = pColl.get(i)).getParent()) != null) {
                pSet.add(parent.getId().toString());
            }
            pSet.add(pColl.get(i).getId().toString());
        }
        HashMap<String, HashMap<String, String>> pPersonMap = ServiceUtils.getPositionsPersonStr(ctx, pSet, appointDate);
        for (int i = 0; i < pColl.size(); ++i) {
            PositionInfo positionInfo = pColl.get(i);
            this.storePositionRefInfo(pPersonMap, result, positionInfo);
        }
        this.storePositionRefInfo(pPersonMap, result, parent);
        return result;
    }

    private void storePositionRefInfo(HashMap<String, HashMap<String, String>> pPersonMap, List<HashMap<String, String>> result, PositionInfo positionInfo) {
        if (positionInfo == null) {
            return;
        }
        HashMap<String, String> each = new HashMap<String, String>();
        each.put("posid", positionInfo.getId().toString());
        each.put("posnm", positionInfo.getName());
        String parentid = "";
        if (positionInfo.getParent() != null) {
            parentid = positionInfo.getParent().getId().toString();
        }
        each.put("jpare", parentid);
        HashMap<String, String> pPersons = pPersonMap.get(positionInfo.getId().toString());
        String personids = "";
        String personNames = "";
        if (pPersons != null) {
            personids = pPersons.get("personID");
            personNames = pPersons.get("personName");
        }
        each.put("perids", personids);
        each.put("pernames", personNames);
        each.put("admid", positionInfo.getAdminOrgUnit().getId().toString());
        each.put("adnam", positionInfo.getAdminOrgUnit().getName());
        result.add(each);
    }
}

