/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.service.mcloud;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.service.MCloudSynLogDetailCollection;
import com.kingdee.eas.hr.service.MCloudSynLogDetailInfo;
import com.kingdee.eas.hr.service.MCloudSynLogFactory;
import com.kingdee.eas.hr.service.MCloudSynLogInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IntergrationMCloudService
implements IHRMsfService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.service.app.service.mcloud.IntergrationMCloudService");

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String responseBody = (String)param.get("response");
        logger.info((Object)("response str = " + responseBody));
        try {
            responseBody = URLDecoder.decode(responseBody, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String action = (String)param.get("action");
        logger.info((Object)("action=" + action + "---response str = " + responseBody));
        action = action.trim();
        boolean isSuccess = this.processResponse(ctx, responseBody, action);
        return isSuccess;
    }

    private boolean processResponse(Context ctx, String responseBody, String action) throws BOSException {
        if (StringUtils.isEmpty((String)responseBody)) {
            return false;
        }
        HashMap responseMap = null;
        try {
            responseMap = JSONUtils.convertJsonToObject((Context)ctx, (String)responseBody);
        }
        catch (Exception e) {
            logger.error((Object)(action + " reseponse error" + responseBody));
            return false;
        }
        if (responseMap == null) {
            return false;
        }
        MCloudSynLogInfo logInfo = new MCloudSynLogInfo();
        logInfo.setError((String)responseMap.get("error"));
        logInfo.setOptTime(new Timestamp(System.currentTimeMillis()));
        logInfo.setOptType(action);
        if (responseMap.get("success") != null) {
            logInfo.setSuccess((Boolean)responseMap.get("success"));
        } else if (logInfo.getError() != null) {
            logInfo.setSuccess(false);
        }
        if (responseMap.get("errorCode") != null) {
            logInfo.setErrorCode(((Double)responseMap.get("errorCode")).intValue());
        }
        Object data = responseMap.get("data");
        List listData = null;
        if (data instanceof Map) {
            listData = (List)((Map)data).get("orgList");
        } else if (data instanceof List) {
            listData = (List)data;
        }
        HashMap<String, String> addPersonMap = new HashMap<String, String>();
        HashSet<String> delPersonSet = new HashSet<String>();
        HashSet<String> updateOrg = new HashSet<String>();
        HashSet<String> deleOrg = new HashSet<String>();
        ArrayList<HashMap<String, String>> responeDataList = new ArrayList<HashMap<String, String>>();
        ArrayList<HashMap<String, String>> updatePerDataList = new ArrayList<HashMap<String, String>>();
        HashSet<String> successSet = new HashSet<String>();
        successSet.add("100");
        successSet.add("209");
        successSet.add("202");
        successSet.add("204");
        successSet.add("205");
        successSet.add("213");
        successSet.add("214");
        successSet.add("222");
        if (listData != null) {
            MCloudSynLogDetailCollection c = new MCloudSynLogDetailCollection();
            MCloudSynLogDetailInfo detailInfo = null;
            for (int i = 0; i < listData.size(); ++i) {
                Map eachMap = (Map)listData.get(i);
                Object obj = eachMap.get("msgCode");
                String key = "";
                if (obj instanceof Integer) {
                    key = obj.toString();
                } else if (obj instanceof Double) {
                    key = "" + ((Double)obj).intValue();
                } else if (obj != null) {
                    key = obj.toString();
                }
                if ("person/get".equals(action) || "person/getall".equals(action)) {
                    Object obj2 = eachMap.get("status");
                    String state = "";
                    if (obj2 instanceof Integer) {
                        state = obj2.toString();
                    } else if (obj2 instanceof Double) {
                        state = "" + ((Double)obj2).intValue();
                    } else if (obj2 != null) {
                        state = obj2.toString();
                    }
                    if (!"1".equals(state)) {
                        logger.info((Object)((String)eachMap.get("name") + " state is null"));
                        continue;
                    }
                    HashMap<String, String> node = new HashMap<String, String>();
                    node.put("name", (String)eachMap.get("name"));
                    node.put("openId", (String)eachMap.get("openId"));
                    node.put("email", (String)eachMap.get("email"));
                    node.put("orgname", (String)eachMap.get("department"));
                    node.put("phone", (String)eachMap.get("phone"));
                    responeDataList.add(node);
                } else if (successSet.contains(key)) {
                    if ("person/delete".equals(action)) {
                        delPersonSet.add((String)eachMap.get("msgId"));
                    } else if ("dept/update".equals(action) || "dept/add".equals(action)) {
                        updateOrg.add((String)eachMap.get("msgId"));
                    } else if ("dept/delete".equals(action)) {
                        deleOrg.add((String)eachMap.get("msgId"));
                    }
                } else if ("person/getAtTime".equals(action)) {
                    HashMap<String, String> updatenode = new HashMap<String, String>();
                    updatenode.put("name", (String)eachMap.get("name"));
                    updatenode.put("openId", (String)eachMap.get("openId"));
                    updatenode.put("email", (String)eachMap.get("email"));
                    updatenode.put("orgname", (String)eachMap.get("department"));
                    updatenode.put("phone", (String)eachMap.get("phone"));
                    updatePerDataList.add(updatenode);
                }
                detailInfo = new MCloudSynLogDetailInfo();
                detailInfo.setParent(logInfo);
                detailInfo.setObjId((String)eachMap.get("id"));
                detailInfo.setName((String)eachMap.get("name"));
                detailInfo.setMsg((String)eachMap.get("msg"));
                Object msgCode = obj;
                if (msgCode != null) {
                    if (msgCode instanceof Double) {
                        detailInfo.setMsgCode(((Double)msgCode).intValue());
                    }
                    if (msgCode instanceof Integer) {
                        detailInfo.setMsgCode((Integer)msgCode);
                    }
                }
                c.add(detailInfo);
            }
            logInfo.setDetail(c);
        }
        try {
            MCloudSynLogFactory.getLocalInstance(ctx).addnew(logInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        logger.info((Object)("-----------------person/update size =" + addPersonMap.size()));
        this.processAddXtUserMap(ctx, addPersonMap);
        this.processDelXtUserMap(ctx, delPersonSet);
        this.processUpdateXtUserMap(ctx, updatePerDataList);
        this.processDelXtOrgMap(ctx, deleOrg);
        this.processUpdateXtOrg(ctx, updateOrg);
        this.processMapUser(ctx, responeDataList);
        return logInfo.isSuccess() || "106".equals(logInfo.getErrorCode());
    }

    private void processMapUser(Context ctx, List<HashMap<String, String>> responeDataList) throws BOSException {
        logger.info((Object)"into processMapUser");
        if (responeDataList == null || responeDataList.size() == 0) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int i = 0; i < responeDataList.size(); ++i) {
            HashMap<String, String> xtUserNode = responeDataList.get(i);
            String phone = xtUserNode.get("phone");
            String name = xtUserNode.get("name");
            String email = xtUserNode.get("email");
            Object[] obj = new Object[]{phone, name, email, name};
            paramList.add(obj);
        }
        ArrayList<Object[]> insertParam = new ArrayList<Object[]>();
        ArrayList<Object[]> deleParam = new ArrayList<Object[]>();
        logger.info((Object)("person phone s =" + responeDataList.toString()));
        String l = LocaleUtils.getShortCode((Context)ctx);
        for (int i = 0; i < paramList.size(); ++i) {
            Object[] params = (Object[])paramList.get(i);
            String personSql = "select person.fid fid,person.fcell fcell,person.femail femail,xt.fopenid fopenid,xt.fname xname,xt.femail xemail,xt.fphone xphone,xt.forgname xorgname,person.fname_" + l + " fname from t_bd_person person  left join t_bd_hrxuntusermapping xt on xt.fpersonid=person.fid  left join T_HR_BDEmployeeType empType on empType.fid=person.FEmployeeTypeID where empType.FIsInCount=1 and (person.fcell=? and person.fname_" + l + "=?) or (person.femail=? and person.fname_" + l + "=?)";
            IRowSet personSet = DbUtil.executeQuery((Context)ctx, (String)personSql, (Object[])params);
            try {
                while (personSet.next()) {
                    String fid = personSet.getString("fid");
                    String phone = personSet.getString("fcell") == null ? "" : personSet.getString("fcell");
                    String emial = personSet.getString("femail") == null ? "" : personSet.getString("femail");
                    String name = personSet.getString("fname") == null ? "" : personSet.getString("fname");
                    String xname = personSet.getString("xname") == null ? "" : personSet.getString("xname");
                    String xemail = personSet.getString("xemail") == null ? "" : personSet.getString("xemail");
                    String xphone = personSet.getString("xphone") == null ? "" : personSet.getString("xphone");
                    String xorgname = personSet.getString("xorgname") == null ? "" : personSet.getString("xorgname");
                    String fopenid = personSet.getString("fopenid");
                    String xtopenid = "";
                    String xtphone = "";
                    String xtname = "";
                    String xtemail = "";
                    String xtorgName = "";
                    for (int k = 0; k < responeDataList.size(); ++k) {
                        HashMap<String, String> xtUserNode = responeDataList.get(k);
                        xtphone = xtUserNode.get("phone");
                        xtname = xtUserNode.get("name");
                        xtemail = xtUserNode.get("email");
                        xtorgName = xtUserNode.get("orgname");
                        if ((!phone.equalsIgnoreCase(xtphone) || !name.equalsIgnoreCase(xtname)) && ("".equals(emial) || !emial.equalsIgnoreCase(xtemail) || !name.equalsIgnoreCase(xtname))) continue;
                        xtopenid = xtUserNode.get("openId");
                        break;
                    }
                    if ("".equalsIgnoreCase(xtopenid) || xtopenid.equals(fopenid) && xname.equalsIgnoreCase(xtname) && xphone.equalsIgnoreCase(xtphone) && xemail.equalsIgnoreCase(xtemail) && xorgname.equalsIgnoreCase(xtorgName)) continue;
                    if (StringUtils.isEmpty((String)fopenid)) {
                        Object[] add = new Object[]{fid, xtopenid, new Timestamp(new Date().getTime()), xtname, xtemail, xtphone, xtorgName};
                        insertParam.add(add);
                        continue;
                    }
                    Object[] del = new Object[]{fopenid};
                    deleParam.add(del);
                    Object[] add = new Object[]{fid, xtopenid, new Timestamp(new Date().getTime()), xtname, xtemail, xtphone, xtorgName};
                    insertParam.add(add);
                }
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        String deleteXtSql = "delete from  t_bd_hrxuntusermapping where fopenId= ? ";
        if (deleParam.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)deleteXtSql, deleParam);
        }
        String insertXtSql = " insert into t_bd_hrxuntusermapping(fpersonid,Fopenid,fcreatetime,fname,femail,fphone,forgname) values (?,?,?,?,?,?,?) ";
        if (insertParam.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)insertXtSql, insertParam);
        }
    }

    private void processUpdateXtOrg(Context ctx, HashSet<String> updateOrg) throws BOSException {
        String updateSql = "update t_bd_hrxuntorgmapping set FLastOrgKey = FCurrentOrgKey where FLastOrgKey = ?  or FCurrentOrgKey = ? ";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String orgKey : updateOrg) {
            Object[] para = new Object[]{orgKey, orgKey};
            params.add(para);
        }
        if (params.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSql, params);
        }
    }

    private void processDelXtOrgMap(Context ctx, HashSet<String> deleOrg) throws BOSException {
        String deleteSql = "delete from t_bd_hrxuntorgmapping  where FLastOrgKey = ? ";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String orgKey : deleOrg) {
            logger.info((Object)("origin key=" + orgKey));
            orgKey = orgKey.replace("\\\\", "\\");
            logger.info((Object)("replace origin key=" + orgKey));
            Object[] para = new Object[]{orgKey};
            params.add(para);
        }
        if (params.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)deleteSql, params);
        }
    }

    private void processDelXtUserMap(Context ctx, HashSet<String> delPersonSet) throws BOSException {
        if (delPersonSet == null || delPersonSet.size() == 0) {
            return;
        }
        Object[] arr = delPersonSet.toArray();
        StringBuffer sb = new StringBuffer();
        for (Object o : arr) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("'").append(o.toString()).append("'");
        }
        String deleSql = "delete from t_bd_hrxuntusermapping where fopenid in(" + sb.toString() + ")";
        DbUtil.execute((Context)ctx, (String)deleSql);
    }

    private void processUpdateXtUserMap(Context ctx, List<HashMap<String, String>> updatePerDataList) throws BOSException {
        if (updatePerDataList == null || updatePerDataList.size() == 0) {
            return;
        }
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (int i = 0; i < updatePerDataList.size(); ++i) {
            HashMap<String, String> xtUserNode = updatePerDataList.get(i);
            String phone = xtUserNode.get("phone");
            String name = xtUserNode.get("name");
            String email = xtUserNode.get("email");
            String orgname = xtUserNode.get("orgname");
            String openid = xtUserNode.get("openId");
            Object[] obj = new Object[]{phone, name, email, orgname, openid};
            paramList.add(obj);
        }
        String updateSql = "update t_bd_hrxuntusermapping set fphone=?,fname=?,femail=?,forgname=? where fopenid=?";
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
    }

    private void processAddXtUserMap(Context ctx, HashMap<String, String> addPersonMap) throws BOSException {
        logger.info((Object)"into processAddXtUserMap");
        if (addPersonMap == null || addPersonMap.size() == 0) {
            return;
        }
        Iterator<Map.Entry<String, String>> it = addPersonMap.entrySet().iterator();
        StringBuffer ids = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (ids.length() > 0) {
                ids.append(",");
            }
            ids.append("'").append(entry.getKey().toString()).append("'");
        }
        logger.info((Object)("addxtuser openids =" + ids.toString()));
        String selectSql = "select fpersonid,fopenid from t_bd_hrxuntusermapping where fopenid in(" + ids.toString() + ")";
        StringBuffer persons = new StringBuffer();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        try {
            while (rowSet.next()) {
                addPersonMap.remove(rowSet.getString("fopenid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (addPersonMap.size() == 0) {
            return;
        }
        it = addPersonMap.entrySet().iterator();
        StringBuffer phones = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (phones.length() > 0) {
                phones.append(",");
            }
            phones.append("'").append(entry.getValue().toString()).append("'");
        }
        logger.info((Object)("person phone s =" + phones.toString()));
        String personSql = "select person.fid,fcell from t_bd_person person inner join T_HR_BDEmployeeType empType on person.FEmployeeTypeID=empType.fid where empType.FIsInCount=1 and fcell in(" + phones.toString() + ")";
        IRowSet personSet = DbUtil.executeQuery((Context)ctx, (String)personSql);
        HashMap<String, String> phonePersonMap = new HashMap<String, String>();
        try {
            while (personSet.next()) {
                phonePersonMap.put(personSet.getString("fcell"), personSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (Map.Entry<String, String> entry : addPersonMap.entrySet()) {
            String personId = (String)phonePersonMap.get(entry.getValue().toString());
            if (StringUtils.isEmpty((String)personId)) continue;
            Object[] param = new Object[]{personId, entry.getKey().toString(), new Timestamp(new Date().getTime())};
            params.add(param);
            if (persons.length() > 0) {
                persons.append(",");
            }
            persons.append("'").append(personId).append("'");
        }
        String insertXtMap = " insert into t_bd_hrxuntusermapping(fpersonid,Fopenid,fcreatetime) values (?,?,?) ";
        if (params.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)insertXtMap, params);
        }
        logger.info((Object)("persons=" + persons.toString()));
        String updateSql = "update t_bd_hrxuntorgmapping set FLastOrgKey = FCurrentOrgKey  where fadminorgunitid in( select fpersondep from t_hr_personposition  where fpersonid in(" + persons.toString() + "))";
        if (persons.length() > 0) {
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }
}

