/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.solid;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.service.FactTypeEnum;
import com.kingdee.eas.hr.service.SolidFildConfigCollection;
import com.kingdee.eas.hr.service.app.SolidConstants;
import com.kingdee.eas.hr.service.app.solid.InsertParam;
import com.kingdee.eas.hr.service.app.solid.SelectSqlParam;
import com.kingdee.eas.hr.service.app.solid.SolidSelectHelper;
import com.kingdee.eas.hr.service.app.solid.SolidUtil;
import com.kingdee.eas.hr.service.app.solid.TreeStructureSaveHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.axis.utils.StringUtils;

public class SolidAdminTable {
    public void solidStructureTable(Context ctx) throws EASBizException, BOSException {
        this.solidByIDSetAndDate(ctx, null, new Date());
    }

    public void solidByIDSetAndDate(Context ctx, HashSet<String> adminIDSet, Date date) throws BOSException {
        String whereStr = SolidUtil.setToStringFilter(adminIDSet);
        SolidSelectHelper selectHelper = new SolidSelectHelper();
        SelectSqlParam selectParam = selectHelper.getSelectSql(ctx, FactTypeEnum.ADMIN);
        String deleteSql = "delete from " + selectParam.getTargetInfo().getTable().getName();
        if (!StringUtils.isEmpty((String)whereStr)) {
            deleteSql = deleteSql + " where fadminorgunitid in(" + whereStr + ")";
        }
        DbUtil.execute((Context)ctx, (String)deleteSql);
        StringBuffer valuesStr = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(selectParam.getTargetInfo().getTable().getName());
        sql.append(" (");
        StringBuffer columsStr = new StringBuffer();
        columsStr.append("fid");
        valuesStr.append("?");
        SolidFildConfigCollection coll = selectParam.getConfigColl();
        EntityObjectInfo target = selectParam.getTargetInfo();
        InsertParam insertParam = SolidUtil.generateInsertColumns(selectParam.getConfigColl(), selectParam.getTargetInfo());
        columsStr.append(",").append(insertParam.getColumnStr());
        valuesStr.append(",").append(insertParam.getValuesStr());
        for (int parentLevelIndex = 0; parentLevelIndex < SolidConstants.maxParanetNodeLevel; ++parentLevelIndex) {
            columsStr.append(",");
            columsStr.append(target.getPropertyByNameRuntime("org" + (parentLevelIndex + 1)).getMappingField().getName());
            valuesStr.append(",").append(" ? ");
        }
        columsStr.append(",").append("FPLANCOUNT");
        valuesStr.append(",").append(" ? ");
        columsStr.append(",").append("FACTUALCOUNT");
        valuesStr.append(",").append(" ? ");
        columsStr.append(",").append("FPRINCIPALID");
        valuesStr.append(",").append(" ? ");
        sql.append(columsStr.toString().toUpperCase());
        sql.append(")");
        sql.append(" values ").append("(");
        sql.append(valuesStr);
        sql.append(")");
        String[] columns = columsStr.toString().toUpperCase().split(",");
        String[] parentColumns = new String[SolidConstants.maxParanetNodeLevel];
        for (int i = 0; i < parentColumns.length; ++i) {
            parentColumns[i] = selectParam.getTargetInfo().getPropertyByNameRuntime(SolidConstants.orgPre + (i + 1)).getMappingField().getName().toUpperCase();
        }
        HashMap nodeMap = null;
        HashMap positionMap = this.getPositionCount(ctx, whereStr);
        HashMap<String, String> principleMap = this.getPrinciple(ctx, whereStr);
        HashMap nodeParent = new HashMap();
        TreeStructureSaveHelper helper = new TreeStructureSaveHelper();
        List nodeInfos = helper.getNodeAllParent(ctx, nodeParent, selectParam, whereStr);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        String adminNodeId = "FADMINORGUNITID";
        for (int nodeIndex = 0; nodeIndex < nodeInfos.size(); ++nodeIndex) {
            nodeMap = (HashMap)nodeInfos.get(nodeIndex);
            Object[] objs = new Object[columns.length];
            objs[0] = BOSUuid.create((BOSObjectType)selectParam.getTargetInfo().getType()).toString();
            String[] parent = (String[])nodeParent.get(nodeMap.get(adminNodeId).toString());
            for (int parentIndex = 0; parentIndex < SolidConstants.maxParanetNodeLevel; ++parentIndex) {
                nodeMap.put(parentColumns[parentIndex], parent[parentIndex]);
            }
            Integer[] counts = (Integer[])positionMap.get(nodeMap.get(adminNodeId).toString());
            if (counts != null) {
                nodeMap.put("FACTUALCOUNT", counts[0]);
                nodeMap.put("FPLANCOUNT", counts[1]);
            }
            nodeMap.put("FPRINCIPALID", principleMap.get(nodeMap.get(adminNodeId).toString()));
            for (int columnIndex = 1; columnIndex < columns.length; ++columnIndex) {
                objs[columnIndex] = nodeMap.get(columns[columnIndex].toString());
            }
            paramsList.add(objs);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
    }

    private HashMap<String, String> getPrinciple(Context ctx, String whereStr) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        String dateFilter = SolidUtil.getValueStringOnly(new Timestamp(DateTimeUtils.truncateDate((Date)new Date()).getTime()));
        String selectSql = " select relation.fpersonid fpersonid,admin.fid fadminorgunitid from  t_hr_emporgrelation  relation  inner join t_org_admin admin on admin.FResponPositionID = relation.fpositionid where relation.FAssignType =1 and relation.FEFFDT  <=  " + dateFilter + " and  relation.FLEFFDT  >  " + dateFilter;
        if (!StringUtils.isEmpty((String)whereStr)) {
            selectSql = selectSql + " and admin.fid in (" + whereStr + ")";
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        try {
            while (rowSet.next()) {
                result.put(rowSet.getString("fadminorgunitid"), rowSet.getString("fpersonid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private HashMap getPositionCount(Context ctx, String whereStr) throws BOSException {
        HashMap<String, Integer[]> positionCount = new HashMap<String, Integer[]>();
        String selectCount = " select sum(FPositionCount) FActualCount,sum(FPosPlanCount) fplancount,fadminorgunitid from t_hr_positionfact ";
        if (!StringUtils.isEmpty((String)whereStr)) {
            selectCount = selectCount + " where fadminorgunitid in(" + whereStr + ")";
        }
        selectCount = selectCount + " group by fadminorgunitid ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectCount);
        try {
            while (rowSet.next()) {
                Integer[] counts = new Integer[]{new Integer(rowSet.getInt("FActualCount")), new Integer(rowSet.getInt("fplancount"))};
                positionCount.put(rowSet.getString("fadminorgunitid"), counts);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return positionCount;
    }
}

