/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.service.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;

public class MobilePagingHelper {
    public static IRowSet getPagingRowSet(Context ctx, Map param, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        int totalCount = -1;
        if (param.get("totalCount") != null) {
            totalCount = Integer.parseInt((String)param.get("totalCount"));
        }
        String startStr = (String)param.get("startRows");
        String rowStr = (String)param.get("topCount");
        int start = 0;
        if (!StringUtils.isEmpty((String)startStr)) {
            start = Integer.valueOf(startStr);
        }
        int length = 10;
        if (!StringUtils.isEmpty((String)rowStr)) {
            length = Integer.valueOf(rowStr);
        }
        if (start + length > totalCount) {
            length = totalCount - start;
        }
        int top = start + length;
        int orderByIndex = sql.toLowerCase().indexOf("order by");
        String orderby = "";
        if (orderByIndex > 0) {
            orderby = sql.substring(orderByIndex);
            sql = sql.substring(0, orderByIndex);
        }
        String pagingSql = "SELECT TOP " + top + " * from (" + sql + ") T";
        if (!StringUtils.isEmpty((String)orderby)) {
            pagingSql = pagingSql + " " + orderby;
        }
        PagingHelper pageHelper = new PagingHelper();
        Connection conn = null;
        ResultSet rset = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pagingSql = pageHelper.getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), pagingSql, start, length);
            stmt = conn.prepareStatement(pagingSql);
            rset = stmt.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rset);
            jdbcRowSet = rowset;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rset, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rset, (Statement)stmt, (Connection)conn);
        return jdbcRowSet;
    }
}

