/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.standby.IStandbyPerson;
import com.kingdee.eas.hr.standby.StandBySelectEntryFactory;
import com.kingdee.eas.hr.standby.StandBySelectEntryInfo;
import com.kingdee.eas.hr.standby.StandBySelectInfo;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyPersonCollection;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.app.AbstractStandBySelectControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StandBySelectControllerBean
extends AbstractStandBySelectControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.standby.app.StandBySelectControllerBean");

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        StandBySelectEntryInfo selectEntryInfo = (StandBySelectEntryInfo)entry;
        PersonInfo person = selectEntryInfo.getPerson();
        StandbyPersonInfo stdPerson = new StandbyPersonInfo();
        stdPerson.setEmployee(person);
        stdPerson.setStandbyType(selectEntryInfo.getStandByType());
        PositionInfo ppInfo = (PositionInfo)selectEntryInfo.get("targetpostion");
        if (ppInfo != null) {
            stdPerson.setToPosition(ppInfo);
        }
        stdPerson.setToUnit(selectEntryInfo.getTargetAdminOrg());
        stdPerson.setToStandbyReason(selectEntryInfo.getApplyReason());
        stdPerson.setIsStandby(1);
        stdPerson.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        stdPerson.setToPositionDate(selectEntryInfo.getToPositionDate());
        stdPerson.setStartTime(selectEntryInfo.getStartDate());
        stdPerson.setToStandbyAudit(selectEntryInfo.getAuditResult());
        IStandbyPerson standbyPerson = StandbyPersonFactory.getLocalInstance(ctx);
        standbyPerson.addnew((CoreBaseInfo)stdPerson);
        super._entryEffect(ctx, entry);
    }

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.standby.app.StandBySelectEditUIFunction";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return StandBySelectEntryFactory.getLocalInstance(ctx);
    }

    protected Map _getStandbyPersonNum(Context ctx, Set personIdSet) throws BOSException, EASBizException {
        HashMap<String, Integer> personNum = new HashMap<String, Integer>();
        StringBuffer sql = new StringBuffer();
        if (personIdSet == null || personIdSet != null && personIdSet.size() <= 0) {
            return personNum;
        }
        Iterator iterator = personIdSet.iterator();
        StringBuffer ids = new StringBuffer();
        while (iterator.hasNext()) {
            ids.append("'").append(iterator.next()).append("',");
        }
        String personIds = ids.substring(0, ids.length() - 1);
        sql.append("select FEmployeeID,count(FEmployeeID)  from T_HR_StandbyPerson").append(" where FIsStandby=1 and FEmployeeID in (").append(personIds).append(") group by FEmployeeID");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                personNum.put(rs.getString(1), rs.getInt(2));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return personNum;
    }

    protected void _verifyStandbyPerson(Context ctx, IObjectCollection standbyPersonCol, Map paramMap) throws BOSException, EASBizException {
        StandBySelectInfo standBySelect = (StandBySelectInfo)paramMap.get("currentBill");
        StandbyPersonCollection sbPerCol = (StandbyPersonCollection)standbyPersonCol;
        this.verifyStandByPersonInOtherBill(ctx, standBySelect, sbPerCol);
        try {
            this.checkBatchInputValidate(ctx, sbPerCol);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void verifyStandByPersonInOtherBill(Context ctx, StandBySelectInfo standBySelect, StandbyPersonCollection infos) throws BOSException, StandbyException {
        StringBuffer sql = new StringBuffer();
        StringBuffer idBuffer = new StringBuffer();
        String currDate = HRUtil.getCurrentDate();
        StandbyPersonInfo standbyPerson = null;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            standbyPerson = infos.get(i);
            idBuffer.append("'").append(standbyPerson.getEmployee().getId().toString()).append("'");
            if (i >= size - 1) continue;
            idBuffer.append(",");
        }
        sql.append("select person.fnumber from T_HR_StandBySelect bill inner join T_HR_StandBySelectEntry entry on bill.fid=entry.FBillID");
        sql.append(" inner join t_bd_person person on person.fid=entry.FPersonID");
        if (standBySelect != null && standBySelect.getId() != null) {
            sql.append(" where entry.FPersonID in (");
            sql.append(idBuffer.toString());
            sql.append(") and bill.fid !='").append(standBySelect.getId().toString()).append("'");
        } else {
            sql.append(" where entry.FPersonID in (");
            sql.append(idBuffer.toString()).append(")");
        }
        sql.append(" and (").append(" bill.fBillState = ").append(0);
        sql.append(" or bill.fBillState = ").append(1);
        sql.append(" or bill.fBillState = ").append(2);
        sql.append(" or (bill.fBillState = ").append(3);
        sql.append(" and entry.FBizDate >= ").append(currDate).append(" ))");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer numberBuffer = new StringBuffer();
        try {
            while (rs.next()) {
                numberBuffer.append(rs.getString("fnumber")).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (numberBuffer.length() > 0) {
            throw new StandbyException(StandbyException.EXIST_STANDBYPERSON_IN_OTHER_BILL, new Object[]{numberBuffer.substring(0, numberBuffer.length() - 1)});
        }
    }

    private void checkBatchInputValidate(Context ctx, StandbyPersonCollection sbPerCol) throws Exception {
        HashMap<BOSUuid, PersonInfo> personMap = new HashMap<BOSUuid, PersonInfo>();
        StringBuffer personIdBuffer = new StringBuffer();
        HashMap<BOSUuid, PositionInfo> toPosMap = new HashMap<BOSUuid, PositionInfo>();
        StringBuffer toPosIdBuffer = new StringBuffer();
        HashMap<BOSUuid, PositionInfo> primaryPosMap = new HashMap<BOSUuid, PositionInfo>();
        HashMap<String, Integer> toPositionCountMap = new HashMap<String, Integer>();
        HashMap<String, Integer> toPositionCountFromBillMap = new HashMap<String, Integer>();
        HashMap<String, Integer> sbPerCountMap = new HashMap<String, Integer>();
        HashMap<String, String> sbPerMap = new HashMap<String, String>();
        HashMap<String, String> sbTypeMap = new HashMap<String, String>();
        StandbyPersonInfo sbPerInfo = null;
        int size = sbPerCol.size();
        for (int i = 0; i < size; ++i) {
            sbPerInfo = sbPerCol.get(i);
            personIdBuffer.append("'" + sbPerInfo.getEmployee().getId().toString() + "',");
            if (sbPerInfo.getToPosition() == null) continue;
            toPosIdBuffer.append("'" + sbPerInfo.getToPosition().getId().toString() + "',");
        }
        PersonCollection personCol = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select id, name where id in (" + personIdBuffer.toString().substring(0, personIdBuffer.toString().length() - 1) + ")");
        PositionCollection toPosCol = null;
        if (toPosIdBuffer.length() > 0) {
            toPosCol = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("select id, name where id in (" + toPosIdBuffer.toString().substring(0, toPosIdBuffer.toString().length() - 1) + ")");
            String sqlToPosCount = "select FToPositionID, count(FToPositionID) from t_hr_standbyperson where FIsStandby = 1 and FToPositionID in (" + toPosIdBuffer.toString().substring(0, toPosIdBuffer.toString().length() - 1) + ") group by FToPositionID";
            IRowSet rsToPosCount = DbUtil.executeQuery((Context)ctx, (String)sqlToPosCount);
            while (rsToPosCount.next()) {
                toPositionCountMap.put(rsToPosCount.getString(1), rsToPosCount.getInt(2));
            }
            String sqlToPosCountFromBill = "select sse.FTargetPostionID, count(sse.FTargetPostionID) from T_HR_StandBySelectEntry sse inner join T_HR_StandBySelect ss on sse.FBillID = ss.FID where sse.FTargetPostionID in (" + toPosIdBuffer.toString().substring(0, toPosIdBuffer.toString().length() - 1) + ") " + "and (ss.FBillState = 4 or (ss.FBillState = 3 and sse.FBizDate >= " + HRUtil.getCurrentDate() + ")) group by sse.FTargetPostionID";
            IRowSet rsToPosCountFromBill = DbUtil.executeQuery((Context)ctx, (String)sqlToPosCountFromBill);
            while (rsToPosCountFromBill.next()) {
                toPositionCountFromBillMap.put(rsToPosCountFromBill.getString(1), rsToPosCountFromBill.getInt(2));
            }
        }
        PositionMemberCollection pmCol = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection("select person.id, position.name, position.adminOrgUnit.*, position.job.* WHERE isPrimary = '1' and person.id in (" + personIdBuffer.toString().substring(0, personIdBuffer.toString().length() - 1) + ")");
        String sqlSbPerCount = "select FEmployeeID, count(FEmployeeID) from t_hr_standbyperson where FIsStandby = 1 and FEmployeeID in (" + personIdBuffer.toString().substring(0, personIdBuffer.toString().length() - 1) + ") group by FEmployeeID";
        IRowSet rsSbPerCount = DbUtil.executeQuery((Context)ctx, (String)sqlSbPerCount);
        while (rsSbPerCount.next()) {
            sbPerCountMap.put(rsSbPerCount.getString(1), rsSbPerCount.getInt(2));
        }
        String sqlSbPer = "select FEmployeeID, FToPositionID, FToUnitID from t_hr_standbyperson where FIsStandby = 1 and FEmployeeID in (" + personIdBuffer.toString().substring(0, personIdBuffer.toString().length() - 1) + ")";
        IRowSet rsSbPer = DbUtil.executeQuery((Context)ctx, (String)sqlSbPer);
        while (rsSbPer.next()) {
            if (rsSbPer.getString(2) != null) {
                sbPerMap.put(rsSbPer.getString(1) + rsSbPer.getString(2), rsSbPer.getString(2));
                continue;
            }
            sbPerMap.put(rsSbPer.getString(1) + rsSbPer.getString(3), rsSbPer.getString(3));
        }
        String sqlSbType = "select FEmployeeID, FStandbyTypeID from t_hr_standbyperson where FIsStandby = 1 and FEmployeeID in (" + personIdBuffer.toString().substring(0, personIdBuffer.toString().length() - 1) + ")";
        IRowSet rsSbType = DbUtil.executeQuery((Context)ctx, (String)sqlSbType);
        while (rsSbType.next()) {
            if (sbTypeMap.get(rsSbType.getString(1)) != null) continue;
            sbTypeMap.put(rsSbType.getString(1), rsSbType.getString(2));
        }
        PersonInfo personInfo = null;
        PositionInfo toPosInfo = null;
        PositionInfo primaryPosInfo = null;
        PositionMemberInfo pmInfo = null;
        int size2 = sbPerCol.size();
        for (int i = 0; i < size2; ++i) {
            int j;
            sbPerInfo = sbPerCol.get(i);
            int personSize = personCol.size();
            for (j = 0; j < personSize; ++j) {
                personInfo = personCol.get(j);
                if (!sbPerInfo.getEmployee().getId().equals((Object)personInfo.getId())) continue;
                personMap.put(sbPerInfo.getId(), personInfo);
                break;
            }
            if (sbPerInfo.getToPosition() != null) {
                int toPosSize = toPosCol.size();
                for (j = 0; j < toPosSize; ++j) {
                    toPosInfo = toPosCol.get(j);
                    if (!sbPerInfo.getToPosition().getId().equals((Object)toPosInfo.getId())) continue;
                    toPosMap.put(sbPerInfo.getId(), toPosInfo);
                    break;
                }
            }
            int posMemsize = pmCol.size();
            for (j = 0; j < posMemsize; ++j) {
                pmInfo = pmCol.get(j);
                if (!sbPerInfo.getEmployee().getId().equals((Object)pmInfo.getPerson().getId())) continue;
                primaryPosMap.put(sbPerInfo.getId(), pmInfo.getPosition());
            }
        }
        AdminOrgUnitInfo toUnitInfo = null;
        int size3 = sbPerCol.size();
        for (int i = 0; i < size3; ++i) {
            sbPerInfo = sbPerCol.get(i);
            personInfo = null;
            toPosInfo = null;
            primaryPosInfo = null;
            toUnitInfo = sbPerInfo.getToUnit();
            if (toPosMap.get(sbPerInfo.getId()) != null) {
                toPosInfo = (PositionInfo)toPosMap.get(sbPerInfo.getId());
            }
            if (primaryPosMap.get(sbPerInfo.getId()) != null) {
                primaryPosInfo = (PositionInfo)primaryPosMap.get(sbPerInfo.getId());
            }
            if (personMap.get(sbPerInfo.getId()) != null) {
                personInfo = (PersonInfo)personMap.get(sbPerInfo.getId());
            }
            if (toPosInfo != null && toPosInfo.getId().equals((Object)primaryPosInfo.getId())) {
                throw new StandbyException(StandbyException.TOPOSITION_CANNOT_EQUAL_EMPPOSITION_WITH_PARAM, new Object[]{personInfo.getName()});
            }
            if (toPosInfo != null && toPositionCountMap.get(toPosInfo.getId().toString()) != null && toPositionCountFromBillMap.get(toPosInfo.getId().toString()) != null && (Integer)toPositionCountMap.get(toPosInfo.getId().toString()) + (Integer)toPositionCountFromBillMap.get(toPosInfo.getId().toString()) >= 3) {
                throw new StandbyException(StandbyException.TOPOSITION_HAVEMORETHAN_THREE, new Object[]{toPosInfo.getName()});
            }
            if (sbPerCountMap.get(personInfo.getId().toString()) != null && sbPerCountMap.get(personInfo.getId().toString()) != null && (Integer)sbPerCountMap.get(personInfo.getId().toString()) >= 3) {
                throw new StandbyException(StandbyException.EMPLOYEE_HAVEMORE_THREE, new Object[]{personInfo.getName()});
            }
            if (toPosInfo != null && sbPerMap.get(personInfo.getId().toString() + toPosInfo.getId().toString()) != null) {
                throw new StandbyException(StandbyException.EMPLOYEE_ALREADY_ON_TOPOSITION, new Object[]{personInfo.getName(), toPosInfo.getName()});
            }
            if (toUnitInfo != null && sbPerMap.get(personInfo.getId().toString() + toUnitInfo.getId().toString()) != null) {
                throw new StandbyException(StandbyException.EMPLOYEE_ALREADY_ON_TOUNIT, new Object[]{personInfo.getName(), toUnitInfo.getName()});
            }
            if (sbTypeMap.get(personInfo.getId().toString()) == null || sbPerInfo.getStandbyType().getId().toString().equals(sbTypeMap.get(personInfo.getId().toString()).toString())) continue;
            throw new StandbyException(StandbyException.EMPLOYEE_CANNOT_HAVE_DIFFTYPE, new Object[]{personInfo.getName()});
        }
    }
}

