/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.standby.IStandbyPerson;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyPersonAdjustBizBillEntryFactory;
import com.kingdee.eas.hr.standby.StandbyPersonAdjustBizBillEntryInfo;
import com.kingdee.eas.hr.standby.StandbyPersonAdjustBizBillInfo;
import com.kingdee.eas.hr.standby.StandbyPersonAdjustHistoryFactory;
import com.kingdee.eas.hr.standby.StandbyPersonAdjustHistoryInfo;
import com.kingdee.eas.hr.standby.StandbyPersonFactory;
import com.kingdee.eas.hr.standby.StandbyPersonInfo;
import com.kingdee.eas.hr.standby.app.AbstractStandbyPersonAdjustBizBillControllerBean;
import com.kingdee.eas.hr.standby.app.StandbyPersonAdjustBillBizBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class StandbyPersonAdjustBizBillControllerBean
extends AbstractStandbyPersonAdjustBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.standby.app.StandbyPersonAdjustBizBillControllerBean");

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.standby.app.StandbyPersonAdjustBizBillEffectFunction";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return StandbyPersonAdjustBizBillEntryFactory.getLocalInstance(ctx);
    }

    protected IHRBillBizBean getBizBean() {
        return new StandbyPersonAdjustBillBizBean();
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        StandbyPersonAdjustBizBillEntryInfo adjustEntry = (StandbyPersonAdjustBizBillEntryInfo)entry;
        IStandbyPerson iStandbyPerson = StandbyPersonFactory.getLocalInstance(ctx);
        StandbyPersonAdjustHistoryInfo adjustHistory = new StandbyPersonAdjustHistoryInfo();
        adjustHistory.setPerson(adjustEntry.getPerson());
        adjustHistory.setStandbyType(adjustEntry.getStandbyType());
        adjustHistory.setToPosition(adjustEntry.getToPosition());
        adjustHistory.setToPositionUnit(adjustEntry.getToPositionUnit());
        adjustHistory.setToAdminOrgUnit(adjustEntry.getToAdminOrg());
        adjustHistory.setQuitReason(adjustEntry.getDescription());
        adjustHistory.setBizDate(adjustEntry.getBizDate());
        StandbyPersonAdjustHistoryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)adjustHistory);
        if (adjustEntry.getToAdminOrg() != null) {
            StandbyPersonInfo standbyPerson = new StandbyPersonInfo();
            standbyPerson = iStandbyPerson.getStandbyPersonInfo("where employee = '" + adjustEntry.getPerson().getId().toString() + "' and toUnit = '" + adjustEntry.getToAdminOrg().getId().toString() + "'");
            standbyPerson.setEndTime(adjustEntry.getBizDate());
            standbyPerson.setIsHistoryStandbyPerson(true);
            standbyPerson.setIsStandby(0);
            standbyPerson.setToCommonReason(adjustEntry.getDescription());
            standbyPerson.setToCommonAudit(adjustEntry.getToCommonAudit());
            iStandbyPerson.update((IObjectPK)new ObjectUuidPK(standbyPerson.getId()), (CoreBaseInfo)standbyPerson);
        } else if (adjustEntry.getToPosition() != null) {
            StandbyPersonInfo standbyPerson = new StandbyPersonInfo();
            standbyPerson = iStandbyPerson.getStandbyPersonInfo("where employee = '" + adjustEntry.getPerson().getId().toString() + "' and toPosition = '" + adjustEntry.getToPosition().getId().toString() + "'");
            standbyPerson.setEndTime(adjustEntry.getBizDate());
            standbyPerson.setIsHistoryStandbyPerson(true);
            standbyPerson.setIsStandby(0);
            standbyPerson.setToCommonReason(adjustEntry.getDescription());
            standbyPerson.setToCommonAudit(adjustEntry.getToCommonAudit());
            iStandbyPerson.update((IObjectPK)new ObjectUuidPK(standbyPerson.getId()), (CoreBaseInfo)standbyPerson);
        }
        super._entryEffect(ctx, entry);
    }

    protected void _checkEntrys(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandbyPersonAdjustBizBillInfo pabbInfo = (StandbyPersonAdjustBizBillInfo)model;
        StandbyPersonAdjustBizBillEntryInfo pabbeInfo1 = null;
        StandbyPersonAdjustBizBillEntryInfo pabbeInfo2 = null;
        int count = pabbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            pabbeInfo1 = pabbInfo.getEntrys().get(i);
            int size = pabbInfo.getEntrys().size();
            for (int j = 0; j < size; ++j) {
                pabbeInfo2 = pabbInfo.getEntrys().get(j);
                if (i == j) continue;
                boolean result = false;
                if (pabbeInfo1.getPerson().equals((Object)pabbeInfo2.getPerson())) {
                    if (pabbeInfo1.getToAdminOrg() != null && pabbeInfo2.getToAdminOrg() != null && pabbeInfo1.getToAdminOrg().equals((Object)pabbeInfo2.getToAdminOrg())) {
                        result = true;
                    }
                    if (pabbeInfo1.getToPosition() != null && pabbeInfo2.getToPosition() != null && pabbeInfo1.getToPosition().getId().equals((Object)pabbeInfo2.getToPosition().getId())) {
                        result = true;
                    }
                }
                if (!result) continue;
                throw new StandbyException(StandbyException.STANDBYPERSON_REPEAT, new Object[]{i + 1, j + 1});
            }
            StringBuffer sql = new StringBuffer("select pab.FNumber from T_HR_StandbyPersonAdjustEntry pae ");
            sql.append("inner join T_HR_StandbyPersonAdjustBill pab on pae.FBillID = pab.FID where pae.FPersonID = '");
            String curDate = this.getCurrentDate();
            if (pabbeInfo1.getToAdminOrg() != null) {
                sql.append(pabbeInfo1.getPerson().getId().toString());
                sql.append("' and pae.FToAdminOrgID = '");
                sql.append(pabbeInfo1.getToAdminOrg().getId().toString());
                sql.append("' and pae.FStandbyTypeID = '");
                sql.append(pabbeInfo1.getStandbyType().getId().toString());
                sql.append("' and (pab.FBillState in (0, 1, 2) or (pab.FBillState = 3 and pae.FBizDate >= ");
                sql.append(curDate);
                sql.append("))");
            } else {
                sql.append(pabbeInfo1.getPerson().getId().toString());
                sql.append("' and pae.FToPositionID = '");
                sql.append(pabbeInfo1.getToPosition().getId().toString());
                sql.append("' and pae.FStandbyTypeID = '");
                sql.append(pabbeInfo1.getStandbyType().getId().toString());
                sql.append("' and (pab.FBillState in (0, 1, 2) or (pab.FBillState = 3 and pae.FBizDate >= ");
                sql.append(curDate);
                sql.append("))");
            }
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    String billNumber = rs.getString(1);
                    if (billNumber.equals(pabbInfo.getNumber())) continue;
                    throw new StandbyException(StandbyException.STANDBYPERSON_ISUSED, new Object[]{i + 1, billNumber});
                }
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected String _getOrgRange(Context ctx, String hrId) throws BOSException, EASBizException {
        String adminStr = null;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer("select ADMIN.FID from T_ORG_Admin ADMIN ");
        sql.append("left join T_ORG_UnitRelation UNITRELATION on ADMIN.FID = UNITRELATION.FFromUnitID ");
        sql.append("left join T_PM_OrgRange ORGRANGE on ADMIN.FID = ORGRANGE.FORGID ");
        sql.append("left join T_PM_USER PUSER on PUSER.FID = ORGRANGE.FUSERID ");
        sql.append("where  ORGRANGE.FType = 20 and ADMIN.FIsSealUp = 0 ");
        sql.append("and (UNITRELATION.FToUnitID = '");
        sql.append(hrId);
        sql.append("' and UNITRELATION.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5') ");
        sql.append("and PUSER.FID = '");
        sql.append(userId);
        sql.append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer adminIdStr = new StringBuffer();
        try {
            while (rs.next()) {
                adminIdStr.append("'");
                adminIdStr.append(rs.getString(1));
                adminIdStr.append("',");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (adminIdStr.length() > 0) {
            adminStr = adminIdStr.substring(0, adminIdStr.length() - 1);
        }
        return adminStr;
    }

    private String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }
}

