/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.standby.app.AbstractStandbyPersonFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StandbyPersonFacadeControllerBean
extends AbstractStandbyPersonFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.standby.app.StandbyPersonFacadeControllerBean");

    protected ArrayList _getResultFilterPerson(Context ctx, HashMap filterMap, FilterInfo commonFilter) throws BOSException, EASBizException {
        boolean isPosition = (Boolean)filterMap.get("isPosition");
        boolean isLevel = (Boolean)filterMap.get("isLevel");
        boolean isYear = (Boolean)filterMap.get("isYear");
        boolean isCompare = (Boolean)filterMap.get("isCompare");
        boolean isDiploma = (Boolean)filterMap.get("isDiploma");
        boolean isPost = (Boolean)filterMap.get("isPost");
        String positionId = null;
        if (filterMap.get("positionId") != null) {
            positionId = filterMap.get("positionId").toString();
        }
        String levelId = null;
        if (filterMap.get("levelId") != null) {
            levelId = filterMap.get("levelId").toString();
        }
        String diplomaId = null;
        if (filterMap.get("diplomaId") != null) {
            diplomaId = filterMap.get("diplomaId").toString();
        }
        String postId = null;
        if (filterMap.get("postId") != null) {
            postId = filterMap.get("postId").toString();
        }
        double fromYear = -1.0;
        double toYear = -1.0;
        if (isYear) {
            fromYear = Double.valueOf(filterMap.get("fromYear").toString());
            toYear = Double.valueOf(filterMap.get("toYear").toString());
        }
        String toPositionId = null;
        if (filterMap.get("toPositionId") != null) {
            toPositionId = filterMap.get("toPositionId").toString();
        }
        String hrId = null;
        if (filterMap.get("hrId") != null) {
            hrId = filterMap.get("hrId").toString();
        }
        String strSelectedMatch = filterMap.get("selectedMatch").toString();
        double selectedMatch = Double.valueOf(strSelectedMatch.substring(0, strSelectedMatch.length() - 1)) / 100.0;
        ArrayList listResult = null;
        try {
            listResult = this.getFilterResult(commonFilter, isPosition, isLevel, isYear, positionId, levelId, fromYear, toYear, isDiploma, diplomaId, isPost, postId, isCompare, toPositionId, selectedMatch, ctx, hrId);
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return listResult;
    }

    private IRowSet getPersonRowSet(FilterInfo commonFilter, boolean isPosition, boolean isLevel, boolean isYear, String positionId, String levelId, double fromYear, double toYear, boolean isDiploma, String diplomaId, boolean isPost, String postId, Context ctx, String hrId) throws BOSException {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.standby.app.StandbyPersonFilterQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (isPosition) {
            filter.getFilterItems().add(new FilterItemInfo("Position.id", (Object)positionId));
        }
        if (isLevel) {
            filter.getFilterItems().add(new FilterItemInfo("JobLevel.id", (Object)levelId));
        }
        if (isYear) {
            filter.getFilterItems().add(new FilterItemInfo("JoinGroupYears", (Object)new Double(fromYear), CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("JoinGroupYears", (Object)new Double(toYear), CompareType.LESS_EQUALS));
        }
        if (isDiploma) {
            filter.getFilterItems().add(new FilterItemInfo("Diploma.id", (Object)diplomaId));
        }
        if (isPost) {
            filter.getFilterItems().add(new FilterItemInfo("TechnicalPost.id", (Object)postId));
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrId));
        if (commonFilter.getFilterItems().size() > 0) {
            filter.mergeFilter(commonFilter, "AND");
        }
        try {
            filter.mergeFilter(this.getSelectDefaultHRFilter(ctx, hrId), "AND");
            FilterInfo filterSealUp = new FilterInfo("AdminOrgUnit.isSealUp = 0");
            filter.mergeFilter(filterSealUp, "and");
        }
        catch (Exception e) {
            new BOSException((Throwable)e);
        }
        view.setFilter(filter);
        exec.setObjectView(view);
        IRowSet rsPerson = exec.executeQuery();
        return rsPerson;
    }

    private FilterInfo getSelectDefaultHRFilter(Context ctx, String hrId) throws Exception {
        return HRUtil.buildHROFilter((Context)ctx, (String)hrId, (String)"AdminOrgUnit.id");
    }

    private ArrayList getFilterResult(FilterInfo commonFilter, boolean isPosition, boolean isLevel, boolean isYear, String positionId, String levelId, double fromYear, double toYear, boolean isDiploma, String diplomaId, boolean isPost, String postId, boolean isCompare, String toPositionId, double selectedMatch, Context ctx, String hrId) throws BOSException, SQLException {
        IRowSet rsPerson = this.getPersonRowSet(commonFilter, isPosition, isLevel, isYear, positionId, levelId, fromYear, toYear, isDiploma, diplomaId, isPost, postId, ctx, hrId);
        ArrayList rtnList = new ArrayList();
        StringBuffer personIds = new StringBuffer(512);
        HashMap personMap = new HashMap();
        HashMap personCompetMap = new HashMap();
        if (rsPerson != null) {
            if (!isCompare) {
                return this.convertRowSetToFilterArrayList(rsPerson);
            }
            IRowSet rsToPosCompet = DbUtil.executeQuery((Context)ctx, (String)("select FCompetIndexID from T_HR_PosiCompIndex where FPositionID = '" + toPositionId + "'"));
            if (rsToPosCompet != null) {
                int toPosCompetCount = rsToPosCompet.size();
                if (toPosCompetCount == 0) {
                    return rtnList;
                }
                this.buildCondition(rsPerson, personIds, personMap);
                IRowSet rsPersonCompet = DbUtil.executeQuery((Context)ctx, (String)("select FCompetIndexID,FPersonID from T_HR_EMPCompetIndex where FPersonID in(" + personIds.substring(0, personIds.length() - 1) + ")"));
                while (rsPersonCompet.next()) {
                    String id = rsPersonCompet.getString("FPersonID");
                    if (personCompetMap.get(id) == null) {
                        ArrayList<String> competList = new ArrayList<String>();
                        competList.add(rsPersonCompet.getString("FCompetIndexID"));
                        personCompetMap.put(id, competList);
                        continue;
                    }
                    ((List)personCompetMap.get(id)).add(rsPersonCompet.getString("FCompetIndexID"));
                }
                rsPersonCompet = null;
                rsToPosCompet.beforeFirst();
                Set personMapset = personCompetMap.entrySet();
                for (Map.Entry entry : personMapset) {
                    String personid = entry.getKey().toString();
                    List competListEntry = (List)entry.getValue();
                    int matchCompet = 0;
                    int len = competListEntry.size();
                    block2: for (int i = 0; i < len; ++i) {
                        rsToPosCompet.beforeFirst();
                        String personCompetId = (String)competListEntry.get(i);
                        while (rsToPosCompet.next()) {
                            String toPosCompetId = rsToPosCompet.getString("FCompetIndexID");
                            if (!toPosCompetId.equals(personCompetId)) continue;
                            ++matchCompet;
                            continue block2;
                        }
                    }
                    double d = matchCompet;
                    if (!(d / (double)toPosCompetCount >= selectedMatch)) continue;
                    rtnList.add(personMap.get(personid));
                }
            }
        }
        return rtnList;
    }

    private void buildCondition(IRowSet rs, StringBuffer ids, Map personMap) throws SQLException {
        while (rs.next()) {
            String id = rs.getString("id");
            ids.append("'" + id + "',");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", id);
            map.put("number", rs.getString("number"));
            map.put("name", rs.getString("name"));
            map.put("AdminOrgUnit.name", rs.getString("AdminOrgUnit.name"));
            map.put("Position.name", rs.getString("Position.name"));
            personMap.put(id, map);
        }
    }

    private HashMap convertRowSetToFilterHashMap(IRowSet rs) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (rs != null) {
            map.put("id", rs.getString("id"));
            map.put("number", rs.getString("number"));
            map.put("name", rs.getString("name"));
            AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)rs.getString("AdminOrgUnit.id")));
            adminInfo.setName(rs.getString("AdminOrgUnit.name"));
            map.put("AdminOrgUnit", (String)adminInfo);
            PositionInfo pInfo = new PositionInfo();
            pInfo.setId(BOSUuid.read((String)rs.getString("Position.id")));
            pInfo.setName(rs.getString("Position.name"));
            map.put("Position", (String)pInfo);
        }
        return map;
    }

    private ArrayList convertRowSetToFilterArrayList(IRowSet rs) throws SQLException {
        ArrayList<HashMap> rtnList = new ArrayList<HashMap>();
        if (rs != null) {
            rs.beforeFirst();
            while (rs.next()) {
                rtnList.add(this.convertRowSetToFilterHashMap(rs));
            }
        }
        return rtnList;
    }

    protected ArrayList _getResultReportPerson(Context ctx, HashMap filterMap) throws BOSException, EASBizException {
        AdminOrgUnitInfo toUnitInfo = null;
        if (filterMap.get("toUnit") != null) {
            toUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterMap.get("toUnit").toString()));
        }
        PositionInfo toPosInfo = null;
        if (filterMap.get("toPosition") != null) {
            toPosInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(filterMap.get("toPosition").toString()));
        }
        int state = (Integer)filterMap.get("state");
        FilterInfo filter = new FilterInfo();
        if (toPosInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("toPosition.id", (Object)toPosInfo.getId().toString()));
        } else if (toUnitInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)toUnitInfo.getLongNumber()));
            filter.getFilterItems().add(new FilterItemInfo("toPositionUnit.longNumber", (Object)(toUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)toUnitInfo.getLongNumber()));
            filter.getFilterItems().add(new FilterItemInfo("toUnit.longNumber", (Object)(toUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 or #1 or #2 or #3");
            try {
                if (filterMap.get("ShowVirtualOrg") != null && !((Boolean)filterMap.get("ShowVirtualOrg")).booleanValue()) {
                    FilterInfo isVirtualFilter = new FilterInfo("toUnit.isVirtual = 0 or toPositionUnit.isVirtual = 0");
                    filter.mergeFilter(isVirtualFilter, "and");
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (state != 2) {
            FilterInfo newFilter = new FilterInfo();
            newFilter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)state));
            filter.mergeFilter(newFilter, "AND");
        }
        String hrOrgUnitId = (String)filterMap.get("hrOrgUnitId");
        filter.mergeFilter(this.getReportDefaultHRFilter(ctx, hrOrgUnitId), "AND");
        if (filterMap.get("includeSealUp") != null && !((Boolean)filterMap.get("includeSealUp")).booleanValue()) {
            FilterInfo sFilter = new FilterInfo();
            sFilter.getFilterItems().add(new FilterItemInfo("toUnit.isSealUp", (Object)Boolean.FALSE));
            sFilter.getFilterItems().add(new FilterItemInfo("toPositionUnit.isSealUp", (Object)Boolean.FALSE));
            sFilter.setMaskString("#0 or #1");
            filter.mergeFilter(sFilter, "and");
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.standby.app.StandbyPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo mainQuery = (EntityViewInfo)filterMap.get("mainQuery");
        if (mainQuery == null) {
            mainQuery = new EntityViewInfo();
        }
        String sql = null;
        ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        boolean isHasPer = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPk, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)hrOrgUnitId)), "standbyPersonDetailList_View");
        if (isHasPer) {
            filter = HRUtil.customMergeFilter((FilterInfo)filter, (FilterInfo)mainQuery.getFilter(), (String)"AND");
            mainQuery.setFilter(filter);
            exec.setObjectView(mainQuery);
            sql = exec.getSQL();
            sql = sql.replaceAll("AND \"STANDBYPERSON\".FID = '00000000-0000-0000-0000-00000000000013B7DE7F'", "");
            sql = sql.replaceAll("AND \"STANDBYPERSON\".FID <> '00000000-0000-0000-0000-00000000000013B7DE7F'", "");
        } else {
            FilterInfo filterNo;
            filter = HRUtil.customMergeFilter((FilterInfo)filter, (FilterInfo)mainQuery.getFilter(), (String)"AND");
            try {
                filterNo = new FilterInfo("id = '00000000-0000-0000-0000-00000000000013B7DE7F' id <> '00000000-0000-0000-0000-00000000000013B7DE7F'");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            filter.mergeFilter(filterNo, "and");
            mainQuery.setFilter(filter);
            exec.setObjectView(mainQuery);
            sql = exec.getSQL();
        }
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList resultList = new ArrayList();
        try {
            resultList = this.getReportResult(ctx, rs1, state, 1);
        }
        catch (SQLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return resultList;
    }

    private FilterInfo getReportDefaultHRFilter(Context ctx, String hrOrgUnitId) {
        FilterInfo ret = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        if (StringUtils.isEmpty((String)hrOrgUnitId)) {
            sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
            sql.append("'");
            sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            sql.append("'");
            sql.append(" AND ");
            sql.append("FType = ");
            sql.append(20);
        } else {
            sql.append("SELECT rel.FFromUnitID FROM T_ORG_UnitRelation rel ");
            sql.append(" inner join T_PM_OrgRange rang on rang.FOrgID = rel.FFromUnitID");
            sql.append(" where rel.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
            sql.append(" and rang.FUserID = ");
            sql.append("'");
            sql.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            sql.append("'");
            sql.append(" and rang.FType = ");
            sql.append(20);
            sql.append(" and rel.FToUnitID = ");
            sql.append("'");
            sql.append(hrOrgUnitId);
            sql.append("'");
        }
        ret.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)sql.toString(), CompareType.INNER));
        ret.getFilterItems().add(new FilterItemInfo("toPositionUnit.id", (Object)sql.toString(), CompareType.INNER));
        ret.setMaskString(" #0 or #1 ");
        return ret;
    }

    private FilterInfo getDefaultCUFilter(Context ctx) {
        FilterInfo filter = new FilterInfo();
        if (ContextUtil.getCurrentCtrlUnit((Context)ctx) == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        return filter;
    }

    private ArrayList getReportResult(Context ctx, IRowSet rs1, int state, int showLevel) throws BOSException, SQLException {
        String FLAG_TOPOSITION = "TOPOSITION";
        String FLAG_TOUNIT = "TOUNIT";
        ArrayList resultList = new ArrayList();
        if (rs1 == null) {
            return resultList;
        }
        ArrayList toPositionOrToUnitIdList = new ArrayList();
        rs1.beforeFirst();
        while (rs1.next()) {
            HashMap<String, String> mapToPositionOrToUnitId;
            if (rs1.getString("toPosition.id") == null) {
                if (this.isExistSameMap(FLAG_TOUNIT, rs1.getString("toUnit.id"), toPositionOrToUnitIdList)) continue;
                mapToPositionOrToUnitId = new HashMap<String, String>();
                mapToPositionOrToUnitId.put(FLAG_TOUNIT, rs1.getString("toUnit.id"));
                toPositionOrToUnitIdList.add(mapToPositionOrToUnitId);
                continue;
            }
            if (this.isExistSameMap(FLAG_TOPOSITION, rs1.getString("toPosition.id"), toPositionOrToUnitIdList)) continue;
            mapToPositionOrToUnitId = new HashMap();
            mapToPositionOrToUnitId.put(FLAG_TOPOSITION, rs1.getString("toPosition.id"));
            toPositionOrToUnitIdList.add(mapToPositionOrToUnitId);
        }
        int size = toPositionOrToUnitIdList.size();
        for (int i = 0; i < size; ++i) {
            HashMap map = (HashMap)toPositionOrToUnitIdList.get(i);
            String toPosOrToUnitId = null;
            String flag = null;
            if (map.containsKey(FLAG_TOPOSITION)) {
                toPosOrToUnitId = map.get(FLAG_TOPOSITION).toString();
                flag = FLAG_TOPOSITION;
            } else if (map.containsKey(FLAG_TOUNIT)) {
                toPosOrToUnitId = map.get(FLAG_TOUNIT).toString();
                flag = FLAG_TOUNIT;
            }
            ArrayList<HashMap> toPosOrToUnitList = new ArrayList<HashMap>();
            ArrayList secondList = new ArrayList();
            if (FLAG_TOPOSITION.equals(flag)) {
                rs1.beforeFirst();
                while (rs1.next()) {
                    if (rs1.getString("toPosition.id") == null || !rs1.getString("toPosition.id").equals(toPosOrToUnitId)) continue;
                    toPosOrToUnitList.add(this.convertRowSetToReportHashMap(rs1, toPosOrToUnitId));
                    if (showLevel != 2) continue;
                    this.mergeList(this.getSecondStandbyPersonByToPosition(ctx, rs1.getString("empPosition.id"), toPosOrToUnitId, state), secondList);
                }
            } else if (flag.equals(FLAG_TOUNIT)) {
                rs1.beforeFirst();
                while (rs1.next()) {
                    if (rs1.getString("toUnit.id") == null || !rs1.getString("toUnit.id").equals(toPosOrToUnitId)) continue;
                    toPosOrToUnitList.add(this.convertRowSetToReportHashMap(rs1, toPosOrToUnitId));
                    if (showLevel != 2) continue;
                    this.mergeList(this.getSecondStandbyPersonByToPosition(ctx, rs1.getString("empPosition.id"), toPosOrToUnitId, state), secondList);
                }
            }
            this.mergeList(toPosOrToUnitList, resultList);
            if (showLevel != 2) continue;
            this.mergeList(secondList, resultList);
        }
        return resultList;
    }

    private ArrayList getSecondStandbyPersonByToPosition(Context ctx, String toPositionId, String toPosOrToUnitId, int state) throws BOSException, SQLException {
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.standby.app.StandbyPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("toPosition.id", (Object)toPositionId));
        if (state != 2) {
            filter.getFilterItems().add(new FilterItemInfo("isStandby", (Object)state));
        }
        view.setFilter(filter);
        exec.setObjectView(view);
        IRowSet rs = exec.executeQuery();
        if (rs != null) {
            rs.beforeFirst();
            while (rs.next()) {
                list.add(this.convertRowSetToReportHashMap(rs, toPosOrToUnitId));
            }
        }
        return list;
    }

    private void mergeList(ArrayList fromList, ArrayList toList) {
        int size = fromList.size();
        for (int i = 0; i < size; ++i) {
            toList.add(fromList.get(i));
        }
    }

    private HashMap convertRowSetToReportHashMap(IRowSet rs, String toPosOrToUnitId) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (rs != null) {
            map.put("toPosOrToUnitId", toPosOrToUnitId);
            map.put("id", rs.getString("id"));
            map.put("toPositionId", rs.getString("toPosition.id"));
            map.put("toUnit", rs.getString("toPositionUnitOrToUnit"));
            map.put("toPosition", rs.getString("toPosition.name"));
            map.put("employeeId", rs.getString("employee.id"));
            map.put("empName", rs.getString("employee.name"));
            map.put("empUnit", rs.getString("empAdminOrgUnit.name"));
            map.put("empPosition", rs.getString("empPosition.name"));
            map.put("standbyType", rs.getString("standbyType.name"));
            map.put("toStandbyAudit", rs.getString("toStandbyAudit"));
            map.put("toStandbyReason", rs.getString("toStandbyReason"));
            map.put("toCommonAudit", rs.getString("toCommonAudit"));
            map.put("toCommonReason", rs.getString("toCommonReason"));
            map.put("standbyState", rs.getString("standbyState"));
            map.put("isStandby", rs.getString("isStandby"));
            map.put("toPositionUnit.name", rs.getString("toPositionUnit.name"));
            map.put("startTime", rs.getString("startTime"));
            map.put("endTime", rs.getString("endTime"));
            map.put("toCommonAudit", rs.getString("toCommonAudit"));
        }
        return map;
    }

    private boolean isExistSameMap(String strKey, String strValue, ArrayList list) {
        HashMap map = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            map = (HashMap)list.get(i);
            if (!map.containsKey(strKey) || !map.get(strKey).equals(strValue)) continue;
            return true;
        }
        return false;
    }
}

