/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.standby.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.IHRBillBizBean;
import com.kingdee.eas.hr.standby.IStandbyPersonAuditRecord;
import com.kingdee.eas.hr.standby.IStandbyPersonCourse;
import com.kingdee.eas.hr.standby.IStandbyPersonPlan;
import com.kingdee.eas.hr.standby.StandbyException;
import com.kingdee.eas.hr.standby.StandbyPersonAuditRecordCollection;
import com.kingdee.eas.hr.standby.StandbyPersonAuditRecordFactory;
import com.kingdee.eas.hr.standby.StandbyPersonAuditRecordInfo;
import com.kingdee.eas.hr.standby.StandbyPersonCourseCollection;
import com.kingdee.eas.hr.standby.StandbyPersonCourseFactory;
import com.kingdee.eas.hr.standby.StandbyPersonCourseInfo;
import com.kingdee.eas.hr.standby.StandbyPersonPlanCollection;
import com.kingdee.eas.hr.standby.StandbyPersonPlanFactory;
import com.kingdee.eas.hr.standby.StandbyPersonPlanInfo;
import com.kingdee.eas.hr.standby.StandbyReviewBizBillEntryCollection;
import com.kingdee.eas.hr.standby.StandbyReviewBizBillEntryFactory;
import com.kingdee.eas.hr.standby.StandbyReviewBizBillEntryInfo;
import com.kingdee.eas.hr.standby.StandbyReviewBizBillInfo;
import com.kingdee.eas.hr.standby.StandbyTrainingItemInfo;
import com.kingdee.eas.hr.standby.app.AbstractStandbyReviewBizBillControllerBean;
import com.kingdee.eas.hr.standby.app.StandbyReviewBillBizBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class StandbyReviewBizBillControllerBean
extends AbstractStandbyReviewBizBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.standby.app.StandbyReviewBizBillControllerBean");

    protected String getBillField() {
        return "bill";
    }

    protected String getEntryField() {
        return "entrys";
    }

    protected String getEntryEffectDateField() {
        return "bizDate";
    }

    protected String getEffectFunction() {
        return "com.kingdee.eas.hr.standby.app.StandbyReviewBizBillEffectFunction";
    }

    protected IHRBillBaseEntry getEntryInterface(Context ctx) throws BOSException, EASBizException {
        return StandbyReviewBizBillEntryFactory.getLocalInstance(ctx);
    }

    protected IHRBillBizBean getBizBean() {
        return new StandbyReviewBillBizBean();
    }

    protected void _entryEffect(Context ctx, HRBillBaseEntryInfo entry) throws BOSException, EASBizException {
        int i;
        int size;
        String personId = ((StandbyReviewBizBillEntryInfo)entry).getPerson().getId().toString();
        IStandbyPersonCourse standbyPersonCourse = StandbyPersonCourseFactory.getLocalInstance(ctx);
        IStandbyPersonAuditRecord standbyPersonAuditRecord = StandbyPersonAuditRecordFactory.getLocalInstance(ctx);
        StandbyPersonPlanCollection ppCol = StandbyPersonPlanFactory.getLocalInstance(ctx).getStandbyPersonPlanCollection("where employee = '" + personId + "'");
        StringBuffer planId = new StringBuffer();
        if (ppCol != null && ppCol.size() > 0) {
            int size2 = ppCol.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                planId.append("'");
                planId.append(ppCol.get(i2).getId().toString());
                if (i2 == size2 - 1) {
                    planId.append("'");
                    continue;
                }
                planId.append("',");
            }
        }
        if (planId != null && planId.length() > 0) {
            StringBuffer personCourseStr = new StringBuffer("where plan in (");
            personCourseStr.append(planId);
            personCourseStr.append(") and billId = '");
            personCourseStr.append(((StandbyReviewBizBillEntryInfo)entry).getBill().getId().toString());
            personCourseStr.append("'");
            StandbyPersonCourseCollection ttCol = standbyPersonCourse.getStandbyPersonCourseCollection(personCourseStr.toString());
            if (ttCol != null && ttCol.size() > 0) {
                size = ttCol.size();
                for (i = 0; i < size; ++i) {
                    StandbyPersonCourseInfo ttInfo = ttCol.get(i);
                    ttInfo.setIsAudited(true);
                    standbyPersonCourse.update((IObjectPK)new ObjectUuidPK(ttInfo.getId()), (CoreBaseInfo)ttInfo);
                }
            }
        }
        StringBuffer auditRecordStr = new StringBuffer("where employee = '");
        auditRecordStr.append(personId);
        auditRecordStr.append("' and billId = '");
        auditRecordStr.append(((StandbyReviewBizBillEntryInfo)entry).getBill().getId().toString());
        auditRecordStr.append("'");
        StandbyPersonAuditRecordCollection rrCol = standbyPersonAuditRecord.getStandbyPersonAuditRecordCollection(auditRecordStr.toString());
        if (rrCol != null && rrCol.size() > 0) {
            size = rrCol.size();
            for (i = 0; i < size; ++i) {
                StandbyPersonAuditRecordInfo rrInfo = rrCol.get(i);
                rrInfo.setIsAudited(true);
                standbyPersonAuditRecord.update((IObjectPK)new ObjectUuidPK(rrInfo.getId()), (CoreBaseInfo)rrInfo);
            }
        }
        super._entryEffect(ctx, entry);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        StandbyReviewBizBillInfo srbbInfo = (StandbyReviewBizBillInfo)model;
        IStandbyPersonCourse standbyPersonCourse = StandbyPersonCourseFactory.getLocalInstance(ctx);
        IStandbyPersonAuditRecord standbyPersonAuditRecord = StandbyPersonAuditRecordFactory.getLocalInstance(ctx);
        this.checkEntry(ctx, srbbInfo);
        IObjectPK billId = super._addnew(ctx, model);
        srbbInfo.setId(BOSUuid.read((String)billId.toString()));
        HashMap srbbMap = (HashMap)srbbInfo.get("traceAndRecord");
        HashMap traceMap = (HashMap)srbbMap.get("trainTrace");
        for (Map.Entry entry : traceMap.entrySet()) {
            HashMap ttMap = (HashMap)entry.getValue();
            if (ttMap == null) continue;
            for (Map.Entry entry1 : ttMap.entrySet()) {
                StandbyPersonCourseInfo ttInfo = (StandbyPersonCourseInfo)entry1.getValue();
                ttInfo.setIsAudited(false);
                ttInfo.setBillId(srbbInfo);
                standbyPersonCourse.addnew((IObjectPK)new ObjectUuidPK(ttInfo.getId()), (CoreBaseInfo)ttInfo);
            }
        }
        HashMap recordMap = (HashMap)srbbMap.get("reviewRecord");
        for (Map.Entry entry : recordMap.entrySet()) {
            HashMap rrMap = (HashMap)entry.getValue();
            if (rrMap == null) continue;
            for (Map.Entry entry1 : rrMap.entrySet()) {
                StandbyPersonAuditRecordInfo rrInfo = (StandbyPersonAuditRecordInfo)entry1.getValue();
                rrInfo.setIsAudited(false);
                rrInfo.setBillId(srbbInfo);
                standbyPersonAuditRecord.addnew((IObjectPK)new ObjectUuidPK(rrInfo.getId()), (CoreBaseInfo)rrInfo);
            }
        }
        srbbInfo.setApplyDate(new Date());
        return billId;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._delete(ctx, pk);
        this._addnew(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashMap srbbMap = null;
        HashMap traceMap = null;
        HashMap recordMap = null;
        IStandbyPersonCourse standbyPersonCourse = StandbyPersonCourseFactory.getLocalInstance(ctx);
        IStandbyPersonAuditRecord standbyPersonAuditRecord = StandbyPersonAuditRecordFactory.getLocalInstance(ctx);
        StandbyReviewBizBillInfo srbbInfo = (StandbyReviewBizBillInfo)this._getValue(ctx, pk);
        if (srbbInfo.get("traceAndRecord") != null) {
            srbbMap = (HashMap)srbbInfo.get("traceAndRecord");
            traceMap = (HashMap)srbbMap.get("trainTrace");
            recordMap = (HashMap)srbbMap.get("reviewRecord");
            if (!traceMap.isEmpty()) {
                for (Map.Entry entry : traceMap.entrySet()) {
                    HashMap ttMap = (HashMap)entry.getValue();
                    if (ttMap == null) continue;
                    for (Map.Entry entry1 : ttMap.entrySet()) {
                        StandbyPersonCourseInfo ttInfo = (StandbyPersonCourseInfo)entry1.getValue();
                        standbyPersonCourse.delete((IObjectPK)new ObjectUuidPK(ttInfo.getId()));
                    }
                }
            }
            if (!recordMap.isEmpty()) {
                for (Map.Entry entry : recordMap.entrySet()) {
                    HashMap rrMap = (HashMap)entry.getValue();
                    if (rrMap == null) continue;
                    for (Map.Entry entry1 : rrMap.entrySet()) {
                        StandbyPersonAuditRecordInfo rrInfo = (StandbyPersonAuditRecordInfo)entry1.getValue();
                        standbyPersonAuditRecord.delete((IObjectPK)new ObjectUuidPK(rrInfo.getId()));
                    }
                }
            }
        }
        super._delete(ctx, pk);
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StandbyReviewBizBillInfo srbbInfo = (StandbyReviewBizBillInfo)super._getValue(ctx, pk);
        HashMap srbbMap = new HashMap();
        HashMap<String, HashMap> traceMap = new HashMap<String, HashMap>();
        HashMap<String, HashMap> recordMap = new HashMap<String, HashMap>();
        StandbyReviewBizBillEntryCollection srbbeCol = srbbInfo.getEntrys();
        int size = srbbeCol.size();
        for (int i = 0; i < size; ++i) {
            StandbyReviewBizBillEntryInfo srbbeInfo = srbbeCol.get(i);
            BOSUuid personId = srbbeInfo.getPerson().getId();
            HashMap ttMap = this.getTrainTraceByPersonId(ctx, personId, srbbInfo.getId().toString());
            String traceKey = "trainTrace~" + personId.toString();
            traceMap.put(traceKey, ttMap);
            HashMap rrMap = this.getReviewRecordByPersonId(ctx, personId, srbbInfo.getId().toString());
            String recordKey = "reviewRecord~" + personId.toString();
            recordMap.put(recordKey, rrMap);
        }
        srbbMap.put("trainTrace", traceMap);
        srbbMap.put("reviewRecord", recordMap);
        srbbInfo.put("traceAndRecord", srbbMap);
        return srbbInfo;
    }

    private HashMap getTrainTraceByPersonId(Context ctx, BOSUuid personId, String billId) throws BOSException {
        HashMap<String, StandbyPersonCourseInfo> ttMap = new HashMap<String, StandbyPersonCourseInfo>();
        IStandbyPersonPlan standbyPersonPlan = StandbyPersonPlanFactory.getLocalInstance(ctx);
        StandbyPersonPlanCollection ppCol = standbyPersonPlan.getStandbyPersonPlanCollection("where employee = '" + personId + "'");
        StringBuffer planId = new StringBuffer();
        if (ppCol != null && ppCol.size() > 0) {
            int size = ppCol.size();
            for (int i = 0; i < size; ++i) {
                planId.append("'");
                planId.append(ppCol.get(i).getId().toString());
                if (i == size - 1) {
                    planId.append("'");
                    continue;
                }
                planId.append("',");
            }
        }
        if (planId == null || planId.length() <= 0) {
            return null;
        }
        String ttSql = "select * from T_HR_StandbyPersonCourse where FPlanID in (" + planId + ") and FBillId = '" + billId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)ttSql);
        StandbyPersonCourseInfo ttInfo = null;
        try {
            while (rs.next()) {
                ttInfo = new StandbyPersonCourseInfo();
                ttInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                ttInfo.setSummary(rs.getString("FSummary_L2"));
                ttInfo.setRealBeginDate(rs.getDate("FRealBeginDate"));
                ttInfo.setRealEndDate(rs.getDate("FRealEndDate"));
                ttInfo.setRealResult(rs.getString("FRealResult_L2"));
                ttInfo.setIsReachTarget(rs.getString("FIsReachTarget_L2"));
                ttInfo.setFailReason(rs.getString("FFailReason_L2"));
                StandbyPersonPlanInfo ppInfo = standbyPersonPlan.getStandbyPersonPlanInfo((IObjectPK)new ObjectUuidPK(rs.getString("FPlanID")));
                String sql = "select FName_l2, FNumber from T_HR_StandbyTrainingItem where FID = '" + ppInfo.getTrainingItem().getId().toString() + "'";
                IRowSet rsTrainingItem = DbUtil.executeQuery((Context)ctx, (String)sql);
                boolean result = false;
                while (rsTrainingItem.next()) {
                    result = true;
                    StandbyTrainingItemInfo trainingItemInfo = new StandbyTrainingItemInfo();
                    trainingItemInfo.setId(ppInfo.getId());
                    trainingItemInfo.setName(rsTrainingItem.getString("FName_l2"));
                    trainingItemInfo.setNumber(rsTrainingItem.getString("FNumber"));
                    ppInfo.setTrainingItem(trainingItemInfo);
                }
                ttInfo.setPlan(ppInfo);
                ttInfo.setIsAudited(rs.getBoolean("FIsAudited"));
                if (!result) continue;
                ttMap.put(rs.getString("FID"), ttInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ttMap;
    }

    private HashMap getReviewRecordByPersonId(Context ctx, BOSUuid personId, String billId) throws BOSException {
        HashMap<String, StandbyPersonAuditRecordInfo> rrMap = new HashMap<String, StandbyPersonAuditRecordInfo>();
        String rrSql = "select * from T_HR_StandbyPersonAuditRecord where FEmployeeID = '" + personId.toString() + "' and FBillId = '" + billId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)rrSql);
        IPerson person = PersonFactory.getLocalInstance((Context)ctx);
        StandbyPersonAuditRecordInfo rrInfo = null;
        try {
            while (rs.next()) {
                rrInfo = new StandbyPersonAuditRecordInfo();
                rrInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                rrInfo.setProject(rs.getString("FProject_L2"));
                rrInfo.setResult(rs.getString("FResult_L2"));
                rrInfo.setExcellence(rs.getString("FExcellence_L2"));
                rrInfo.setShortAge(rs.getString("FShortAge_L2"));
                rrInfo.setSumUp(rs.getString("FSumUp_L2"));
                rrInfo.setEmployee(person.getPersonInfo((IObjectPK)new ObjectUuidPK(personId)));
                rrInfo.setIsAudited(rs.getBoolean("FIsAudited"));
                rrMap.put(rs.getString("FID"), rrInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return rrMap;
    }

    private String getCurrentDate() {
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat sFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "{ts'" + sFormat.format(cal.getTime()) + "'}";
    }

    private void checkEntry(Context ctx, StandbyReviewBizBillInfo rbbInfo) throws BOSException, EASBizException {
        StandbyReviewBizBillEntryInfo rbbeInfo1 = null;
        StandbyReviewBizBillEntryInfo rbbeInfo2 = null;
        int count = rbbInfo.getEntrys().size();
        for (int i = 0; i < count; ++i) {
            rbbeInfo1 = rbbInfo.getEntrys().get(i);
            int size = rbbInfo.getEntrys().size();
            for (int j = 0; j < size; ++j) {
                rbbeInfo2 = rbbInfo.getEntrys().get(j);
                if (i == j) continue;
                boolean result = false;
                if (rbbeInfo1.getPerson().getId().equals((Object)rbbeInfo2.getPerson().getId())) {
                    if (rbbeInfo1.getToAdminOrg() != null && rbbeInfo2.getToAdminOrg() != null && rbbeInfo1.getToAdminOrg().getId().equals((Object)rbbeInfo2.getToAdminOrg().getId())) {
                        result = true;
                    }
                    if (rbbeInfo1.getToPosition() != null && rbbeInfo2.getToPosition() != null && rbbeInfo1.getToPosition().getId().equals((Object)rbbeInfo2.getToPosition().getId())) {
                        result = true;
                    }
                }
                if (!result) continue;
                throw new StandbyException(StandbyException.STANDBYPERSON_REPEAT, new Object[]{i + 1, j + 1});
            }
            StringBuffer sql = new StringBuffer("select rb.FNumber, rb.FID from T_HR_StandbyReviewBizBillEntry re ");
            sql.append("inner join T_HR_StandbyReviewBizBill rb on re.FBillID = rb.FID where re.FPersonID = '");
            if (rbbeInfo1.getToAdminOrg() != null) {
                sql.append(rbbeInfo1.getPerson().getId().toString());
                sql.append("' and re.FToAdminOrgID = '");
                sql.append(rbbeInfo1.getToAdminOrg().getId().toString());
                sql.append("' and re.FStandbyTypeID = '");
                sql.append(rbbeInfo1.getStandbyType().getId().toString());
                sql.append("' and (rb.FBillState in (0, 1, 2) or (rb.FBillState = 3 and re.FBizDate >= ");
                sql.append(this.getCurrentDate());
                sql.append("))");
            } else {
                sql.append(rbbeInfo1.getPerson().getId().toString());
                sql.append("' and re.FToPositionID = '");
                sql.append(rbbeInfo1.getToPosition().getId().toString());
                sql.append("' and re.FStandbyTypeID = '");
                sql.append(rbbeInfo1.getStandbyType().getId().toString());
                sql.append("' and (rb.FBillState in (0, 1, 2) or (rb.FBillState = 3 and re.FBizDate >= ");
                sql.append(this.getCurrentDate());
                sql.append("))");
            }
            if (sql.length() <= 0) continue;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (!rs.next()) continue;
                String billNumber = rs.getString(1);
                throw new StandbyException(StandbyException.STANDBYPERSON_ISUSED, new Object[]{i + 1, billNumber});
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }
}

