/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.ChannelCoursE1Collection;
import com.kingdee.eas.hr.train.ChannelCoursE1Factory;
import com.kingdee.eas.hr.train.ChannelCoursE1Info;
import com.kingdee.eas.hr.train.app.AbstractChannelCoursE1ControllerBean;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ChannelCoursE1ControllerBean
extends AbstractChannelCoursE1ControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.ChannelCoursE1ControllerBean");
    private static final String resourcePath = "com.kingdee.eas.hr.train.TrainResource";
    private static final String RES = "com.kingdee.eas.hr.train.RequirementResource";
    Set notDeleteSet = new HashSet();

    protected String _batchForE1(Context ctx, IObjectCollection channelCoursE1Col, Set deleteE1Col) throws BOSException, EASBizException {
        String notDelMessage = null;
        if (channelCoursE1Col != null && channelCoursE1Col.size() > 0) {
            this.batchUpdateChannelCoursE1(ctx, channelCoursE1Col);
        }
        if (deleteE1Col != null && !deleteE1Col.isEmpty()) {
            notDelMessage = this.checkIsReference(ctx, deleteE1Col);
            if (this.notDeleteSet != null && !this.notDeleteSet.isEmpty()) {
                for (String notDelID : this.notDeleteSet) {
                    deleteE1Col.remove(notDelID);
                }
            }
            if (deleteE1Col != null && !deleteE1Col.isEmpty()) {
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)deleteE1Col, CompareType.INCLUDE));
                ChannelCoursE1Factory.getLocalInstance(ctx).delete(fi);
            }
        }
        return notDelMessage;
    }

    private void batchUpdateChannelCoursE1(Context ctx, IObjectCollection channelCoursE1Col) throws BOSException, EASBizException {
        ChannelCoursE1Collection channelCoursE1Collection = (ChannelCoursE1Collection)channelCoursE1Col;
        Connection con = null;
        PreparedStatement pstm = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("update T_HR_CHANNELCOURSE set FTrainCourseID = ?,FInstructorID = ?,FChargeStand = ?,FRemark = ?,FTrainItemID =?,FSeq =?,FParentID =?,FTrainChannelID =?");
            sql.append(" where FID = ?");
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            ChannelCoursE1Collection col = new ChannelCoursE1Collection();
            for (int i = 0; i < channelCoursE1Col.size(); ++i) {
                int index = 1;
                ChannelCoursE1Info info = channelCoursE1Collection.get(i);
                if (info.getId() != null) {
                    if (info.getTrainCourse() != null) {
                        pstm.setString(index++, info.getTrainCourse().getId().toString());
                    } else {
                        pstm.setNull(index++, 12);
                    }
                    if (info.getInstructor() != null) {
                        pstm.setString(index++, info.getInstructor().getId().toString());
                    } else {
                        pstm.setNull(index++, 12);
                    }
                    pstm.setString(index++, info.getChargeStand());
                    pstm.setString(index++, info.getRemark());
                    if (info.getTrainItem() != null) {
                        pstm.setString(index++, info.getTrainItem().getId().toString());
                    } else {
                        pstm.setNull(index++, 12);
                    }
                    pstm.setInt(index++, info.getSeq());
                    pstm.setString(index++, null);
                    pstm.setString(index++, info.getTrainChannel().getId().toString());
                    pstm.setString(index++, info.getId().toString());
                    pstm.addBatch();
                    continue;
                }
                col.add(info);
            }
            pstm.executeBatch();
            if (col != null && col.size() > 0) {
                this.batchAddChannelCoursE1(ctx, col);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)con);
    }

    private void batchAddChannelCoursE1(Context ctx, ChannelCoursE1Collection col) throws BOSException {
        Connection con = null;
        PreparedStatement pstm = null;
        try {
            String sql = "INSERT INTO T_HR_CHANNELCOURSE (FID, FTrainCourseID, FInstructorID, FChargeStand, FRemark, FTrainItemID, FSeq, FParentID, FTrainChannelID) VALUES (?,?,?,?,?,?,?,?,?)";
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            String id = null;
            for (int i = 0; i < col.size(); ++i) {
                int index = 1;
                ChannelCoursE1Info info = col.get(i);
                id = BOSUuid.create((BOSObjectType)new ChannelCoursE1Info().getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)id);
                if (info.getTrainCourse() != null) {
                    pstm.setString(index++, info.getTrainCourse().getId().toString());
                } else {
                    pstm.setNull(index++, 12);
                }
                if (info.getInstructor() != null) {
                    pstm.setString(index++, info.getInstructor().getId().toString());
                } else {
                    pstm.setNull(index++, 12);
                }
                pstm.setString(index++, info.getChargeStand());
                pstm.setString(index++, info.getRemark());
                if (info.getTrainItem() != null) {
                    pstm.setString(index++, info.getTrainItem().getId().toString());
                } else {
                    pstm.setNull(index++, 12);
                }
                pstm.setInt(index++, info.getSeq());
                pstm.setString(index++, null);
                pstm.setString(index++, info.getTrainChannel().getId().toString());
                pstm.addBatch();
            }
            pstm.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)con);
    }

    protected String _batchAddInstructorForCourse(Context ctx, Set addInstructorID, Set delInstructorID, String courseID) throws BOSException, EASBizException {
        String notDelMessage = null;
        if (delInstructorID != null && delInstructorID.size() > 0) {
            notDelMessage = this.checkIsReference(ctx, delInstructorID, courseID);
            if (this.notDeleteSet != null && !this.notDeleteSet.isEmpty()) {
                for (String notDelID : this.notDeleteSet) {
                    delInstructorID.remove(notDelID);
                    if (!addInstructorID.contains(notDelID)) continue;
                    addInstructorID.remove(notDelID);
                }
            }
            if (delInstructorID != null && !delInstructorID.isEmpty()) {
                this.batchDelChannelCoursE1ForCourse(ctx, delInstructorID, courseID);
            }
        }
        if (addInstructorID != null && addInstructorID.size() > 0) {
            this.batchAddChannelCoursE1ForCourse(ctx, addInstructorID, courseID);
        }
        return notDelMessage;
    }

    private void batchDelChannelCoursE1ForCourse(Context ctx, Set delInstructorID, String courseID) throws BOSException {
        Connection con = null;
        PreparedStatement pstm = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("DELETE FROM T_HR_CHANNELCOURSE WHERE FTraincourseID = ");
            sql.append("'");
            sql.append(courseID);
            sql.append("' ");
            sql.append("AND FInstructorID in(");
            sql.append(TrainUtilsServer.setSetToString(delInstructorID));
            sql.append(") ");
            sql.append("AND FTrainChannelID is null");
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            pstm.execute();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)con);
    }

    private void batchAddChannelCoursE1ForCourse(Context ctx, Set addInstructorID, String courseID) throws BOSException {
        Connection con = null;
        PreparedStatement pstm = null;
        try {
            String sql = "INSERT INTO T_HR_CHANNELCOURSE (FID, FTrainCourseID, FInstructorID, FChargeStand, FRemark, FTrainItemID, FSeq, FParentID, FTrainChannelID) VALUES (?,?,?,?,?,?,?,?,?)";
            con = this.getConnection(ctx);
            pstm = con.prepareStatement(sql.toString());
            String id = null;
            Iterator iterator = addInstructorID.iterator();
            while (iterator.hasNext()) {
                int index = 1;
                String instructorID = (String)iterator.next();
                id = BOSUuid.create((BOSObjectType)new ChannelCoursE1Info().getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstm, (int)index++, (String)id);
                pstm.setString(index++, courseID);
                pstm.setString(index++, instructorID);
                pstm.setString(index++, null);
                pstm.setString(index++, null);
                pstm.setNull(index++, 12);
                pstm.setInt(index++, 0);
                pstm.setString(index++, null);
                pstm.setString(index++, null);
                pstm.addBatch();
            }
            pstm.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstm, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstm, (Connection)con);
    }

    private String checkIsReference(Context ctx, Set deleteE1Set) throws BOSException {
        StringBuffer sql = new StringBuffer();
        HashSet<String> notDelAct = new HashSet<String>();
        HashSet<String> notDelEmp = new HashSet<String>();
        sql.append("Select TA.FName_L2, TI.FName_L2, ACP.FChannelCourse from T_HR_TrainActivity AS TA \n");
        sql.append("Left Outer join T_HR_TrainActCourse AS TAC On TA.FID = TAC.FTrainActivityID \n");
        sql.append("Left Outer join T_HR_TrainACP AS ACP ON TAC.FID = ACP.FParentID \n");
        sql.append("Left Outer join T_HR_CHANNELCOURSE AS E1 ON ACP.FChannelCourse = E1.FID \n");
        sql.append("Left Outer join T_HR_TrainInstructor AS TI ON E1.FInstructorID = TI.FID \n");
        sql.append("Where ACP.FChannelCourse In (");
        sql.append(TrainUtilsServer.setSetToString(deleteE1Set));
        sql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer existMessage = new StringBuffer();
        String hasExistE1 = ResourceBase.getString((String)resourcePath, (String)"hasExistE1", (Locale)ctx.getLocale());
        try {
            while (rowSet.next()) {
                this.notDeleteSet.add(rowSet.getString(3));
                notDelAct.add(rowSet.getString(1));
                notDelEmp.add(rowSet.getString(2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!notDelAct.isEmpty() && !notDelEmp.isEmpty()) {
            Iterator it = notDelAct.iterator();
            StringBuffer notDelActST = new StringBuffer();
            String split = ResourceBase.getString((String)RES, (String)"SPLIT", (Locale)ctx.getLocale());
            while (it.hasNext()) {
                if (notDelActST.length() > 0) {
                    notDelActST.append(split);
                }
                notDelActST.append(it.next().toString());
            }
            it = notDelEmp.iterator();
            StringBuffer notDelEmpST = new StringBuffer();
            while (it.hasNext()) {
                if (notDelEmpST.length() > 0) {
                    notDelActST.append(split);
                }
                notDelEmpST.append(it.next().toString());
            }
            existMessage.append(MessageFormat.format(hasExistE1, notDelEmpST.toString(), notDelActST.toString()));
            return existMessage.toString();
        }
        return null;
    }

    private String checkIsReference(Context ctx, Set delInstructorID, String courseID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        HashSet<String> notDelAct = new HashSet<String>();
        HashSet<String> notDelEmp = new HashSet<String>();
        sql.append("Select TA.FName_L2, TI.FName_L2, E1.FInstructorID from T_HR_TrainActivity AS TA \n");
        sql.append("Left Outer join T_HR_TrainActCourse AS TAC On TA.FID = TAC.FTrainActivityID \n");
        sql.append("Left Outer join T_HR_TrainACP AS ACP ON TAC.FID = ACP.FParentID \n");
        sql.append("Left Outer join T_HR_CHANNELCOURSE AS E1 ON ACP.FChannelCourse = E1.FID \n");
        sql.append("Left Outer join T_HR_TrainInstructor AS TI ON E1.FInstructorID = TI.FID \n");
        sql.append("Where E1.FTraincourseID = '");
        sql.append(courseID);
        sql.append("' \n");
        sql.append("And E1.FInstructorID In(");
        sql.append(TrainUtilsServer.setSetToString(delInstructorID));
        sql.append(") \n");
        sql.append("AND E1.FTrainChannelID is null");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer existMessage = new StringBuffer();
        String hasExistE1 = ResourceBase.getString((String)resourcePath, (String)"hasExistE1", (Locale)ctx.getLocale());
        try {
            while (rowSet.next()) {
                this.notDeleteSet.add(rowSet.getString(3));
                notDelAct.add(rowSet.getString(1));
                notDelEmp.add(rowSet.getString(2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!notDelAct.isEmpty() && !notDelEmp.isEmpty()) {
            Iterator it = notDelAct.iterator();
            StringBuffer notDelActST = new StringBuffer();
            String split = ResourceBase.getString((String)RES, (String)"SPLIT", (Locale)ctx.getLocale());
            while (it.hasNext()) {
                if (notDelActST.length() > 0) {
                    notDelActST.append(split);
                }
                notDelActST.append(it.next().toString());
            }
            it = notDelEmp.iterator();
            StringBuffer notDelEmpST = new StringBuffer();
            while (it.hasNext()) {
                if (notDelEmpST.length() > 0) {
                    notDelEmpST.append(split);
                }
                notDelEmpST.append(it.next().toString());
            }
            existMessage.append(MessageFormat.format(hasExistE1, notDelEmpST.toString(), notDelActST.toString()));
            return existMessage.toString();
        }
        return null;
    }
}

