/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.OuterTrainApplyException;
import com.kingdee.eas.hr.train.OuterTrainApplyFactory;
import com.kingdee.eas.hr.train.OuterTrainApplyInfo;
import com.kingdee.eas.hr.train.TrainAuditStateEnum;
import com.kingdee.eas.hr.train.app.AbstractOuterTrainApplyControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class OuterTrainApplyControllerBean
extends AbstractOuterTrainApplyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.OuterTrainApplyControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkCanUpdateOrDelete(ctx, pk);
        CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)OuterTrainApplyFactory.getLocalInstance(ctx), OuterTrainApplyInfo.class.getName());
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        this.checkCanUpdateOrDelete(ctx, pk);
        super._update(ctx, pk, model);
    }

    private void checkCanUpdateOrDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException, OuterTrainApplyException {
        if (!this._canUpdateOrDelete(ctx, pk.toString())) {
            throw new OuterTrainApplyException(OuterTrainApplyException.CANNOT_DELETE_UPDATE);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((OuterTrainApplyInfo)model));
        this._checkNumberDup(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((OuterTrainApplyInfo)model));
        this._checkNumberDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        OuterTrainApplyInfo info = (OuterTrainApplyInfo)model;
        String number = info.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            throw new OuterTrainApplyException(OuterTrainApplyException.NUMBER_NOT_EMPTY);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("HrOrgUnit.id", (Object)ContextUtil.getCurrentHRUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (OuterTrainApplyFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new OuterTrainApplyException(OuterTrainApplyException.NUMBER_NOT_DUP);
        }
    }

    protected void _submission(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (!this.canSubmission(ctx, ((OuterTrainApplyInfo)model).getId())) {
            throw new OuterTrainApplyException(OuterTrainApplyException.UNSUBMIT);
        }
    }

    private boolean canSubmission(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (id == null) {
            return false;
        }
        return this._canUpdateOrDelete(ctx, id.toString());
    }

    private boolean _canUpdateOrDelete(Context ctx, String id) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)10, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("AuditState", (Object)30, CompareType.EQUALS));
        filterInfo.setMaskString("#0 AND ( #1 OR #2)");
        return OuterTrainApplyFactory.getLocalInstance(ctx).exists(filterInfo);
    }

    protected void _setAuditingState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.updateBillState(ctx, id, TrainAuditStateEnum.AUDITING);
    }

    protected void _setPassState(Context ctx, BOSUuid id, BOSUuid auditorID) throws BOSException, EASBizException {
        this.updateBillAuditor(ctx, id, auditorID);
        this.updateBillState(ctx, id, TrainAuditStateEnum.PASS);
    }

    protected void _setUnpassState(Context ctx, BOSUuid id, BOSUuid auditorID) throws BOSException, EASBizException {
        this.updateBillAuditor(ctx, id, auditorID);
        this.updateBillState(ctx, id, TrainAuditStateEnum.UNPASS);
    }

    private void updateBillAuditor(Context ctx, BOSUuid id, BOSUuid auditorID) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE T_HR_OuterTrainApply SET FAuditorID = ? WHERE FID = ? ";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            if (auditorID != null) {
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)auditorID.toString());
            } else {
                pstmt.setString(1, null);
            }
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)id.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void updateBillState(Context ctx, BOSUuid id, TrainAuditStateEnum pass) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "UPDATE T_HR_OuterTrainApply SET FAuditState = ? WHERE FID = ? ";
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, pass.getValue());
            DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)id.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }
}

