/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.train.RequirementFactory;
import com.kingdee.eas.hr.train.RequirementInfo;
import com.kingdee.eas.hr.train.RequirementIssueFactory;
import com.kingdee.eas.hr.train.RequirementStateEnum;
import com.kingdee.eas.hr.train.app.AbstractRequirementControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import org.apache.log4j.Logger;

public class RequirementControllerBean
extends AbstractRequirementControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.RequirementControllerBean");
    private static final String HR_ORG_UNIT = "hrOrgUnit.id";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameDup(ctx, model);
        return super._submit(ctx, model);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filterInfo = TrainUtilsServer.getHRFilterInfo(ctx, HR_ORG_UNIT);
        if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
            return filterInfo;
        }
        return super.getFilterForDefaultCU(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)pk.toString()));
        RequirementIssueFactory.getLocalInstance(ctx).delete(filterInfo);
        CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)RequirementFactory.getLocalInstance(ctx), RequirementInfo.class.getName());
        super._delete(ctx, pk);
    }

    protected void _close(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RequirementInfo requirementInfo = (RequirementInfo)this._getValue(ctx, pk);
        requirementInfo.setState(RequirementStateEnum.CLOSED);
        this._update(ctx, pk, (IObjectValue)requirementInfo);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((RequirementInfo)model));
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((RequirementInfo)model));
        return super._addnew(ctx, model);
    }
}

