/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.hr.train.RequirementAssistant;
import com.kingdee.eas.hr.train.TrainAssistant;
import com.kingdee.eas.hr.train.app.AbstractRequirementListUIHandler;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;

public class RequirementListUIHandler
extends AbstractRequirementListUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        TrainUtilsServer.handleDefaultSolution(request, response, context);
        TrainAssistant.getUserOrgInfo((String)request.get("currentPersonId"), context);
    }

    protected void _handleActionPublish(RequestContext request, ResponseContext response, Context context) throws Exception {
        RequirementAssistant.getIssueId((String)request.get("requirementId"), (Boolean)request.get("curRowIsCreatorOrSameOrg"), context);
    }

    protected void _handleActionProcess(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.handleRootIssueInfo(request, context);
    }

    private void handleRootIssueInfo(RequestContext request, Context context) throws BOSException {
        if (request.get("requirementId") != null) {
            RequirementAssistant.getRootIssueInfo((String)request.get("requirementId"), context);
        }
    }

    protected FilterInfo getDefaultFilterForQuery(RequestContext request, Context context) throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        String currentPersonId = (String)request.get("currentPersonId");
        AdminOrgUnitInfo orgUnitInfo = TrainAssistant.getUserOrgInfo(currentPersonId, context);
        String userOrgUnitId = null;
        if (orgUnitInfo != null) {
            userOrgUnitId = orgUnitInfo.getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)currentPersonId));
        filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)userOrgUnitId));
        filterInfo.getFilterItems().add(new FilterItemInfo("receiver.id", (Object)currentPersonId));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)10, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("issueEntry.state", (Object)20));
        filterInfo.setMaskString("#0 or #1 or (#2 and #3 and #4)");
        filterInfo.mergeFilter(TrainUtilsServer.getHRFilterInfo(context, "hrOrgUnit.id"), "AND");
        request.setInitFilterInfo(filterInfo);
        return filterInfo;
    }

    protected void _handleActionGather(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.handleRootIssueInfo(request, context);
    }

    protected void _handleActionResponseSuggest(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.handleRootIssueInfo(request, context);
    }

    protected void _handleActionClose(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionAddCourseRequirement(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected void _handleActionAddItemRequirement(RequestContext request, ResponseContext response, Context context) throws Exception {
    }
}

