/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.RequirementIssueEntryCollection;
import com.kingdee.eas.hr.train.RequirementIssueEntryFactory;
import com.kingdee.eas.hr.train.RequirementResponseCollection;
import com.kingdee.eas.hr.train.RequirementResponseEnum;
import com.kingdee.eas.hr.train.RequirementResponseInfo;
import com.kingdee.eas.hr.train.app.AbstractRequirementResponseControllerBean;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class RequirementResponseControllerBean
extends AbstractRequirementResponseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.RequirementResponseControllerBean");

    protected boolean _parentIsResponsed(Context ctx, String requirementId, String responserId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("parent.publisher.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("parent.isRoot"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)responserId));
        filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
        viewInfo.setFilter(filterInfo);
        RequirementIssueEntryCollection collection = RequirementIssueEntryFactory.getLocalInstance(ctx).getRequirementIssueEntryCollection(viewInfo);
        String superPublisherId = null;
        if (collection != null && collection.size() > 0) {
            if (collection.get(0).getParent().isIsRoot()) {
                return false;
            }
            superPublisherId = collection.get(0).getParent().getPublisher().getId().toString();
        }
        viewInfo.getSelector().clear();
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        filterInfo.getFilterItems().clear();
        filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
        filterInfo.getFilterItems().add(new FilterItemInfo("responser.id", (Object)superPublisherId));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)20));
        viewInfo.setFilter(filterInfo);
        RequirementResponseCollection responses = this.getRequirementResponseCollection(ctx, viewInfo);
        boolean result = false;
        if (responses != null && responses.size() > 0) {
            result = true;
        }
        return result;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RequirementResponseInfo info = (RequirementResponseInfo)model;
        info.setState(RequirementResponseEnum.RESPONSED);
        info.setResponseDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        return super._submit(ctx, model);
    }

    protected IObjectValue _getRequirementResponseInfo(Context ctx, String requirementId, String responserId, SelectorItemCollection selectors) throws BOSException, EASBizException {
        RequirementResponseInfo info = null;
        if (requirementId != null && responserId != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            if (selectors != null && selectors.size() > 0) {
                for (int i = 0; i < selectors.size(); ++i) {
                    viewInfo.getSelector().add(selectors.get(i));
                }
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("requirement.id", (Object)requirementId));
            filterInfo.getFilterItems().add(new FilterItemInfo("responser.id", (Object)responserId));
            viewInfo.setFilter(filterInfo);
            RequirementResponseCollection collection = this.getRequirementResponseCollection(ctx, viewInfo);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
            }
        }
        return info;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("requirement.name"));
        sic.add(new SelectorItemInfo("responser.name"));
        RequirementResponseInfo responseInfo = (RequirementResponseInfo)this._getValue(ctx, pk, sic);
        return responseInfo.getLogInfo();
    }
}

