/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.hr.train.TrainActCourseCollection;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActivityException;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainCourseCostFactory;
import com.kingdee.eas.hr.train.TrainCourseFactory;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainCourseSummaryCollection;
import com.kingdee.eas.hr.train.TrainCourseSummaryFactory;
import com.kingdee.eas.hr.train.TrainPlanException;
import com.kingdee.eas.hr.train.TrainStudentCollection;
import com.kingdee.eas.hr.train.TrainStudentCourseFactory;
import com.kingdee.eas.hr.train.TrainStudentCourseInfo;
import com.kingdee.eas.hr.train.TrainStudentFactory;
import com.kingdee.eas.hr.train.TrainStudentInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainActCourseControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainActCourseControllerBean
extends AbstractTrainActCourseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainActCourseControllerBean");

    protected void _delete(Context ctx, Set trainActCourseIdSet, String trainActivityId) throws BOSException, EASBizException {
        for (int i = 0; i < trainActCourseIdSet.size(); ++i) {
            if (!ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)trainActCourseIdSet.toArray()[i].toString()))) continue;
            TrainActCourseInfo trainActCourseInfo = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseInfo((IObjectPK)new ObjectUuidPK(trainActCourseIdSet.toArray()[i].toString()));
            TrainCourseInfo courseInfo = TrainCourseFactory.getLocalInstance(ctx).getTrainCourseInfo((IObjectPK)new ObjectUuidPK(trainActCourseInfo.getTrainCourse().getId()));
            Object[] objs = new Object[]{courseInfo.getName()};
            throw new TrainPlanException(TrainPlanException.TRAINACTCOURSE_HASREL, objs);
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainActCourseIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(fInfo);
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        TrainCourseSummaryCollection trainCourseSummaryColl = TrainCourseSummaryFactory.getLocalInstance(ctx).getTrainCourseSummaryCollection(entityViewInfo);
        int size = trainCourseSummaryColl.size();
        for (int i = 0; i < size; ++i) {
            TrainCourseSummaryFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(trainCourseSummaryColl.get(i).getId()));
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("id"));
        int trainActCourseCount = 0;
        TrainActCourseCollection trainActCourseCollection = this.getTrainActCourseCollection(ctx, evi);
        if (trainActCourseCollection != null) {
            trainActCourseCount = trainActCourseCollection.size();
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainActCourseIdSet, CompareType.INCLUDE));
        TrainStudentCourseFactory.getLocalInstance(ctx).delete(fi);
        TrainCourseCostFactory.getLocalInstance(ctx).delete(fi);
        if (trainActCourseIdSet.size() == trainActCourseCount) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)trainActivityId));
            TrainStudentFactory.getLocalInstance(ctx).delete(filter);
        }
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(new FilterItemInfo("id", (Object)trainActCourseIdSet, CompareType.INCLUDE));
        this.delete(ctx, info);
        trainActCourseCollection = this.getTrainActCourseCollection(ctx, evi);
        if (trainActCourseCollection != null) {
            trainActCourseCount = trainActCourseCollection.size();
        }
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app", "TrainStudentCourseCountQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("trainActivity.id", (Object)trainActivityId));
        viewInfo.setFilter(filter);
        exec.setObjectView(viewInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)exec.getSQL());
        Map orgAndPosMap = null;
        try {
            orgAndPosMap = this.getOrgAndPosition(ctx, trainActivityId);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.fillTrainStudent(ctx, rowSet, trainActCourseCount, orgAndPosMap);
        TrainActivityFacadeFactory.getLocalInstance(ctx).updateTrainActivityBudgetCost(trainActivityId);
    }

    private Map getOrgAndPosition(Context ctx, String activityID) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FOrgStudentID AS orgID, FPosiStudentID AS posID, FPersonID AS personID from T_HR_TrainStudentCourse where FTrainActCourseID IN (");
        sql.append("select FID from T_HR_TrainActCourse where FTrainActivityID = ");
        sql.append("'");
        sql.append(activityID);
        sql.append("'");
        sql.append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String[]> personMap = new HashMap<String, String[]>();
        HashSet<String> personIDSet = new HashSet<String>();
        rowSet.beforeFirst();
        while (rowSet.next()) {
            if (personIDSet.contains(rowSet.getString("personID"))) continue;
            String[] str = new String[]{rowSet.getString("orgID"), rowSet.getString("posID")};
            String personID = rowSet.getString("personID");
            personMap.put(personID, str);
            personIDSet.add(rowSet.getString("personID"));
        }
        return personMap;
    }

    private void fillTrainStudent(Context ctx, IRowSet rowSet, int trainActCourseCount, Map orgAndPosMap) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            String sql2 = "INSERT INTO T_HR_TrainStudent (FID, FControlUnitID, FTrainActivityID, FPersonID, FOrgStudentID, FPosiStudentID, FType) VALUES (?,?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql2);
            while (rowSet.next()) {
                if (rowSet.getInt("count") != trainActCourseCount) continue;
                String studentId = BOSUuid.create((BOSObjectType)new TrainStudentInfo().getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)studentId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)rowSet.getString("trainActivity.id"));
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)rowSet.getString("Person.id"));
                if (orgAndPosMap.containsKey(rowSet.getString("Person.id"))) {
                    String[] str = (String[])orgAndPosMap.get(rowSet.getString("Person.id"));
                    pstmt.setString(5, str[0]);
                    pstmt.setString(6, str[1]);
                } else {
                    pstmt.setNull(5, 12);
                    pstmt.setNull(6, 12);
                }
                pstmt.setInt(7, 10);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainActCourseInfo actCourseInfo = (TrainActCourseInfo)model;
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainCourse.id", (Object)actCourseInfo.getTrainCourse().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)actCourseInfo.getTrainActivity().getId().toString()));
        if (actCourseInfo.getId() != null) {
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)actCourseInfo.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, fi)) {
            throw new TrainActivityException(TrainActivityException.EXIST_COURSE_WITH_THE_SAME_ID);
        }
        if (!actCourseInfo.getTrainActivity().isNeedDivide() && actCourseInfo.getId() == null) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)actCourseInfo.getTrainActivity().getId().toString()));
            TrainStudentFactory.getLocalInstance(ctx).delete(filterInfo);
        }
        IObjectPK pk = super._submit(ctx, model);
        TrainActivityFacadeFactory.getLocalInstance(ctx).updateTrainActivityBudgetCost(actCourseInfo.getTrainActivity().getId().toString());
        return pk;
    }

    private void fillTrainStudentCourse(Context ctx, TrainStudentCollection studentCollection, String trainActCourseId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String sql = "INSERT INTO T_HR_TrainStudentCourse (FID, FControlUnitID, FTrainActCourseID, FPersonID, FType, FOrgStudentID, FPosiStudentID) VALUES (?,?,?,?,?,?,?)";
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            TrainStudentInfo info = null;
            int size = studentCollection.size();
            for (int i = 0; i < size; ++i) {
                info = (TrainStudentInfo)studentCollection.getObject(i);
                String id = BOSUuid.create((BOSObjectType)new TrainStudentCourseInfo().getBOSType()).toString();
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)trainActCourseId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getPerson().getId().toString());
                pstmt.setInt(5, info.getType().getValue());
                pstmt.setString(6, info.getOrgStudent().getId().toString());
                pstmt.setString(7, info.getPosiStudent().getId().toString());
                if (info.getPosiStudent() == null) {
                    pstmt.setString(7, null);
                }
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _update(Context ctx, IObjectPK objectPK, IObjectValue objectValue) throws BOSException, EASBizException {
        super._update(ctx, objectPK, objectValue);
        TrainCourseSummaryFactory.getLocalInstance(ctx).syncParticipator(this._getValue(ctx, objectPK));
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        this.handleTrainStudentCourse(ctx, (TrainActCourseInfo)model, pk);
        return pk;
    }

    private void handleTrainStudentCourse(Context ctx, TrainActCourseInfo actCourseInfo, IObjectPK pk) throws BOSException, EASBizException {
        if (actCourseInfo.getTrainActivity().isNeedDivide()) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("TrainActivity.id", (Object)actCourseInfo.getTrainActivity().getId().toString()));
            evi.setFilter(filterInfo);
            evi.getSelector().add(new SelectorItemInfo("Person.id"));
            evi.getSelector().add(new SelectorItemInfo("Type"));
            evi.getSelector().add(new SelectorItemInfo("OrgStudent.id"));
            evi.getSelector().add(new SelectorItemInfo("PosiStudent.id"));
            TrainStudentCollection studentColl = TrainStudentFactory.getLocalInstance(ctx).getTrainStudentCollection(evi);
            this.fillTrainStudentCourse(ctx, studentColl, pk.toString());
        }
    }
}

