/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.train.TrainChanneCategoryEnum;
import com.kingdee.eas.hr.train.TrainChanneCategoryFactory;
import com.kingdee.eas.hr.train.TrainChanneCategoryInfo;
import com.kingdee.eas.hr.train.TrainChanneException;
import com.kingdee.eas.hr.train.TrainException;
import com.kingdee.eas.hr.train.app.AbstractTrainChanneCategoryControllerBean;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class TrainChanneCategoryControllerBean
extends AbstractTrainChanneCategoryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainChanneCategoryControllerBean");
    private static final String HR_ORG_UNIT = "hrOrgUnit.id";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (dataBaseInfo.getNumber() != null) {
            dataBaseInfo.setNumber(dataBaseInfo.getNumber().trim());
            if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
                this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
            }
        }
        if (dataBaseInfo.getName() != null) {
            dataBaseInfo.setName(dataBaseInfo.getName().trim());
            if (dataBaseInfo.getName() != null && dataBaseInfo.getName().length() > 0) {
                this._checkNameDup(ctx, model);
            }
        }
        return super._submit(ctx, model);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return super.getFilterForDefaultCU(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            if (this.isInnerTrainChanneCategory(ctx, pk)) {
                throw new TrainException(TrainException.INNER_CHANNETYPE_NOTDEL);
            }
            super._delete(ctx, pk);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainChanneCategoryInfo info = (TrainChanneCategoryInfo)model;
        String number = info.getNumber();
        if (StringUtils.isEmpty((String)number)) {
            throw new TrainChanneException(TrainChanneException.NUMBER_NOT_NULL);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (TrainChanneCategoryFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new TrainChanneException(TrainChanneException.NUMBER_DUP);
        }
    }

    private boolean isInnerTrainChanneCategory(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        TrainChanneCategoryInfo info = (TrainChanneCategoryInfo)TrainChanneCategoryFactory.getLocalInstance(ctx).getValue(pk);
        return info != null && (info.getProperty() == null || TrainChanneCategoryEnum.INNER.equals((Object)info.getProperty()));
    }
}

