/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.dao.ReferenceDAO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.train.TrainCourseFactory;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainException;
import com.kingdee.eas.hr.train.TrainItemCourseCollection;
import com.kingdee.eas.hr.train.TrainItemCourseFactory;
import com.kingdee.eas.hr.train.TrainItemCourseInfo;
import com.kingdee.eas.hr.train.TrainResourceException;
import com.kingdee.eas.hr.train.app.AbstractTrainCourseControllerBean;
import com.kingdee.eas.hr.train.app.CodingRuleServerHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;

public class TrainCourseControllerBean
extends AbstractTrainCourseControllerBean {
    private static String RES = "com.kingdee.eas.hr.train.TrainResource";

    protected boolean _setEnable(Context ctx, IObjectPK courseId) throws BOSException, EASBizException {
        TrainCourseInfo courseInfo = TrainCourseFactory.getLocalInstance(ctx).getTrainCourseInfo(courseId);
        if (courseInfo.isIsEnable()) {
            throw new TrainException(TrainException.TRAINCOURSE_ISENABLED);
        }
        courseInfo.setIsEnable(true);
        this.update(ctx, courseId, (CoreBaseInfo)courseInfo);
        return true;
    }

    protected boolean _setDisnable(Context ctx, IObjectPK courseId) throws BOSException, EASBizException {
        TrainCourseInfo courseInfo = TrainCourseFactory.getLocalInstance(ctx).getTrainCourseInfo(courseId);
        String names = null;
        if (!courseInfo.isIsEnable()) {
            throw new TrainException(TrainException.TRAINCOURSE_ISDISABLED);
        }
        names = this.isTrainItemDisable(ctx, courseId.toString());
        if (names.length() > 0) {
            throw new TrainException(TrainException.TRAINITEM_ISNOTDISABLE, new Object[]{names});
        }
        courseInfo.setIsEnable(false);
        this.update(ctx, courseId, (CoreBaseInfo)courseInfo);
        return true;
    }

    private String isTrainItemDisable(Context ctx, String courseId) throws BOSException {
        StringBuffer nameString = new StringBuffer();
        TrainItemCourseCollection itemCourseCollection = this.getItemCourses(ctx, courseId);
        if (itemCourseCollection != null && itemCourseCollection.size() > 0) {
            int i = 0;
            Iterator it = itemCourseCollection.iterator();
            while (it.hasNext()) {
                TrainItemCourseInfo itemCourseInfo = (TrainItemCourseInfo)it.next();
                if (i != 0) {
                    nameString.append(", ");
                }
                nameString.append(itemCourseInfo.getParent().getName());
                ++i;
            }
        }
        return nameString.toString();
    }

    private TrainItemCourseCollection getItemCourses(Context ctx, String courseId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("parent.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("parent.isEnable"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("course.id", (Object)courseId));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.isEnable", (Object)1));
        viewInfo.setFilter(filterInfo);
        return TrainItemCourseFactory.getLocalInstance(ctx).getTrainItemCourseCollection(viewInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        TrainCourseInfo info = (TrainCourseInfo)model;
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        super._update(ctx, pk, model);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return super.getFilterForDefaultCU(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainCourseInfo)model));
        TrainCourseInfo info = (TrainCourseInfo)model;
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        super._addnew(ctx, pk, (IObjectValue)info);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CodingRuleServerHelper.setInfoNumber(ctx, (CoreBaseInfo)((TrainCourseInfo)model));
        TrainCourseInfo info = (TrainCourseInfo)model;
        info.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
        return super._addnew(ctx, (IObjectValue)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        if (ReferenceDAO.isReferenced((Context)ctx, (BOSUuid)BOSUuid.read((String)pk.toString()))) {
            throw new TrainResourceException(TrainResourceException.CAN_NOT_DEL_COURSE);
        }
        CodingRuleServerHelper.recycleNumber(ctx, pk, (ICoreBase)TrainCourseFactory.getLocalInstance(ctx), TrainCourseInfo.class.getName());
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameDup(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TrainCourseInfo info = (TrainCourseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)info.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getOrgUnit().getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String message = null;
            MessageFormat format = new MessageFormat(ResourceBase.getString((String)RES, (String)"nameDup", (Locale)ctx.getLocale()));
            message = format.format(new Object[]{info.getOrgUnit().getName(), info.getName()});
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{message});
        }
    }
}

