/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.train.ITrainActCourse;
import com.kingdee.eas.hr.train.TrainActCourseCollection;
import com.kingdee.eas.hr.train.TrainActCourseFactory;
import com.kingdee.eas.hr.train.TrainActCourseInfo;
import com.kingdee.eas.hr.train.TrainActivityFacadeFactory;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseCostInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainCourseCostControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class TrainCourseCostControllerBean
extends AbstractTrainCourseCostControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainCourseCostControllerBean");

    protected Map _submit(Context ctx, IObjectCollection trainCourseCostCollection, boolean isNeedOverWrite) throws BOSException, EASBizException {
        HashMap<String, String> map;
        PreparedStatement pstmt;
        Connection conn;
        block10: {
            conn = null;
            pstmt = null;
            map = new HashMap<String, String>();
            try {
                String sql = "INSERT INTO T_HR_TrainCourseCost (FID, FControlUnitID, FTrainActCourseID, FChargeItemID, FChargeStand, FCount, FCost) VALUES (?,?,?,?,?,?,?)";
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement(sql);
                HashSet<String> actCourseIds = new HashSet<String>();
                String id = null;
                TrainCourseCostInfo info = null;
                int size = trainCourseCostCollection.size();
                for (int i = 0; i < size; ++i) {
                    info = (TrainCourseCostInfo)trainCourseCostCollection.getObject(i);
                    if (!TrainCommonUtils.isEmpty((CoreBaseInfo)info.getTrainActCourse())) {
                        actCourseIds.add(info.getTrainActCourse().getId().toString());
                    }
                    if (info.getId() != null) continue;
                    id = BOSUuid.create((BOSObjectType)info.getBOSType()).toString();
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)id);
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)3, (String)info.getTrainActCourse().getId().toString());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)4, (String)info.getChargeItem().getId().toString());
                    pstmt.setString(5, info.getChargeStand());
                    pstmt.setString(6, info.getCount());
                    pstmt.setBigDecimal(7, info.getCost());
                    pstmt.addBatch();
                    map.put(info.getChargeItem().getId().toString(), id);
                }
                pstmt.executeBatch();
                SQLUtils.cleanup((Statement)pstmt);
                String sql2 = "UPDATE T_HR_TrainCourseCost SET FChargeItemID = ?, FChargeStand= ?, FCount = ?, FCost = ? WHERE FID = ?";
                pstmt = conn.prepareStatement(sql2);
                TrainCourseCostInfo info2 = null;
                int size2 = trainCourseCostCollection.size();
                for (int i = 0; i < size2; ++i) {
                    info2 = (TrainCourseCostInfo)trainCourseCostCollection.getObject(i);
                    if (info2.getId() == null) continue;
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)info2.getChargeItem().getId().toString());
                    pstmt.setString(2, info2.getChargeStand());
                    pstmt.setString(3, info2.getCount());
                    pstmt.setBigDecimal(4, info2.getCost());
                    DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)5, (String)info2.getId().toString());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                if (!isNeedOverWrite) break block10;
                String sql3 = "UPDATE T_HR_TrainActCourse SET FTotalCost = ? WHERE FID = ?";
                pstmt = conn.prepareStatement(sql3);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", actCourseIds, CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                TrainActCourseCollection courseColl = TrainActCourseFactory.getLocalInstance(ctx).getTrainActCourseCollection(viewInfo);
                TrainActCourseInfo courseInfo = null;
                if (courseColl != null) {
                    int size3 = courseColl.size();
                    for (int i = 0; i < size3; ++i) {
                        courseInfo = courseColl.get(i);
                        BigDecimal totalCost = this.getTotalCost(courseInfo.getId().toString(), trainCourseCostCollection);
                        if (totalCost == null || totalCost.compareTo(new BigDecimal("0.00")) == 0) continue;
                        pstmt.setBigDecimal(1, totalCost);
                        DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)courseInfo.getId().toString());
                        pstmt.addBatch();
                    }
                    pstmt.executeBatch();
                }
                if (courseColl != null && courseColl.size() > 0) {
                    String trainActivityId = courseColl.get(0).getTrainActivity().getId().toString();
                    TrainActivityFacadeFactory.getLocalInstance(ctx).updateTrainActivityBudgetCost(trainActivityId);
                }
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return map;
    }

    private BigDecimal getTotalCost(String id, IObjectCollection trainCourseCostCollection) {
        BigDecimal totalCost = new BigDecimal("0.00");
        TrainCourseCostInfo info = null;
        int size = trainCourseCostCollection.size();
        for (int i = 0; i < size; ++i) {
            info = (TrainCourseCostInfo)trainCourseCostCollection.getObject(i);
            if (!id.equals(info.getTrainActCourse().getId().toString()) || info.getCost() == null) continue;
            totalCost = totalCost.add(info.getCost());
        }
        return totalCost;
    }

    protected void _delete(Context ctx, IObjectPK trainActCourseId, boolean isNeedOverWrite) throws BOSException, EASBizException {
        if (trainActCourseId == null) {
            return;
        }
        if (isNeedOverWrite) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("TotalCost"));
            sic.add(new SelectorItemInfo("TotalCost"));
            sic.add(new SelectorItemInfo("TrainCourse.id"));
            sic.add(new SelectorItemInfo("TrainActivity.id"));
            sic.add(new SelectorItemInfo("TrainActivity.needDivide"));
            ITrainActCourse trainActCourse = TrainActCourseFactory.getLocalInstance(ctx);
            TrainActCourseInfo info = trainActCourse.getTrainActCourseInfo(trainActCourseId, sic);
            info.setTotalCost(new BigDecimal("0.00"));
            trainActCourse.submit((CoreBaseInfo)info);
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("TrainActCourse.id", (Object)trainActCourseId.toString()));
        this._delete(ctx, fi);
    }
}

