/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.train.ITrainActivity;
import com.kingdee.eas.hr.train.ITrainCourse;
import com.kingdee.eas.hr.train.TrainActivityFactory;
import com.kingdee.eas.hr.train.TrainActivityInfo;
import com.kingdee.eas.hr.train.TrainCourseFactory;
import com.kingdee.eas.hr.train.TrainCourseInfo;
import com.kingdee.eas.hr.train.TrainExpenseReportHelper;
import com.kingdee.eas.hr.train.app.AbstractTrainExpenseReportFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TrainExpenseReportFacadeControllerBean
extends AbstractTrainExpenseReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainExpenseReportFacadeControllerBean");
    private AdminOrgUnitInfo rootUnit;
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private boolean isActivity;
    private boolean isCourse;

    protected Map _queryTrainExpense(Context ctx, Vector orgUnits, Date startDate, Date endDate, String activityId, String courseId) throws BOSException, EASBizException {
        return null;
    }

    protected Map _queryTrainExpense(Context ctx, Vector orgUnits, Date startDate, Date endDate, boolean isActivity, boolean isCourse, String activityId, String courseId) throws BOSException, EASBizException {
        AdminOrgUnitInfo rootUnit;
        if (orgUnits == null || orgUnits.size() <= 0) {
            return null;
        }
        Object rootNode = orgUnits.get(0);
        if (!(rootNode instanceof AdminOrgUnitInfo)) {
            return null;
        }
        this.rootUnit = rootUnit = (AdminOrgUnitInfo)rootNode;
        this.isActivity = isActivity;
        this.isCourse = isCourse;
        String sql = this.buildUnionSql(startDate, endDate, isActivity, isCourse, activityId, courseId);
        Map result = this.executeUnionQuery(ctx, sql, isActivity, isCourse, activityId, courseId);
        return result;
    }

    private void updateParentNodeExpense(Context ctx, AdminOrgUnitInfo info, TrainExpenseReportHelper helper, Map result) throws BOSException, EASBizException {
        List<TrainExpenseReportHelper> list;
        if (this.rootUnit.equals((Object)info)) {
            return;
        }
        AdminOrgUnitInfo parent = info.getParent();
        if (parent == null || this.rootUnit.equals((Object)parent)) {
            return;
        }
        String parentId = parent.getId().toString();
        if (result.containsKey(parentId)) {
            list = (List)result.get(parentId);
            int length = list.size();
            int lastIndex = length - 1;
            String activityId = "";
            if (helper.getActivityInfo() != null) {
                activityId = helper.getActivityInfo().getId().toString();
            }
            String courseId = "";
            if (helper.getCourseInfo() != null) {
                courseId = helper.getCourseInfo().getId().toString();
            }
            double newExpense = helper.getExpense();
            if (this.isActivity && this.isCourse) {
                for (int i = 0; i < length; ++i) {
                    TrainExpenseReportHelper rh = (TrainExpenseReportHelper)list.get(i);
                    if (activityId.equals(rh.getActivityInfo().getId().toString()) && courseId.equals(rh.getCourseInfo().getId().toString())) {
                        double e = rh.getExpense() + newExpense;
                        rh.setExpense(e);
                        break;
                    }
                    if (i != lastIndex) continue;
                    TrainExpenseReportHelper parentHelper = new TrainExpenseReportHelper(parentId);
                    parentHelper.setActivity(helper.isActivity());
                    parentHelper.setCourse(helper.isCourse());
                    parentHelper.setActivityInfo(helper.getActivityInfo());
                    parentHelper.setCourseInfo(helper.getCourseInfo());
                    parentHelper.setExpense(helper.getExpense());
                    list.add(parentHelper);
                }
            } else if (this.isActivity) {
                for (int i = 0; i < length; ++i) {
                    TrainExpenseReportHelper rh = (TrainExpenseReportHelper)list.get(i);
                    if (rh.getActivityInfo() != null && rh.getActivityInfo().getId() != null && activityId.equals(rh.getActivityInfo().getId().toString())) {
                        rh.setExpense(rh.getExpense() + newExpense);
                        break;
                    }
                    if (i != lastIndex) continue;
                    TrainExpenseReportHelper parentHelper = new TrainExpenseReportHelper(parentId);
                    parentHelper.setActivity(helper.isActivity());
                    parentHelper.setCourse(helper.isCourse());
                    parentHelper.setActivityInfo(helper.getActivityInfo());
                    parentHelper.setCourseInfo(helper.getCourseInfo());
                    parentHelper.setExpense(helper.getExpense());
                    list.add(parentHelper);
                }
            } else if (this.isCourse) {
                for (int i = 0; i < length; ++i) {
                    TrainExpenseReportHelper rh = (TrainExpenseReportHelper)list.get(i);
                    if (courseId.equals(rh.getCourseInfo().getId().toString())) {
                        rh.setExpense(rh.getExpense() + newExpense);
                        break;
                    }
                    if (i != lastIndex) continue;
                    TrainExpenseReportHelper parentHelper = new TrainExpenseReportHelper(parentId);
                    parentHelper.setActivity(helper.isActivity());
                    parentHelper.setCourse(helper.isCourse());
                    parentHelper.setActivityInfo(helper.getActivityInfo());
                    parentHelper.setCourseInfo(helper.getCourseInfo());
                    parentHelper.setExpense(helper.getExpense());
                    list.add(parentHelper);
                }
            } else {
                TrainExpenseReportHelper rh = (TrainExpenseReportHelper)list.get(0);
                rh.setExpense(rh.getExpense() + newExpense);
            }
        } else {
            list = new ArrayList();
            TrainExpenseReportHelper parentHelper = new TrainExpenseReportHelper(parentId);
            parentHelper.setActivity(helper.isActivity());
            parentHelper.setCourse(helper.isCourse());
            parentHelper.setActivityInfo(helper.getActivityInfo());
            parentHelper.setCourseInfo(helper.getCourseInfo());
            parentHelper.setExpense(helper.getExpense());
            list.add(parentHelper);
            result.put(parentId, list);
        }
        AdminOrgUnitInfo parentInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(parentId), this.getSIC());
        this.updateParentNodeExpense(ctx, parentInfo, helper, result);
    }

    private String buildUnionSql(Date startDate, Date endDate, boolean isActivity, boolean isCourse, String activityId, String courseId) {
        StringBuffer sql = new StringBuffer();
        String longNumber = this.rootUnit.getLongNumber();
        if (isActivity && isCourse) {
            if (activityId == null && courseId == null) {
                StringBuffer sb = new StringBuffer(" select distinct sum(tr.FCourseCost) expense,tr.FTrainActivityID activityId,tr.FTrainCourseID courseId,oa.FLongNumber number,oa.fid orgId  ");
                sb.append(" from T_HR_TrainCourseRecord tr ");
                sb.append(" left join t_hr_traincourserecordExtends ext on tr.FRecordExtendsID = ext.FID");
                sb.append(" left join T_ORG_Position op on ext.FPosiStudentID = op.FID ");
                sb.append(" left join T_ORG_Admin oa on ext.FOrgStudentID = oa.FID ");
                sb.append(" where tr.FCourseCost is not null");
                sb.append(" and oa.FLongNumber like ").append("'").append(longNumber + "%").append("'");
                sb.append(" and ( ");
                if (startDate != null) {
                    sb.append(" tr.FActBeginDate >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FActEndDate <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                if (startDate != null) {
                    sb.append(" or tr.FBeginDateTime >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FEndDateTime <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                sb.append(" )");
                sb.append(" group by tr.FTrainActivityID,tr.FTrainCourseID,oa.FLongNumber,oa.fid ");
                sb.append(" order by oa.FLongNumber asc ");
                sql.append(sb.toString());
            } else if (activityId != null && courseId == null) {
                StringBuffer sb = new StringBuffer(" select distinct sum(tr.FCourseCost) expense,tr.FTrainCourseID courseId ,oa.FLongNumber number,oa.FID orgId  ");
                sb.append(" from T_HR_TrainCourseRecord tr  ");
                sb.append(" left join t_hr_traincourserecordExtends ext on tr.FRecordExtendsID = ext.FID");
                sb.append(" left join T_ORG_Position op on ext.FPosiStudentID = op.FID ");
                sb.append(" left join T_ORG_Admin oa on ext.FOrgStudentID = oa.FID ");
                sb.append(" where tr.FCourseCost is not null ");
                sb.append(" and tr.FTrainActivityID = '").append(activityId).append("'");
                sb.append(" and oa.FLongNumber like ").append("'").append(longNumber + "%").append("'");
                if (startDate != null) {
                    sb.append(" and tr.FActBeginDate >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FActEndDate <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                sb.append(" group by tr.FTrainCourseID,oa.FLongNumber,oa.FID ");
                sb.append(" order by oa.FLongNumber asc ");
                sql.append(sb.toString());
            } else if (activityId == null && courseId != null) {
                StringBuffer sb = new StringBuffer("  select distinct sum(tr.FCourseCost) expense,tr.FTrainActivityID activityId ,oa.FLongNumber number,oa.FID orgId ");
                sb.append("  from T_HR_TrainCourseRecord tr  ");
                sb.append(" left join t_hr_traincourserecordExtends ext on tr.FRecordExtendsID = ext.FID");
                sb.append(" left join T_ORG_Position op on ext.FPosiStudentID = op.FID ");
                sb.append(" left join T_ORG_Admin oa on ext.FOrgStudentID = oa.FID ");
                sb.append(" where tr.FCourseCost is not null");
                sb.append(" and tr.FTrainCourseID = '").append(courseId).append("'");
                sb.append(" and oa.FLongNumber like ").append("'").append(longNumber + "%").append("'");
                sb.append(" and ( ");
                if (startDate != null) {
                    sb.append(" tr.FActBeginDate >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FActEndDate <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                if (startDate != null) {
                    sb.append(" or tr.FBeginDateTime >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FEndDateTime <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                sb.append(" )");
                sb.append(" group by tr.FTrainActivityID,oa.FLongNumber ,oa.FID ");
                sb.append(" order by oa.FLongNumber asc");
                sql.append(sb.toString());
            } else {
                StringBuffer sb = new StringBuffer(" select sum(tr.FCourseCost) expense ,oa.FLongNumber number, oa.FID orgId ");
                sb.append(" from T_HR_TrainCourseRecord tr ");
                sb.append(" left join t_hr_traincourserecordExtends ext on tr.FRecordExtendsID = ext.FID");
                sb.append(" left join T_ORG_Position op on ext.FPosiStudentID = op.FID ");
                sb.append(" left join T_ORG_Admin oa on ext.FOrgStudentID = oa.FID ");
                sb.append(" where tr.FCourseCost is not null");
                if (startDate != null) {
                    sb.append(" and tr.FActBeginDate >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FActEndDate <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                sb.append(" and tr.FTrainActivityID = '").append(activityId).append("' ");
                sb.append(" and tr.FTrainCourseID = '").append(courseId).append("' ");
                sb.append(" and tr.FTrainCourseID = '").append(courseId).append("'");
                sb.append(" and oa.FLongNumber like ").append("'").append(longNumber + "%").append("'");
                sb.append(" group by tr.FTrainActivityID,tr.FTrainCourseID,oa.FLongNumber,oa.FID ");
                sb.append(" order by oa.FLongNumber asc ");
                sql.append(sb.toString());
            }
        } else if (isActivity && !isCourse) {
            if (activityId == null) {
                StringBuffer sb = new StringBuffer(" select distinct tr.FTrainActivityID activityId, sum(tr.FCourseCost) expense,oa.FLongNumber number, oa.FID orgId  ");
                sb.append("\u3000from T_HR_TrainCourseRecord tr\u3000");
                sb.append(" left join t_hr_traincourserecordExtends ext on tr.FRecordExtendsID = ext.FID");
                sb.append(" left join T_ORG_Position op on ext.FPosiStudentID = op.FID ");
                sb.append(" left join T_ORG_Admin oa on ext.FOrgStudentID = oa.FID ");
                sb.append(" where tr.FCourseCost is not null");
                if (startDate != null) {
                    sb.append(" and tr.FActBeginDate >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FActEndDate <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                sb.append(" and oa.FLongNumber like ").append("'").append(longNumber + "%").append("'");
                sb.append(" group by tr.FTrainActivityID,oa.FLongNumber,oa.FID ");
                sb.append(" order by oa.FLongNumber asc ");
                sql.append(sb.toString());
            } else {
                StringBuffer sb = new StringBuffer("  select sum(tr.FCourseCost) expense,oa.FLongNumber number,oa.FID orgId  ");
                sb.append("  from T_HR_TrainCourseRecord tr  ");
                sb.append(" left join t_hr_traincourserecordExtends ext on tr.FRecordExtendsID = ext.FID");
                sb.append(" left join T_ORG_Position op on ext.FPosiStudentID = op.FID ");
                sb.append(" left join T_ORG_Admin oa on ext.FOrgStudentID = oa.FID ");
                sb.append(" where tr.FCourseCost is not null");
                if (startDate != null) {
                    sb.append(" and tr.FActBeginDate >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FActEndDate <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                sb.append(" and tr.FTrainActivityID = '").append(activityId).append("' ");
                sb.append(" and oa.FLongNumber like ").append("'").append(longNumber + "%").append("'");
                sb.append(" group by tr.FTrainActivityID,oa.FLongNumber,oa.FID ");
                sb.append(" order by oa.FLongNumber asc ");
                sql.append(sb.toString());
            }
        } else if (isCourse && !isActivity) {
            if (courseId == null) {
                StringBuffer sb = new StringBuffer(" select distinct tr.FTrainCourseID courseId, sum(tr.FCourseCost) expense,oa.FLongNumber number,oa.FID orgId ");
                sb.append(" from T_HR_TrainCourseRecord tr ");
                sb.append(" left join t_hr_traincourserecordExtends ext on tr.FRecordExtendsID = ext.FID");
                sb.append(" left join T_ORG_Position op on ext.FPosiStudentID = op.FID ");
                sb.append(" left join T_ORG_Admin oa on ext.FOrgStudentID = oa.FID ");
                sb.append(" where tr.FCourseCost is not null");
                sb.append(" and oa.FLongNumber like ").append("'").append(longNumber + "%").append("'");
                sb.append(" and ( ");
                if (startDate != null) {
                    sb.append(" tr.FActBeginDate >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FActEndDate <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                if (startDate != null) {
                    sb.append(" or tr.FBeginDateTime >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FEndDateTime <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                sb.append(" )");
                sb.append(" group by tr.FTrainCourseID,oa.FLongNumber,oa.FID ");
                sb.append(" order by oa.FLongNumber asc ");
                sql.append(sb.toString());
            } else {
                StringBuffer sb = new StringBuffer(" select sum(tr.FCourseCost) expense,oa.FLongNumber number,oa.FID orgId ");
                sb.append(" from T_HR_TrainCourseRecord tr ");
                sb.append(" left join t_hr_traincourserecordExtends ext on tr.FRecordExtendsID = ext.FID");
                sb.append(" left join T_ORG_Position op on ext.FPosiStudentID = op.FID ");
                sb.append(" left join T_ORG_Admin oa on ext.FOrgStudentID = oa.FID ");
                sb.append(" where tr.FCourseCost is not null");
                sb.append(" and tr.FTrainCourseID = '").append(courseId).append("'");
                sb.append(" and oa.FLongNumber like ").append("'").append(longNumber + "%").append("'");
                sb.append(" and ( ");
                if (startDate != null) {
                    sb.append(" tr.FActBeginDate >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FActEndDate <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                if (startDate != null) {
                    sb.append(" or tr.FBeginDateTime >= to_date('").append(this.df.format(startDate)).append("') ");
                }
                if (endDate != null) {
                    sb.append(" and tr.FEndDateTime <= to_date('").append(this.df.format(endDate)).append("') ");
                }
                sb.append(" )");
                sb.append(" group by tr.FTrainCourseID,oa.FLongNumber,oa.FID ");
                sb.append(" order by oa.FLongNumber asc ");
                sql.append(sb.toString());
            }
        } else {
            StringBuffer sb = new StringBuffer(" select sum(tr.FCourseCost) expense ,oa.FLongNumber number,oa.FID orgId ");
            sb.append(" from T_HR_TrainCourseRecord tr ");
            sb.append(" left join t_hr_traincourserecordExtends ext on tr.FRecordExtendsID = ext.FID");
            sb.append(" left join T_ORG_Position op on ext.FPosiStudentID = op.FID ");
            sb.append(" left join T_ORG_Admin oa on ext.FOrgStudentID = oa.FID ");
            sb.append(" where tr.FCourseCost is not null");
            sb.append(" and oa.FLongNumber like ").append("'").append(longNumber + "%").append("'");
            sb.append(" and ( ");
            if (startDate != null) {
                sb.append(" tr.FActBeginDate >= to_date('").append(this.df.format(startDate)).append("') ");
            }
            if (endDate != null) {
                sb.append(" and tr.FActEndDate <= to_date('").append(this.df.format(endDate)).append("') ");
            }
            if (startDate != null) {
                sb.append(" or tr.FBeginDateTime >= to_date('").append(this.df.format(startDate)).append("') ");
            }
            if (endDate != null) {
                sb.append(" and tr.FEndDateTime <= to_date('").append(this.df.format(endDate)).append("') ");
            }
            sb.append(" )");
            sb.append(" group by oa.FLongNumber,oa.FID ");
            sb.append(" order by oa.FLongNumber asc ");
            sql.append(sb.toString());
        }
        return sql.toString();
    }

    private Map executeUnionQuery(Context ctx, String sql, boolean isActivity, boolean isCourse, String activityId, String courseId) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        IRowSet rs = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        ITrainActivity trainActivity = TrainActivityFactory.getLocalInstance(ctx);
        ITrainCourse trainCourse = TrainCourseFactory.getLocalInstance(ctx);
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            String oldOrgId = "";
            ArrayList<TrainExpenseReportHelper> expenseList = null;
            ArrayList<TrainExpenseReportHelper> expenseList2 = null;
            AdminOrgUnitInfo info = null;
            String adminOrgUnitId = null;
            String activity = null;
            String course = null;
            TrainExpenseReportHelper helper = null;
            TrainActivityInfo activityInfo = null;
            TrainCourseInfo courseInfo = null;
            while (rs.next()) {
                adminOrgUnitId = rs.getString("orgId");
                helper = new TrainExpenseReportHelper(adminOrgUnitId);
                double expense = rs.getDouble("expense");
                if (isActivity && isCourse) {
                    if (activityId == null && courseId == null) {
                        activity = rs.getString("activityId");
                        course = rs.getString("courseId");
                        if (activity != null) {
                            activityInfo = trainActivity.getTrainActivityInfo((IObjectPK)new ObjectUuidPK(activity), sic);
                            helper.setActivityInfo(activityInfo);
                        } else {
                            activityInfo = new TrainActivityInfo();
                            activityInfo.setName(" ");
                            activityInfo.setId(BOSUuid.read((String)course));
                            helper.setActivityInfo(activityInfo);
                        }
                        if (course != null) {
                            courseInfo = trainCourse.getTrainCourseInfo((IObjectPK)new ObjectUuidPK(course), sic);
                            helper.setCourseInfo(courseInfo);
                        }
                    } else if (activityId != null && courseId == null) {
                        activityInfo = trainActivity.getTrainActivityInfo((IObjectPK)new ObjectUuidPK(activityId), sic);
                        course = rs.getString("courseId");
                        courseInfo = trainCourse.getTrainCourseInfo((IObjectPK)new ObjectUuidPK(course), sic);
                        helper.setActivityInfo(activityInfo);
                        helper.setCourseInfo(courseInfo);
                    } else if (activityId == null && courseId != null) {
                        activity = rs.getString("activityId");
                        if (activity != null) {
                            activityInfo = trainActivity.getTrainActivityInfo((IObjectPK)new ObjectUuidPK(activity), sic);
                            helper.setActivityInfo(activityInfo);
                        } else {
                            activityInfo = new TrainActivityInfo();
                            activityInfo.setName(" ");
                            activityInfo.setId(BOSUuid.read((String)courseId));
                            helper.setActivityInfo(activityInfo);
                        }
                        courseInfo = trainCourse.getTrainCourseInfo((IObjectPK)new ObjectUuidPK(courseId), sic);
                        helper.setCourseInfo(courseInfo);
                    } else {
                        activityInfo = trainActivity.getTrainActivityInfo((IObjectPK)new ObjectUuidPK(activityId), sic);
                        courseInfo = trainCourse.getTrainCourseInfo((IObjectPK)new ObjectUuidPK(courseId), sic);
                        helper.setActivityInfo(activityInfo);
                        helper.setCourseInfo(courseInfo);
                    }
                } else if (isActivity && !isCourse) {
                    if (activityId == null) {
                        activity = rs.getString("activityId");
                        if (activity != null) {
                            activityInfo = trainActivity.getTrainActivityInfo((IObjectPK)new ObjectUuidPK(activity), sic);
                            helper.setActivityInfo(activityInfo);
                        }
                    } else {
                        activityInfo = trainActivity.getTrainActivityInfo((IObjectPK)new ObjectUuidPK(activityId), sic);
                        helper.setActivityInfo(activityInfo);
                    }
                } else if (isCourse && !isActivity) {
                    if (courseId == null) {
                        course = rs.getString("courseId");
                        courseInfo = trainCourse.getTrainCourseInfo((IObjectPK)new ObjectUuidPK(course), sic);
                        helper.setCourseInfo(courseInfo);
                    } else {
                        courseInfo = trainCourse.getTrainCourseInfo((IObjectPK)new ObjectUuidPK(courseId), sic);
                        helper.setCourseInfo(courseInfo);
                    }
                }
                helper.setExpense(expense);
                helper.setExpense2(expense);
                if (!oldOrgId.equals(adminOrgUnitId)) {
                    expenseList = new ArrayList<TrainExpenseReportHelper>();
                    result.put(adminOrgUnitId, expenseList);
                    oldOrgId = adminOrgUnitId;
                    info = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitId), this.getSIC());
                    if (!info.isIsLeaf()) {
                        expenseList2 = new ArrayList<TrainExpenseReportHelper>();
                        result.put(adminOrgUnitId + "#", expenseList2);
                    }
                }
                expenseList.add(helper);
                if (info != null && !info.isIsLeaf()) {
                    expenseList2.add(helper);
                }
                this.updateParentNodeExpense(ctx, info, helper, result);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return result;
    }

    private SelectorItemCollection getSIC() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("parent"));
        sic.add(new SelectorItemInfo("isLeaf"));
        return sic;
    }
}

