/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.hr.emp.PersonDegreeCollection;
import com.kingdee.eas.hr.emp.PersonDegreeFactory;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonTechnicalPostCollection;
import com.kingdee.eas.hr.emp.PersonTechnicalPostFactory;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.train.ITrainCourseRecord;
import com.kingdee.eas.hr.train.TrainCommonUtils;
import com.kingdee.eas.hr.train.TrainCourseRecordCollection;
import com.kingdee.eas.hr.train.TrainCourseRecordFactory;
import com.kingdee.eas.hr.train.TrainCourseRecordInfo;
import com.kingdee.eas.hr.train.app.AbstractTrainFacadeControllerBean;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainFacadeControllerBean
extends AbstractTrainFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainFacadeControllerBean");

    protected Map _getEmployeeRelationInfo(Context ctx, String employeeId) throws BOSException, EASBizException {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        if (TrainCommonUtils.isEmpty(employeeId)) {
            return infos;
        }
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(employeeId));
        PositionInfo posInfo = iPerson.getPrimaryPosition(personInfo.getId());
        infos.put("person", personInfo);
        infos.put("number", personInfo.getNumber());
        if (personInfo.getGender() != null) {
            infos.put("sex", personInfo.getGender().getAlias());
        }
        if (posInfo != null) {
            infos.put("position", posInfo.getName());
            if (posInfo.getJob() != null) {
                JobInfo jobInfo = JobFactory.getLocalInstance((Context)ctx).getJobInfo((IObjectPK)new ObjectUuidPK(posInfo.getJob().getId().toString()));
                infos.put("job", jobInfo.getName());
            }
        }
        String sql = "select technicalPost.name where person.id = '" + employeeId + "' and isHighTechnical = 1";
        PersonTechnicalPostCollection personPostCol = PersonTechnicalPostFactory.getLocalInstance((Context)ctx).getPersonTechnicalPostCollection(sql);
        if (personPostCol.size() > 0) {
            infos.put("technicalPost", personPostCol.get(0).getTechnicalPost().getName());
        }
        sql = "select joinGroupDate, jobGrade.name, adjustGroupVal,personDep.id,personDep.name where person.id = '" + employeeId + "'";
        PersonPositionCollection personPositionCollection = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection(sql);
        if (personPositionCollection.size() > 0 && personPositionCollection.get(0).getJobGrade() != null) {
            infos.put("grade", personPositionCollection.get(0).getJobGrade().getName());
            infos.put("joinGroupDate", personPositionCollection.get(0).getJoinGroupDate());
            infos.put("adjustGroupVal", new Float(personPositionCollection.get(0).getAdjustGroupVal()));
        }
        if (personPositionCollection.size() > 0 && personPositionCollection.get(0).getPersonDep() != null) {
            AdminOrgUnitInfo unitInfo = personPositionCollection.get(0).getPersonDep();
            infos.put("adminOrgUnit", unitInfo);
        }
        sql = "select diploma.name,specialty where person.id = '" + employeeId + "' and isHighest = 1";
        PersonDegreeCollection personDegreeCol = PersonDegreeFactory.getLocalInstance((Context)ctx).getPersonDegreeCollection(sql);
        if (personDegreeCol.size() > 0 && personDegreeCol.get(0).getDiploma() != null) {
            infos.put("diploma", personDegreeCol.get(0).getDiploma().getName());
            infos.put("special", personDegreeCol.get(0).getSpecialty());
        }
        return infos;
    }

    protected Map _batchGetCollection(Context ctx, Map parameter) throws BOSException, EASBizException {
        HashMap<String, IObjectCollection> result = null;
        if (parameter != null && parameter.size() > 0) {
            result = new HashMap<String, IObjectCollection>();
            String key = null;
            for (Map.Entry entry : parameter.entrySet()) {
                key = (String)entry.getKey();
                result.put(key, this.getDataCollection(ctx, (Map)parameter.get(key)));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IObjectCollection getDataCollection(Context ctx, Map map) throws BOSException {
        IObjectCollection collection = null;
        if (map != null && map.size() > 0) {
            FilterInfo filterInfo = (FilterInfo)map.get("filter");
            EntityViewInfo viewInfo = new EntityViewInfo();
            if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
                viewInfo.setFilter(filterInfo);
            }
            SorterItemInfo itemInfo = new SorterItemInfo("number");
            itemInfo.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(itemInfo);
            BOSObjectType bosType = (BOSObjectType)map.get("bosType");
            Connection cn = null;
            try {
                cn = this.getConnection(ctx);
                collection = ORMappingDAO.getInstance((BOSObjectType)bosType, (Context)ctx, (Connection)cn).getCollection(viewInfo);
            }
            finally {
                SQLUtils.cleanup((Connection)cn);
            }
        }
        return collection;
    }

    protected boolean _hasDefaultSolution(Context ctx, IMetaDataPK mainQueryPK, String className) throws BOSException, EASBizException {
        QueryInfo queryInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getQuery(mainQueryPK);
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getLocalInstance((Context)ctx);
        return !iQuery.hasDefaultSolution(className, queryInfo.getFullName());
    }

    protected Map _getSysCateData(Context ctx, Set positionIds, Set jobIds, Set jobGradeIds, Set techPostIds) throws BOSException, EASBizException {
        HashMap<String, IRowSet> result = new HashMap<String, IRowSet>();
        IRowSet rowSet = this.getRowSet(ctx, "com.kingdee.eas.hr.train.app.TrainSysCatejobGradeQuery", "jobGrade1.id", "JobGrade.name", jobGradeIds);
        if (rowSet != null) {
            result.put("jobGrade", rowSet);
        }
        if ((rowSet = this.getRowSet(ctx, "com.kingdee.eas.hr.train.app.TrainSysCatePostionCourseQuery", "Position.id", "Position.name", positionIds)) != null) {
            result.put("position", rowSet);
        }
        if ((rowSet = this.getRowSet(ctx, "com.kingdee.eas.hr.train.app.TrainSysCateJobCourseQuery", "Job.id", "Job.name", jobIds)) != null) {
            result.put("job", rowSet);
        }
        if ((rowSet = this.getRowSet(ctx, "com.kingdee.eas.hr.train.app.TrainSysCateTechPostCourseQuery", "TechnicalPost.id", "TechnicalPost.name", techPostIds)) != null) {
            result.put("technicalPost", rowSet);
        }
        return result;
    }

    private IRowSet getRowSet(Context ctx, String queryName, String keyId, String keyName, Set ids) throws BOSException {
        IRowSet rowSet = null;
        if (ids != null && !ids.isEmpty()) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(keyName, null, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo(keyId, (Object)ids, CompareType.INCLUDE));
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo item = new SorterItemInfo(keyName);
            sorter.add(item);
            rowSet = TrainUtilsServer.getRowSet(ctx, queryName, filter, sorter);
        }
        return rowSet;
    }

    protected void _deleteCertificate(Context ctx, String certificateId) throws BOSException, EASBizException {
        if (certificateId == null) {
            return;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("actCertificate.id", (Object)certificateId));
        filterInfo.getFilterItems().add(new FilterItemInfo("EmpCertificatio.id", (Object)certificateId));
        filterInfo.setMaskString("#0 or #1");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("actCertificate.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("EmpCertificatio.id"));
        ITrainCourseRecord iTrainCourseRecord = TrainCourseRecordFactory.getLocalInstance(ctx);
        TrainCourseRecordCollection collection = iTrainCourseRecord.getTrainCourseRecordCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            boolean modify = false;
            TrainCourseRecordInfo info = null;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                info = collection.get(i);
                modify = false;
                if (!TrainCommonUtils.isEmpty((CoreBaseInfo)info.getEmpCertificatio()) && certificateId.equals(info.getEmpCertificatio().getId().toString())) {
                    info.setEmpCertificatio(null);
                    modify = true;
                }
                if (!TrainCommonUtils.isEmpty((CoreBaseInfo)info.getActCertificate()) && certificateId.equals(info.getActCertificate().getId().toString())) {
                    info.setActCertificate(null);
                    modify = true;
                }
                if (!modify) continue;
                iTrainCourseRecord.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
            }
        }
    }

    protected boolean _isInAdminRange(Context ctx, Set adminOrgUnitIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select * from (");
        sql.append(PerfUtils.getAdminRangeSql((Context)ctx));
        sql.append(") t ");
        if (adminOrgUnitIds != null && !adminOrgUnitIds.isEmpty()) {
            sql.append(" where t.FFromUnitID in (");
            sql.append(TrainCommonUtils.collectionToStrings(adminOrgUnitIds));
            sql.append(")");
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected boolean _isIncludeRange_Modify(Context ctx, Set adminOrgUnitIds) throws BOSException, EASBizException {
        IRowSet rowSet;
        StringBuffer sql = new StringBuffer();
        sql.append("select * from (");
        sql.append(PerfUtils.getAdminRangeSql((Context)ctx));
        sql.append(") t ");
        if (adminOrgUnitIds != null && !adminOrgUnitIds.isEmpty()) {
            sql.append(" where t.FFromUnitID in (");
            sql.append(TrainCommonUtils.collectionToStrings(adminOrgUnitIds));
            sql.append(")");
        }
        if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString())) != null && rowSet.size() > 0) {
            HashSet<String> fromUnitIDSet = new HashSet<String>();
            try {
                while (rowSet.next()) {
                    fromUnitIDSet.add(rowSet.getString("FFromUnitID"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (fromUnitIDSet != null && fromUnitIDSet.size() > 0) {
                Iterator iterator = adminOrgUnitIds.iterator();
                while (iterator.hasNext()) {
                    if (fromUnitIDSet.contains(iterator.next().toString())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected Set _getPersonHRRange(Context ctx, String userID) throws BOSException, EASBizException {
        HashSet<String> hrSet = new HashSet<String>();
        String sql = this.getHRRangeByUserId(userID);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                hrSet.add(rowSet.getString("forgId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hrSet;
    }

    private String getHRRangeByUserId(String userID) {
        StringBuffer sql = new StringBuffer();
        sql.append("select orgRange.forgId as forgId from T_PM_OrgRange orgRange inner join ");
        sql.append("T_ORG_HRO hro on orgRange.forgId = hro.fid ");
        sql.append("where orgRange.ftype = ");
        sql.append(10);
        sql.append(" and fuserid = '");
        sql.append(userID);
        sql.append("' ");
        return sql.toString();
    }
}

