/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.train.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.IPersonPhoto;
import com.kingdee.eas.hr.emp.PersonPhotoCollection;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.hr.train.app.AbstractTrainInstructorFacadeControllerBean;
import com.kingdee.eas.hr.train.app.TrainUtilsServer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TrainInstructorFacadeControllerBean
extends AbstractTrainInstructorFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.train.app.TrainInstructorFacadeControllerBean");
    private String RES = "com.kingdee.eas.hr.train.TrainResource";

    protected Map _getPrintInstructorInfo(Context ctx, Set sourceID) throws BOSException, EASBizException {
        if (sourceID == null || sourceID.size() == 0) {
            return null;
        }
        MetaDataPK queryPK = null;
        MetaDataPK queryPK_workExp = null;
        MetaDataPK queryPK_techWorkExp = null;
        MetaDataPK queryPK_techExp = null;
        MetaDataPK queryPK_educationExp = null;
        HashMap<String, IRowSet> map = new HashMap<String, IRowSet>();
        queryPK = new MetaDataPK("com.kingdee.eas.hr.train.app.TrainInstructorInfoQuery");
        queryPK_workExp = new MetaDataPK("com.kingdee.eas.hr.train.app.InstructorWorkExpQuery");
        queryPK_techWorkExp = new MetaDataPK("com.kingdee.eas.hr.train.app.InstructorRecordExpQuery");
        queryPK_techExp = new MetaDataPK("com.kingdee.eas.hr.train.app.TrainHistoryForCourseQuery");
        queryPK_educationExp = new MetaDataPK("com.kingdee.eas.hr.train.app.TrainEmpDegreeListQuery");
        IQueryExecutor query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sourceID, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        query.setObjectView(viewInfo);
        IRowSet InstructorRows = query.executeQuery();
        this.updateGiveDate(ctx, InstructorRows);
        this.updateStartDate(ctx, InstructorRows);
        try {
            InstructorRows.beforeFirst();
            EntityViewInfo evi = new EntityViewInfo();
            EntityViewInfo evi_for = new EntityViewInfo();
            EntityViewInfo evi_forHistory = new EntityViewInfo();
            String instructorID = null;
            String personID = null;
            while (InstructorRows.next()) {
                instructorID = InstructorRows.getString("id");
                personID = InstructorRows.getString("Employee.id");
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personID));
                evi.setFilter(fi);
                FilterInfo fi1 = new FilterInfo();
                fi1.getFilterItems().add(new FilterItemInfo("Instructor.id", (Object)instructorID));
                evi_for.setFilter(fi1);
                FilterInfo fi2 = new FilterInfo();
                fi2.getFilterItems().add(new FilterItemInfo("Employee.id", (Object)personID));
                fi2.getFilterItems().add(new FilterItemInfo("trainInstructor.id", (Object)instructorID));
                evi_forHistory.setFilter(fi2);
                query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK_workExp);
                query.setObjectView(evi);
                map.put(personID + "_workExp", query.executeQuery());
                query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK_techWorkExp);
                query.setObjectView(evi_for);
                map.put(instructorID + "_techWorkExp", query.executeQuery());
                query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK_techExp);
                query.setObjectView(evi_forHistory);
                IRowSet rowSet = query.executeQuery();
                while (rowSet.next()) {
                    rowSet.updateString("startEndDate", TrainUtilsServer.getStartDate2EndDateString(rowSet.getDate("countStudent.BeginDateTime"), rowSet.getDate("countStudent.EndDateTime"), ResourceBase.getString((String)this.RES, (String)"zhi", (Locale)ctx.getLocale())));
                    rowSet.updateString("hourAndUnit", TrainUtilsServer.getHourUnitString(rowSet.getObject("countStudent.CourseHour"), rowSet.getObject("countStudent.CourseHourUnit")));
                }
                rowSet.beforeFirst();
                map.put(instructorID + "_techExp", rowSet);
                query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK_educationExp);
                query.setObjectView(evi);
                map.put(personID + "_educationExp", query.executeQuery());
                try {
                    map.put(personID + "_photo", this.getPhoto(ctx, personID));
                }
                catch (IOException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            InstructorRows.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        map.put("InnerInstructorInfo", InstructorRows);
        return map;
    }

    private void updateGiveDate(Context ctx, IRowSet rowSet) throws BOSException {
        try {
            while (rowSet.next()) {
                if (rowSet.getString("highestTechPost.id") == null) continue;
                StringBuffer sql = new StringBuffer();
                sql.append("select FConferDate from T_HR_PersonTechPost where FTechnicalPostID = ");
                sql.append("'");
                sql.append(rowSet.getString("highestTechPost.id"));
                sql.append("'");
                sql.append(" and FPersonID = ");
                sql.append("'");
                sql.append(rowSet.getString("Employee.id"));
                sql.append("'");
                IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!rowSet1.next()) continue;
                rowSet.updateDate("giveDate", rowSet1.getDate(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateStartDate(Context ctx, IRowSet rowSet) throws BOSException {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (rowSet.getString("Position.id") == null) continue;
                StringBuffer sql = new StringBuffer();
                sql.append("select FBeginDate from T_ORG_PositionMember where FPositionID = ");
                sql.append("'");
                sql.append(rowSet.getString("Position.id"));
                sql.append("'");
                sql.append(" and FPersonID = ");
                sql.append("'");
                sql.append(rowSet.getString("Employee.id"));
                sql.append("'");
                IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!rowSet1.next()) continue;
                rowSet.updateDate("startDate", rowSet1.getDate(1));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private IRowSet getPhoto(Context ctx, String personID) throws BOSException, IOException, SQLException {
        byte[] imageData;
        IPersonPhoto iPhoto;
        PersonPhotoCollection ppColl;
        DynamicRowSet photoResultSet = null;
        if (personID != null && (ppColl = (iPhoto = PersonPhotoFactory.getLocalInstance((Context)ctx)).getPersonPhotoCollection(" select imageData where person='" + personID + "'")) != null && ppColl.size() > 0 && ppColl.get(0).getImageData() != null && (imageData = ppColl.get(0).getImageData()) != null) {
            photoResultSet = new DynamicRowSet(2);
            photoResultSet.setColInfo(1, new ColInfo("photo", "photo", -2, null));
            photoResultSet.setColInfo(2, new ColInfo("photoId", "photoId", 12, null));
            ByteArrayInputStream bais = new ByteArrayInputStream(imageData);
            photoResultSet.moveToInsertRow();
            photoResultSet.updateBinaryStream("photo", (InputStream)bais, imageData.length);
            photoResultSet.updateString("photoId", personID);
            photoResultSet.insertRow();
            photoResultSet.beforeFirst();
        }
        return photoResultSet;
    }
}

